/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.common.ssl;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.cert.X509Certificate;
import java.util.Locale;
import javax.accessibility.AccessibleContext;
import javax.security.auth.x500.X500Principal;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import oracle.forms.common.ssl.CertificateHandler;
import oracle.forms.registry.MessageGenerator;

public class CertDialogUtility
implements ActionListener,
MouseListener {
    protected static final MessageGenerator mEMG = new MessageGenerator("oracle.forms.engine.ErrorMessageBundle", Locale.getDefault()){

        @Override
        protected boolean showMessageKey(String string) {
            char c = string.charAt(6);
            return c < '7' || c > '8';
        }
    };
    private static final String OK = mEMG.getMessage("FRM-92713");
    private static final String CANCEL = mEMG.getMessage("FRM-92714");
    private static final String Close = mEMG.getMessage("FRM-92735");
    private static final String ACCEPT = mEMG.getMessage("FRM-92715");
    private static final String MORE_INFORMATION = mEMG.getMessage("FRM-92720");
    private static final String PUBLISHER = mEMG.getMessage("FRM-92712");
    private static final String LOCATION = mEMG.getMessage("FRM-92716");
    private static final String HTTPS = "https://";
    private static final String ADDRESS_SEPARATOR = ":";
    private JButton mOk;
    private JButton mCancel;
    private JButton mHyperLink;
    private CertificateHandler mCertHandler;
    private boolean mVal;
    private boolean mIsValid;
    private boolean mDebug;
    private char[] mPassword;
    private JPasswordField mPasswordField;
    private JDialog mJd;
    private JDialog mPasswordDialog;
    private JLabel mLabel;
    private X509Certificate[] mCertChain;
    private static int mPasswordRetryCount = 0;

    CertDialogUtility(CertificateHandler certificateHandler, boolean bl, boolean bl2) {
        this.mCertHandler = certificateHandler;
        this.mDebug = bl;
        if (bl2) {
            this._createPasswordField();
        }
    }

    CertDialogUtility() {
        JOptionPane.showMessageDialog(null, mEMG.getMessage("FRM-92313"), mEMG.getMessage("FRM-92719"), 0);
    }

    private JPanel _createPanel(String string, String string2, boolean bl) {
        JPanel jPanel = new JPanel(new GridLayout(1, 10, 10, 10));
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
        this.mOk = new JButton(OK);
        this.mCancel = new JButton(CANCEL);
        this.mOk.setActionCommand(string);
        this.mCancel.setActionCommand(string2);
        this.mOk.addActionListener(this);
        this.mCancel.addActionListener(this);
        this._addKeyListeners(this.mCancel);
        jPanel.add(this.mOk);
        jPanel.add(this.mCancel);
        if (bl) {
            JPanel jPanel2 = new JPanel(new GridLayout(1, 1, 0, 0));
            JPanel jPanel3 = new JPanel();
            String string3 = System.getProperty("os.name");
            if (string3 != null) {
                if (string3.startsWith("Mac")) {
                    jPanel3.setLayout(new GridLayout(1, 1, 195, 10));
                } else if (string3.startsWith("Windows")) {
                    jPanel3.setLayout(new GridLayout(1, 1, 230, 10));
                } else {
                    jPanel3.setLayout(new GridLayout(1, 1, 200, 10));
                }
            }
            JButton jButton = this._createHyperLink();
            jPanel2.add(jButton);
            jPanel3.add(jPanel2);
            jPanel3.add(jPanel);
            return jPanel3;
        }
        return jPanel;
    }

    private JButton _createHyperLink() {
        this.mHyperLink = new JButton(MORE_INFORMATION);
        this.mHyperLink.setHorizontalAlignment(2);
        this.mHyperLink.setBorderPainted(false);
        this.mHyperLink.setOpaque(false);
        this.mHyperLink.setLocation(200, 200);
        this.mHyperLink.setBackground(Color.WHITE);
        this.mHyperLink.setToolTipText(mEMG.getMessage("FRM-92737"));
        this.mHyperLink.setForeground(Color.BLUE.darker());
        this.mHyperLink.setCursor(Cursor.getPredefinedCursor(12));
        this.mHyperLink.addMouseListener(this);
        this.mHyperLink.addActionListener(this);
        this.mHyperLink.setActionCommand(MORE_INFORMATION);
        this.mHyperLink.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                CertDialogUtility.this.mHyperLink.transferFocus();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                CertDialogUtility.this.mHyperLink.removeFocusListener(this);
            }
        });
        this._addKeyListeners(this.mHyperLink);
        return this.mHyperLink;
    }

    private void _addKeyListeners(JButton jButton) {
        InputMap inputMap = jButton.getInputMap(0);
        inputMap.put(KeyStroke.getKeyStroke(10, 0, false), "pressed");
        inputMap.put(KeyStroke.getKeyStroke(10, 0, true), "released");
    }

    public boolean dialog(X509Certificate[] x509CertificateArray, String string, int n, boolean bl) {
        this.mJd = new JDialog();
        this.mJd.setModal(true);
        this.mJd.setResizable(false);
        if (bl) {
            this.mJd.setTitle(mEMG.getMessage("FRM-92741"));
        } else {
            this.mJd.setTitle(mEMG.getMessage("FRM-92710"));
        }
        this.mJd.setDefaultCloseOperation(2);
        this.mJd.getContentPane().setLayout(new FlowLayout(4));
        JScrollPane jScrollPane = this._createScrollPane(x509CertificateArray, string, n, bl);
        if (jScrollPane == null) {
            return false;
        }
        this.mJd.getContentPane().add(jScrollPane);
        this.mJd.getContentPane().add(this._createPanel(OK, CANCEL, true));
        this.mJd.getRootPane().setDefaultButton(this.mOk);
        this.mJd.setLocation(200, 200);
        this.mJd.setSize(580, 300);
        this.mJd.setVisible(true);
        return true;
    }

    private JScrollPane _createScrollPane(X509Certificate[] x509CertificateArray, String string, int n, boolean bl) {
        JScrollPane jScrollPane;
        block8: {
            if (x509CertificateArray == null) {
                System.out.println(mEMG.getMessage("FRM-92095"));
                return null;
            }
            this.mCertChain = x509CertificateArray;
            String string2 = x509CertificateArray[0].getSubjectX500Principal().getName();
            String string3 = new CertificateInfo()._extractFromQuote(string2, "O=");
            String string4 = null;
            String string5 = null;
            if (string3 == null || string3.isEmpty()) {
                string3 = mEMG.getMessage("FRM-92736");
            }
            string3 = string3 + System.lineSeparator() + System.lineSeparator();
            String string6 = HTTPS + string + ADDRESS_SEPARATOR + n + System.lineSeparator() + System.lineSeparator();
            if (bl) {
                string4 = mEMG.getMessage("FRM-92740") + System.lineSeparator() + System.lineSeparator();
                string3 = mEMG.getMessage("FRM-92739") + System.lineSeparator() + System.lineSeparator();
                string5 = mEMG.getMessage("FRM-92738");
            } else {
                string4 = mEMG.getMessage("FRM-92710") + System.lineSeparator() + System.lineSeparator();
                string5 = mEMG.getMessage("FRM-92711");
            }
            JTextPane jTextPane = new JTextPane();
            jTextPane.setEditable(false);
            jTextPane.setCaretPosition(0);
            jTextPane.setBackground(new JFrame().getBackground());
            jTextPane.setFocusable(false);
            StyledDocument styledDocument = jTextPane.getStyledDocument();
            jScrollPane = new JScrollPane(jTextPane);
            jScrollPane.setPreferredSize(new Dimension(550, 210));
            jScrollPane.setBorder(BorderFactory.createEmptyBorder());
            SimpleAttributeSet[] simpleAttributeSetArray = new SimpleAttributeSet[4];
            simpleAttributeSetArray[0] = new SimpleAttributeSet();
            StyleConstants.setFontFamily(simpleAttributeSetArray[0], "SansSerif");
            simpleAttributeSetArray[1] = new SimpleAttributeSet(simpleAttributeSetArray[0]);
            StyleConstants.setFontSize(simpleAttributeSetArray[1], 12);
            StyleConstants.setBold(simpleAttributeSetArray[1], true);
            simpleAttributeSetArray[2] = new SimpleAttributeSet(simpleAttributeSetArray[0]);
            StyleConstants.setFontSize(simpleAttributeSetArray[2], 12);
            simpleAttributeSetArray[3] = new SimpleAttributeSet(simpleAttributeSetArray[0]);
            StyleConstants.setFontSize(simpleAttributeSetArray[3], 16);
            StyleConstants.setBold(simpleAttributeSetArray[3], true);
            try {
                styledDocument.insertString(styledDocument.getLength(), string4, simpleAttributeSetArray[3]);
                if (!bl) {
                    styledDocument.insertString(styledDocument.getLength(), PUBLISHER, simpleAttributeSetArray[1]);
                }
                styledDocument.insertString(styledDocument.getLength(), string3, simpleAttributeSetArray[2]);
                styledDocument.insertString(styledDocument.getLength(), LOCATION, simpleAttributeSetArray[1]);
                styledDocument.insertString(styledDocument.getLength(), string6, simpleAttributeSetArray[2]);
                styledDocument.insertString(styledDocument.getLength(), string5, simpleAttributeSetArray[1]);
                AccessibleContext accessibleContext = this.mJd.getAccessibleContext();
                String string7 = string4;
                if (!bl) {
                    string7 = string7 + PUBLISHER;
                }
                string7 = string7 + string3 + LOCATION + string6 + string5;
                accessibleContext.setAccessibleDescription(string7);
                accessibleContext.setAccessibleName(string7);
            }
            catch (BadLocationException badLocationException) {
                System.err.println(mEMG.getMessage("FRM-92510"));
                if (!this.mDebug) break block8;
                badLocationException.printStackTrace();
            }
        }
        return jScrollPane;
    }

    private void _createPasswordField() {
        FlowLayout flowLayout = new FlowLayout(4);
        flowLayout.setVgap(10);
        flowLayout.setHgap(15);
        this.mPasswordDialog = new JDialog();
        this.mLabel = new JLabel(mEMG.getMessage("FRM-92717"));
        this.mPasswordDialog.setModal(true);
        this.mPasswordDialog.setResizable(false);
        this.mPasswordDialog.setDefaultCloseOperation(2);
        this.mPasswordDialog.getContentPane().setLayout(flowLayout);
        this.mPasswordDialog.setTitle(mEMG.getMessage("FRM-92718"));
        this.mPasswordField = new JPasswordField(20);
        this.mPasswordField.setEchoChar('\u25cf');
        JScrollPane jScrollPane = new JScrollPane(this.mPasswordField);
        jScrollPane.setPreferredSize(new Dimension(300, 30));
        jScrollPane.setBackground(new JFrame().getBackground());
        jScrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.mPasswordField.setActionCommand(ACCEPT);
        this.mPasswordField.addActionListener(this);
        this.mPasswordDialog.getContentPane().add(this.mLabel);
        this.mPasswordDialog.getContentPane().add(jScrollPane);
        this.mPasswordDialog.getContentPane().add(this._createPanel(ACCEPT, CANCEL, false));
        this.mPasswordDialog.getRootPane().setDefaultButton(this.mOk);
        this.mPasswordDialog.setLocationRelativeTo(null);
        this.mPasswordDialog.setSize(415, 130);
        this.mPasswordDialog.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (OK == actionEvent.getActionCommand()) {
            this.mJd.dispose();
            this.setVal(true);
        } else if (CANCEL == actionEvent.getActionCommand()) {
            this.setVal(false);
            if (this.mJd != null) {
                this.mJd.dispose();
            } else {
                this.mPasswordDialog.dispose();
            }
        } else if (ACCEPT == actionEvent.getActionCommand()) {
            this.mPassword = this.mPasswordField.getPassword();
            if (this.mPassword.length != 0 && this.mPassword != null) {
                if (!this.mCertHandler.isPasswordCorrect(this.mPassword)) {
                    if (mPasswordRetryCount > 1) {
                        JOptionPane.showMessageDialog(this.mPasswordDialog, mEMG.getMessage("FRM-92311"), mEMG.getMessage("FRM-92719"), 0);
                        this.mPasswordDialog.dispose();
                    } else {
                        JOptionPane.showMessageDialog(this.mPasswordDialog, mEMG.getMessage("FRM-92310"), mEMG.getMessage("FRM-92719"), 0);
                        this.mPasswordField.selectAll();
                        this.mPasswordField.requestFocusInWindow();
                        ++mPasswordRetryCount;
                    }
                } else {
                    this.setIsValid(true);
                    this.mPasswordDialog.dispose();
                }
            } else {
                JOptionPane.showMessageDialog(this.mPasswordDialog, mEMG.getMessage("FRM-92312"), mEMG.getMessage("FRM-92719"), 0);
            }
        } else if (MORE_INFORMATION == actionEvent.getActionCommand()) {
            this._showCertificateDetails(this.mJd);
        }
    }

    private void _showCertificateDetails(JDialog jDialog) {
        final JDialog jDialog2 = new JDialog();
        jDialog2.setModal(true);
        jDialog2.setTitle(mEMG.getMessage("FRM-92734"));
        jDialog2.getContentPane().setLayout(new BorderLayout());
        jDialog2.getContentPane().add((Component)this._getComponents(), "Center");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(4));
        JButton jButton = new JButton(Close);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jDialog2.setVisible(false);
                jDialog2.dispose();
            }
        });
        jPanel.add(jButton);
        jDialog2.setLocationRelativeTo(jDialog);
        jDialog2.getContentPane().add((Component)jPanel, "South");
        jDialog2.pack();
        jDialog2.setResizable(false);
        jDialog2.setVisible(true);
    }

    private JPanel _getComponents() {
        if (this.mCertChain.length > 0 && this.mCertChain[0] instanceof X509Certificate) {
            final JTable jTable = new JTable();
            final JTextArea jTextArea = new JTextArea();
            final JTree jTree = this._buildCertChainTree();
            jTree.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)jTree.getLastSelectedPathComponent();
                    if (defaultMutableTreeNode != null) {
                        CertificateInfo certificateInfo = (CertificateInfo)defaultMutableTreeNode.getUserObject();
                        CertDialogUtility.this._showCertificateInfo(certificateInfo.getCertificate(), jTable, jTextArea);
                    }
                }
            });
            this._showCertificateInfo(this.mCertChain[0], jTable, jTextArea);
            jTable.setSelectionMode(0);
            ListSelectionModel listSelectionModel = jTable.getSelectionModel();
            listSelectionModel.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    int n = jTable.getSelectedRow();
                    if (n >= 0) {
                        String string = (String)jTable.getValueAt(n, 1);
                        jTextArea.setText(string);
                        jTextArea.repaint();
                    }
                }
            });
            jTextArea.setLineWrap(false);
            jTextArea.setEditable(false);
            jTextArea.setRows(10);
            jTextArea.setColumns(40);
            jTable.setRowSelectionInterval(8, 8);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            Dimension dimension = jTable.getPreferredScrollableViewportSize();
            dimension.setSize(dimension.getWidth(), 145.0);
            jTable.setPreferredScrollableViewportSize(dimension);
            JScrollPane jScrollPane = new JScrollPane(jTable);
            jScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0), jScrollPane.getBorder()));
            jPanel.add((Component)jScrollPane, "Center");
            jPanel.add((Component)new JScrollPane(jTextArea), "South");
            jPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BorderLayout());
            dimension = jTree.getPreferredScrollableViewportSize();
            dimension.setSize(200.0, 100.0);
            jScrollPane = new JScrollPane(jTree);
            jScrollPane.setPreferredSize(dimension);
            jPanel2.add((Component)jScrollPane, "West");
            jPanel2.add((Component)jPanel, "East");
            return jPanel2;
        }
        return new JPanel();
    }

    private void _showCertificateInfo(X509Certificate x509Certificate, JTable jTable, JTextArea jTextArea) {
        String string = "V" + x509Certificate.getVersion();
        String string2 = "[xxxxx-xxxxx]";
        String string3 = null;
        String string4 = null;
        try {
            string2 = "[" + x509Certificate.getSerialNumber() + "]";
            string3 = this._getCertFingerPrint("MD5", x509Certificate);
            string4 = this._getCertFingerPrint("SHA1", x509Certificate);
        }
        catch (Throwable throwable) {
            JOptionPane.showMessageDialog(null, mEMG.getMessage("FRM-92314"), mEMG.getMessage("FRM-92719"), 0);
            return;
        }
        String string5 = "[" + x509Certificate.getSigAlgName() + "]";
        String string6 = this._formatDNString(x509Certificate.getIssuerX500Principal().toString());
        String string7 = mEMG.getMessage("FRM-92721") + x509Certificate.getNotBefore() + System.lineSeparator() + mEMG.getMessage("FRM-92722") + x509Certificate.getNotAfter() + "]";
        String string8 = this._formatDNString(x509Certificate.getSubjectX500Principal().toString());
        String string9 = this.mCertHandler.toHexString(x509Certificate.getSignature());
        Object[][] objectArray = new Object[][]{{mEMG.getMessage("FRM-92723"), string}, {mEMG.getMessage("FRM-92724"), string2}, {mEMG.getMessage("FRM-92725"), string5}, {mEMG.getMessage("FRM-92726"), string6}, {mEMG.getMessage("FRM-92727"), string7}, {mEMG.getMessage("FRM-92728"), string8}, {mEMG.getMessage("FRM-92729"), string9}, {mEMG.getMessage("FRM-92730"), string3}, {mEMG.getMessage("FRM-92731"), string4}};
        Object[] objectArray2 = new String[]{mEMG.getMessage("FRM-92732"), mEMG.getMessage("FRM-92733")};
        DefaultTableModel defaultTableModel = new DefaultTableModel(objectArray, objectArray2);
        jTable.setModel(defaultTableModel);
        jTable.setDefaultEditor(Object.class, null);
        jTable.setRowSelectionInterval(8, 8);
        jTable.repaint();
        jTextArea.repaint();
    }

    private String _getCertFingerPrint(String string, X509Certificate x509Certificate) throws Exception {
        byte[] byArray = x509Certificate.getEncoded();
        MessageDigest messageDigest = MessageDigest.getInstance(string);
        byte[] byArray2 = messageDigest.digest(byArray);
        return this.mCertHandler.toHexString(byArray2);
    }

    private String _formatDNString(String string) {
        int n = string.length();
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == ' ') continue;
            if (c == '\"' || c == '\'') {
                boolean bl2 = bl = !bl;
            }
            if (c == ',' && !bl) {
                stringBuffer.append(",\n");
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private JTree _buildCertChainTree() {
        Serializable serializable;
        Serializable serializable2 = null;
        Serializable serializable3 = null;
        for (int i = 0; i < this.mCertChain.length; ++i) {
            serializable = new DefaultMutableTreeNode(new CertificateInfo(this.mCertChain[i]));
            if (serializable2 == null) {
                serializable2 = serializable;
                serializable3 = serializable;
                continue;
            }
            serializable3.add((MutableTreeNode)((Object)serializable));
            serializable3 = serializable;
        }
        JTree jTree = new JTree((TreeNode)((Object)serializable2));
        serializable = new DefaultTreeCellRenderer();
        serializable.putClientProperty("html.disable", Boolean.TRUE);
        jTree.setCellRenderer((TreeCellRenderer)((Object)serializable));
        jTree.getSelectionModel().setSelectionMode(1);
        jTree.putClientProperty("JTree.lineStyle", "Angled");
        return jTree;
    }

    public void setVal(boolean bl) {
        this.mVal = bl;
    }

    public boolean getVal() {
        return this.mVal;
    }

    public void setIsValid(boolean bl) {
        this.mIsValid = bl;
    }

    public boolean getIsValid() {
        return this.mIsValid;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        String string = "<html><a href=''>";
        String string2 = "</a></html>";
        String string3 = string.concat(MORE_INFORMATION + string2);
        this.mHyperLink.setText(string3);
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.mHyperLink.setText(MORE_INFORMATION);
    }

    class CertificateInfo {
        X509Certificate cert;

        CertificateInfo() {
        }

        CertificateInfo(X509Certificate x509Certificate) {
            this.cert = x509Certificate;
        }

        public X509Certificate getCertificate() {
            return this.cert;
        }

        private String extractAliasName(X509Certificate x509Certificate) {
            String string = null;
            String string2 = null;
            try {
                X500Principal x500Principal = x509Certificate.getSubjectX500Principal();
                X500Principal x500Principal2 = x509Certificate.getIssuerX500Principal();
                String string3 = x500Principal.getName();
                String string4 = x500Principal2.getName();
                string = this._extractFromQuote(string3, "CN=");
                if (string == null) {
                    string = this._extractFromQuote(string3, "O=");
                }
                if ((string2 = this._extractFromQuote(string4, "CN=")) == null) {
                    string2 = this._extractFromQuote(string4, "O=");
                }
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(null, mEMG.getMessage("FRM-92314"), mEMG.getMessage("FRM-92719"), 0);
                return null;
            }
            return string.concat(" (" + string2 + ")");
        }

        private String _extractFromQuote(String string, String string2) {
            if (string == null) {
                return null;
            }
            int n = string.indexOf(string2);
            int n2 = 0;
            if (n >= 0) {
                if ((n2 = string.charAt(n += string2.length()) == '\"' ? string.indexOf(34, ++n) : string.indexOf(44, n)) < 0) {
                    return string.substring(n);
                }
                return string.substring(n, n2);
            }
            return null;
        }

        public String toString() {
            return this.extractAliasName(this.cert);
        }
    }
}

