/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.common;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class Utils {
    private static final char[] BINARY_TO_HEX_DIGIT;
    private static final int[] HEX_DIGIT_TO_BINARY;
    private static final boolean[] IS_UNRESERVED;

    private Utils() {
    }

    public static final byte[] urlEncode(byte[] byArray, boolean bl, boolean bl2) {
        int n = 0;
        while (true) {
            if (n == byArray.length) {
                return byArray;
            }
            if (!IS_UNRESERVED[byArray[n] & 0xFF]) break;
            ++n;
        }
        byte[] byArray2 = Arrays.copyOf(byArray, n + (byArray.length - n) * 3);
        int n2 = n;
        while (n < byArray.length) {
            int n3;
            if (IS_UNRESERVED[n3 = byArray[n++] & 0xFF]) {
                byArray2[n2++] = (byte)n3;
                continue;
            }
            if (n3 == 32 && bl) {
                byArray2[n2++] = 43;
                continue;
            }
            byArray2[n2++] = 37;
            byArray2[n2++] = (byte)BINARY_TO_HEX_DIGIT[n3 >>> 4];
            byArray2[n2++] = (byte)BINARY_TO_HEX_DIGIT[n3 & 0xF];
        }
        byte[] byArray3 = Arrays.copyOf(byArray2, n2);
        if (bl2) {
            Arrays.fill(byArray, (byte)0);
            Arrays.fill(byArray2, 0, n2, (byte)0);
        }
        return byArray3;
    }

    public static final String urlEncode(String string) {
        return Utils.urlEncode(string, true);
    }

    public static final String urlEncode(String string, boolean bl) {
        int n = 0;
        byte[] byArray = string.getBytes(StandardCharsets.UTF_8);
        char[] cArray = new char[byArray.length * 3];
        boolean bl2 = false;
        for (byte by : byArray) {
            char c = (char)(by & 0xFF);
            if (IS_UNRESERVED[c]) {
                cArray[n++] = c;
                continue;
            }
            if (c == ' ' && bl) {
                cArray[n++] = 43;
                bl2 = true;
                continue;
            }
            cArray[n++] = 37;
            cArray[n++] = BINARY_TO_HEX_DIGIT[c >>> 4];
            cArray[n++] = BINARY_TO_HEX_DIGIT[c & 0xF];
        }
        if (n == string.length() && !bl2) {
            return string;
        }
        return new String(cArray, 0, n);
    }

    public static final String urlDecode(String string) {
        int n = 0;
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[cArray.length];
        boolean bl = false;
        int n2 = 0;
        while (n2 < cArray.length) {
            int n3;
            if ((n3 = cArray[n2++]) != 37) {
                if (n3 == 43) {
                    n3 = 32;
                    bl = true;
                }
                byArray[n++] = (byte)n3;
                continue;
            }
            if (n2 + 1 >= cArray.length) {
                throw new IllegalArgumentException("oracle.forms.common.Utils.urlDecode: Incomplete trailing escape (%) pattern");
            }
            int n4 = HEX_DIGIT_TO_BINARY[cArray[n2]] << 4 | HEX_DIGIT_TO_BINARY[cArray[n2 + 1]];
            if (n4 < 0) {
                throw new IllegalArgumentException("oracle.forms.common.Utils.urlDecode: Illegal hex characters in escape (%) pattern");
            }
            byArray[n++] = (byte)n4;
            n2 += 2;
        }
        if (n == cArray.length && !bl) {
            return string;
        }
        return new String(byArray, 0, n, StandardCharsets.UTF_8);
    }

    public static byte[] charsToUtf8Bytes(char[] cArray, boolean bl) {
        int n = 0;
        byte[] byArray = new byte[cArray.length];
        boolean bl2 = false;
        int n2 = 0;
        while (n2 < cArray.length) {
            int n3;
            if ((n3 = cArray[n2++]) < 128) {
                byArray[n++] = (byte)n3;
                continue;
            }
            if (!bl2) {
                byte[] byArray2 = Arrays.copyOf(byArray, n + (cArray.length - n) * 3);
                if (bl) {
                    Arrays.fill(byArray, 0, n, (byte)0);
                }
                byArray = byArray2;
                bl2 = true;
            }
            if (n3 < 2048) {
                byArray[n++] = (byte)(n3 >>> 6 & 0x1F | 0xC0);
                byArray[n++] = (byte)(n3 & 0x3F | 0x80);
                continue;
            }
            if ((n3 & 0xF800) == 55296) {
                char c;
                if ((n3 & 0x400) == 0 && n2 < cArray.length && ((c = cArray[n2]) & 0xFC00) == 56320) {
                    int n4 = 65536 + ((n3 & 0x3FF) << 10 | c & 0x3FF);
                    byArray[n++] = (byte)(n4 >>> 18 & 7 | 0xF0);
                    byArray[n++] = (byte)(n4 >>> 12 & 0x3F | 0x80);
                    byArray[n++] = (byte)(n4 >>> 6 & 0x3F | 0x80);
                    byArray[n++] = (byte)(n4 & 0x3F | 0x80);
                    ++n2;
                    continue;
                }
                n3 = 65533;
            }
            byArray[n++] = (byte)(n3 >>> 12 & 0xF | 0xE0);
            byArray[n++] = (byte)(n3 >>> 6 & 0x3F | 0x80);
            byArray[n++] = (byte)(n3 & 0x3F | 0x80);
        }
        if (!bl2) {
            return byArray;
        }
        byte[] byArray3 = Arrays.copyOf(byArray, n);
        if (bl) {
            Arrays.fill(byArray, 0, n, (byte)0);
        }
        return byArray3;
    }

    public static char[] utf8BytesToChars(byte[] byArray, boolean bl) {
        int n = 0;
        char[] cArray = new char[byArray.length];
        int n2 = 0;
        block0: while (n2 < byArray.length) {
            byte by;
            if ((by = byArray[n2++]) >= 0) {
                cArray[n++] = (char)by;
                continue;
            }
            if (by < -64) {
                cArray[n++] = 65533;
                continue;
            }
            int n3 = n2 + 1;
            byte by2 = -32;
            while (by >= by2) {
                if (by2 == -8) {
                    cArray[n++] = 65533;
                    continue block0;
                }
                by2 = (byte)(by2 >> 1);
                ++n3;
            }
            if (n3 > byArray.length) {
                cArray[n++] = 65533;
                break;
            }
            int n4 = by & ~by2;
            while (n2 < n3) {
                if (((by = byArray[n2++]) & 0xC0) != 128) {
                    --n2;
                    cArray[n++] = 65533;
                    continue block0;
                }
                n4 <<= 6;
                n4 |= by & 0x3F;
            }
            if (n4 <= 65535) {
                if ((n4 & 0xF800) == 55296) {
                    n4 = 65533;
                }
                cArray[n++] = (char)n4;
                continue;
            }
            if (n4 > 0x10FFFF) {
                cArray[n++] = 65533;
                continue;
            }
            cArray[n++] = (char)(0xD800 | (n4 -= 65536) >>> 10);
            cArray[n++] = (char)(0xDC00 | n4 & 0x3FF);
        }
        if (n == cArray.length) {
            return cArray;
        }
        char[] cArray2 = Arrays.copyOf(cArray, n);
        if (bl) {
            Arrays.fill(cArray, 0, n, '\u0000');
        }
        return cArray2;
    }

    public static int[] delimitPieces(byte[] byArray, int n) {
        int[] nArray = new int[byArray.length + 1];
        int n2 = 1;
        nArray[0] = -1;
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] != n) continue;
            nArray[n2++] = i;
        }
        nArray[n2++] = byArray.length;
        return Arrays.copyOf(nArray, n2);
    }

    public static String delimitedPiece(byte[] byArray, int[] nArray, int n) {
        return new String(byArray, nArray[n] + 1, nArray[n + 1] - (nArray[n] + 1), StandardCharsets.UTF_8);
    }

    public static byte[] delimitedPieceBytes(byte[] byArray, int[] nArray, int n, boolean bl) {
        byte[] byArray2 = Arrays.copyOfRange(byArray, nArray[n] + 1, nArray[n + 1]);
        if (bl) {
            Arrays.fill(byArray, nArray[n] + 1, nArray[n + 1], (byte)32);
        }
        return byArray2;
    }

    public static int indexOf(byte[] byArray, int n, int n2) {
        for (int i = n2; i < byArray.length; ++i) {
            if (byArray[i] != n) continue;
            return i;
        }
        return -1;
    }

    public static byte[] concat(byte[] ... byArray) {
        int n = 0;
        int n2 = 0;
        for (byte[] byArray2 : byArray) {
            n2 += byArray2.length;
        }
        byte[] byArray3 = new byte[n2];
        for (byte[] byArray2 : byArray) {
            System.arraycopy(byArray2, 0, byArray3, n, byArray2.length);
            n += byArray2.length;
        }
        return byArray3;
    }

    public static byte[] join(int n, byte[] ... byArray) {
        int n2 = 0;
        int n3 = -1;
        for (byte[] byArray2 : byArray) {
            n3 += byArray2.length + 1;
        }
        byte[] byArray3 = new byte[n3];
        for (byte[] byArray2 : byArray) {
            System.arraycopy(byArray2, 0, byArray3, n2, byArray2.length);
            if ((n2 += byArray2.length) == byArray3.length) break;
            byArray3[n2++] = (byte)n;
        }
        return byArray3;
    }

    public static byte[] hexStringToBytes(String string) {
        if ((string.length() & 1) != 0) {
            throw new IllegalArgumentException("odd number of hex digits");
        }
        int n = 0;
        int n2 = 0;
        byte[] byArray = string.getBytes(StandardCharsets.UTF_8);
        byte[] byArray2 = new byte[byArray.length / 2];
        n = 0;
        for (n2 = 0; n2 < byArray2.length; ++n2) {
            int n3 = HEX_DIGIT_TO_BINARY[byArray[n]] << 4 | HEX_DIGIT_TO_BINARY[byArray[n + 1]];
            if (n3 < 0) {
                throw new IllegalArgumentException("illegal hex digit at offset " + n);
            }
            byArray2[n2] = (byte)n3;
            n += 2;
        }
        return byArray2;
    }

    public static String hexStringToString(String string) {
        return new String(Utils.hexStringToBytes(string), StandardCharsets.UTF_8);
    }

    public static String bytesToHexString(byte[] byArray) {
        int n = 0;
        char[] cArray = new char[byArray.length * 2];
        for (byte by : byArray) {
            char c = (char)(by & 0xFF);
            cArray[n++] = BINARY_TO_HEX_DIGIT[c >>> 4];
            cArray[n++] = BINARY_TO_HEX_DIGIT[c & 0xF];
        }
        return new String(cArray);
    }

    public static String stringToHexString(String string) {
        return Utils.bytesToHexString(string.getBytes(StandardCharsets.UTF_8));
    }

    public static boolean getBoolEnvValue(String string, boolean bl) {
        switch (string.length()) {
            case 0: {
                return bl;
            }
            case 1: {
                switch (string.charAt(0)) {
                    case '0': 
                    case 'F': 
                    case 'N': 
                    case 'f': 
                    case 'n': {
                        return false;
                    }
                }
                break;
            }
            case 2: {
                switch (string) {
                    case "NO": 
                    case "No": 
                    case "no": {
                        return false;
                    }
                }
                break;
            }
            case 5: {
                switch (string) {
                    case "FALSE": 
                    case "False": 
                    case "false": {
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public static final String canonicalLowerCase(String string) {
        int n = string.length();
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        for (int i = 0; i < n; ++i) {
            cArray[i] = Character.toLowerCase(Character.toUpperCase(cArray[i]));
        }
        return new String(cArray);
    }

    public static final void obfuscateConcealedData(char[] cArray) {
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c > '\u14ff') continue;
            cArray[i] = (char)(c + 58368);
        }
    }

    public static final void deobfuscateConcealedData(char[] cArray) {
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c < '\ue400' || c > '\uf8ff') continue;
            cArray[i] = (char)(c - 58368);
        }
    }

    public static final boolean containsCookie(String string, String string2, boolean bl) {
        if (string == null) {
            return false;
        }
        if (bl) {
            string2 = string2 + "=";
        }
        return string.startsWith(string2) || string.contains("; " + string2);
    }

    public static String appendQueryString(String string, String string2) {
        int n = string.indexOf(35);
        String string3 = "";
        if (n >= 0) {
            string3 = string.substring(n);
            string = string.substring(0, n);
        }
        return string + (string.indexOf(63) >= 0 ? (char)'&' : '?') + string2 + string3;
    }

    public static final long ub4FromNetworkBytes(byte[] byArray, int n) {
        return ((long)byArray[n] & 0xFFL) << 24 | ((long)byArray[n + 1] & 0xFFL) << 16 | ((long)byArray[n + 2] & 0xFFL) << 8 | (long)byArray[n + 3] & 0xFFL;
    }

    public static final void ub4ToNetworkBytes(long l, byte[] byArray, int n) {
        byArray[n] = (byte)(l >>> 24);
        byArray[n + 1] = (byte)(l >>> 16);
        byArray[n + 2] = (byte)(l >>> 8);
        byArray[n + 3] = (byte)l;
    }

    public static final long ub8FromNetworkBytes(byte[] byArray, int n) {
        return ((long)byArray[n] & 0xFFL) << 56 | ((long)byArray[n + 1] & 0xFFL) << 48 | ((long)byArray[n + 2] & 0xFFL) << 40 | ((long)byArray[n + 3] & 0xFFL) << 32 | ((long)byArray[n + 4] & 0xFFL) << 24 | ((long)byArray[n + 5] & 0xFFL) << 16 | ((long)byArray[n + 6] & 0xFFL) << 8 | (long)byArray[n + 7] & 0xFFL;
    }

    public static final void ub8ToNetworkBytes(long l, byte[] byArray, int n) {
        byArray[n] = (byte)(l >>> 56);
        byArray[n + 1] = (byte)(l >>> 48);
        byArray[n + 2] = (byte)(l >>> 40);
        byArray[n + 3] = (byte)(l >>> 32);
        byArray[n + 4] = (byte)(l >>> 24);
        byArray[n + 5] = (byte)(l >>> 16);
        byArray[n + 6] = (byte)(l >>> 8);
        byArray[n + 7] = (byte)l;
    }

    public static int truncateUtf8(byte[] byArray, int n) {
        char c;
        if (byArray.length <= n) {
            return byArray.length;
        }
        if (n == 0) {
            return 0;
        }
        int n2 = n;
        if ((c = (char)(byArray[--n2] & 0xFF)) < '\u0080') {
            return n;
        }
        if (c >= '\u00c0') {
            return n2;
        }
        if (n2 == 0) {
            return n;
        }
        if ((c = (char)(byArray[--n2] & 0xFF)) >= '\u00e0') {
            return n2;
        }
        if (c >= '\u00c0') {
            return n;
        }
        if (c < '\u0080') {
            return n;
        }
        if (n2 == 0) {
            return n;
        }
        if ((c = (char)(byArray[--n2] & 0xFF)) >= '\u00f0') {
            return n2;
        }
        return n;
    }

    public static boolean hostMatches(String string, String string2) {
        if (string2.length() == 0) {
            return false;
        }
        string = Utils.canonicalLowerCase(string);
        string2 = Utils.canonicalLowerCase(string2);
        block0: for (String string3 : string2.split("\\|")) {
            String[] stringArray = string3.split("\\*", -1);
            int n = stringArray.length - 1;
            if (n == 0) {
                if (!string.equals(stringArray[0])) continue;
                return true;
            }
            int n2 = stringArray[0].length();
            if (!string.startsWith(stringArray[0]) || !string.substring(n2).endsWith(stringArray[n])) continue;
            if (n == 1) {
                return true;
            }
            int n3 = string.length() - stringArray[n].length();
            for (int i = 1; i < n; ++i) {
                if ((n2 = string.indexOf(stringArray[i], n2)) < 0 || (n2 += stringArray[i].length()) > n3) continue block0;
            }
            return true;
        }
        return false;
    }

    static {
        int n;
        BINARY_TO_HEX_DIGIT = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        HEX_DIGIT_TO_BINARY = new int[256];
        for (n = 0; n <= 255; ++n) {
            Utils.HEX_DIGIT_TO_BINARY[n] = -1;
        }
        for (n = 48; n <= 57; ++n) {
            Utils.HEX_DIGIT_TO_BINARY[n] = n - 48;
        }
        for (n = 65; n <= 70; ++n) {
            Utils.HEX_DIGIT_TO_BINARY[n] = n - 65 + 10;
        }
        for (n = 97; n <= 102; ++n) {
            Utils.HEX_DIGIT_TO_BINARY[n] = n - 97 + 10;
        }
        IS_UNRESERVED = new boolean[256];
        for (n = 48; n <= 57; ++n) {
            Utils.IS_UNRESERVED[n] = true;
        }
        for (n = 65; n <= 90; ++n) {
            Utils.IS_UNRESERVED[n] = true;
        }
        for (n = 97; n <= 122; ++n) {
            Utils.IS_UNRESERVED[n] = true;
        }
        Utils.IS_UNRESERVED[45] = true;
        Utils.IS_UNRESERVED[46] = true;
        Utils.IS_UNRESERVED[95] = true;
        Utils.IS_UNRESERVED[126] = true;
    }
}

