/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.common;

import java.util.Arrays;

public class JavaVersionChecker {
    private final String[] mTuple;
    private final boolean mUsePrefixMatch;
    private final boolean mUseGreaterThan;
    private final boolean mIsFamily;

    private JavaVersionChecker(String string) {
        if (string == null || string.length() == 0) {
            this.mTuple = new String[0];
            this.mUseGreaterThan = false;
            this.mUsePrefixMatch = false;
            this.mIsFamily = false;
            return;
        }
        if (string.endsWith("+")) {
            this.mUseGreaterThan = true;
            this.mUsePrefixMatch = false;
        } else if (string.endsWith("*")) {
            this.mUseGreaterThan = false;
            this.mUsePrefixMatch = true;
        } else {
            this.mUseGreaterThan = false;
            this.mUsePrefixMatch = false;
        }
        String[] stringArray = string.split("[+*-]", 2);
        this.mTuple = stringArray[0].split("[_.]");
        this.mIsFamily = this.mTuple.length > 2 && this.mUsePrefixMatch;
    }

    public static boolean compareJavaVersions(String string, String string2) {
        JavaVersionChecker javaVersionChecker = new JavaVersionChecker(string);
        return javaVersionChecker._match(new JavaVersionChecker(string2));
    }

    private boolean _matchTuple(Object object) {
        if (object == null || !(object instanceof JavaVersionChecker)) {
            return false;
        }
        JavaVersionChecker javaVersionChecker = (JavaVersionChecker)object;
        String[] stringArray = this._padTo(this.mTuple, javaVersionChecker.mTuple.length);
        String[] stringArray2 = this._padTo(javaVersionChecker.mTuple, this.mTuple.length);
        for (int i = 0; i < stringArray.length; ++i) {
            Object object2;
            Object object3 = this._getValueAsObject(stringArray[i]);
            if (object3.equals(object2 = this._getValueAsObject(stringArray2[i]))) continue;
            return false;
        }
        return true;
    }

    private Object _getValueAsObject(String string) {
        if (string.length() > 0) {
            try {
                return Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return string;
    }

    private boolean _isGreaterThanOrEqual(JavaVersionChecker javaVersionChecker, boolean bl) {
        String[] stringArray = this._padTo(javaVersionChecker.mTuple, this.mTuple.length);
        String[] stringArray2 = this._padTo(this.mTuple, javaVersionChecker.mTuple.length);
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            Object object2 = this._getValueAsObject(stringArray[i]);
            if (object2.equals(object = this._getValueAsObject(stringArray2[i]))) continue;
            if (object2 instanceof Integer && object instanceof Integer) {
                return (Integer)object2 > (Integer)object;
            }
            return false;
        }
        return bl;
    }

    private String[] _padTo(String[] stringArray, int n) {
        if (stringArray.length < n) {
            Object[] objectArray = new String[n];
            System.arraycopy(stringArray, 0, objectArray, 0, stringArray.length);
            Arrays.fill(objectArray, stringArray.length, objectArray.length, "0");
            return objectArray;
        }
        return stringArray;
    }

    private boolean _isPrefixMatchTuple(JavaVersionChecker javaVersionChecker) {
        String[] stringArray = this._padTo(javaVersionChecker.mTuple, this.mTuple.length);
        for (int i = 0; i < this.mTuple.length; ++i) {
            Object object;
            Object object2 = this._getValueAsObject(this.mTuple[i]);
            if (object2.equals(object = this._getValueAsObject(stringArray[i]))) continue;
            if (this.mIsFamily && i == this.mTuple.length - 1 && object2 instanceof Integer && object instanceof Integer) {
                return (Integer)object2 < (Integer)object;
            }
            return false;
        }
        return true;
    }

    private boolean _match(JavaVersionChecker javaVersionChecker) {
        return this.mUsePrefixMatch ? this._isPrefixMatchTuple(javaVersionChecker) : (this.mUseGreaterThan ? this._isGreaterThanOrEqual(javaVersionChecker, true) : this._matchTuple(javaVersionChecker));
    }
}

