/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.common;

import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class InitialNBytesInputStream
extends FilterInputStream {
    private long mBytesRemaining;
    private boolean mAllRequired;
    private boolean mInRead = false;

    public InitialNBytesInputStream(InputStream inputStream, long l, boolean bl) {
        super(inputStream);
        this.mBytesRemaining = l;
        this.mAllRequired = bl;
    }

    @Override
    public int read() throws IOException {
        if (this.mBytesRemaining <= 0L || this.mInRead) {
            return -1;
        }
        this.mInRead = true;
        int n = super.read();
        if (n >= 0) {
            --this.mBytesRemaining;
        } else if (this.mAllRequired) {
            throw new EOFException();
        }
        this.mInRead = false;
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.mBytesRemaining <= 0L || this.mInRead) {
            return -1;
        }
        if ((long)n2 > this.mBytesRemaining) {
            n2 = (int)this.mBytesRemaining;
        }
        this.mInRead = true;
        int n3 = super.read(byArray, n, n2);
        if (n3 >= 0) {
            this.mBytesRemaining -= (long)n3;
        } else if (this.mAllRequired) {
            throw new EOFException();
        }
        this.mInRead = false;
        return n3;
    }

    @Override
    public long skip(long l) throws IOException {
        if (this.mBytesRemaining <= 0L || this.mInRead) {
            return 0L;
        }
        if (l > this.mBytesRemaining) {
            l = this.mBytesRemaining;
        }
        this.mInRead = true;
        long l2 = super.skip(l);
        this.mBytesRemaining -= l2;
        if (l2 < l && this.mAllRequired) {
            throw new EOFException();
        }
        this.mInRead = false;
        return l2;
    }

    @Override
    public int available() throws IOException {
        if (this.mBytesRemaining <= 0L || this.mInRead) {
            return 0;
        }
        int n = super.available();
        if ((long)n > this.mBytesRemaining) {
            n = (int)this.mBytesRemaining;
        }
        return n;
    }

    @Override
    public void close() throws IOException {
        this.skip(this.mBytesRemaining);
    }

    @Override
    public synchronized void mark(int n) {
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    public long bytesRemaining() {
        return this.mBytesRemaining;
    }

    public boolean inRead() {
        return this.mInRead;
    }
}

