/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.common;

import java.io.FileInputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import oracle.forms.common.Base64Basic;
import oracle.forms.common.Charsets;

public class CheckSumUtil {
    private static final String DIGEST_ALGORITHM = "SHA-256";

    private CheckSumUtil() {
    }

    public static String generateSecureCheckSumOfFile(String string) throws Exception {
        int n;
        FileInputStream fileInputStream = new FileInputStream(string);
        MessageDigest messageDigest = MessageDigest.getInstance(DIGEST_ALGORITHM);
        messageDigest.reset();
        byte[] byArray = new byte[1024];
        while ((n = fileInputStream.read(byArray)) != -1) {
            messageDigest.update(byArray, 0, n);
        }
        return Base64Basic.encodeToString(messageDigest.digest());
    }

    public static String getMD5CheckSumOfString(String string, int n) {
        try {
            byte[] byArray = new byte[17];
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(string.getBytes(Charsets.UTF_8));
            messageDigest.digest(byArray, 1, 16);
            return new BigInteger(byArray).toString(n);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

