/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.common;

import java.util.Arrays;
import java.util.Locale;

public class CharsetMapper {
    private static final String[] mOracleCharsets = new String[]{"AL16UTF16", "AL32UTF8", "AR8ARABICMAC", "AR8ARABICMACS", "AR8EBCDIC420S", "AR8EBCDICX", "AR8ISO8859P6", "AR8MSWIN1256", "BLT8CP921", "BLT8EBCDIC1112", "BLT8EBCDIC1112S", "BLT8ISO8859P13", "BLT8MSWIN1257", "BLT8PC775", "CDN8PC863", "CL8EBCDIC1025", "CL8EBCDIC1025C", "CL8EBCDIC1025R", "CL8EBCDIC1025S", "CL8EBCDIC1025X", "CL8ISO8859P5", "CL8KOI8R", "CL8MACCYRILLIC", "CL8MACCYRILLICS", "CL8MSWIN1251", "D8EBCDIC1141", "D8EBCDIC273", "DK8EBCDIC1142", "DK8EBCDIC277", "EE8EBCDIC870", "EE8EBCDIC870C", "EE8EBCDIC870S", "EE8ISO8859P2", "EE8MACCE", "EE8MACCES", "EE8MACCROATIAN", "EE8MACCROATIANS", "EE8MSWIN1250", "EE8PC852", "EL8EBCDIC875", "EL8EBCDIC875R", "EL8ISO8859P7", "EL8MSWIN1253", "EL8PC737", "EL8PC869", "F8EBCDIC1147", "F8EBCDIC297", "I8EBCDIC1144", "I8EBCDIC280", "IS8MACICELANDIC", "IS8MACICELANDICS", "IS8PC861", "IW8EBCDIC424", "IW8EBCDIC424S", "IW8ISO8859P8", "IW8MACHEBREW", "IW8MACHEBREWS", "IW8MSWIN1255", "IW8PC1507", "JA16EBCDIC930", "JA16EUC", "JA16EUCTILDE", "JA16EUCYEN", "JA16SJIS", "JA16SJISTILDE", "JA16SJISYEN", "JA16VMS", "KO16KSC5601", "KO16MSWIN949", "LT8MSWIN921", "N8PC865", "NEE8ISO8859P4", "RU8PC855", "RU8PC866", "S8EBCDIC1143", "S8EBCDIC278", "SE8ISO8859P3", "TH8MACTHAI", "TH8MACTHAIS", "TH8TISASCII", "TH8TISEBCDIC", "TH8TISEBCDICS", "TR8EBCDIC1026", "TR8EBCDIC1026S", "TR8MACTURKISH", "TR8MACTURKISHS", "TR8MSWIN1254", "TR8PC857", "US7ASCII", "US8PC437", "UTF8", "VN8MSWIN1258", "WE8EBCDIC1047", "WE8EBCDIC1047E", "WE8EBCDIC1140", "WE8EBCDIC1140C", "WE8EBCDIC1145", "WE8EBCDIC1146", "WE8EBCDIC1148", "WE8EBCDIC1148C", "WE8EBCDIC284", "WE8EBCDIC285", "WE8EBCDIC37", "WE8EBCDIC37C", "WE8EBCDIC500", "WE8EBCDIC500C", "WE8EBCDIC871", "WE8ISO8859P1", "WE8ISO8859P15", "WE8ISO8859P9", "WE8MACROMAN8", "WE8MACROMAN8S", "WE8MSWIN1252", "WE8PC850", "WE8PC858", "WE8PC860", "ZHS16CGB231280", "ZHS16GBK", "ZHS32GB18030", "ZHT16BIG5", "ZHT16HKSCS", "ZHT16MSWIN950", "ZHT32EUC"};
    private static final String[] mJavaCharsets = new String[]{"UTF-16BE", "UTF-8", "MacArabic", "MacArabic", "CP420", "CP420", "ISO-8859-6", "WINDOWS-1256", "CP921", "CP1112", "CP1112", "ISO-8859-13", "WINDOWS-1257", "CP775", "CP863", "CP1025", "CP1025", "CP1025", "CP1025", "CP1025", "ISO-8859-5", "KOI8-R", "MacCyrillic", "MacCyrillic", "WINDOWS-1251", "Cp1141", "CP273", "Cp1142", "IBM277", "CP870", "CP870", "CP870", "ISO-8859-2", "MacCentralEurope", "MacCentralEurope", "MacCroatian", "MacCroatian", "WINDOWS-1250", "CP852", "CP875", "CP875", "ISO-8859-7", "WINDOWS-1253", "CP737", "CP869", "Cp1147", "CP297", "Cp1144", "CP280", "MacIceland", "MacIceland", "CP861", "CP424", "CP424", "ISO-8859-8", "MacHebrew", "MacHebrew", "WINDOWS-1255", "CP862", "CP930", "EUC-JP", "EUC-JP", "EUC-JP", "MS932", "MS932", "MS932", "EUC-JP", "MS949", "MS949", "CP921", "CP865", "ISO-8859-4", "CP855", "CP866", "Cp1143", "CP278", "ISO-8859-3", "MacThai", "MacThai", "MS874", "CP838", "CP838", "CP1026", "CP1026", "MacTurkish", "MacTurkish", "WINDOWS-1254", "CP857", "US-ASCII", "CP437", "UTF-8", "WINDOWS-1258", "Cp1047", "Cp1047", "Cp1140", "Cp1140", "Cp1145", "Cp1146", "Cp1148", "Cp1148", "CP284", "CP285", "CP037", "CP037", "CP500", "CP500", "CP871", "ISO-8859-1", "ISO-8859-15", "ISO-8859-9", "MacRoman", "MacRoman", "WINDOWS-1252", "CP850", "Cp858", "CP860", "MS936", "MS936", "GB18030", "MS950", "MS950_HKSCS", "MS950", "EUC-TW"};

    private CharsetMapper() {
    }

    public static String javaFromOracle(String string) {
        int n = Arrays.binarySearch(mOracleCharsets, string.toUpperCase(Locale.ROOT));
        if (n < 0) {
            return null;
        }
        return mJavaCharsets[n];
    }
}

