/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.common;

import java.util.Arrays;
import oracle.forms.common.Charsets;

public class Base64Basic {
    private static final char[] toBase64 = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static final int[] fromBase64 = new int[256];

    private Base64Basic() {
    }

    private static final int outLength(int n) {
        return 4 * ((n + 2) / 3);
    }

    public static byte[] encode(byte[] byArray) {
        return Base64Basic.encode(byArray, false);
    }

    public static byte[] encode(byte[] byArray, boolean bl) {
        int n = Base64Basic.outLength(byArray.length);
        byte[] byArray2 = new byte[n];
        int n2 = Base64Basic.encode0(byArray, 0, byArray.length, byArray2);
        if (n2 != byArray2.length) {
            byte[] byArray3 = byArray2;
            byArray2 = Arrays.copyOf(byArray2, n2);
            if (bl) {
                Arrays.fill(byArray3, (byte)32);
            }
        }
        return byArray2;
    }

    public static String encodeToString(byte[] byArray) {
        byte[] byArray2 = Base64Basic.encode(byArray);
        return new String(byArray2, 0, 0, byArray2.length);
    }

    private static int encode0(byte[] byArray, int n, int n2, byte[] byArray2) {
        int n3;
        int n4;
        char[] cArray = toBase64;
        int n5 = n;
        int n6 = (n2 - n) / 3 * 3;
        int n7 = n + n6;
        int n8 = 0;
        while (n5 < n7) {
            n4 = Math.min(n5 + n6, n7);
            n3 = n5;
            int n9 = n8;
            while (n3 < n4) {
                int n10 = (byArray[n3++] & 0xFF) << 16 | (byArray[n3++] & 0xFF) << 8 | byArray[n3++] & 0xFF;
                byArray2[n9++] = (byte)cArray[n10 >>> 18 & 0x3F];
                byArray2[n9++] = (byte)cArray[n10 >>> 12 & 0x3F];
                byArray2[n9++] = (byte)cArray[n10 >>> 6 & 0x3F];
                byArray2[n9++] = (byte)cArray[n10 & 0x3F];
            }
            n3 = (n4 - n5) / 3 * 4;
            n8 += n3;
            n5 = n4;
        }
        if (n5 < n2) {
            n4 = byArray[n5++] & 0xFF;
            byArray2[n8++] = (byte)cArray[n4 >> 2];
            if (n5 == n2) {
                byArray2[n8++] = (byte)cArray[n4 << 4 & 0x3F];
                byArray2[n8++] = 61;
                byArray2[n8++] = 61;
            } else {
                n3 = byArray[n5++] & 0xFF;
                byArray2[n8++] = (byte)cArray[n4 << 4 & 0x3F | n3 >> 4];
                byArray2[n8++] = (byte)cArray[n3 << 2 & 0x3F];
                byArray2[n8++] = 61;
            }
        }
        return n8;
    }

    public static byte[] decode(byte[] byArray) {
        byte[] byArray2 = new byte[Base64Basic.outLength(byArray, 0, byArray.length)];
        int n = Base64Basic.decode0(byArray, 0, byArray.length, byArray2);
        if (n != byArray2.length) {
            byArray2 = Arrays.copyOf(byArray2, n);
        }
        return byArray2;
    }

    public static byte[] decode(String string) {
        return Base64Basic.decode(string.getBytes(Charsets.ISO_8859_1));
    }

    private static int outLength(byte[] byArray, int n, int n2) {
        int n3 = 0;
        int n4 = n2 - n;
        if (n4 == 0) {
            return 0;
        }
        if (n4 < 2) {
            throw new IllegalArgumentException("Input byte[] should at least have 2 bytes for base64 bytes");
        }
        if (byArray[n2 - 1] == 61) {
            ++n3;
            if (byArray[n2 - 2] == 61) {
                ++n3;
            }
        }
        if (n3 == 0 && (n4 & 3) != 0) {
            n3 = 4 - (n4 & 3);
        }
        return 3 * ((n4 + 3) / 4) - n3;
    }

    private static int decode0(byte[] byArray, int n, int n2, byte[] byArray2) {
        int[] nArray = fromBase64;
        int n3 = 0;
        int n4 = 0;
        int n5 = 18;
        while (n < n2) {
            int n6 = byArray[n++] & 0xFF;
            if ((n6 = nArray[n6]) < 0) {
                if (n6 == -2) {
                    if ((n5 != 6 || n != n2 && byArray[n++] == 61) && n5 != 18) break;
                    throw new IllegalArgumentException("Input byte array has wrong 4-byte ending unit");
                }
                if (n6 == -3) continue;
                throw new IllegalArgumentException("Illegal base64 character " + Integer.toString(byArray[n - 1], 16));
            }
            n4 |= n6 << n5;
            if ((n5 -= 6) >= 0) continue;
            byArray2[n3++] = (byte)(n4 >> 16);
            byArray2[n3++] = (byte)(n4 >> 8);
            byArray2[n3++] = (byte)n4;
            n5 = 18;
            n4 = 0;
        }
        if (n5 == 6) {
            byArray2[n3++] = (byte)(n4 >> 16);
        } else if (n5 == 0) {
            byArray2[n3++] = (byte)(n4 >> 16);
            byArray2[n3++] = (byte)(n4 >> 8);
        } else if (n5 == 12) {
            throw new IllegalArgumentException("Last unit does not have enough valid bits");
        }
        if (n < n2) {
            throw new IllegalArgumentException("Input byte array has incorrect ending byte at " + n);
        }
        return n3;
    }

    static {
        Arrays.fill(fromBase64, -1);
        for (int i = 0; i < toBase64.length; ++i) {
            Base64Basic.fromBase64[Base64Basic.toBase64[i]] = i;
        }
        Base64Basic.fromBase64[61] = -2;
        Base64Basic.fromBase64[10] = -3;
        Base64Basic.fromBase64[13] = -3;
    }
}

