/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Window;
import oracle.ewt.event.tracking.MouseGrabProvider;

public final class ComponentUtils {
    private ComponentUtils() {
    }

    public static Point translatePoint(Component component, Component component2, int n, int n2) {
        while (component != component2) {
            Point point = component.getLocation();
            n += point.x;
            n2 += point.y;
            component = component.getParent();
        }
        return new Point(n, n2);
    }

    public static Component getTopmostParent(Component component, Point point) {
        Container container;
        int n = point.x;
        int n2 = point.y;
        while (!(component instanceof Window) && component != null && component.isLightweight() && (container = component.getParent()) != null) {
            Point point2 = component.getLocation();
            n += point2.x;
            n2 += point2.y;
            component = container;
        }
        point.x = n;
        point.y = n2;
        return component;
    }

    public static Component getTargetComponentOutside(Component component, Point point) {
        Component component2 = ComponentUtils.getTopmostParent(component, point);
        return ComponentUtils.getTargetComponent(component2, point);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Component getTargetComponent(Component component, Point point) {
        Component component2 = null;
        if (component instanceof MouseGrabProvider) {
            component2 = ((MouseGrabProvider)((Object)component)).getProxyComponent();
        }
        int n = point.x;
        int n2 = point.y;
        if (component instanceof Container) {
            Container container = (Container)component;
            Object object = container.getTreeLock();
            synchronized (object) {
                int n3 = container.getComponentCount();
                for (int i = 0; i < n3; ++i) {
                    Component component3 = container.getComponent(i);
                    Point point2 = component3.getLocation();
                    int n4 = n - point2.x;
                    int n5 = n2 - point2.y;
                    if (component3 == component2 || !component3.isVisible() || !component3.contains(n4, n5)) continue;
                    point.x = n4;
                    point.y = n5;
                    return ComponentUtils.getTargetComponent(component3, point);
                }
            }
        }
        return component;
    }
}

