/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.tabBar;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import oracle.bali.share.util.IntegerUtils;
import oracle.ewt.graphics.ImageSet;
import oracle.ewt.graphics.SynthesizingImageSet;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.painter.PaintContextProxy;
import oracle.ewt.plaf.TabBarUI;
import oracle.ewt.tabBar.TabBar;
import oracle.ewt.tabBar.TabBarEvent;
import oracle.ewt.tabBar.TabBarValidateEvent;
import oracle.ewt.util.ImmInsets;

public class TabBarItem
extends PaintContextProxy
implements Accessible {
    private String _label;
    private ImageSet _imageSet;
    private TabBar _parent;
    private int _x;
    private int _y;
    private int _width;
    private int _height;
    private boolean _disabled;
    private boolean _selected;
    private boolean _hidden;
    private Object _mnemonic;
    private AccessibleContext _accessibleContext;

    public TabBarItem(String string) {
        this._label = string;
    }

    public Rectangle getBounds() {
        if (this.isSelected()) {
            return this.getSelectedBounds();
        }
        return new Rectangle(this._x, this._y, this._width, this._height);
    }

    public Rectangle getOuterBounds() {
        Rectangle rectangle = this.getBounds();
        TabBar tabBar = this.getParent();
        if (tabBar != null) {
            Point point = tabBar.convertCanvasToOuter(0, 0);
            rectangle.x += point.x;
            rectangle.y += point.y;
        }
        return rectangle;
    }

    public synchronized void setEnabled(boolean bl) {
        if (bl == this._disabled) {
            Object object;
            boolean bl2 = this.isEnabled();
            boolean bl3 = this._disabled = !bl;
            if (!bl && this.isSelected() && (object = this.getParent()) != null) {
                ((TabBar)object)._moveSelection(true);
            }
            if (bl2 != this.isEnabled()) {
                this.repaint();
                object = this._accessibleContext;
                if (object != null) {
                    ((AccessibleContext)object).firePropertyChange("AccessibleState", bl ? AccessibleState.ENABLED : null, bl ? null : AccessibleState.ENABLED);
                }
            }
        }
    }

    public synchronized void setVisible(boolean bl) {
        if (bl != this.isVisible()) {
            AccessibleContext accessibleContext;
            TabBar tabBar = this.getParent();
            boolean bl2 = this._hidden = !bl;
            if (!bl && this.isSelected() && tabBar != null) {
                tabBar._moveSelection(true);
            }
            if (tabBar != null) {
                tabBar.invalidateCanvas();
            }
            if ((accessibleContext = this._accessibleContext) != null) {
                accessibleContext.firePropertyChange("AccessibleState", bl ? null : AccessibleState.VISIBLE, bl ? AccessibleState.VISIBLE : null);
            }
        }
    }

    public boolean contains(int n, int n2) {
        return this.getBounds().contains(n, n2);
    }

    public boolean isVisible() {
        return !this._hidden;
    }

    public boolean isEnabled() {
        TabBar tabBar;
        boolean bl = this.isItemEnabled();
        if (bl && (tabBar = this.getParent()) != null) {
            bl = tabBar.isEnabled();
        }
        return bl;
    }

    public Dimension getSize() {
        Rectangle rectangle = this.getBounds();
        return new Dimension(rectangle.width, rectangle.height);
    }

    public Dimension getPreferredSize() {
        TabBarUI tabBarUI;
        TabBar tabBar = this.getParent();
        if (tabBar != null && (tabBarUI = tabBar.getTabBarUI()) != null) {
            return tabBarUI.getTabPainter(tabBar, false, false).getPreferredSize(this);
        }
        return new Dimension(0, 0);
    }

    public Dimension getMinimumSize() {
        TabBarUI tabBarUI;
        TabBar tabBar = this.getParent();
        if (tabBar != null && (tabBarUI = tabBar.getTabBarUI()) != null) {
            return tabBarUI.getTabPainter(tabBar, false, false).getMinimumSize(this);
        }
        return new Dimension(0, 0);
    }

    public int indexOf() {
        TabBar tabBar = this.getParent();
        if (tabBar != null) {
            return tabBar.getIndexOf(this);
        }
        return -1;
    }

    public String getLabel() {
        return this._label;
    }

    public ImageSet getImageSet() {
        return this._imageSet;
    }

    public void setImageSet(ImageSet imageSet) {
        if (imageSet != this._imageSet) {
            this._imageSet = imageSet;
            TabBar tabBar = this.getParent();
            if (tabBar != null) {
                tabBar.invalidateCanvas();
            }
        }
    }

    TabBar getParent() {
        return this._parent;
    }

    public final void setIcon(Image image) {
        this.setImageSet(image != null ? new SynthesizingImageSet(image, 1) : null);
    }

    public void setLabel(String string) {
        AccessibleContext accessibleContext = this._accessibleContext;
        String string2 = accessibleContext == null ? null : accessibleContext.getAccessibleName();
        String string3 = this.getLabel();
        this._label = string;
        TabBar tabBar = this.getParent();
        if (tabBar != null) {
            tabBar.invalidateCanvas();
        }
        if (accessibleContext != null) {
            String string4;
            if (string3 != string) {
                accessibleContext.firePropertyChange("AccessibleVisibleData", string3, string);
            }
            if ((string4 = accessibleContext.getAccessibleName()) != string2) {
                accessibleContext.firePropertyChange("AccessibleName", string2, string4);
            }
        }
    }

    public void setMnemonicIndex(int n) {
        if (n != this.getMnemonicIndex()) {
            this._mnemonic = n != -1 ? IntegerUtils.getInteger(n) : null;
            this.repaint();
        }
    }

    public void setMnemonicChar(char c) {
        if (c != this.getMnemonicChar()) {
            this._mnemonic = c != '\u0000' ? new Character(c) : null;
            this.repaint();
        }
    }

    public int getMnemonicIndex() {
        if (this._mnemonic != null) {
            int n;
            if (this._mnemonic instanceof Integer) {
                return (Integer)this._mnemonic;
            }
            String string = this.getLabel();
            if (string != null && (n = string.indexOf(((Character)this._mnemonic).charValue())) != -1) {
                return n;
            }
        }
        return -1;
    }

    public char getMnemonicChar() {
        if (this._mnemonic != null) {
            int n;
            if (this._mnemonic instanceof Character) {
                return ((Character)this._mnemonic).charValue();
            }
            String string = this.getLabel();
            if (string != null && (n = ((Integer)this._mnemonic).intValue()) < string.length()) {
                return string.charAt(n);
            }
        }
        return '\u0000';
    }

    public boolean isSelected() {
        return this._selected;
    }

    public void setSelected(boolean bl) {
        if (bl != this.isSelected()) {
            TabBar tabBar = this.getParent();
            if (!bl) {
                Rectangle rectangle = this.getBounds();
                this._selected = false;
                if (tabBar != null) {
                    tabBar.itemDeselected(this);
                }
                this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            } else if (tabBar != null) {
                TabBarValidateEvent tabBarValidateEvent = new TabBarValidateEvent(tabBar, 2000, this);
                TabBarItem tabBarItem = tabBar.getSelectedItem();
                if (tabBarItem == null || tabBarItem.isEnabled() && tabBarItem.isVisible() && tabBarItem.getParent() != null) {
                    tabBar.dispatchEvent(tabBarValidateEvent);
                }
                if (!tabBarValidateEvent.isCancelled()) {
                    this.makeSelected();
                    tabBar.scrollIntoView(this);
                    this.repaint();
                }
            }
        }
    }

    public void setSize(int n, int n2) {
        this._width = n;
        this._height = n2;
    }

    public void setLocation(int n, int n2) {
        this._x = n;
        this._y = n2;
    }

    public final void repaint() {
        TabBar tabBar = this.getParent();
        if (tabBar != null) {
            ImmInsets immInsets = this.isSelected() ? tabBar.getTabBarUI().getSelectedItemOutsets(tabBar) : ImmInsets.getEmptyInsets();
            this.repaint(this._x - immInsets.left, this._y - immInsets.top, this._width + immInsets.left + immInsets.right, this._height + immInsets.top + immInsets.bottom);
        }
    }

    public void repaint(int n, int n2, int n3, int n4) {
        TabBar tabBar = this.getParent();
        if (tabBar != null) {
            tabBar.repaintCanvas(n, n2, n3, n4);
        }
    }

    @Override
    public Object getPaintData(Object object) {
        if (object.equals(PaintContext.IMAGESET_KEY)) {
            return this.getImageSet();
        }
        if (object.equals(PaintContext.LABEL_KEY)) {
            return this.getLabel();
        }
        if (object == TabBarUI.MNEMONIC_INDEX_KEY && this._mnemonic != null) {
            if (this._mnemonic instanceof Integer) {
                return this._mnemonic;
            }
            return IntegerUtils.getInteger(this.getMnemonicIndex());
        }
        return super.getPaintData(object);
    }

    @Override
    public int getPaintState() {
        int n = super.getPaintState();
        if (!this.isEnabled()) {
            n |= 1;
        }
        n = this.isSelected() ? (n |= 0x80) : (n &= 0xFFFFFFDF);
        return n;
    }

    @Override
    public Color getPaintBackground() {
        if (this.isSelected()) {
            if (this._parent.isActive()) {
                return this._parent.getSelectedBackground();
            }
            return this._parent.getSelectedInactiveBackground();
        }
        return this._parent.getItemBackground();
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this._accessibleContext == null) {
            this._accessibleContext = new Access();
        }
        return this._accessibleContext;
    }

    protected void makeSelected() {
        this._selected = true;
        TabBar tabBar = this.getParent();
        if (tabBar != null) {
            tabBar.dispatchEvent(new TabBarEvent(tabBar, 2001, this));
        }
    }

    protected void mousePressed(MouseEvent mouseEvent, int n, int n2) {
        if (this.isItemEnabled() && this.contains(n, n2) && !this.isSelected()) {
            this.setSelected(true);
        }
    }

    protected boolean isItemEnabled() {
        return !this._disabled;
    }

    @Override
    protected PaintContext getPaintContext() {
        return this._parent.getPaintContext();
    }

    void setParent(TabBar tabBar) {
        this._parent = tabBar;
    }

    Rectangle getSelectedBounds() {
        Rectangle rectangle = new Rectangle(this._x, this._y, this._width, this._height);
        TabBar tabBar = this.getParent();
        if (tabBar != null) {
            ImmInsets immInsets = tabBar.getTabBarUI().getSelectedItemOutsets(tabBar);
            rectangle.x -= immInsets.left;
            rectangle.y -= immInsets.top;
            rectangle.width += immInsets.left + immInsets.right;
            rectangle.height += immInsets.top + immInsets.bottom;
        }
        return rectangle;
    }

    private class Access
    extends AccessibleContext
    implements AccessibleComponent {
        private Access() {
        }

        @Override
        public Accessible getAccessibleParent() {
            return TabBarItem.this.getParent();
        }

        @Override
        public String getAccessibleName() {
            if (this.accessibleName != null) {
                return this.accessibleName;
            }
            return TabBarItem.this.getLabel();
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PAGE_TAB;
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = TabBarItem.this.getParent().getAccessibleContext().getAccessibleStateSet();
            accessibleStateSet.add(AccessibleState.SELECTABLE);
            accessibleStateSet.add(AccessibleState.FOCUSABLE);
            if (TabBarItem.this.isSelected()) {
                accessibleStateSet.add(AccessibleState.SELECTED);
                if (TabBarItem.this.getParent().hasFocus()) {
                    accessibleStateSet.add(AccessibleState.FOCUSED);
                }
            }
            return accessibleStateSet;
        }

        @Override
        public int getAccessibleIndexInParent() {
            return TabBarItem.this.getParent().getIndexOf(TabBarItem.this);
        }

        @Override
        public int getAccessibleChildrenCount() {
            return 0;
        }

        @Override
        public Accessible getAccessibleChild(int n) {
            return null;
        }

        @Override
        public Locale getLocale() {
            return TabBarItem.this.getParent().getLocale();
        }

        @Override
        public AccessibleComponent getAccessibleComponent() {
            return this;
        }

        @Override
        public Color getBackground() {
            return TabBarItem.this.getParent().getBackground();
        }

        @Override
        public void setBackground(Color color) {
        }

        @Override
        public Color getForeground() {
            return TabBarItem.this.getParent().getForeground();
        }

        @Override
        public void setForeground(Color color) {
        }

        @Override
        public Cursor getCursor() {
            Cursor cursor = TabBarItem.this.getParent().getCursor();
            if (cursor == null) {
                cursor = Cursor.getDefaultCursor();
            }
            return cursor;
        }

        @Override
        public void setCursor(Cursor cursor) {
        }

        @Override
        public Font getFont() {
            return TabBarItem.this.getParent().getFont();
        }

        @Override
        public void setFont(Font font) {
        }

        @Override
        public FontMetrics getFontMetrics(Font font) {
            return TabBarItem.this.getParent().getFontMetrics(font);
        }

        @Override
        public boolean isEnabled() {
            return TabBarItem.this.isEnabled();
        }

        @Override
        public void setEnabled(boolean bl) {
            TabBarItem.this.setEnabled(bl);
        }

        @Override
        public boolean isVisible() {
            return TabBarItem.this.isVisible();
        }

        @Override
        public void setVisible(boolean bl) {
            TabBarItem.this.setVisible(bl);
        }

        @Override
        public boolean isShowing() {
            return this.isVisible() && TabBarItem.this.getParent().isShowing();
        }

        @Override
        public boolean contains(Point point) {
            Rectangle rectangle = this.getBounds();
            if (rectangle == null) {
                return false;
            }
            return rectangle.contains(point);
        }

        @Override
        public Point getLocationOnScreen() {
            if (!this.isShowing()) {
                return null;
            }
            TabBar tabBar = TabBarItem.this.getParent();
            Point point = tabBar.getLocationOnScreen();
            Point point2 = this.getLocation();
            point2.translate(point.x, point.y);
            point2.translate(tabBar.getCanvasOriginX(), tabBar.getCanvasOriginY());
            return point2;
        }

        @Override
        public Point getLocation() {
            Rectangle rectangle = this.getBounds();
            if (rectangle == null) {
                return null;
            }
            return new Point(rectangle.x, rectangle.y);
        }

        @Override
        public void setLocation(Point point) {
        }

        @Override
        public Rectangle getBounds() {
            if (!this.isShowing()) {
                return null;
            }
            Rectangle rectangle = TabBarItem.this.getBounds();
            rectangle.setLocation(TabBarItem.this.getParent().convertInteriorToOuter(rectangle.x, rectangle.y));
            return rectangle;
        }

        @Override
        public void setBounds(Rectangle rectangle) {
        }

        @Override
        public Dimension getSize() {
            Rectangle rectangle = this.getBounds();
            if (rectangle == null) {
                return null;
            }
            return new Dimension(rectangle.width, rectangle.height);
        }

        @Override
        public void setSize(Dimension dimension) {
        }

        @Override
        public Accessible getAccessibleAt(Point point) {
            return null;
        }

        @Override
        public boolean isFocusTraversable() {
            return false;
        }

        @Override
        public void requestFocus() {
        }

        @Override
        public void addFocusListener(FocusListener focusListener) {
        }

        @Override
        public void removeFocusListener(FocusListener focusListener) {
        }
    }
}

