/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.splitter;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.RGBImageFilter;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleValue;
import oracle.bali.share.util.IntegerUtils;
import oracle.ewt.access.AccessibleLWComponent;
import oracle.ewt.graphics.ImageUtils;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.painter.Painter;
import oracle.ewt.plaf.ComponentUI;
import oracle.ewt.plaf.SplitPaneUI;
import oracle.ewt.thread.Task;
import oracle.ewt.thread.TaskEvent;
import oracle.ewt.thread.TaskScheduler;
import oracle.ewt.util.InputEventUtils;

public class Splitter
extends LWComponent {
    public static final int SPLITTER_NOT_VISIBLE = -1;
    private static final int _NO_FEEDBACK = -1;
    private static final int _POINT_OUTSIDE_SPLITTER = 1;
    private static final int _INVALID_SPLITTER_POS = -2;
    private static MouseCheck _sMouseCheck;
    private PropertyChangeSupport _propertySupport;
    private int _splitterPosition;
    private int _oldSplitterPosition = -2;
    private boolean _horizontal;
    private double _preferredRatio;
    private boolean _isContinuousLayout;
    private transient Validater _validater;
    private transient Visible _visible;
    private transient int _resizingOffset;
    private transient int _feedback = -1;
    private transient Dimension _c1MinSize;
    private transient Dimension _c2MinSize;
    private transient Image _dragImage;
    private static final short _INIT_WITH_NONE = -1;
    private static final short _INIT_WITH_SIZE_RATIO = 1;
    private static final short _INIT_WITH_SPLIT_POS = 2;
    private short _initSplitterPosWith = 1;

    public Splitter() {
        this(true);
    }

    public Splitter(boolean bl) {
        this(null, null, bl);
    }

    public Splitter(Component component, Component component2, boolean bl) {
        this._horizontal = bl;
        this._isContinuousLayout = true;
        this._preferredRatio = 0.5;
        super.setLayout(null);
        if (component != null) {
            this.add(component);
        }
        if (component2 != null) {
            this.add(component2);
        }
        this._splitterPosition = -1;
        this._setResizingOffset(1);
        long l = 57L;
        this.enableEvents(l);
        this.updateUI(Splitter.class);
    }

    public void setContinuousLayout(boolean bl) {
        this._isContinuousLayout = bl;
    }

    public boolean isContinuousLayout() {
        return this._isContinuousLayout;
    }

    public void setSizeRatio(double d) {
        this._preferredRatio = d;
        if (!this.isShowing()) {
            this._initSplitterPosWith = 1;
            return;
        }
        int n = this.getSplitterPosition();
        if (n != -1) {
            Dimension dimension = this.getInnerSize();
            int n2 = this.isHorizontal() ? dimension.height : dimension.width;
            this.setSplitterPosition((int)((double)(n2 -= this.getDividerSize()) * d));
        }
    }

    public double getSizeRatio() {
        return this._preferredRatio;
    }

    public int getDividerSize() {
        Dimension dimension = this._getPainter().getPreferredSize(this.getPaintContext());
        if (this.isHorizontal()) {
            return dimension.height;
        }
        return dimension.width;
    }

    @Override
    protected void setUI(ComponentUI componentUI) {
        super.setUI(componentUI);
        this._dragImage = null;
    }

    @Override
    protected void updateUI(Class clazz) {
        if (clazz == Splitter.class) {
            this.updateUI();
        }
    }

    @Override
    public Object getUIClassID() {
        return "SplitPaneUI";
    }

    public boolean isHorizontal() {
        return this._horizontal;
    }

    public void setHorizontal(boolean bl) {
        if (bl != this.isHorizontal()) {
            this._horizontal = bl;
            this._firePropertyChanged("horizontal", bl ? Boolean.FALSE : Boolean.TRUE, bl ? Boolean.TRUE : Boolean.FALSE);
            AccessibleContext accessibleContext = this.accessAccessibleContext();
            if (accessibleContext != null) {
                accessibleContext.firePropertyChange("AccessibleState", bl ? AccessibleState.VERTICAL : AccessibleState.HORIZONTAL, bl ? AccessibleState.HORIZONTAL : AccessibleState.VERTICAL);
            }
            this._dragImage = null;
            this.setSplitterPosition(-1);
            this._invalidateAndRepaint();
        }
    }

    public int getSplitterPosition() {
        return this._splitterPosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSplitterPosition(int n) {
        int n2 = this.getSplitterPosition();
        if (!this.isShowing()) {
            this._splitterPosition = n;
            this._initSplitterPosWith = (short)2;
            this._fireSplitterPosChange(n2);
            return;
        }
        this._initSplitterPosWith = (short)-1;
        if (n2 != (n = this._checkSplitterPosition(n))) {
            int n3;
            this._splitterPosition = n;
            this._preferredRatio = n != -1 ? ((n3 = this._getAvailableSize()) > 0 ? (double)n / (double)n3 : 0.0) : 0.5;
            this._fireSplitterPosChange(n2);
            if (this.__isResizing()) {
                Object object = this.getTreeLock();
                synchronized (object) {
                    Splitter._doRecursiveLayout(this);
                }
                this.paintImmediate();
            } else {
                this._invalidateAndRepaint();
            }
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._propertySupport == null) {
            this._propertySupport = new PropertyChangeSupport(this);
        }
        this._propertySupport.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._propertySupport != null) {
            this._propertySupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    @Override
    public boolean isFocusTraversable() {
        return this.getSplitterPosition() != -1;
    }

    @Override
    public Dimension getPreferredSize() {
        Component component = this._getFirstComponent();
        Component component2 = this._getSecondComponent();
        Dimension dimension = component == null ? null : component.getPreferredSize();
        Dimension dimension2 = component2 == null ? null : component2.getPreferredSize();
        return this._computeSize(dimension, dimension2);
    }

    @Override
    public Dimension getMinimumSize() {
        Component component = this._getFirstComponent();
        Component component2 = this._getSecondComponent();
        Dimension dimension = component == null ? null : component.getMinimumSize();
        Dimension dimension2 = component2 == null ? null : component2.getMinimumSize();
        return this._computeSize(dimension, dimension2);
    }

    @Override
    public Dimension getMaximumSize() {
        Component component = this._getFirstComponent();
        Component component2 = this._getSecondComponent();
        Dimension dimension = component == null ? null : component.getMaximumSize();
        Dimension dimension2 = component2 == null ? null : component2.getMaximumSize();
        return this._computeSize(dimension, dimension2);
    }

    @Override
    public void setLayout(LayoutManager layoutManager) {
    }

    @Override
    public void remove(int n) {
        Component component = this.getComponent(n);
        component.removeComponentListener(this._visible);
        super.remove(n);
        this.setSplitterPosition(-1);
        this._oldSplitterPosition = -2;
    }

    @Override
    public void removeAll() {
        Component[] componentArray = this.getComponents();
        if (componentArray != null) {
            for (int i = 0; i < componentArray.length; ++i) {
                componentArray[i].removeComponentListener(this._visible);
            }
        }
        super.removeAll();
        this.setSplitterPosition(-1);
        this._oldSplitterPosition = -2;
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            componentArray[i].setEnabled(bl);
        }
        this.repaint();
    }

    @Override
    public void doLayout() {
        this._initSplitterPosition();
        Component component = this._getFirstComponent();
        Component component2 = this._getSecondComponent();
        Dimension dimension = this.getInnerSize();
        Point point = this.getInnerOrigin();
        if (component == null || component2 == null || !component.isVisible() || !component2.isVisible()) {
            if (this._oldSplitterPosition == -2) {
                this._oldSplitterPosition = this.getSplitterPosition();
            }
            this.setSplitterPosition(-1);
            if (component != null && component.isVisible()) {
                component.setBounds(point.x, point.y, dimension.width, dimension.height);
            } else if (component2 != null && component2.isVisible()) {
                component2.setBounds(point.x, point.y, dimension.width, dimension.height);
            }
        } else {
            int n = this.getDividerSize();
            this._c1MinSize = component.getMinimumSize();
            this._c2MinSize = component2.getMinimumSize();
            int n2 = this.getSplitterPosition();
            int n3 = -1;
            if (n2 == -1) {
                if (this._initSplitterPosWith == -1) {
                    n2 = this.isHorizontal() ? dimension.height : dimension.width;
                    this.setSplitterPosition((int)((double)(n2 -= n) * this._preferredRatio));
                    n2 = this.getSplitterPosition();
                } else {
                    n2 = 0;
                    n3 = 0;
                }
            }
            if (n3 != 0) {
                n3 = n2 + n;
            }
            if (this.isHorizontal()) {
                component.setBounds(point.x, point.y, dimension.width, n2);
                component2.setBounds(point.x, point.y + n3, dimension.width, dimension.height - n3);
            } else {
                component.setBounds(point.x, point.y, n2, dimension.height);
                component2.setBounds(point.x + n3, point.y, dimension.width - n3, dimension.height);
            }
        }
    }

    @Override
    public void paintInterior(Graphics graphics) {
        int n = this.getSplitterPosition();
        if (n != -1) {
            Dimension dimension = this.getInnerSize();
            int n2 = this.getDividerSize();
            int n3 = 0;
            int n4 = 0;
            if (this.isHorizontal()) {
                dimension.height = n2;
                n4 = n;
            } else {
                dimension.width = n2;
                n3 = n;
            }
            this._getPainter().paint(this.getPaintContext(), graphics, n3, n4, dimension.width, dimension.height);
            this._paintFeedback();
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this._initSplitterPosition();
    }

    @Override
    protected int getPaintState() {
        int n = super.getPaintState();
        if (this.__isResizing()) {
            n |= 2;
        }
        return n;
    }

    @Override
    protected int getRepaintFlags() {
        return super.getRepaintFlags() | this._getPainter().getRepaintFlags(this.getPaintContext());
    }

    @Override
    protected int getInvalidateFlags() {
        return super.getInvalidateFlags() | 0x4000 | this._getPainter().getInvalidateFlags(this.getPaintContext());
    }

    @Override
    protected void addImpl(Component component, Object object, int n) {
        if (this.getComponentCount() == 2) {
            String string = "Only two components can be added to the splitter";
            throw new IllegalStateException(string);
        }
        if (this._visible == null) {
            this._visible = new Visible();
        }
        component.addComponentListener(this._visible);
        super.addImpl(component, object, n);
        this.setSplitterPosition(-1);
        this._oldSplitterPosition = -2;
        this._invalidateAndRepaint();
    }

    @Override
    protected void processKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
        if (keyEvent.isConsumed() || !this.isEnabled() || keyEvent.getID() != 401 || keyEvent.isAltDown() || keyEvent.isControlDown()) {
            return;
        }
        int n = keyEvent.getKeyCode();
        int n2 = this.getSplitterPosition();
        int n3 = n2--;
        switch (n) {
            case 37: {
                if (this.isHorizontal()) break;
                break;
            }
            case 39: {
                if (this.isHorizontal()) break;
                ++n2;
                break;
            }
            case 38: {
                if (!this.isHorizontal()) break;
                --n2;
                break;
            }
            case 40: {
                if (!this.isHorizontal()) break;
                ++n2;
                break;
            }
            case 9: {
                if (!this._transferFocus(keyEvent.isShiftDown())) break;
                keyEvent.consume();
            }
        }
        if (n3 != n2) {
            this.setSplitterPosition(n2);
            keyEvent.consume();
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
        if (mouseEvent.isConsumed() || !this.isEnabled()) {
            return;
        }
        Point point = this.getInnerOrigin();
        mouseEvent.translatePoint(-point.x, -point.y);
        boolean bl = false;
        switch (mouseEvent.getID()) {
            case 501: {
                bl = this._processMousePressed(mouseEvent);
                break;
            }
            case 502: {
                bl = this._processMouseReleased(mouseEvent);
                break;
            }
            case 505: {
                this.setCursor(Cursor.getDefaultCursor());
                bl = true;
            }
        }
        if (bl) {
            mouseEvent.consume();
        }
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        super.processMouseMotionEvent(mouseEvent);
        if (mouseEvent.isConsumed() || !this.isEnabled()) {
            return;
        }
        Point point = this.getInnerOrigin();
        mouseEvent.translatePoint(-point.x, -point.y);
        boolean bl = false;
        switch (mouseEvent.getID()) {
            case 503: {
                bl = this._processMouseMoved(mouseEvent);
                break;
            }
            case 506: {
                bl = this._processMouseDragged(mouseEvent);
            }
        }
        if (bl) {
            mouseEvent.consume();
        }
    }

    @Override
    protected void processComponentEvent(ComponentEvent componentEvent) {
        super.processComponentEvent(componentEvent);
        if (componentEvent.getID() == 101) {
            this._dragImage = null;
            if (this._initSplitterPosition()) {
                this.invalidate();
                if (this._validater == null) {
                    this._validater = new Validater();
                }
                TaskScheduler.getDefaultTaskScheduler().schedule(this._validater, 0);
            } else {
                this.setSplitterPosition((int)(this._preferredRatio * (double)this._getAvailableSize()));
            }
        } else if (componentEvent.getID() == 102) {
            this._initSplitterPosition();
        }
    }

    @Override
    protected AccessibleContext createAccessibleContext() {
        return new Access();
    }

    final boolean __isResizing() {
        return this._resizingOffset != 1;
    }

    final void _invalidateAndRepaint() {
        if (this.isShowing()) {
            this.invalidate();
            if (this._validater == null) {
                this._validater = new Validater();
            }
            TaskScheduler.getDefaultTaskScheduler().schedule(this._validater, 0);
        }
    }

    private void _setResizingOffset(int n) {
        if (this._resizingOffset != n) {
            this._resizingOffset = n;
            this.invalidateAndRepaintIfNecessary(2);
        }
    }

    private Dimension _computeSize(Dimension dimension, Dimension dimension2) {
        int n = 0;
        int n2 = 0;
        if (dimension != null) {
            n2 = dimension.height;
            n = dimension.width;
        }
        if (dimension2 != null) {
            if (this.isHorizontal()) {
                n2 += dimension2.height;
                if (dimension2.width > n) {
                    n = dimension2.width;
                }
            } else {
                n += dimension2.width;
                if (dimension2.height > n2) {
                    n2 = dimension2.height;
                }
            }
        }
        int n3 = this.getDividerSize();
        if (this.isHorizontal()) {
            n += n3;
        } else {
            n2 += n3;
        }
        return this.convertInnerToOuterSize(n, n2);
    }

    private boolean _processMousePressed(MouseEvent mouseEvent) {
        if (!InputEventUtils.isLeftMouseButton(mouseEvent)) {
            this.setCursor(Cursor.getDefaultCursor());
            return false;
        }
        int n = this._pointInSplitter(mouseEvent.getX(), mouseEvent.getY());
        if (n != 1) {
            this._setResizingOffset(n);
            Cursor cursor = this.isHorizontal() ? Cursor.getPredefinedCursor(9) : Cursor.getPredefinedCursor(11);
            this.setCursor(cursor);
            this._bugWorkAround(true);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _processMouseReleased(MouseEvent mouseEvent) {
        if (!this.__isResizing()) {
            return false;
        }
        this.freezeRepaints();
        try {
            int n = this._resizingOffset;
            this._updateFeedback(-1);
            this._setResizingOffset(1);
            this.setCursor(Cursor.getDefaultCursor());
            int n2 = this._checkMousePosition(mouseEvent);
            this.setSplitterPosition(n2 - n);
            this._invalidateAndRepaint();
        }
        finally {
            this.unfreezeRepaints();
        }
        this._bugWorkAround(false);
        return true;
    }

    private boolean _processMouseMoved(MouseEvent mouseEvent) {
        int n = this._pointInSplitter(mouseEvent.getX(), mouseEvent.getY());
        Cursor cursor = n != 1 ? (this.isHorizontal() ? Cursor.getPredefinedCursor(9) : Cursor.getPredefinedCursor(11)) : Cursor.getDefaultCursor();
        this.setCursor(cursor);
        return true;
    }

    private boolean _processMouseDragged(MouseEvent mouseEvent) {
        if (this.__isResizing()) {
            int n = this._checkMousePosition(mouseEvent);
            if (this._isContinuousLayout) {
                this.setSplitterPosition(n - this._resizingOffset);
            } else {
                this._updateFeedback(n);
            }
            return true;
        }
        return false;
    }

    private int _checkMousePosition(MouseEvent mouseEvent) {
        int n = this.isHorizontal() ? mouseEvent.getY() : mouseEvent.getX();
        Dimension dimension = this.getInnerSize();
        int n2 = this.getDividerSize();
        this._getMinimumSizes();
        if (this.isHorizontal()) {
            if (n < this._c1MinSize.height) {
                n = this._c1MinSize.height;
            } else if (n > dimension.height - this._c2MinSize.height - n2) {
                n = dimension.height - this._c2MinSize.height - n2;
            }
        } else if (n < this._c1MinSize.width) {
            n = this._c1MinSize.width;
        } else if (n > dimension.width - this._c2MinSize.width - n2) {
            n = dimension.width - this._c2MinSize.width - n2;
        }
        return n;
    }

    private int _pointInSplitter(int n, int n2) {
        int n3;
        int n4 = n3 = this.isHorizontal() ? n2 : n;
        if (this._canResize(n3)) {
            int n5 = this.getSplitterPosition();
            int n6 = this.getDividerSize();
            if ((n3 -= n5) >= 0 && n3 < n6) {
                return n3;
            }
        }
        return 1;
    }

    private boolean _canResize(int n) {
        Component component = this._getFirstComponent();
        Component component2 = this._getSecondComponent();
        if (component == null || component2 == null) {
            return false;
        }
        Dimension dimension = this.getInnerSize();
        int n2 = this.getDividerSize();
        this._getMinimumSizes();
        if (this.isHorizontal()) {
            return dimension.height > this._c1MinSize.height + this._c2MinSize.height + n2;
        }
        return dimension.width > this._c1MinSize.width + this._c2MinSize.width + n2;
    }

    int __getMinimumPosition() {
        Dimension dimension = this._c1MinSize;
        if (dimension == null) {
            return 0;
        }
        return this.isHorizontal() ? dimension.height : dimension.width;
    }

    int __getMaximumPosition() {
        int n;
        Dimension dimension = this.getInnerSize();
        int n2 = n = this.isHorizontal() ? dimension.height : dimension.width;
        if (this._c2MinSize == null) {
            return n;
        }
        return n - this.getDividerSize() - (this.isHorizontal() ? this._c2MinSize.height : this._c2MinSize.width);
    }

    private int _checkSplitterPosition(int n) {
        if (n != -1) {
            int n2;
            int n3;
            int n4;
            Component component = this._getFirstComponent();
            Component component2 = this._getSecondComponent();
            if (component == null || component2 == null) {
                return 0;
            }
            if (this._c1MinSize == null || this._c2MinSize == null) {
                return n;
            }
            Dimension dimension = this.getInnerSize();
            if (this.isHorizontal()) {
                n4 = this._c1MinSize.height;
                n3 = this._c2MinSize.height;
                n2 = dimension.height;
            } else {
                n4 = this._c1MinSize.width;
                n3 = this._c2MinSize.width;
                n2 = dimension.width;
            }
            int n5 = this.getDividerSize();
            if (n2 < n4 + n3 + n5) {
                n = n2 * n4 / (n4 + n3);
            } else if (n < n4) {
                n = n4;
            } else if (n > n2 - n5 - n3) {
                n = n2 - n5 - n3;
            }
        }
        return n;
    }

    private Image _getDragImage() {
        if (this._dragImage == null) {
            Dimension dimension = this.getInnerSize();
            int n = this.getDividerSize();
            if (this.isHorizontal()) {
                dimension.height = n;
            } else {
                dimension.width = n;
            }
            Image image = this.createImage(dimension.width, dimension.height);
            Graphics graphics = image.getGraphics();
            this._getPainter().paint(this.getPaintContext(), graphics, 0, 0, dimension.width, dimension.height);
            graphics.dispose();
            this._dragImage = image = ImageUtils.createFilteredImage(image, new DragFilter());
        }
        return this._dragImage;
    }

    private static void _doRecursiveLayout(Component component) {
        component.doLayout();
        if (component instanceof Container) {
            Container container = (Container)component;
            int n = container.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Splitter._doRecursiveLayout(container.getComponent(i));
            }
        }
    }

    private void _paintFeedback() {
        if (this._feedback == -1) {
            return;
        }
        Point point = this.getInnerOrigin();
        int n = this.isHorizontal() ? point.y : point.x;
        int n2 = this._feedback + n;
        Graphics graphics = this.getGraphics();
        Rectangle rectangle = graphics.getClipBounds();
        if (rectangle != null) {
            this.clipToParents(rectangle);
            graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        if (this.isHorizontal()) {
            graphics.drawImage(this._getDragImage(), this.getInnerOrigin().x, n2, this);
        } else {
            graphics.drawImage(this._getDragImage(), n2, this.getInnerOrigin().x, this);
        }
        graphics.dispose();
    }

    private void _updateFeedback(int n) {
        if (this._feedback == n) {
            return;
        }
        int n2 = this._feedback;
        this._feedback = n;
        if (n2 != -1) {
            Dimension dimension = this.getInnerSize();
            int n3 = this.getDividerSize();
            int n4 = 0;
            int n5 = 0;
            boolean bl = this.isHorizontal();
            if (n == -1) {
                if (bl) {
                    n5 = n2;
                    dimension.height = n3;
                } else {
                    n4 = n2;
                    dimension.width = n3;
                }
            } else {
                int n6 = n - n2;
                if (bl) {
                    dimension.height = n3;
                    if (n6 < 0) {
                        n5 = n + n3;
                        dimension.height = -n6;
                    } else {
                        n5 = n2;
                        dimension.height = n6;
                    }
                } else {
                    dimension.width = n3;
                    if (n6 < 0) {
                        n4 = n + n3;
                        dimension.width = -n6;
                    } else {
                        n4 = n2;
                        dimension.width = n6;
                    }
                }
            }
            Point point = this.getInnerOrigin();
            if (bl) {
                n4 += point.x;
            } else {
                n5 += point.y;
            }
            this.paintImmediate(n4, n5, dimension.width, dimension.height);
        }
        this._paintFeedback();
    }

    private void _firePropertyChanged(String string, Object object, Object object2) {
        if (this._propertySupport != null) {
            this._propertySupport.firePropertyChange(string, object, object2);
        }
    }

    private Component _getFirstComponent() {
        int n;
        boolean bl = this.getActualReadingDirection() == 1 || this.isHorizontal();
        int n2 = n = bl ? 0 : 1;
        if (this.getComponentCount() > n) {
            return this.getComponent(n);
        }
        return null;
    }

    private Component _getSecondComponent() {
        int n;
        boolean bl = this.getActualReadingDirection() == 1 || this.isHorizontal();
        int n2 = n = bl ? 1 : 0;
        if (this.getComponentCount() > n) {
            return this.getComponent(n);
        }
        return null;
    }

    private Painter _getPainter() {
        return ((SplitPaneUI)this.getUI()).getSplitterPainter(this);
    }

    private void _getMinimumSizes() {
        Component component;
        if (this._c1MinSize == null && (component = this._getFirstComponent()) != null) {
            this._c1MinSize = component.getMinimumSize();
        }
        if (this._c2MinSize == null && (component = this._getSecondComponent()) != null) {
            this._c2MinSize = component.getMinimumSize();
        }
    }

    private void _fireSplitterPosChange(int n) {
        int n2 = this.getSplitterPosition();
        this._firePropertyChanged("splitterPosition", IntegerUtils.getInteger(n), IntegerUtils.getInteger(n2));
        AccessibleContext accessibleContext = this.accessAccessibleContext();
        if (accessibleContext != null) {
            accessibleContext.firePropertyChange("AccessibleValue", IntegerUtils.getInteger(n), IntegerUtils.getInteger(n2));
        }
    }

    private int _getAvailableSize() {
        int n;
        int n2 = n = this.isHorizontal() ? this.getInnerHeight() : this.getInnerWidth();
        if ((n -= this.getDividerSize()) < 0) {
            n = 0;
        }
        return n;
    }

    private boolean _initSplitterPosition() {
        if (this._initSplitterPosWith != -1) {
            int n = this._getAvailableSize();
            if (n > 0) {
                int n2 = this._initSplitterPosWith == 1 ? (int)((double)n * this._preferredRatio) : this._splitterPosition;
                n2 = this._checkSplitterPosition(n2);
                this._preferredRatio = n2 != -1 ? (double)n2 / (double)n : 0.5;
                this._splitterPosition = -2;
                this.setSplitterPosition(n2);
                this._initSplitterPosWith = (short)-1;
            }
            return true;
        }
        return false;
    }

    private MouseCheck _getMouseCheck() {
        if (_sMouseCheck == null) {
            _sMouseCheck = new MouseCheck();
        }
        return _sMouseCheck;
    }

    private void _bugWorkAround(boolean bl) {
        Component component = this._getFirstComponent();
        if (component instanceof LWComponent) {
            if (bl) {
                component.addMouseListener(this._getMouseCheck());
                component.addMouseMotionListener(this._getMouseCheck());
            } else {
                component.removeMouseListener(this._getMouseCheck());
                component.removeMouseMotionListener(this._getMouseCheck());
            }
        }
        if ((component = this._getSecondComponent()) instanceof LWComponent) {
            if (bl) {
                component.addMouseListener(this._getMouseCheck());
                component.addMouseMotionListener(this._getMouseCheck());
            } else {
                component.removeMouseListener(this._getMouseCheck());
                component.removeMouseMotionListener(this._getMouseCheck());
            }
        }
    }

    void bugWorkAround(MouseEvent mouseEvent) {
        int n;
        Object object = mouseEvent.getSource();
        if (object == this._getSecondComponent()) {
            n = this.getSplitterPosition();
            int n2 = this.getDividerSize();
            int n3 = n + n2;
            if (this.isHorizontal()) {
                mouseEvent.translatePoint(0, n3);
            } else {
                mouseEvent.translatePoint(n3, 0);
            }
        }
        if ((n = mouseEvent.getID()) == 506) {
            if (this._processMouseDragged(mouseEvent)) {
                mouseEvent.consume();
            }
        } else if (n == 502 && this._processMouseReleased(mouseEvent)) {
            mouseEvent.consume();
        }
    }

    private boolean _transferFocus(boolean bl) {
        Component component;
        boolean bl2 = false;
        Component component2 = this._getFirstComponent();
        Component component3 = this._getSecondComponent();
        Component component4 = component2 == null ? null : this._findFirstFocusableComponent(component2);
        Component component5 = component = component3 == null ? null : this._findFirstFocusableComponent(component3);
        if (!bl) {
            if (component4 != null) {
                bl2 = true;
                component4.requestFocus();
            } else if (component != null) {
                bl2 = true;
                component.requestFocus();
            }
        } else if (component != null) {
            bl2 = true;
            component.requestFocus();
        } else if (component4 != null) {
            bl2 = true;
            component4.requestFocus();
        }
        return bl2;
    }

    private Component _findFirstFocusableComponent(Component component) {
        if (component.isFocusTraversable()) {
            return component;
        }
        if (component instanceof Container) {
            Container container = (Container)component;
            int n = container.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component component2 = container.getComponent(i);
                if ((component2 = this._findFirstFocusableComponent(component2)) == null) continue;
                return component2;
            }
        }
        return null;
    }

    private class Access
    extends AccessibleLWComponent
    implements AccessibleValue {
        public Access() {
            super(Splitter.this);
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (Splitter.this.__isResizing()) {
                accessibleStateSet.add(AccessibleState.BUSY);
            }
            if (Splitter.this.isHorizontal()) {
                accessibleStateSet.add(AccessibleState.HORIZONTAL);
            } else {
                accessibleStateSet.add(AccessibleState.VERTICAL);
            }
            return accessibleStateSet;
        }

        @Override
        public AccessibleValue getAccessibleValue() {
            return this;
        }

        @Override
        public Number getCurrentAccessibleValue() {
            return IntegerUtils.getInteger(Splitter.this.getSplitterPosition());
        }

        @Override
        public boolean setCurrentAccessibleValue(Number number) {
            Splitter.this.setSplitterPosition(number.intValue());
            return true;
        }

        @Override
        public Number getMinimumAccessibleValue() {
            return IntegerUtils.getInteger(Splitter.this.__getMinimumPosition());
        }

        @Override
        public Number getMaximumAccessibleValue() {
            return IntegerUtils.getInteger(Splitter.this.__getMaximumPosition());
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.SPLIT_PANE;
        }
    }

    public static class DragFilter
    extends RGBImageFilter {
        public DragFilter() {
            this.canFilterIndexColorModel = true;
        }

        @Override
        public int filterRGB(int n, int n2, int n3) {
            int n4 = n3 & 0xFF000000;
            int n5 = n3 >> 16 & 0xFF;
            int n6 = n3 >> 8 & 0xFF;
            int n7 = n3 & 0xFF;
            n5 -= n5 >> 2;
            n6 -= n6 >> 2;
            n7 -= n7 >> 2;
            return n4 | n5 << 16 | n6 << 8 | n7;
        }
    }

    private class MouseCheck
    extends MouseAdapter
    implements MouseMotionListener {
        private MouseCheck() {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            Splitter.this.bugWorkAround(mouseEvent);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            Splitter.this.bugWorkAround(mouseEvent);
        }
    }

    private class Validater
    implements Task {
        private Validater() {
        }

        @Override
        public void runTask(TaskEvent taskEvent) {
            Splitter.this.freezeRepaints();
            try {
                Splitter.this.validate();
                Splitter.this.repaint();
            }
            finally {
                Splitter.this.unfreezeRepaints();
            }
        }
    }

    private class Visible
    extends ComponentAdapter {
        private Visible() {
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
            if (Splitter.this._oldSplitterPosition != -2) {
                Splitter.this.setSplitterPosition(Splitter.this._oldSplitterPosition);
            }
            Splitter.this._invalidateAndRepaint();
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
            int n = Splitter.this.getSplitterPosition();
            if (n != -1) {
                Splitter.this._oldSplitterPosition = n;
            }
            Splitter.this._invalidateAndRepaint();
        }
    }
}

