/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.spinBox;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleValue;
import oracle.bali.share.util.IntegerUtils;
import oracle.ewt.access.AccessibleLWComponent;
import oracle.ewt.access.OracleAccessibleRole;
import oracle.ewt.button.SpinAccelerator;
import oracle.ewt.button.SpinButton;
import oracle.ewt.button.SpinButtonEvent;
import oracle.ewt.button.SpinButtonListener;
import oracle.ewt.event.ListenerManager;
import oracle.ewt.iterator.Iterator;
import oracle.ewt.iterator.NumericIterator;
import oracle.ewt.iterator.Range;
import oracle.ewt.lwAWT.LWContainer;
import oracle.ewt.lwAWT.lwText.LWTextComponent;
import oracle.ewt.plaf.SpinnerUI;
import oracle.ewt.plaf.TextUI;
import oracle.ewt.spinBox.BuddyTextField;
import oracle.ewt.spinBox.SpinBoxEvent;
import oracle.ewt.spinBox.SpinBoxListener;
import oracle.ewt.spinBox.SpinBuddy;
import oracle.ewt.util.ImmInsets;

public class SpinBox
extends LWContainer
implements SpinButtonListener {
    private SpinButton _spinButton;
    private SpinBuddy _buddy;
    private Component _buddyComponent;
    private Object _value;
    private Iterator _iterator;
    private ListenerManager _listeners;
    private SpinListener _spinListener = new SpinListener();
    private static int _sInstanceCounter;
    private static final int _GAP = 1;

    public SpinBox() {
        this(new BuddyTextField(), new NumericIterator(new Range(0, 0)));
    }

    public SpinBox(SpinBuddy spinBuddy, Iterator iterator) {
        if (spinBuddy == null) {
            throw new IllegalArgumentException();
        }
        if (iterator == null) {
            throw new IllegalArgumentException();
        }
        this.addKeyListener(this._spinListener);
        this.addFocusListener(this._spinListener);
        this._spinButton = this.createSpinButton();
        this._spinButton.addSpinButtonListener(this);
        this.setLayout(null);
        this.setSpinBuddy(spinBuddy);
        this.setIterator(iterator);
        this.add(this.getSpinButton());
        this.updateUI(SpinBox.class);
    }

    @Override
    public Object getUIClassID() {
        return "SpinnerUI";
    }

    public void setSpinBuddy(SpinBuddy spinBuddy) {
        if (spinBuddy == null) {
            throw new IllegalArgumentException();
        }
        if (this._buddyComponent != null) {
            this._buddyComponent.removeKeyListener(this._spinListener);
            this._buddyComponent.removeFocusListener(this._spinListener);
            this.remove(this._buddyComponent);
        }
        this._buddy = spinBuddy;
        this._buddyComponent = (Component)((Object)this._buddy);
        Object object = this.getValue();
        if (object != null) {
            spinBuddy.setValue(object);
        }
        this._buddyComponent.addKeyListener(this._spinListener);
        this._buddyComponent.addFocusListener(this._spinListener);
        this.add(this._buddyComponent);
    }

    public SpinAccelerator getAccelerator() {
        return this.getSpinButton().getAccelerator();
    }

    public void setAccelerator(SpinAccelerator spinAccelerator) {
        this.getSpinButton().setAccelerator(spinAccelerator);
    }

    public Object getValue() {
        return this._value;
    }

    public Iterator getIterator() {
        return this._iterator;
    }

    public void setIterator(Iterator iterator) {
        this._iterator = iterator;
        this._buddy.setValue(this._nextElement(true));
        this._updateEnabled();
        this.processEvent(new SpinBoxEvent(this, 2000, this.getValue()));
    }

    public SpinBuddy getSpinBuddy() {
        return this._buddy;
    }

    public void addSpinBoxListener(SpinBoxListener spinBoxListener) {
        if (this._listeners == null) {
            this._listeners = new ListenerManager();
        }
        this._listeners.addListener(spinBoxListener);
    }

    public void removeSpinBoxListener(SpinBoxListener spinBoxListener) {
        this._listeners.removeListener(spinBoxListener);
    }

    @Override
    public void doLayout() {
        Dimension dimension = this.getSize();
        Component component = this._buddyComponent;
        Dimension dimension2 = component.getPreferredSize();
        SpinnerUI spinnerUI = (SpinnerUI)this.getUI();
        ImmInsets immInsets = this.getBorderInsets();
        ImmInsets immInsets2 = spinnerUI.getSpinButtonInsets(this);
        dimension.width -= immInsets.left + immInsets.right;
        dimension.height -= immInsets.top + immInsets.bottom;
        int n = (dimension.height - dimension2.height) / 2;
        if (n < 0) {
            n = 0;
            dimension2.height = dimension.height;
        }
        SpinButton spinButton = this.getSpinButton();
        Dimension dimension3 = spinButton.getPreferredSize();
        int n2 = immInsets2.top;
        dimension3.height = dimension.height - (immInsets2.top + immInsets2.bottom);
        dimension3.width -= immInsets2.left + immInsets2.right;
        if (this.getActualAlignment() != 2) {
            component.setBounds(immInsets.left, n + immInsets.top, dimension.width - dimension3.width - 1, dimension2.height);
            spinButton.setBounds(dimension.width - dimension3.width + immInsets.left + immInsets2.left, n2 + immInsets.top, dimension3.width, dimension3.height);
        } else {
            component.setBounds(dimension3.width + 1 + immInsets.left, n + immInsets.top, dimension.width - dimension3.width - 1, dimension2.height);
            spinButton.setBounds(immInsets.left + immInsets2.left, n2 + immInsets.top, dimension3.width, dimension3.height);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = this._buddyComponent.getPreferredSize();
        Dimension dimension2 = this.getSpinButton().getPreferredSize();
        SpinnerUI spinnerUI = (SpinnerUI)this.getUI();
        ImmInsets immInsets = this.getBorderInsets();
        ImmInsets immInsets2 = spinnerUI.getSpinButtonInsets(this);
        int n = immInsets.top + immInsets.bottom;
        return new Dimension(dimension2.width + dimension.width + 1 + immInsets.left + immInsets.right + immInsets2.left + immInsets2.right, Math.max(dimension.height + n, dimension2.height + n + immInsets2.top + immInsets2.bottom));
    }

    @Override
    public void setEnabled(boolean bl) {
        this.getSpinButton().setEnabled(bl);
        this._buddyComponent.setEnabled(bl);
        super.setEnabled(bl);
    }

    @Override
    protected Object getPaintData(Object object) {
        if (object.equals("GapX")) {
            Rectangle rectangle = this._spinButton.getBounds();
            if (this.getActualAlignment() != 2) {
                return IntegerUtils.getInteger(rectangle.x - 1);
            }
            return IntegerUtils.getInteger(rectangle.x + rectangle.width);
        }
        if (TextUI.TEXT_IS_EDITABLE_KEY.equals(object)) {
            if (!(this._buddyComponent instanceof LWTextComponent)) {
                return Boolean.TRUE;
            }
            LWTextComponent lWTextComponent = (LWTextComponent)this._buddyComponent;
            return lWTextComponent.isEditable() ? Boolean.TRUE : Boolean.FALSE;
        }
        return super.getPaintData(object);
    }

    @Override
    protected String paramString() {
        return "value=" + this.getValue();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void addImpl(Component component, Object object, int n) {
        if (component != this._spinButton && component != this._buddy) {
            if (!(component instanceof SpinBuddy)) throw new IllegalArgumentException();
            this.setSpinBuddy((SpinBuddy)((Object)component));
            return;
        } else {
            super.addImpl(component, object, n);
        }
    }

    @Override
    public boolean isFocusTraversable() {
        return !this._buddyComponent.isFocusTraversable();
    }

    @Override
    public void requestFocus() {
        if (this._buddyComponent.isFocusTraversable()) {
            this._buddyComponent.requestFocus();
        } else {
            super.requestFocus();
        }
    }

    @Override
    public void spinButtonSpinning(SpinButtonEvent spinButtonEvent) {
        if (this._buddyComponent.isFocusTraversable()) {
            this._buddyComponent.requestFocus();
        } else {
            this.requestFocus();
        }
        this.doIncrement(spinButtonEvent.getType() == 1);
    }

    @Override
    protected void processEventImpl(AWTEvent aWTEvent) {
        if (aWTEvent instanceof SpinBoxEvent) {
            this.processSpinBoxEvent((SpinBoxEvent)aWTEvent);
        } else {
            super.processEventImpl(aWTEvent);
        }
    }

    protected void processSpinBoxEvent(SpinBoxEvent spinBoxEvent) {
        Object object;
        ListenerManager listenerManager = this._listeners;
        if (listenerManager != null && (object = listenerManager.getListeners()) != null) {
            while (object.hasMoreElements()) {
                SpinBoxListener spinBoxListener = (SpinBoxListener)object.nextElement();
                switch (spinBoxEvent.getID()) {
                    case 2000: {
                        spinBoxListener.spinBoxValueChanged(spinBoxEvent);
                        break;
                    }
                }
            }
        }
        if ((object = this.accessAccessibleContext()) != null) {
            ((AccessibleContext)object).firePropertyChange("AccessibleVisibleData", Boolean.FALSE, Boolean.TRUE);
        }
    }

    protected void doIncrement(boolean bl) {
        this._iterator.setIteratingForward(bl);
        this.getSpinBuddy().setValue(this._nextElement(false));
        this._updateEnabled();
        this.processEvent(new SpinBoxEvent(this, 2000, this.getValue()));
    }

    protected SpinButton createSpinButton() {
        return new SpinButton(true, false);
    }

    protected SpinButton getSpinButton() {
        return this._spinButton;
    }

    @Override
    protected int getInvalidateFlags() {
        return super.getInvalidateFlags() | 0x800;
    }

    @Override
    protected AccessibleContext createAccessibleContext() {
        return new Access();
    }

    @Override
    protected String getDefaultName() {
        return this.getBaseClassName() + _sInstanceCounter++;
    }

    void _updateEnabled() {
        Iterator iterator = this._iterator;
        SpinButton spinButton = this.getSpinButton();
        boolean bl = iterator.isIteratingForward();
        iterator.setIteratingForward(true);
        spinButton.setIncrementEnabled(iterator.hasMoreElements());
        iterator.setIteratingForward(false);
        spinButton.setDecrementEnabled(iterator.hasMoreElements());
        iterator.setIteratingForward(bl);
    }

    private Object _nextElement(boolean bl) {
        SpinAccelerator spinAccelerator = this.getAccelerator();
        if (bl || spinAccelerator == null) {
            this._value = this._iterator.nextElement();
        } else {
            int n = this._iterator.remainingElements(spinAccelerator.getIncrement());
            this._value = this._iterator.skip(n);
        }
        return this._value;
    }

    private class Access
    extends AccessibleLWComponent {
        public Access() {
            super(SpinBox.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return OracleAccessibleRole.SPIN_BOX;
        }

        @Override
        public String getAccessibleName() {
            if (this.accessibleName != null) {
                return this.accessibleName;
            }
            return super.getAccessibleName();
        }

        @Override
        public String getAccessibleDescription() {
            if (this.accessibleDescription != null) {
                return this.accessibleDescription;
            }
            return super.getAccessibleDescription();
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (accessibleStateSet.contains(AccessibleState.ENABLED)) {
                accessibleStateSet.add(AccessibleState.EDITABLE);
            }
            return accessibleStateSet;
        }

        @Override
        public AccessibleValue getAccessibleValue() {
            SpinBuddy spinBuddy = SpinBox.this.getSpinBuddy();
            if (spinBuddy != null && spinBuddy instanceof Accessible) {
                return ((Accessible)((Object)spinBuddy)).getAccessibleContext().getAccessibleValue();
            }
            return null;
        }

        @Override
        public AccessibleAction getAccessibleAction() {
            return SpinBox.this.getSpinButton().getAccessibleContext().getAccessibleAction();
        }
    }

    private class SpinListener
    extends KeyAdapter
    implements FocusListener {
        private SpinListener() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            boolean bl;
            SpinButton spinButton = SpinBox.this.getSpinButton();
            int n = keyEvent.getKeyCode();
            boolean bl2 = bl = n == 38 || n == 40;
            if (!bl) {
                spinButton.setIncrementArmed(false);
                spinButton.setDecrementArmed(false);
            }
            if (keyEvent.isConsumed()) {
                return;
            }
            if (bl) {
                boolean bl3;
                boolean bl4 = bl3 = n == 38;
                if (bl3 && spinButton.isIncrementEnabled() || !bl3 && spinButton.isDecrementEnabled()) {
                    if (bl3) {
                        spinButton.setIncrementArmed(true);
                    } else {
                        spinButton.setDecrementArmed(true);
                    }
                    SpinBox.this.doIncrement(bl3);
                    SpinAccelerator spinAccelerator = SpinBox.this.getAccelerator();
                    if (spinAccelerator != null) {
                        spinAccelerator.advance();
                    }
                    keyEvent.consume();
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            switch (keyEvent.getKeyCode()) {
                case 38: {
                    SpinBox.this.getSpinButton().setIncrementArmed(false);
                    break;
                }
                case 40: {
                    SpinBox.this.getSpinButton().setDecrementArmed(false);
                }
            }
            SpinAccelerator spinAccelerator = SpinBox.this.getAccelerator();
            if (spinAccelerator != null) {
                spinAccelerator.reset();
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            SpinButton spinButton = SpinBox.this.getSpinButton();
            spinButton.setIncrementArmed(false);
            spinButton.setDecrementArmed(false);
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
        }
    }
}

