/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.multiLineLabel;

import java.awt.Adjustable;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Locale;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import oracle.ewt.EwtComponent;
import oracle.ewt.LookAndFeel;
import oracle.ewt.access.AccessibleLWComponent;
import oracle.ewt.graphics.FontUtils;
import oracle.ewt.graphics.GraphicUtils;
import oracle.ewt.multiLineLabel.LabelGeometry;
import oracle.ewt.multiLineLabel.LineInfo;
import oracle.ewt.scrolling.ScrollableException;
import oracle.ewt.textWrapper.NoWrapper;
import oracle.ewt.textWrapper.TextWrapper;

public class MultiLineLabel
extends EwtComponent {
    public static final int ALIGNMENT_DEFAULT = 0;
    public static final int ALIGNMENT_LEFT = 1;
    public static final int ALIGNMENT_RIGHT = 2;
    public static final int ALIGNMENT_CENTER = 3;
    public static final float ASPECTRATIO_NONE = 0.0f;
    private static final int _MINIMUM_COLUMNS = 20;
    private boolean _isWrappingLocked;
    private boolean _useFullJustification;
    private float _preferredAspectRatio;
    private LabelGeometry _geometry;
    private Adjustable _hAdjustable;
    private Adjustable _vAdjustable;
    private transient Dimension _preferredSize;

    public MultiLineLabel() {
        this("");
    }

    public MultiLineLabel(String string) {
        this(NoWrapper.getTextWrapper(), string);
    }

    public MultiLineLabel(TextWrapper textWrapper, String string) {
        if (string == null) {
            string = "";
        }
        this._geometry = new LabelGeometry(this, textWrapper, string);
        this._isWrappingLocked = true;
        this._preferredAspectRatio = 4.0f;
    }

    public void setText(String string) {
        String string2 = this.getText();
        if (string2 == null || !string2.equals(string)) {
            String string3;
            AccessibleContext accessibleContext = this.accessAccessibleContext();
            String string4 = string3 = accessibleContext == null ? null : accessibleContext.getAccessibleName();
            if (string == null) {
                string = "";
            }
            if (string != this.getText()) {
                this._preferredSize = null;
            }
            this._geometry._setText(string);
            if (accessibleContext != null) {
                accessibleContext.firePropertyChange("AccessibleVisibleData", string2, string);
                String string5 = accessibleContext.getAccessibleName();
                if (string5 != string3) {
                    accessibleContext.firePropertyChange("AccessibleName", string3, string5);
                }
            }
        }
    }

    public String getText() {
        return this._geometry._getText();
    }

    public void setTextWrapper(TextWrapper textWrapper) {
        if (textWrapper != this.getTextWrapper()) {
            this._preferredSize = null;
        }
        this._geometry._setTextWrapper(textWrapper);
    }

    public TextWrapper getTextWrapper() {
        return this._geometry._getTextWrapper();
    }

    public void setWrappingLocked(boolean bl) {
        if (this._isWrappingLocked != bl) {
            this._isWrappingLocked = bl;
            if (bl) {
                this.setWrapWidth(this.getInnerSize().width);
            }
        }
    }

    public boolean isWrappingLocked() {
        return this._isWrappingLocked;
    }

    public void setWrapWidth(int n) {
        this._setWrapWidthNoResize(n);
        if (this.isWrappingLocked()) {
            super.setSize(this.convertInnerToOuterSize((int)n, (int)0).width, this.getSize().height);
        }
    }

    public int getWrapWidth() {
        return this._geometry.getWrapWidth();
    }

    public void setFullJustification(boolean bl) {
        if (this._useFullJustification != bl) {
            this._useFullJustification = bl;
            this.repaint();
        }
    }

    public boolean isFullyJustified() {
        return this._useFullJustification;
    }

    public void setPreferredAspectRatio(float f) {
        if (this._preferredAspectRatio != f) {
            this._preferredAspectRatio = f;
            this.invalidate();
        }
    }

    public float getPreferredAspectRatio() {
        return this._preferredAspectRatio;
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this._geometry != null) {
            this._geometry._setFontMetrics(this.getFontMetrics(this.getFont()));
        }
    }

    @Override
    public void setLocale(Locale locale) {
        if (locale != this.getLocale()) {
            super.setLocale(locale);
            this.invalidate();
        }
    }

    @Override
    public Object getUIClassID() {
        return "LabelUI";
    }

    @Override
    public void doLayout() {
        this._geometry._validate();
        super.doLayout();
    }

    @Override
    public boolean isHScrollable() {
        return true;
    }

    @Override
    public boolean isVScrollable() {
        return true;
    }

    @Override
    public Adjustable getHAdjustable() {
        return this._hAdjustable;
    }

    @Override
    public Adjustable getVAdjustable() {
        return this._vAdjustable;
    }

    @Override
    public void attachHAdjustable(Adjustable adjustable) throws ScrollableException {
        if (this._hAdjustable != null) {
            throw new ScrollableException();
        }
        this._hAdjustable = adjustable;
    }

    @Override
    public void attachVAdjustable(Adjustable adjustable) throws ScrollableException {
        if (this._vAdjustable != null) {
            throw new ScrollableException();
        }
        this._vAdjustable = adjustable;
    }

    @Override
    public void detachAdjustable(Adjustable adjustable) throws ScrollableException {
        if (this._hAdjustable == adjustable) {
            this._hAdjustable = null;
        } else if (this._vAdjustable == adjustable) {
            this._vAdjustable = null;
        } else {
            throw new ScrollableException();
        }
    }

    @Override
    protected int getVMaximum() {
        return this._geometry.getLineCount();
    }

    @Override
    protected int getVOffsetOfValue(int n) {
        return -this._geometry.getFontMetrics().getHeight() * n;
    }

    @Override
    protected int getVValueOfOffset(int n) {
        return -n / this._geometry.getFontMetrics().getHeight();
    }

    @Override
    protected Dimension layoutCanvas() {
        FontMetrics fontMetrics = this._geometry.getFontMetrics();
        int n = 0;
        if (fontMetrics != null) {
            n = this._geometry.getLineCount() * fontMetrics.getHeight();
        }
        return new Dimension(Math.max(this.getInnerSize().width, this._geometry.getMaxPixelWidth()), n);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this._geometry._setFontMetrics(this.getFontMetrics(this.getFont()));
    }

    @Override
    protected void paintCanvasInterior(Graphics graphics) {
        if (!this.isEnabled()) {
            graphics.setColor(this.getUIDefaults().getColor(LookAndFeel.CONTROL_LT_HIGHLIGHT));
            graphics.translate(1, 1);
            this._paintCanvasInterior(graphics);
            graphics.setColor(this.getUIDefaults().getColor(LookAndFeel.CONTROL_INACTIVE_TEXT));
            graphics.translate(-1, -1);
        }
        this._paintCanvasInterior(graphics);
    }

    @Override
    protected int getRepaintFlags() {
        return super.getRepaintFlags() | 0x800 | 1;
    }

    @Override
    protected AccessibleContext createAccessibleContext() {
        return new Access();
    }

    @Override
    public void reshape(int n, int n2, int n3, int n4) {
        super.reshape(n, n2, n3, n4);
        if (this.isWrappingLocked()) {
            this._setWrapWidthNoResize(this.getInnerSize().width);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = this._getPreferredInnerSize();
        return this.convertInnerToOuterSize(dimension.width, dimension.height);
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dimension = new Dimension();
        FontMetrics fontMetrics = this._geometry.getFontMetrics();
        if (fontMetrics != null) {
            int n = this.getText().length();
            if (n > 20) {
                n = 20;
            }
            dimension.width = n * FontUtils.getAverageWidth(this.getFont());
            dimension.height = fontMetrics.getHeight();
        }
        return dimension;
    }

    void invalidateMultiLineLabelCanvas() {
        this.invalidateCanvas();
    }

    private void _paintCanvasInterior(Graphics graphics) {
        LabelGeometry labelGeometry = this._geometry;
        FontMetrics fontMetrics = labelGeometry.getFontMetrics();
        int n = fontMetrics.getHeight();
        Rectangle rectangle = graphics.getClipBounds();
        if (rectangle.width == 0 || rectangle.height == 0) {
            return;
        }
        int n2 = rectangle.y / n;
        if (n2 < 0) {
            n2 = 0;
        }
        int n3 = n2 * n + fontMetrics.getAscent() + fontMetrics.getLeading();
        int n4 = labelGeometry.getLineCount();
        int n5 = labelGeometry.getWrapWidth();
        int n6 = rectangle.y + rectangle.height;
        int n7 = this.getActualAlignment();
        LineInfo lineInfo = new LineInfo();
        while (n2 < n4) {
            if ((lineInfo = labelGeometry.getLineInfo(n2, lineInfo)) == null) {
                return;
            }
            String string = lineInfo.text;
            if (string != null) {
                if (this._useFullJustification && !lineInfo.isNotWrapped) {
                    this._paintFullJustified(graphics, 0, n3, lineInfo);
                } else {
                    int n8 = 0;
                    if (n7 != 1) {
                        n8 = n5 - lineInfo.pixelWidth;
                        if (n7 == 3) {
                            n8 >>= 1;
                        }
                    }
                    GraphicUtils.drawString(graphics, string, n8, n3);
                }
            }
            if (n3 > n6) break;
            n3 += n;
            ++n2;
        }
    }

    private void _setWrapWidthNoResize(int n) {
        if (n != this.getWrapWidth()) {
            this._preferredSize = null;
        }
        this._geometry._setWrapWidth(n);
    }

    private Dimension _getPreferredAspectInnerSize() {
        Dimension dimension = new Dimension();
        Font font = this.getFont();
        if (font == null) {
            return dimension;
        }
        FontMetrics fontMetrics = this.getFontMetrics(font);
        if (fontMetrics != null) {
            int n = fontMetrics.getHeight();
            float f = this.getPreferredAspectRatio();
            int n2 = f != 0.0f ? (int)Math.sqrt((float)fontMetrics.stringWidth(this.getText()) * (float)n * f) + 1 : this.getInnerSize().width;
            LabelGeometry labelGeometry = new LabelGeometry(this, this.getTextWrapper(), this.getText(), fontMetrics, n2, true);
            dimension.width = labelGeometry.getMaxPixelWidth();
            dimension.height = labelGeometry.getLineCount() * n;
        }
        return dimension;
    }

    private Dimension _getPreferredInnerSize() {
        Dimension dimension = this._preferredSize;
        if (dimension == null) {
            dimension = this.isWrappingLocked() ? this._getPreferredAspectInnerSize() : this.layoutCanvas();
            this._preferredSize = dimension;
        }
        return dimension;
    }

    private static int _getWhiteSpacePixels(FontMetrics fontMetrics, char[] cArray, int n, int n2) {
        int n3 = 0;
        for (int i = n; i <= n2; ++i) {
            char c = cArray[i];
            if (!Character.isWhitespace(c)) continue;
            n3 += fontMetrics.charWidth(c);
        }
        return n3;
    }

    private static int _getFirstNonWhiteSpaceIndex(char[] cArray) {
        int n;
        int n2 = cArray.length;
        for (n = 0; n < n2 && Character.isWhitespace(cArray[n]); ++n) {
        }
        return n;
    }

    private int _getLastNonWhiteSpaceIndex(char[] cArray) {
        int n;
        for (n = cArray.length - 1; n >= 0 && Character.isWhitespace(cArray[n]); --n) {
        }
        return n;
    }

    private void _paintFullJustified(Graphics graphics, int n, int n2, LineInfo lineInfo) {
        LabelGeometry labelGeometry = this._geometry;
        String string = lineInfo.text;
        char[] cArray = string.toCharArray();
        int n3 = cArray.length;
        int n4 = MultiLineLabel._getFirstNonWhiteSpaceIndex(cArray);
        if (n4 == n3) {
            return;
        }
        int n5 = this._getLastNonWhiteSpaceIndex(cArray);
        int n6 = labelGeometry.getWrapWidth() - lineInfo.pixelWidth;
        if (n6 == 0 && n4 == 0 && n5 == n3 - 1) {
            GraphicUtils.drawString(graphics, string, n, n2);
        } else {
            float f;
            int n7;
            FontMetrics fontMetrics = labelGeometry.getFontMetrics();
            if (n4 != 0) {
                n7 = fontMetrics.charsWidth(cArray, 0, n4);
                if (lineInfo.isNewParagraph) {
                    n += n7;
                } else {
                    n6 += n7;
                }
            }
            if (n5 != n3 - 1) {
                n6 += fontMetrics.charsWidth(cArray, n5 + 1, n3 - (n5 + 1));
            }
            if ((f = (float)n6 / (float)(n7 = MultiLineLabel._getWhiteSpacePixels(fontMetrics, cArray, n4, n5)) + 1.0f) < 0.0f) {
                f = 0.0f;
            }
            n7 += n6;
            float f2 = 0.0f;
            boolean bl = false;
            int n8 = n4;
            int n9 = n4;
            int n10 = n4;
            while (n8 <= n5) {
                if (bl) {
                    float f3;
                    int n11;
                    while (Character.isWhitespace(cArray[n9])) {
                        if (++n9 <= n5) continue;
                        GraphicUtils.drawChars(graphics, cArray, n10, n9 - n10, n += n7, n2);
                        return;
                    }
                    int n12 = fontMetrics.charsWidth(cArray, n8, n9 - n8);
                    if (n12 != (n11 = (int)(f3 = (float)n12 * f + f2))) {
                        if (n10 != n8) {
                            GraphicUtils.drawChars(graphics, cArray, n10, n8 - n10, n, n2);
                            n += fontMetrics.charsWidth(cArray, n10, n8 - n10);
                        }
                        n += n11;
                        n8 = n9;
                        n10 = n9;
                    }
                    n7 -= n11;
                    f2 = f3 - (float)n11;
                } else {
                    while (!Character.isWhitespace(cArray[n9])) {
                        if (++n9 <= n5) continue;
                        GraphicUtils.drawChars(graphics, cArray, n10, n9 - n10, n += n7, n2);
                        return;
                    }
                    n8 = n9;
                }
                bl = !bl;
            }
        }
    }

    private class Access
    extends AccessibleLWComponent {
        public Access() {
            super(MultiLineLabel.this);
        }

        @Override
        public String getAccessibleName() {
            if (this.accessibleName != null) {
                return this.accessibleName;
            }
            if (MultiLineLabel.this.getText() == null) {
                return super.getAccessibleName();
            }
            return MultiLineLabel.this.getText();
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LABEL;
        }
    }
}

