/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.meter;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleValue;
import oracle.bali.share.util.IntegerUtils;
import oracle.ewt.access.AccessibleLWComponent;
import oracle.ewt.lwAWT.AbstractPainterComponent;
import oracle.ewt.meter.BoundedRangeModel;
import oracle.ewt.meter.StringModelAdaptor;
import oracle.ewt.meter.StringRangeModel;
import oracle.ewt.painter.Painter;
import oracle.ewt.plaf.MeterUI;

public class Meter
extends AbstractPainterComponent {
    private PropertyChangeListener _propertyListener;
    private StringRangeModel _model;
    private Painter _painter;

    public Meter() {
        this(null, null);
    }

    public Meter(BoundedRangeModel boundedRangeModel, Painter painter) {
        this._init(painter);
        this.setModel(boundedRangeModel);
    }

    public Meter(StringRangeModel stringRangeModel, Painter painter) {
        this._init(painter);
        this.setModel(stringRangeModel);
    }

    @Override
    public Object getUIClassID() {
        return "MeterUI";
    }

    public final void setModel(BoundedRangeModel boundedRangeModel) {
        StringRangeModel stringRangeModel = boundedRangeModel == null || boundedRangeModel instanceof StringRangeModel ? (StringRangeModel)boundedRangeModel : new StringModelAdaptor(boundedRangeModel);
        this.setModel(stringRangeModel);
    }

    public void setModel(StringRangeModel stringRangeModel) {
        if (stringRangeModel != this.getModel()) {
            if (this._model != null) {
                this._model.removePropertyChangeListener(this._propertyListener);
            }
            this._model = stringRangeModel;
            this._propertyListener = null;
            if (this._model != null) {
                this._propertyListener = new _PropListener();
                this._model.addPropertyChangeListener(this._propertyListener);
            }
            this.repaint();
        }
    }

    public StringRangeModel getModel() {
        return this._model;
    }

    @Override
    protected AccessibleContext createAccessibleContext() {
        return new Access();
    }

    @Override
    protected Object getPaintData(Object object) {
        Object object2 = null;
        object2 = object == null || object == "Model" ? this.getModel() : super.getPaintData(object);
        return object2;
    }

    @Override
    public Painter getPainter() {
        if (this._painter == null) {
            return ((MeterUI)this.getUI()).getPainter(this);
        }
        return this._painter;
    }

    public void setPainter(Painter painter) {
        if (this._painter != painter) {
            this._painter = painter;
            this.repaint();
        }
    }

    void __propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.repaint();
        AccessibleContext accessibleContext = this.accessAccessibleContext();
        if (accessibleContext != null && "value".equals(propertyChangeEvent.getPropertyName())) {
            accessibleContext.firePropertyChange("AccessibleValue", propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        }
    }

    private void _init(Painter painter) {
        this._painter = painter;
    }

    private class Access
    extends AccessibleLWComponent
    implements AccessibleValue {
        public Access() {
            super(Meter.this);
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            StringRangeModel stringRangeModel = Meter.this.getModel();
            if (stringRangeModel != null && stringRangeModel.getValue() < stringRangeModel.getMaximum()) {
                accessibleStateSet.add(AccessibleState.BUSY);
            }
            accessibleStateSet.add(AccessibleState.HORIZONTAL);
            return accessibleStateSet;
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PROGRESS_BAR;
        }

        @Override
        public AccessibleValue getAccessibleValue() {
            return this;
        }

        @Override
        public Number getCurrentAccessibleValue() {
            StringRangeModel stringRangeModel = Meter.this.getModel();
            return IntegerUtils.getInteger(stringRangeModel == null ? 0 : stringRangeModel.getValue());
        }

        @Override
        public boolean setCurrentAccessibleValue(Number number) {
            StringRangeModel stringRangeModel = Meter.this.getModel();
            if (stringRangeModel == null) {
                return false;
            }
            stringRangeModel.setValue(number.intValue());
            return true;
        }

        @Override
        public Number getMinimumAccessibleValue() {
            StringRangeModel stringRangeModel = Meter.this.getModel();
            return IntegerUtils.getInteger(stringRangeModel == null ? 0 : stringRangeModel.getMinimum());
        }

        @Override
        public Number getMaximumAccessibleValue() {
            StringRangeModel stringRangeModel = Meter.this.getModel();
            return IntegerUtils.getInteger(stringRangeModel == null ? 0 : stringRangeModel.getMaximum());
        }
    }

    private class _PropListener
    implements PropertyChangeListener {
        private _PropListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Meter.this.__propertyChange(propertyChangeEvent);
        }
    }
}

