/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.lwAWT.lwWindow.laf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.Enumeration;
import java.util.Vector;
import oracle.ewt.event.tracking.MouseGrabProvider;
import oracle.ewt.event.tracking.TrackingUtils;
import oracle.ewt.graphics.GraphicUtils;
import oracle.ewt.lwAWT.KeyProcessor;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.lwAWT.lwMenu.LWMenuBar;
import oracle.ewt.lwAWT.lwWindow.Desktop;
import oracle.ewt.lwAWT.lwWindow.DesktopEvent;
import oracle.ewt.lwAWT.lwWindow.DesktopListener;
import oracle.ewt.lwAWT.lwWindow.LWWindow;
import oracle.ewt.lwAWT.lwWindow.WindowManager;
import oracle.ewt.lwAWT.lwWindow.WindowType;
import oracle.ewt.lwAWT.lwWindow.laf.KeyWindowActivater;
import oracle.ewt.lwAWT.lwWindow.laf.MouseWindowActivater;

public class BaseWindowManager
implements WindowManager,
DesktopListener,
ComponentListener {
    private Desktop _desktop;
    private Rectangle _resizeRect;
    private Point _movePoint;
    private LWWindow _activeWindow;
    private MouseGrabProvider _grabProvider;
    private Window _window;
    private Vector _activationList;
    private Vector _navigationList;
    private static final int _RESIZE_BORDER_THICKNESS = 2;
    private static final String _CLIENTPROP_RESTORE_BOUNDS = "restoreBounds";
    private static final String _CLIENTPROP_MINIMIZE_BOUNDS = "minimizeBounds";

    public void setDesktop(Desktop desktop) {
        if (desktop != this._desktop) {
            if (this._desktop != null) {
                this._activationList = null;
                this._navigationList = null;
                this._activeWindow = null;
                this._desktop.removeDesktopListener(this);
                this._removeMouseGrab();
                if (this._desktop instanceof KeyProcessor) {
                    ((KeyProcessor)((Object)this._desktop)).removePostKeyListener(KeyWindowActivater.getInstance());
                }
            }
            this._desktop = desktop;
            if (desktop != null) {
                Enumeration enumeration = desktop.getWindows();
                this._activationList = new Vector(1);
                this._navigationList = new Vector(1);
                while (enumeration.hasMoreElements()) {
                    LWWindow lWWindow = (LWWindow)enumeration.nextElement();
                    this._activationList.addElement(lWWindow);
                    this._navigationList.addElement(lWWindow);
                    if (!lWWindow.isActive()) continue;
                    this._activeWindow = lWWindow;
                }
                this._addMouseGrab();
                desktop.addDesktopListener(this);
                if (desktop instanceof KeyProcessor) {
                    ((KeyProcessor)((Object)desktop)).addPostKeyListener(KeyWindowActivater.getInstance());
                }
            }
        }
    }

    @Override
    public void beginResizingWindow(LWWindow lWWindow) {
        lWWindow.setReshaping(true);
        this._resizeRect = lWWindow.getBounds();
        this._drawResizeBorder(lWWindow, this._resizeRect.x, this._resizeRect.y, this._resizeRect.width, this._resizeRect.height);
    }

    @Override
    public void resizeWindow(LWWindow lWWindow, int n, int n2, int n3, int n4) {
        this._drawResizeBorder(lWWindow, this._resizeRect.x, this._resizeRect.y, this._resizeRect.width, this._resizeRect.height);
        Desktop desktop = lWWindow.getDesktop();
        Component component = desktop.getDesktopComponent();
        Dimension dimension = component.getSize();
        if (n < this._resizeRect.x && n < 0) {
            n3 += n;
            n = 0;
        } else if (n > dimension.width - 2) {
            n = dimension.width - 2;
        }
        if (n2 < this._resizeRect.y && n2 < 0) {
            n4 += n2;
            n2 = 0;
        } else if (n2 > dimension.height - 2) {
            n2 = dimension.height - 2;
        }
        int n5 = n + n3;
        if (n5 > this._resizeRect.x + this._resizeRect.width && n5 > dimension.width) {
            n3 = dimension.width - n;
        } else if (n5 < 2) {
            n3 = 2 - n;
        }
        int n6 = n2 + n4;
        if (n6 > this._resizeRect.y + this._resizeRect.height && n6 > dimension.height) {
            n4 = dimension.height - n2;
        } else if (n6 < 2) {
            n4 = 2 - n2;
        }
        this._resizeRect.x = n;
        this._resizeRect.y = n2;
        this._resizeRect.width = n3;
        this._resizeRect.height = n4;
        this._drawResizeBorder(lWWindow, this._resizeRect.x, this._resizeRect.y, this._resizeRect.width, this._resizeRect.height);
    }

    @Override
    public void endResizingWindow(LWWindow lWWindow, boolean bl) {
        this._drawResizeBorder(lWWindow, this._resizeRect.x, this._resizeRect.y, this._resizeRect.width, this._resizeRect.height);
        if (bl) {
            lWWindow.setBounds(this._resizeRect.x, this._resizeRect.y, this._resizeRect.width, this._resizeRect.height);
            lWWindow.validate();
        }
        lWWindow.setReshaping(false);
    }

    @Override
    public void beginMovingWindow(LWWindow lWWindow) {
        lWWindow.setReshaping(true);
        Dimension dimension = lWWindow.getSize();
        this._movePoint = lWWindow.getLocation();
        this._drawResizeBorder(lWWindow, this._movePoint.x, this._movePoint.y, dimension.width, dimension.height);
    }

    @Override
    public void moveWindow(LWWindow lWWindow, int n, int n2) {
        Dimension dimension = lWWindow.getSize();
        this._drawResizeBorder(lWWindow, this._movePoint.x, this._movePoint.y, dimension.width, dimension.height);
        this._movePoint.x = n;
        this._movePoint.y = n2;
        this._drawResizeBorder(lWWindow, this._movePoint.x, this._movePoint.y, dimension.width, dimension.height);
    }

    @Override
    public void endMovingWindow(LWWindow lWWindow, boolean bl) {
        Dimension dimension = lWWindow.getSize();
        this._drawResizeBorder(lWWindow, this._movePoint.x, this._movePoint.y, dimension.width, dimension.height);
        if (bl) {
            lWWindow.setLocation(this._movePoint.x, this._movePoint.y);
        }
        lWWindow.setReshaping(false);
    }

    @Override
    public void desktopAdded(DesktopEvent desktopEvent) {
        this._addMouseGrab();
    }

    @Override
    public void desktopRemoved(DesktopEvent desktopEvent) {
        this._removeMouseGrab();
    }

    @Override
    public void transferActivationForward() {
        LWWindow lWWindow;
        Object object;
        Object object2 = null;
        if (this._activeWindow != null) {
            this._navigationList.removeElement(this._activeWindow);
            this._navigationList.addElement(this._activeWindow);
            for (object = this._activeWindow; object != null; object = ((LWWindow)object).getLeader()) {
                if (!((LWWindow)object).isModal()) continue;
                object2 = object;
                break;
            }
        } else {
            int n = this._activationList.size();
            for (int i = 0; i < n; ++i) {
                lWWindow = (LWWindow)this._activationList.elementAt(i);
                if (!lWWindow.isModal() || !lWWindow.isVisible()) continue;
                object2 = lWWindow;
                break;
            }
        }
        object = this._navigationList.elements();
        while (object.hasMoreElements()) {
            LWWindow lWWindow2 = (LWWindow)object.nextElement();
            if (!this._isTraversible(lWWindow2)) continue;
            if (object2 == null) {
                lWWindow2.setActive(true);
                return;
            }
            for (lWWindow = lWWindow2; lWWindow != null; lWWindow = lWWindow.getLeader()) {
                if (lWWindow != object2) continue;
                lWWindow2.setActive(true);
                return;
            }
        }
    }

    @Override
    public void transferActivationBackward() {
        LWWindow lWWindow = null;
        if (this._activeWindow != null) {
            for (LWWindow lWWindow2 = this._activeWindow; lWWindow2 != null; lWWindow2 = lWWindow2.getLeader()) {
                if (!lWWindow2.isModal()) continue;
                lWWindow = lWWindow2;
                break;
            }
        }
        for (int i = this._navigationList.size() - 1; i >= 0; --i) {
            LWWindow lWWindow3 = (LWWindow)this._navigationList.elementAt(i);
            if (!this._isTraversible(lWWindow3)) continue;
            if (lWWindow == null) {
                lWWindow3.setActive(true);
                return;
            }
            for (LWWindow lWWindow4 = lWWindow3; lWWindow4 != null; lWWindow4 = lWWindow4.getLeader()) {
                if (lWWindow4 != lWWindow) continue;
                lWWindow3.setActive(true);
                return;
            }
        }
    }

    @Override
    public void windowAdded(DesktopEvent desktopEvent) {
        LWWindow lWWindow = desktopEvent.getWindow();
        this._activationList.addElement(lWWindow);
        this._navigationList.addElement(lWWindow);
        lWWindow.addComponentListener(this);
    }

    @Override
    public void windowRemoved(DesktopEvent desktopEvent) {
        LWWindow lWWindow = desktopEvent.getWindow();
        this._activationList.removeElement(lWWindow);
        this._navigationList.removeElement(lWWindow);
        if (this._activeWindow == null) {
            this.transferActivationForward();
        }
        lWWindow.removeComponentListener(this);
    }

    @Override
    public boolean activateWindow(LWWindow lWWindow) {
        if (this._activeWindow != lWWindow) {
            if (this._activeWindow != null && !this._activeWindow.setActive(false)) {
                return false;
            }
            this._activeWindow = lWWindow;
            this._activationList.removeElement(lWWindow);
            this._activationList.insertElementAt(lWWindow, 0);
            this._navigationList.removeElement(lWWindow);
            this._navigationList.insertElementAt(lWWindow, 0);
        }
        return true;
    }

    @Override
    public void deactivateWindow(LWWindow lWWindow) {
        this._activeWindow = null;
    }

    @Override
    public void maximizeWindow(LWWindow lWWindow) {
        Rectangle rectangle;
        Desktop desktop = lWWindow.getDesktop();
        Component component = desktop.getDesktopComponent();
        Dimension dimension = component.getSize();
        if (lWWindow.getClientProperty(_CLIENTPROP_RESTORE_BOUNDS) == null) {
            rectangle = lWWindow.getBounds();
            lWWindow.putClientProperty(_CLIENTPROP_RESTORE_BOUNDS, rectangle);
        }
        this._setWindowContentsVisible(lWWindow, true);
        rectangle = new Rectangle(0, 0, dimension.width, dimension.height);
        if (component instanceof LWComponent) {
            ((LWComponent)component).clipToParents(rectangle);
        }
        Dimension dimension2 = lWWindow.getMaximumSize();
        if (rectangle.width > dimension2.width) {
            rectangle.width = dimension2.width;
        }
        if (rectangle.height > dimension2.height) {
            rectangle.height = dimension2.height;
        }
        lWWindow.setBounds(rectangle);
        lWWindow.validate();
    }

    @Override
    public void minimizeWindow(LWWindow lWWindow) {
        if (!lWWindow.isMinimizable() && lWWindow.getType() != WindowType.FRAME) {
            lWWindow.setVisible(false);
        } else {
            if (lWWindow.isActive()) {
                this.transferActivationForward();
            }
            if (lWWindow.getClientProperty(_CLIENTPROP_RESTORE_BOUNDS) == null) {
                Rectangle rectangle = lWWindow.getBounds();
                lWWindow.putClientProperty(_CLIENTPROP_RESTORE_BOUNDS, rectangle);
            }
            this._setWindowContentsVisible(lWWindow, false);
            lWWindow.setBounds(this._getMinimizeBounds(lWWindow));
            lWWindow.validate();
        }
    }

    @Override
    public void restoreMaximizedWindow(LWWindow lWWindow) {
        Rectangle rectangle = (Rectangle)lWWindow.getClientProperty(_CLIENTPROP_RESTORE_BOUNDS);
        lWWindow.setBounds(rectangle);
        lWWindow.validate();
        lWWindow.putClientProperty(_CLIENTPROP_RESTORE_BOUNDS, null);
    }

    @Override
    public void restoreMinimizedWindow(LWWindow lWWindow) {
        lWWindow.putClientProperty(_CLIENTPROP_MINIMIZE_BOUNDS, lWWindow.getBounds());
        this._setWindowContentsVisible(lWWindow, true);
        Rectangle rectangle = (Rectangle)lWWindow.getClientProperty(_CLIENTPROP_RESTORE_BOUNDS);
        if (rectangle == null) {
            lWWindow.setVisible(true, false);
        } else {
            lWWindow.setBounds(rectangle);
            lWWindow.putClientProperty(_CLIENTPROP_RESTORE_BOUNDS, null);
        }
        lWWindow.validate();
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
        if (this._activeWindow == null) {
            this.transferActivationForward();
        }
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    private void _drawResizeBorder(LWWindow lWWindow, int n, int n2, int n3, int n4) {
        Desktop desktop = lWWindow.getDesktop();
        Component component = desktop.getDesktopComponent();
        Graphics graphics = component.getGraphics();
        Color color = component.getBackground();
        if (color instanceof SystemColor) {
            color = new Color(color.getRGB());
        }
        graphics.setColor(Color.black);
        graphics.setXORMode(color);
        GraphicUtils.drawRect(graphics, n + 1, n2 + 1, n3 - 2, n4 - 2, 2);
        Toolkit toolkit = lWWindow.getToolkit();
        toolkit.sync();
    }

    private void _addMouseGrab() {
        this._grabProvider = TrackingUtils.getMouseGrabProvider(this._desktop.getDesktopComponent());
        if (this._grabProvider != null) {
            this._grabProvider.addMouseGrab(MouseWindowActivater.getInstance());
            this._grabProvider.addMouseMotionGrab(MouseWindowActivater.getInstance());
        }
    }

    private void _removeMouseGrab() {
        if (this._grabProvider != null) {
            this._grabProvider.removeMouseGrab(MouseWindowActivater.getInstance());
            this._grabProvider.removeMouseMotionGrab(MouseWindowActivater.getInstance());
            this._grabProvider = null;
        }
    }

    private int _getActualReadingDirection() {
        Component component = this._desktop.getDesktopComponent();
        if (component instanceof LWComponent) {
            return ((LWComponent)component).getActualReadingDirection();
        }
        return 1;
    }

    private Rectangle _getMinimizeBounds(LWWindow lWWindow) {
        Component component = this._desktop.getDesktopComponent();
        Dimension dimension = new Dimension();
        Rectangle rectangle = component.getBounds();
        int n = -rectangle.y;
        int n2 = -rectangle.x;
        rectangle.y = 0;
        ((LWComponent)component).clipToParents(rectangle);
        dimension.width = rectangle.width;
        dimension.height = rectangle.height;
        Rectangle[] rectangleArray = this._getMinimizedRects(lWWindow);
        Rectangle rectangle2 = (Rectangle)lWWindow.getClientProperty(_CLIENTPROP_MINIMIZE_BOUNDS);
        if (rectangle2 != null && !this._rectIntersects(rectangle2, rectangleArray) && rectangle.contains(rectangle2.x, rectangle2.y) && rectangle.contains(rectangle2.x + rectangle2.width, rectangle2.y + rectangle2.height)) {
            return rectangle2;
        }
        Dimension dimension2 = lWWindow.getMinimumSize();
        int n3 = 0;
        for (int i = n + dimension.height - dimension2.height; i >= 0; i -= dimension2.height) {
            while (n3 + dimension2.width < dimension.width) {
                rectangle2 = this._getActualReadingDirection() == 2 ? new Rectangle(dimension.width - n3 - dimension2.width + n2, i, dimension2.width, dimension2.height) : new Rectangle(n3 + n2, i, dimension2.width, dimension2.height);
                if (!this._rectIntersects(rectangle2, rectangleArray)) {
                    return rectangle2;
                }
                n3 += dimension2.width;
            }
            n3 = 0;
        }
        return new Rectangle(0, rectangle.y + dimension.height - dimension2.height, dimension2.width, dimension2.height);
    }

    private Rectangle[] _getMinimizedRects(LWWindow lWWindow) {
        Rectangle[] rectangleArray = new Rectangle[]{};
        Enumeration enumeration = this._desktop.getWindows();
        while (enumeration.hasMoreElements()) {
            LWWindow lWWindow2 = (LWWindow)enumeration.nextElement();
            if (lWWindow2 == lWWindow || !lWWindow2.isMinimized()) continue;
            Rectangle[] rectangleArray2 = new Rectangle[rectangleArray.length + 1];
            System.arraycopy(rectangleArray, 0, rectangleArray2, 0, rectangleArray.length);
            rectangleArray = rectangleArray2;
            rectangleArray[rectangleArray.length - 1] = lWWindow2.getBounds();
        }
        return rectangleArray;
    }

    private boolean _isTraversible(LWWindow lWWindow) {
        return lWWindow.isVisible() && lWWindow.isEnabled() && lWWindow.getType() != WindowType.PALETTE;
    }

    private boolean _rectIntersects(Rectangle rectangle, Rectangle[] rectangleArray) {
        for (int i = 0; i < rectangleArray.length; ++i) {
            if (!rectangle.intersects(rectangleArray[i])) continue;
            return true;
        }
        return false;
    }

    private void _setWindowContentsVisible(LWWindow lWWindow, boolean bl) {
        LWMenuBar lWMenuBar;
        Component component = lWWindow.getContent();
        if (component != null) {
            component.setVisible(bl);
        }
        if ((lWMenuBar = lWWindow.getMenuBar()) != null) {
            lWMenuBar.setVisible(bl);
        }
    }
}

