/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.lwAWT.lwWindow;

import java.awt.Rectangle;
import java.util.Vector;

class Region
implements Cloneable {
    private int _x;
    private int _y;
    private int _width;
    private int _height;
    private Rectangle[] _rects;
    private static Rectangle[] _sNullRects = new Rectangle[0];

    public Region() {
        this(0, 0, 0, 0);
    }

    public Region(int n, int n2, int n3, int n4) {
        if (n3 > 0 && n4 > 0) {
            this._rects = new Rectangle[1];
            this._rects[0] = new Rectangle();
            this._rects[0].x = n;
            this._rects[0].y = n2;
            this._rects[0].width = n3;
            this._rects[0].height = n4;
        } else {
            this._rects = _sNullRects;
        }
        this._updateBounds();
    }

    public void add(Region region) {
        if (region == this || region.isEmpty()) {
            return;
        }
        if (this.isEmpty()) {
            this._rects = this._copyRects(region.__getRectangles());
            this._updateBounds();
            return;
        }
        AddHandler addHandler = AddHandler.getInstance();
        this._combine(region, addHandler, addHandler, addHandler);
    }

    public Object clone() {
        Region region = null;
        try {
            region = (Region)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        region.__setRectangles(this._copyRects(this._rects));
        return region;
    }

    public Rectangle getBounds() {
        return new Rectangle(this._x, this._y, this._width, this._height);
    }

    public void intersect(Region region) {
        if (this.isEmpty()) {
            return;
        }
        if (region.isEmpty()) {
            this._rects = _sNullRects;
            this._updateBounds();
            return;
        }
        this._combine(region, IntersectHandler.getInstance(), null, null);
    }

    public boolean intersects(int n, int n2, int n3, int n4) {
        if (n3 == 0 || n4 == 0 || n + n3 <= this._x || n2 + n4 <= this._y || n >= this._x + this._width || n2 >= this._y + this._height) {
            return false;
        }
        int n5 = 0;
        int n6 = n + n3;
        int n7 = n2 + n4;
        while (n5 < this._rects.length) {
            Rectangle rectangle = this._rects[n5];
            if (n7 <= rectangle.y) {
                return false;
            }
            if (n2 >= rectangle.y + rectangle.height) {
                ++n5;
                continue;
            }
            if (n < rectangle.x + rectangle.width && n6 > rectangle.x) {
                return true;
            }
            ++n5;
        }
        return false;
    }

    public boolean isEmpty() {
        return this._width == 0 || this._height == 0;
    }

    public void subtract(Region region) {
        if (this.isEmpty() || region.isEmpty()) {
            return;
        }
        this._combine(region, SubtractHandler.getInstance(), AddHandler.getInstance(), null);
    }

    public String toString() {
        String string = this.getClass().getName() + "[numRects=" + this._rects.length + "\n";
        for (int i = 0; i < this._rects.length; ++i) {
            string = string + "  " + this._rects[i].toString() + "\n";
        }
        string = string + "]";
        return string;
    }

    public void translate(int n, int n2) {
        this._x += n;
        this._y += n2;
        for (int i = 0; i < this._rects.length; ++i) {
            this._rects[i].translate(n, n2);
        }
    }

    private Rectangle[] __getRectangles() {
        return this._rects;
    }

    private void __setRectangles(Rectangle[] rectangleArray) {
        this._rects = rectangleArray == null ? _sNullRects : rectangleArray;
        this._updateBounds();
    }

    private int _coalesce(Vector vector, int n, int n2) {
        return n;
    }

    private void _combine(Region region, OverlapHandler overlapHandler, NonOverlapHandler nonOverlapHandler, NonOverlapHandler nonOverlapHandler2) {
        int n;
        Rectangle rectangle;
        Rectangle rectangle2;
        int n2;
        int n3;
        Rectangle[] rectangleArray = this.__getRectangles();
        Rectangle[] rectangleArray2 = region.__getRectangles();
        Vector vector = new Vector(Math.max(rectangleArray.length, rectangleArray2.length) * 2);
        Rectangle rectangle3 = this.getBounds();
        Rectangle rectangle4 = region.getBounds();
        int n4 = 0;
        int n5 = 0;
        int n6 = Math.min(rectangle3.y, rectangle4.y);
        int n7 = 0;
        do {
            int n8;
            int n9;
            int n10 = vector.size();
            n3 = this._getBandEnd(rectangleArray, n4);
            n2 = this._getBandEnd(rectangleArray2, n5);
            rectangle2 = rectangleArray[n4];
            rectangle = rectangleArray2[n5];
            if (rectangle2.y < rectangle.y) {
                n = Math.max(rectangle2.y, n6);
                if (n != (n9 = Math.min(rectangle2.y + rectangle2.height, rectangle.y)) && nonOverlapHandler != null) {
                    nonOverlapHandler.handleNonOverlappingBand(vector, rectangleArray, n4, n3, n, n9);
                }
                n8 = rectangle.y;
            } else if (rectangle.y < rectangle2.y) {
                n = Math.max(rectangle.y, n6);
                if (n != (n9 = Math.min(rectangle.y + rectangle.height, rectangle2.y)) && nonOverlapHandler2 != null) {
                    nonOverlapHandler2.handleNonOverlappingBand(vector, rectangleArray2, n5, n2, n, n9);
                }
                n8 = rectangle2.y;
            } else {
                n8 = rectangle2.y;
            }
            if (vector.size() != n10) {
                n7 = this._coalesce(vector, n7, n10);
            }
            n6 = Math.min(rectangle2.y + rectangle2.height, rectangle.y + rectangle.height);
            n10 = vector.size();
            if (n6 > n8) {
                overlapHandler.handleOverlappingBand(vector, rectangleArray, n4, n3, rectangleArray2, n5, n2, n8, n6);
            }
            if (vector.size() != n10) {
                n7 = this._coalesce(vector, n7, n10);
            }
            if (rectangle2.y + rectangle2.height == n6) {
                n4 = n3;
            }
            if (rectangle.y + rectangle.height != n6) continue;
            n5 = n2;
        } while (n4 < rectangleArray.length && n5 < rectangleArray2.length);
        if (n4 < rectangleArray.length) {
            if (nonOverlapHandler != null) {
                do {
                    n3 = this._getBandEnd(rectangleArray, n4);
                    rectangle2 = rectangleArray[n4];
                    nonOverlapHandler.handleNonOverlappingBand(vector, rectangleArray, n4, n3, Math.max(rectangle2.y, n6), rectangle2.y + rectangle2.height);
                } while ((n4 = n3) < rectangleArray.length);
            }
        } else if (n5 < rectangleArray2.length && nonOverlapHandler2 != null) {
            do {
                n2 = this._getBandEnd(rectangleArray2, n5);
                rectangle = rectangleArray2[n5];
                nonOverlapHandler2.handleNonOverlappingBand(vector, rectangleArray2, n5, n2, Math.max(rectangle.y, n6), rectangle.y + rectangle.height);
            } while ((n5 = n2) < rectangleArray2.length);
        }
        Rectangle[] rectangleArray3 = (n = vector.size()) == this._rects.length ? this._rects : new Rectangle[n];
        for (int i = 0; i < n; ++i) {
            rectangleArray3[i] = (Rectangle)vector.elementAt(i);
        }
        this.__setRectangles(rectangleArray3);
    }

    private Rectangle[] _copyRects(Rectangle[] rectangleArray) {
        Rectangle[] rectangleArray2 = new Rectangle[rectangleArray.length];
        for (int i = 0; i < rectangleArray.length; ++i) {
            rectangleArray2[i] = new Rectangle(rectangleArray[i]);
        }
        return rectangleArray2;
    }

    private int _getBandEnd(Rectangle[] rectangleArray, int n) {
        int n2;
        int n3 = rectangleArray[n].y;
        for (n2 = n + 1; n2 < rectangleArray.length && rectangleArray[n2].y == n3; ++n2) {
        }
        return n2;
    }

    private void _updateBounds() {
        this._x = 0;
        this._y = 0;
        this._width = 0;
        this._height = 0;
        if (this._rects.length > 0) {
            this._y = this._rects[0].y;
            Rectangle rectangle = this._rects[this._rects.length - 1];
            this._height = rectangle.y + rectangle.height;
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < this._rects.length; ++i) {
                rectangle = this._rects[i];
                n = Math.min(rectangle.x, n);
                n2 = Math.max(rectangle.x + rectangle.width, n2);
            }
            this._x = n;
            this._width = n2 - n;
        }
    }

    private static class SubtractHandler
    implements OverlapHandler {
        private static SubtractHandler _sInstance;

        private SubtractHandler() {
        }

        public static SubtractHandler getInstance() {
            if (_sInstance == null) {
                _sInstance = new SubtractHandler();
            }
            return _sInstance;
        }

        @Override
        public void handleOverlappingBand(Vector vector, Rectangle[] rectangleArray, int n, int n2, Rectangle[] rectangleArray2, int n3, int n4, int n5, int n6) {
            Rectangle rectangle;
            int n7 = 0;
            while (n < n2 && n3 < n4) {
                rectangle = rectangleArray[n];
                Rectangle rectangle2 = rectangleArray2[n3];
                int n8 = rectangle.x;
                int n9 = rectangle2.x;
                int n10 = rectangle.x + rectangle.width;
                int n11 = rectangle2.x + rectangle2.width;
                if (n7 < n8) {
                    n7 = n8;
                }
                if (n11 <= n8) {
                    ++n3;
                    continue;
                }
                if (n10 <= n9) {
                    if (n10 > n7) {
                        vector.addElement(new Rectangle(n7, n5, n10 - n7, n6 - n5));
                    }
                    ++n;
                    continue;
                }
                if (n9 <= n8) {
                    n7 = n11;
                    ++n3;
                    if (n10 > n11) continue;
                    ++n;
                    continue;
                }
                if (n9 > n7) {
                    vector.addElement(new Rectangle(n7, n5, n9 - n7, n6 - n5));
                }
                n7 = n11;
                ++n3;
                if (n10 > n11) continue;
                ++n;
            }
            while (n != n2) {
                rectangle = rectangleArray[n];
                if (rectangle.x + rectangle.width - n7 > 0) {
                    vector.addElement(new Rectangle(n7, n5, rectangle.x + rectangle.width - n7, n6 - n5));
                }
                if (++n == n2) continue;
                n7 = rectangleArray[n].x;
            }
        }
    }

    private static class IntersectHandler
    implements OverlapHandler {
        private static IntersectHandler _sInstance;

        private IntersectHandler() {
        }

        public static IntersectHandler getInstance() {
            if (_sInstance == null) {
                _sInstance = new IntersectHandler();
            }
            return _sInstance;
        }

        @Override
        public void handleOverlappingBand(Vector vector, Rectangle[] rectangleArray, int n, int n2, Rectangle[] rectangleArray2, int n3, int n4, int n5, int n6) {
            while (n < n2 && n3 < n4) {
                int n7;
                Rectangle rectangle = rectangleArray[n];
                Rectangle rectangle2 = rectangleArray2[n3];
                int n8 = rectangle.x + rectangle.width;
                int n9 = rectangle2.x + rectangle2.width;
                int n10 = Math.max(rectangle.x, rectangle2.x);
                if (n10 < (n7 = Math.min(n8, n9))) {
                    vector.addElement(new Rectangle(n10, n5, n7 - n10, n6 - n5));
                }
                if (n8 < n9) {
                    ++n;
                    continue;
                }
                if (n9 < n8) {
                    ++n3;
                    continue;
                }
                ++n;
                ++n3;
            }
        }
    }

    private static class AddHandler
    implements OverlapHandler,
    NonOverlapHandler {
        private static AddHandler _sInstance;

        private AddHandler() {
        }

        public static AddHandler getInstance() {
            if (_sInstance == null) {
                _sInstance = new AddHandler();
            }
            return _sInstance;
        }

        @Override
        public void handleNonOverlappingBand(Vector vector, Rectangle[] rectangleArray, int n, int n2, int n3, int n4) {
            while (n < n2) {
                Rectangle rectangle = rectangleArray[n];
                vector.addElement(new Rectangle(rectangle.x, n3, rectangle.width, n4 - n3));
                ++n;
            }
        }

        @Override
        public void handleOverlappingBand(Vector vector, Rectangle[] rectangleArray, int n, int n2, Rectangle[] rectangleArray2, int n3, int n4, int n5, int n6) {
            while (n < n2 && n3 < n4) {
                Rectangle rectangle = rectangleArray[n];
                Rectangle rectangle2 = rectangleArray2[n3];
                if (rectangle.x < rectangle2.x) {
                    this._mergeRect(vector, rectangle, n5, n6);
                    ++n;
                    continue;
                }
                this._mergeRect(vector, rectangle2, n5, n6);
                ++n3;
            }
            while (n < n2) {
                this._mergeRect(vector, rectangleArray[n++], n5, n6);
            }
            while (n3 < n4) {
                this._mergeRect(vector, rectangleArray2[n3++], n5, n6);
            }
        }

        private void _mergeRect(Vector vector, Rectangle rectangle, int n, int n2) {
            int n3 = vector.size();
            if (n3 > 0) {
                Rectangle rectangle2 = (Rectangle)vector.elementAt(n3 - 1);
                if (rectangle2.y == n && rectangle.x <= rectangle2.x + rectangle2.width && rectangle.x + rectangle.width > rectangle2.x + rectangle2.width) {
                    rectangle2.width = rectangle.x + rectangle.width - rectangle2.x;
                    return;
                }
            }
            vector.addElement(new Rectangle(rectangle.x, n, rectangle.width, n2 - n));
        }
    }

    private static interface NonOverlapHandler {
        public void handleNonOverlappingBand(Vector var1, Rectangle[] var2, int var3, int var4, int var5, int var6);
    }

    private static interface OverlapHandler {
        public void handleOverlappingBand(Vector var1, Rectangle[] var2, int var3, int var4, Rectangle[] var5, int var6, int var7, int var8, int var9);
    }
}

