/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.lwAWT.lwWindow;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import oracle.ewt.access.AccessibleLWComponent;
import oracle.ewt.event.tracking.KeyFilterProvider;
import oracle.ewt.event.tracking.KeyFilterSupport;
import oracle.ewt.event.tracking.MouseGrabProvider;
import oracle.ewt.event.tracking.TrackingUtils;
import oracle.ewt.lwAWT.FocusRoot;
import oracle.ewt.lwAWT.ImmediatePainter;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.lwAWT.lwMenu.LWMenuBar;
import oracle.ewt.lwAWT.lwWindow.Desktop;
import oracle.ewt.lwAWT.lwWindow.ModalStyle;
import oracle.ewt.lwAWT.lwWindow.Region;
import oracle.ewt.lwAWT.lwWindow.SystemModalStyle;
import oracle.ewt.lwAWT.lwWindow.WindowManager;
import oracle.ewt.lwAWT.lwWindow.WindowType;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.util.ImmInsets;
import oracle.ewt.util.LocaleUtils;
import oracle.ewt.util.WindowUtils;

public class LWWindow
extends LWComponent
implements KeyFilterProvider,
FocusRoot {
    public static final String PROPERTY_ACTIVE = "active";
    public static final String PROPERTY_CLOSABLE = "closable";
    public static final String PROPERTY_CLOSED = "closed";
    public static final String PROPERTY_CONTENT = "content";
    public static final String PROPERTY_DESKTOP = "desktop";
    public static final String PROPERTY_FRAME_ICON = "frameIcon";
    public static final String PROPERTY_LEADER = "leader";
    public static final String PROPERTY_MAXIMIZABLE = "maximizable";
    public static final String PROPERTY_MAXIMIZED = "maximized";
    public static final String PROPERTY_MENUBAR = "menubar";
    public static final String PROPERTY_MINIMIZABLE = "minimizable";
    public static final String PROPERTY_MINIMIZED = "minimized";
    public static final String PROPERTY_MODAL = "modal";
    public static final String PROPERTY_MODAL_STYLE = "modalStyle";
    public static final String PROPERTY_MOVABLE = "movable";
    public static final String PROPERTY_RESHAPING = "reshaping";
    public static final String PROPERTY_RESIZABLE = "resizable";
    public static final String PROPERTY_TITLE = "title";
    public static final String PROPERTY_TYPE = "type";
    public static final String PROPERTY_ENABLED = "enabled";
    private WindowType _type;
    private Desktop _desktop;
    private Component _content;
    private LWWindow _leader;
    private Vector _children;
    private Image _frameIcon;
    private LWMenuBar _menuBar;
    private Component _focusOwner;
    private String _title;
    private boolean _modal;
    private boolean _active;
    private boolean _closable;
    private boolean _maximizable;
    private boolean _maximized;
    private boolean _minimizable;
    private boolean _minimized;
    private boolean _movable;
    private boolean _reshaping;
    private boolean _resizable;
    private boolean _raising;
    private boolean _ignoreRepaints;
    private PropertyChangeSupport _propSupport;
    private VetoableChangeSupport _vetoSupport;
    private KeyFilterSupport _filterSupport;
    private MouseGrab _mouseGrab;
    private MouseGrabProvider _mouseGrabProvider;
    private ModalStyle _modalStyle;
    private Component _component;
    private static Hashtable _sModalStackTable = new Hashtable(5);
    private static final String _RECOMPUTE_VISIBLE_REGIONS = "_lwWindowRecompute";
    private static final String _VISIBLE_REGION = "_lwWindowVisibleRegion";
    static final String _ACCESSIBILITY_BUNDLE = "oracle.ewt.access.resource.AccessibilityBundle";

    public LWWindow() {
        this(WindowType.FRAME);
    }

    public LWWindow(WindowType windowType) {
        this(windowType, null, false);
    }

    public LWWindow(WindowType windowType, LWWindow lWWindow, boolean bl) {
        this.setType(windowType);
        this.setLeader(lWWindow);
        this._modal = bl;
        this._modalStyle = SystemModalStyle.getSystemModalStyle();
        this._addFocusProxyComponents();
        this.updateUI(LWWindow.class);
    }

    @Override
    public void addKeyFilter(KeyListener keyListener) {
        if (this._filterSupport == null) {
            this._filterSupport = new KeyFilterSupport();
            this._filterSupport.setComponent(this);
        }
        this._filterSupport.addKeyFilter(keyListener);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._propSupport == null) {
            this._propSupport = new PropertyChangeSupport(this);
        }
        this._propSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (this._vetoSupport == null) {
            this._vetoSupport = new VetoableChangeSupport(this);
        }
        this._vetoSupport.addVetoableChangeListener(vetoableChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean close() {
        Desktop desktop = this.getDesktop();
        if (desktop != null) {
            Object object;
            try {
                this.fireBooleanVetoableChanged(PROPERTY_CLOSED, true);
            }
            catch (PropertyVetoException propertyVetoException) {
                return false;
            }
            if (this._children != null) {
                Vector vector = (Vector)this._children.clone();
                object = vector.elements();
                while (object.hasMoreElements()) {
                    LWWindow lWWindow = (LWWindow)object.nextElement();
                    if (lWWindow.getDesktop() == null || lWWindow.close()) continue;
                    return false;
                }
            }
            if (this.isActive() && !this.setActive(false)) {
                return false;
            }
            boolean bl = this.isModal();
            if (bl) {
                object = this.getTreeLock();
                synchronized (object) {
                    this._removeModalWindow(desktop);
                    this._removeMouseGrab();
                }
            }
            desktop.removeWindow(this);
            if (bl) {
                object = this.getTreeLock();
                synchronized (object) {
                    this.getTreeLock().notifyAll();
                }
            }
            this.fireBooleanPropertyChanged(PROPERTY_CLOSED, true);
        }
        return true;
    }

    public final void dispose() {
        this.close();
    }

    public Component getContent() {
        return this._content;
    }

    public Desktop getDesktop() {
        return this._desktop;
    }

    public Component getFocusOwner() {
        Component component;
        if (!this.isActive()) {
            return null;
        }
        Window window = WindowUtils.getWindow(this);
        if (window == null) {
            return null;
        }
        for (Component component2 = component = WindowUtils.getFocusOwner(window); component2 != null; component2 = component2.getParent()) {
            if (component2 != this) continue;
            return component;
        }
        return null;
    }

    public Image getFrameIcon() {
        return this._frameIcon;
    }

    public LWWindow getLeader() {
        return this._leader;
    }

    public LWMenuBar getMenuBar() {
        return this._menuBar;
    }

    public ModalStyle getModalStyle() {
        return this._modalStyle;
    }

    public String getTitle() {
        return this._title;
    }

    public WindowType getType() {
        return this._type;
    }

    @Override
    public boolean isActive() {
        if (this.getType() == WindowType.PALETTE) {
            return true;
        }
        return this._active;
    }

    public boolean isClosable() {
        return this._closable;
    }

    public boolean isMaximizable() {
        return this._maximizable;
    }

    public boolean isMaximized() {
        return this._maximized;
    }

    public boolean isMinimizable() {
        return this._minimizable;
    }

    public boolean isMinimized() {
        return this._minimized;
    }

    public boolean isModal() {
        return this._modal;
    }

    public boolean isMovable() {
        return this._movable;
    }

    public boolean isReshaping() {
        return this._reshaping;
    }

    public boolean isResizable() {
        return this._resizable;
    }

    public void pack() {
        if (this.isDisplayable()) {
            this.setSize(this.getPreferredSize());
            this.validate();
        }
    }

    @Override
    public void removeKeyFilter(KeyListener keyListener) {
        if (this._filterSupport != null) {
            this._filterSupport.removeKeyFilter(keyListener);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._propSupport != null) {
            this._propSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (this._vetoSupport != null) {
            this._vetoSupport.removeVetoableChangeListener(vetoableChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setActive(boolean bl) {
        if (this.getType() == WindowType.PALETTE) {
            return true;
        }
        if (bl != this.isActive()) {
            if (!(!bl || this.isVisible() && this.isEnabled() && this._isModalDescendent())) {
                return false;
            }
            try {
                this.fireBooleanVetoableChanged(PROPERTY_ACTIVE, bl);
            }
            catch (PropertyVetoException propertyVetoException) {
                return false;
            }
            Desktop desktop = this.getDesktop();
            if (desktop == null) {
                this._active = bl;
                return true;
            }
            ImmediatePainter immediatePainter = this._getImmediatePainter();
            immediatePainter.freezeRepaints();
            try {
                WindowManager windowManager = desktop.getWindowManager();
                if (bl) {
                    if (!windowManager.activateWindow(this)) {
                        boolean bl2 = false;
                        return bl2;
                    }
                    this._fireAccessibleActiveEvent(bl);
                    this._moveToFront(false);
                } else {
                    windowManager.deactivateWindow(this);
                    this._fireAccessibleActiveEvent(bl);
                    this._setFocusOwner(this.getFocusOwner());
                }
                this._active = bl;
                if (!bl) {
                    this._transferFocusToDesktop(desktop);
                }
                this.fireBooleanPropertyChanged(PROPERTY_ACTIVE, bl);
                if (bl) {
                    this._restoreFocus();
                }
                this._paintImmediate();
            }
            finally {
                immediatePainter.unfreezeRepaints();
            }
        }
        return true;
    }

    public void setClosable(boolean bl) {
        if (bl != this._closable) {
            this._closable = bl;
            this.fireBooleanPropertyChanged(PROPERTY_CLOSABLE, bl);
        }
    }

    public void setContent(Component component) {
        if (component != this._content) {
            Component component2 = this._content;
            AccessibleContext accessibleContext = this.accessAccessibleContext();
            if (accessibleContext != null && component2 instanceof Accessible) {
                ((Accessible)((Object)component2)).getAccessibleContext().setAccessibleParent(null);
                accessibleContext.firePropertyChange("AccessibleChild", component2, null);
            }
            this._content = component;
            this.firePropertyChange(PROPERTY_CONTENT, component2, component);
            if (accessibleContext != null && component instanceof Accessible) {
                ((Accessible)((Object)component)).getAccessibleContext().setAccessibleParent(this);
                accessibleContext.firePropertyChange("AccessibleChild", null, component);
            }
        }
    }

    public void setFrameIcon(Image image) {
        if (this._frameIcon != image) {
            Image image2 = this._frameIcon;
            this._frameIcon = image;
            this.firePropertyChange(PROPERTY_FRAME_ICON, image2, image);
        }
    }

    public void setLeader(LWWindow lWWindow) {
        if (lWWindow != this._leader) {
            LWWindow lWWindow2 = this._leader;
            if (lWWindow2 != null) {
                lWWindow2._removeChildWindow(this);
            }
            this._leader = lWWindow;
            if (lWWindow != null) {
                lWWindow._addChildWindow(this);
            }
            this.firePropertyChange(PROPERTY_LEADER, lWWindow2, lWWindow);
            if (lWWindow2 == null || lWWindow == null) {
                this.moveToFront();
            }
        }
    }

    public void setMaximizable(boolean bl) {
        if (bl != this._maximizable) {
            this._maximizable = bl;
            this.fireBooleanPropertyChanged(PROPERTY_MAXIMIZABLE, bl);
        }
    }

    public void setMaximized(boolean bl) {
        if (this.isMaximizable() && bl != this._maximized) {
            Desktop desktop = this.getDesktop();
            WindowManager windowManager = desktop.getWindowManager();
            this.setMinimized(false);
            this._maximized = bl;
            if (bl) {
                windowManager.maximizeWindow(this);
            } else {
                windowManager.restoreMaximizedWindow(this);
            }
            this.fireBooleanPropertyChanged(PROPERTY_MAXIMIZED, bl);
            if (this._maximized && this._children != null) {
                Vector vector = (Vector)this._children.clone();
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    LWWindow lWWindow = (LWWindow)enumeration.nextElement();
                    if (lWWindow.getDesktop() == null || !lWWindow.isMinimized()) continue;
                    lWWindow.setMinimized(false);
                }
            }
        }
    }

    public void setMenuBar(LWMenuBar lWMenuBar) {
        if (this._menuBar != lWMenuBar) {
            AccessibleContext accessibleContext = this.accessAccessibleContext();
            LWMenuBar lWMenuBar2 = this._menuBar;
            if (accessibleContext != null && lWMenuBar2 != null) {
                lWMenuBar2.getAccessibleContext().setAccessibleParent(null);
                accessibleContext.firePropertyChange("AccessibleChild", lWMenuBar2, null);
            }
            this._menuBar = lWMenuBar;
            this.firePropertyChange(PROPERTY_MENUBAR, lWMenuBar2, lWMenuBar);
            if (accessibleContext != null && lWMenuBar != null) {
                lWMenuBar.getAccessibleContext().setAccessibleParent(this);
                accessibleContext.firePropertyChange("AccessibleChild", null, lWMenuBar);
            }
        }
    }

    public void setMinimizable(boolean bl) {
        if (bl != this._minimizable) {
            this._minimizable = bl;
            this.fireBooleanPropertyChanged(PROPERTY_MINIMIZABLE, bl);
        }
    }

    public void setMinimized(boolean bl) {
        if (bl != this._minimized) {
            Object object;
            Desktop desktop = this.getDesktop();
            WindowManager windowManager = desktop.getWindowManager();
            boolean bl2 = this.isActive();
            this.setMaximized(false);
            if (this.isActive()) {
                if (bl && (object = this.getFocusOwner()) != null) {
                    this._setFocusOwner((Component)object);
                    this._transferFocusToDesktop(desktop);
                }
                this._minimized = bl;
            } else {
                this._minimized = bl;
            }
            if (bl) {
                windowManager.minimizeWindow(this);
            } else {
                windowManager.restoreMinimizedWindow(this);
                this._restoreFocus();
            }
            this.fireBooleanPropertyChanged(PROPERTY_MINIMIZED, bl);
            if (this._children != null) {
                object = (Vector)this._children.clone();
                Enumeration enumeration = ((Vector)object).elements();
                while (enumeration.hasMoreElements()) {
                    LWWindow lWWindow = (LWWindow)enumeration.nextElement();
                    if (lWWindow.getDesktop() == null || bl && !lWWindow.isVisible()) continue;
                    lWWindow.setMinimized(bl);
                }
            }
            if ((object = this.accessAccessibleContext()) != null) {
                if (bl) {
                    ((AccessibleContext)object).firePropertyChange("AccessibleState", null, AccessibleState.ICONIFIED);
                } else {
                    ((AccessibleContext)object).firePropertyChange("AccessibleState", AccessibleState.ICONIFIED, null);
                }
            }
        }
    }

    public void setModal(boolean bl) {
        if (this.getDesktop() != null && this.isVisible()) {
            throw new IllegalStateException();
        }
        if (bl != this._modal) {
            this._modal = bl;
            this.fireBooleanPropertyChanged(PROPERTY_MODAL, bl);
            this.moveToFront();
        }
    }

    public void setModalStyle(ModalStyle modalStyle) {
        if (modalStyle != this._modalStyle) {
            ModalStyle modalStyle2 = this._modalStyle;
            this._modalStyle = modalStyle;
            this.firePropertyChange(PROPERTY_MODAL_STYLE, modalStyle2, modalStyle);
        }
    }

    public void setMovable(boolean bl) {
        if (bl != this._movable) {
            this._movable = bl;
            this.fireBooleanPropertyChanged(PROPERTY_MOVABLE, bl);
        }
    }

    public void setReshaping(boolean bl) {
        if (bl != this._reshaping) {
            this._reshaping = bl;
            this.fireBooleanPropertyChanged(PROPERTY_RESHAPING, bl);
        }
    }

    public void setResizable(boolean bl) {
        if (bl != this._resizable) {
            this._resizable = bl;
            this.fireBooleanPropertyChanged(PROPERTY_RESIZABLE, bl);
            AccessibleContext accessibleContext = this.accessAccessibleContext();
            if (accessibleContext != null) {
                if (bl) {
                    accessibleContext.firePropertyChange("AccessibleState", null, AccessibleState.RESIZABLE);
                } else {
                    accessibleContext.firePropertyChange("AccessibleState", AccessibleState.RESIZABLE, null);
                }
            }
        }
    }

    public void setTitle(String string) {
        if (this._title != string) {
            AccessibleContext accessibleContext = this.accessAccessibleContext();
            String string2 = accessibleContext == null ? null : accessibleContext.getAccessibleName();
            String string3 = this._title;
            this._title = string;
            this.firePropertyChange(PROPERTY_TITLE, string3, string);
            if (accessibleContext != null) {
                accessibleContext.firePropertyChange("AccessibleVisibleData", string3, string);
                String string4 = accessibleContext.getAccessibleName();
                if (string4 != string2) {
                    accessibleContext.firePropertyChange("AccessibleName", string2, string4);
                }
            }
        }
    }

    public void setType(WindowType windowType) {
        if (windowType != this._type) {
            WindowType windowType2 = this._type;
            this._type = windowType;
            this._type.setDefaults(this);
            this.firePropertyChange(PROPERTY_TYPE, windowType2, windowType);
            this.moveToFront();
        }
    }

    @Override
    public final void setVisible(boolean bl) {
        this.setVisible(bl, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVisible(boolean bl, boolean bl2) {
        if (this.isVisible() != bl) {
            Desktop desktop = this.getDesktop();
            this.freezeRepaints();
            try {
                if (this.isActive() && !bl) {
                    this.setActive(false);
                    if (desktop != null && this.getFocusOwner() != null) {
                        this._transferFocusToDesktop(desktop);
                    }
                    this.paintImmediate();
                }
                super.setVisible(bl);
                if (bl) {
                    this.validate();
                    if (bl2 && desktop != null) {
                        this.setActive(true);
                    }
                    this.paintImmediate();
                }
            }
            finally {
                this.unfreezeRepaints();
            }
            Object object = this.getTreeLock();
            synchronized (object) {
                if (this.isModal() && desktop != null) {
                    if (!bl) {
                        this.getTreeLock().notifyAll();
                    } else {
                        this._addModalWindow(desktop);
                        this._addMouseGrab();
                        try {
                            while (this.getDesktop() != null && this.isVisible()) {
                                this.getTreeLock().wait();
                            }
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        finally {
                            this._removeMouseGrab();
                            this._removeModalWindow(this.getDesktop());
                        }
                    }
                }
            }
        }
    }

    public void setDesktop(Desktop desktop) {
        if (this._desktop != desktop) {
            if (desktop == null && this.isActive()) {
                this.setActive(false);
            }
            Desktop desktop2 = this._desktop;
            this._desktop = desktop;
            this.firePropertyChange(PROPERTY_DESKTOP, desktop2, desktop);
        }
    }

    public void moveToBack() {
        Desktop desktop = this.getDesktop();
        desktop.setWindowPosition(this, desktop.getWindowCount() - 1);
    }

    public final void moveToFront() {
        this._moveToFront(true);
    }

    @Override
    public void setRootFocusOwner(Component component) {
        this._focusOwner = component;
    }

    @Override
    public Component getRootFocusOwner() {
        return this._focusOwner;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.isVisible()) {
            this._clearVisibleRegions();
        }
    }

    @Override
    public void disable() {
        if (this.isEnabled()) {
            this.setActive(false);
            super.disable();
            this.fireBooleanPropertyChanged(PROPERTY_ENABLED, false);
        }
    }

    @Override
    public void enable() {
        if (!this.isEnabled()) {
            super.enable();
            this.fireBooleanPropertyChanged(PROPERTY_ENABLED, true);
        }
    }

    @Override
    public void hide() {
        if (this.isVisible()) {
            this._clearVisibleRegions();
            super.hide();
        }
    }

    @Override
    public boolean isShowing() {
        if (this._ignoreRepaints) {
            return false;
        }
        return super.isShowing();
    }

    @Override
    public void paint(Graphics graphics) {
        Region region = this._getVisibleRegion();
        Rectangle rectangle = graphics.getClipBounds();
        if (region != null && (rectangle == null || region.intersects(rectangle.x, rectangle.y, rectangle.width, rectangle.height))) {
            super.paint(graphics);
        }
    }

    @Override
    public void postProcessKey(KeyEvent keyEvent) {
        ModalStyle modalStyle;
        super.postProcessKey(keyEvent);
        if (!keyEvent.isConsumed() && this.isModal() && (modalStyle = this.getModalStyle()) != null && modalStyle.grabKeyEvent(this, keyEvent) && (keyEvent.getID() != 401 || !LocaleUtils.isDeadKey(keyEvent))) {
            keyEvent.consume();
        }
    }

    @Override
    public void removeNotify() {
        if (this.isVisible()) {
            this._clearVisibleRegions();
        }
        super.removeNotify();
    }

    @Override
    public void repaint(long l, int n, int n2, int n3, int n4) {
        if (!this._raising && !this._ignoreRepaints) {
            super.repaint(l, n, n2, n3, n4);
        }
    }

    @Override
    public void reshape(int n, int n2, int n3, int n4) {
        Container container = this.getParent();
        Rectangle rectangle = this.getBounds();
        if (n != rectangle.x || n2 != rectangle.y || n3 != rectangle.width || n4 != rectangle.height) {
            boolean bl = this.isShowing();
            if (bl) {
                this._clearVisibleRegions();
            }
            Rectangle[] rectangleArray = this._rectangleDifference(rectangle, new Rectangle(n, n2, n3, n4));
            if (!bl || !(container instanceof LWComponent) || rectangleArray.length > 2) {
                super.reshape(n, n2, n3, n4);
                if (bl && container != null) {
                    container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
            } else {
                this._ignoreRepaints = true;
                super.reshape(n, n2, n3, n4);
                this.validate();
                this._ignoreRepaints = false;
                boolean bl2 = this._isClippedBySibling();
                if (!bl2) {
                    this._paintImmediateBorder();
                }
                for (int i = 0; i < rectangleArray.length; ++i) {
                    Rectangle rectangle2 = rectangleArray[i];
                    ((LWComponent)container).paintImmediate(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                }
                if (!bl2) {
                    this.paintImmediateInterior();
                } else {
                    this.paintImmediate();
                }
            }
        }
    }

    @Override
    public void show() {
        if (!this.isVisible()) {
            this._clearVisibleRegions();
            super.show();
        }
    }

    @Override
    public Object getUIClassID() {
        return "WindowUI";
    }

    @Override
    protected void updateUI(Class clazz) {
        if (clazz == LWWindow.class) {
            this.updateUI();
        }
    }

    protected final void fireBooleanPropertyChanged(String string, boolean bl) {
        if (this._propSupport != null) {
            if (bl) {
                this._propSupport.firePropertyChange(string, Boolean.FALSE, Boolean.TRUE);
            } else {
                this._propSupport.firePropertyChange(string, Boolean.TRUE, Boolean.FALSE);
            }
        }
    }

    @Override
    protected final void firePropertyChange(String string, Object object, Object object2) {
        if (this._propSupport != null) {
            this._propSupport.firePropertyChange(string, object, object2);
        }
    }

    protected final void fireBooleanVetoableChanged(String string, boolean bl) throws PropertyVetoException {
        if (this._vetoSupport != null) {
            if (bl) {
                this._vetoSupport.fireVetoableChange(string, Boolean.FALSE, Boolean.TRUE);
            } else {
                this._vetoSupport.fireVetoableChange(string, Boolean.TRUE, Boolean.FALSE);
            }
        }
    }

    protected void fireVetoableChange(String string, Object object, Object object2) throws PropertyVetoException {
        if (this._vetoSupport != null) {
            this._vetoSupport.fireVetoableChange(string, object, object2);
        }
    }

    @Override
    protected void addImpl(Component component, Object object, int n) {
        if (n == 0) {
            n = 1;
        } else if (n == -1 || n >= this.getComponentCount()) {
            n = this.getComponentCount() - 1;
        }
        super.addImpl(component, object, n);
    }

    @Override
    protected AccessibleContext createAccessibleContext() {
        LWMenuBar lWMenuBar;
        Component component = this.getContent();
        if (component instanceof Accessible) {
            ((Accessible)((Object)component)).getAccessibleContext().setAccessibleParent(this);
        }
        if ((lWMenuBar = this.getMenuBar()) != null) {
            lWMenuBar.getAccessibleContext().setAccessibleParent(this);
        }
        return new Access();
    }

    void _addChildWindow(LWWindow lWWindow) {
        if (this._children == null) {
            this._children = new Vector(1, 1);
        }
        this._children.addElement(lWWindow);
    }

    Vector __getModalStack(Desktop desktop) {
        if (desktop == null) {
            return null;
        }
        return (Vector)_sModalStackTable.get(desktop);
    }

    void _removeChildWindow(LWWindow lWWindow) {
        this._children.removeElement(lWWindow);
    }

    private void _addFocusProxyComponents() {
        FocusTransferComp focusTransferComp = new FocusTransferComp(false);
        focusTransferComp.setBounds(-1, -1, 0, 0);
        super.addImpl(focusTransferComp, null, 0);
        FocusTransferComp focusTransferComp2 = new FocusTransferComp(true);
        focusTransferComp2.setBounds(-1, -1, 0, 0);
        super.addImpl(focusTransferComp2, null, -1);
    }

    private void _addModalWindow(Desktop desktop) {
        Vector<LWWindow> vector = this.__getModalStack(desktop);
        if (vector == null) {
            vector = new Vector<LWWindow>(5);
            this._setModalStack(desktop, vector);
        }
        vector.addElement(this);
    }

    private void _addMouseGrab() {
        this._mouseGrabProvider = TrackingUtils.getMouseGrabProvider(this);
        if (this._mouseGrabProvider != null) {
            this._mouseGrab = new MouseGrab();
            this._mouseGrabProvider.addMouseGrab(this._mouseGrab);
            this._mouseGrabProvider.addMouseMotionGrab(this._mouseGrab);
        }
    }

    private Rectangle _clipToParentsInner(Rectangle rectangle, Component component) {
        rectangle = new Rectangle(rectangle);
        int n = 0;
        int n2 = 0;
        do {
            Rectangle rectangle2 = component.getBounds();
            rectangle.x += rectangle2.x;
            rectangle.y += rectangle2.y;
            n += rectangle2.x;
            n2 += rectangle2.y;
            if (component instanceof Container) {
                Insets insets = ((Container)component).getInsets();
                rectangle2.x += insets.left;
                rectangle2.y += insets.top;
                rectangle2.width -= insets.left + insets.right;
                rectangle2.height -= insets.top + insets.bottom;
            }
            rectangle = rectangle.intersection(rectangle2);
        } while ((component = component.getParent()) != null && !(component instanceof Window));
        rectangle.x -= n;
        rectangle.y -= n2;
        return rectangle;
    }

    private ImmediatePainter _getImmediatePainter() {
        if (this.getLeader() == null && !this._hasVisibleChildren()) {
            return this;
        }
        Desktop desktop = this.getDesktop();
        for (Component component = desktop.getDesktopComponent(); component != null; component = component.getParent()) {
            if (!(component instanceof ImmediatePainter)) continue;
            return (ImmediatePainter)((Object)component);
        }
        return null;
    }

    Component __getFirstFocusableComponent(Component component) {
        if (component instanceof Container) {
            Container container = (Container)component;
            int n = container.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component component2 = container.getComponent(i);
                Component component3 = this.__getFirstFocusableComponent(component2);
                if (component3 == null) continue;
                return component3;
            }
        }
        return this._isFullyFocusable(component) && component.isFocusTraversable() ? component : null;
    }

    private Component _getFocusOwner() {
        return this._focusOwner;
    }

    private Component _getLastFocusableComponent(Component component) {
        if (this._isFullyFocusable(component) && component.isFocusTraversable()) {
            return component;
        }
        if (component instanceof Container) {
            Container container = (Container)component;
            for (int i = container.getComponentCount() - 1; i >= 0; --i) {
                Component component2 = container.getComponent(i);
                Component component3 = this._getLastFocusableComponent(component2);
                if (component3 == null) continue;
                return component3;
            }
        }
        return null;
    }

    private LWWindow _getTopModalWindow(Vector vector) {
        if (vector == null || vector.isEmpty()) {
            return null;
        }
        int n = vector.size();
        Object[] objectArray = new Object[n];
        vector.copyInto(objectArray);
        for (int i = n - 1; i >= 0; --i) {
            LWWindow lWWindow = (LWWindow)objectArray[i];
            if (lWWindow == null || !lWWindow.isVisible()) continue;
            return lWWindow;
        }
        return null;
    }

    private boolean _hasVisibleChildren() {
        if (this._children != null) {
            Vector vector = (Vector)this._children.clone();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                LWWindow lWWindow = (LWWindow)enumeration.nextElement();
                if (!lWWindow.isVisible() || lWWindow.getDesktop() == null) continue;
                return true;
            }
        }
        return false;
    }

    private boolean _isClippedBySibling() {
        Container container = this.getParent();
        if (container instanceof ImmediatePainter) {
            return ((ImmediatePainter)((Object)container)).isChildClipped(this);
        }
        return false;
    }

    private boolean _isFullyFocusable(Component component) {
        return component.isVisible() && component.isEnabled() && component.isShowing();
    }

    private boolean _isFocusable(Component component) {
        return component.isVisible() && component.isEnabled();
    }

    private boolean _isModalDescendent() {
        Vector vector = this.__getModalStack(this.getDesktop());
        if (vector == null) {
            return true;
        }
        LWWindow lWWindow = this._getTopModalWindow(vector);
        if (lWWindow == null) {
            return true;
        }
        for (LWWindow lWWindow2 = this; lWWindow2 != null; lWWindow2 = lWWindow2.getLeader()) {
            if (lWWindow2 != lWWindow) continue;
            return true;
        }
        return this.isModal() && vector.indexOf(this) == -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _moveToFront(boolean bl) {
        Desktop desktop = this.getDesktop();
        if (this._raising || desktop == null) {
            return;
        }
        this._raising = true;
        ImmediatePainter immediatePainter = this._getImmediatePainter();
        immediatePainter.freezeRepaints();
        try {
            LWWindow lWWindow = this.getLeader();
            if (lWWindow != null) {
                lWWindow.moveToFront();
            }
            desktop.setWindowPosition(this, 0);
            if (this._children != null) {
                Vector vector = (Vector)this._children.clone();
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    LWWindow lWWindow2 = (LWWindow)enumeration.nextElement();
                    if (lWWindow2.getDesktop() == null || !lWWindow2.isVisible()) continue;
                    lWWindow2.moveToFront();
                }
            }
            if (bl) {
                this.paintImmediate();
            }
        }
        finally {
            immediatePainter.unfreezeRepaints();
        }
        this._raising = false;
    }

    private void _paintImmediate() {
        if (this.isBorderTransparent() && !this._isClippedBySibling()) {
            this.paintImmediateInterior();
            this._paintImmediateBorder();
        } else {
            this.paintImmediate();
        }
    }

    private void _paintImmediateBorder() {
        Graphics graphics;
        if (!this.isShowing()) {
            return;
        }
        Container container = this.getParent();
        BorderPainter borderPainter = this.getBorderPainter();
        if (container != null && borderPainter != null && (graphics = container.getGraphics()) != null) {
            Rectangle rectangle = this.getBounds();
            Rectangle rectangle2 = this._clipToParentsInner(rectangle, container);
            graphics.clipRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            borderPainter.paint(this.getBorderContext(), graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.dispose();
        }
    }

    private Rectangle[] _rectangleDifference(Rectangle rectangle, Rectangle rectangle2) {
        if (!rectangle.intersects(rectangle2)) {
            return new Rectangle[]{new Rectangle(rectangle)};
        }
        int n = 0;
        Rectangle rectangle3 = null;
        Rectangle rectangle4 = null;
        Rectangle rectangle5 = null;
        Rectangle rectangle6 = null;
        int n2 = rectangle.x + rectangle.width;
        int n3 = rectangle2.x + rectangle2.width;
        int n4 = rectangle.y + rectangle.height;
        int n5 = rectangle2.y + rectangle2.height;
        if (rectangle2.y > rectangle.y) {
            rectangle3 = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle2.y - rectangle.y);
            ++n;
        }
        if (n5 < n4) {
            rectangle4 = new Rectangle(rectangle.x, n5, rectangle.width, n4 - n5);
            ++n;
        }
        int n6 = Math.max(rectangle.y, rectangle2.y);
        int n7 = Math.min(n4, n5);
        if (rectangle2.x > rectangle.x) {
            rectangle5 = new Rectangle(rectangle.x, n6, rectangle2.x - rectangle.x, n7 - n6);
            ++n;
        }
        if (n3 < n2) {
            rectangle6 = new Rectangle(n3, n6, n2 - n3, n7);
            ++n;
        }
        Rectangle[] rectangleArray = new Rectangle[n];
        n = 0;
        if (rectangle3 != null) {
            rectangleArray[n++] = rectangle3;
        }
        if (rectangle4 != null) {
            rectangleArray[n++] = rectangle4;
        }
        if (rectangle5 != null) {
            rectangleArray[n++] = rectangle5;
        }
        if (rectangle6 != null) {
            rectangleArray[n++] = rectangle6;
        }
        return rectangleArray;
    }

    private void _setFocusOwner(Component component) {
        if (component != null) {
            this._focusOwner = component;
        }
    }

    private void _removeModalWindow(Desktop desktop) {
        if (desktop == null) {
            return;
        }
        Vector vector = this.__getModalStack(desktop);
        if (vector != null) {
            vector.removeElement(this);
            if (vector.isEmpty()) {
                this._setModalStack(desktop, null);
            }
        }
    }

    private void _removeMouseGrab() {
        if (this._mouseGrabProvider != null) {
            this._mouseGrabProvider.removeMouseGrab(this._mouseGrab);
            this._mouseGrabProvider.removeMouseMotionGrab(this._mouseGrab);
            this._mouseGrab = null;
            this._mouseGrabProvider = null;
        }
    }

    private void _transferFocusToDesktop(Desktop desktop) {
        Component component = desktop.getDesktopComponent();
        component.requestFocus();
    }

    private void _restoreFocus() {
        Component component;
        if (this.getType() == WindowType.PALETTE) {
            return;
        }
        Component component2 = this.getFocusOwner();
        if (component2 != null && component2 != this) {
            return;
        }
        component2 = this._getFocusOwner();
        if (!(component2 != null && this._isFocusable(component2) || (component = this.getContent()) == null)) {
            component2 = this.__getFirstFocusableComponent(this.getContent());
        }
        if (component2 == null) {
            component2 = this;
        }
        component2.requestFocus();
    }

    private void _setModalStack(Desktop desktop, Vector vector) {
        if (vector == null) {
            _sModalStackTable.remove(desktop);
        } else {
            _sModalStackTable.put(desktop, vector);
        }
    }

    void _clearVisibleRegions() {
        Desktop desktop = this.getDesktop();
        if (desktop == null || !(desktop.getDesktopComponent() instanceof LWComponent)) {
            return;
        }
        LWComponent lWComponent = (LWComponent)desktop.getDesktopComponent();
        lWComponent.putClientProperty(_RECOMPUTE_VISIBLE_REGIONS, Boolean.TRUE);
    }

    private Region _getVisibleRegion() {
        Desktop desktop = this.getDesktop();
        if (desktop == null || !(desktop.getDesktopComponent() instanceof LWComponent)) {
            return null;
        }
        LWComponent lWComponent = (LWComponent)desktop.getDesktopComponent();
        Region region = (Region)this.getClientProperty(_VISIBLE_REGION);
        if (region == null || lWComponent.getClientProperty(_RECOMPUTE_VISIBLE_REGIONS) != null) {
            this._computeVisibleRegions();
            lWComponent.putClientProperty(_RECOMPUTE_VISIBLE_REGIONS, null);
            region = (Region)this.getClientProperty(_VISIBLE_REGION);
        }
        return region;
    }

    private void _computeVisibleRegions() {
        Desktop desktop = this.getDesktop();
        if (desktop == null || !(desktop.getDesktopComponent() instanceof LWComponent)) {
            return;
        }
        Enumeration enumeration = desktop.getWindows();
        Region region = new Region();
        while (enumeration.hasMoreElements()) {
            LWWindow lWWindow = (LWWindow)enumeration.nextElement();
            if (!lWWindow.isVisible()) continue;
            Rectangle rectangle = lWWindow.getBounds();
            Region region2 = new Region(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            region2.subtract(region);
            if (!lWWindow.isBorderTransparent()) {
                region.add(region2);
            } else {
                ImmInsets immInsets = lWWindow.getBorderInsets();
                rectangle.x += immInsets.left;
                rectangle.y += immInsets.top;
                rectangle.width -= immInsets.left + immInsets.right;
                rectangle.height -= immInsets.top + immInsets.bottom;
                Region region3 = new Region(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                region.add(region3);
            }
            region2.translate(-rectangle.x, -rectangle.y);
            lWWindow.putClientProperty(_VISIBLE_REGION, region2);
        }
    }

    private void _fireAccessibleActiveEvent(boolean bl) {
        AccessibleContext accessibleContext = this.accessAccessibleContext();
        if (accessibleContext != null) {
            if (bl) {
                accessibleContext.firePropertyChange("AccessibleState", null, AccessibleState.ACTIVE);
            } else {
                accessibleContext.firePropertyChange("AccessibleState", AccessibleState.ACTIVE, null);
            }
        }
    }

    private class Access
    extends AccessibleLWComponent
    implements AccessibleAction {
        public Access() {
            super(LWWindow.this);
        }

        @Override
        public AccessibleAction getAccessibleAction() {
            return this;
        }

        @Override
        public String getAccessibleName() {
            String string = super.getAccessibleName();
            if (string == null || "".equals(string)) {
                string = LWWindow.this.getTitle();
            }
            return string;
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.INTERNAL_FRAME;
        }

        @Override
        public Accessible getAccessibleParent() {
            if (this.accessibleParent != null) {
                return this.accessibleParent;
            }
            LWWindow lWWindow = LWWindow.this.getLeader();
            if (lWWindow != null) {
                return lWWindow;
            }
            return super.getAccessibleParent();
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (LWWindow.this.isActive()) {
                accessibleStateSet.add(AccessibleState.ACTIVE);
            }
            if (LWWindow.this.isMinimized()) {
                accessibleStateSet.add(AccessibleState.ICONIFIED);
            }
            if (LWWindow.this.isModal()) {
                accessibleStateSet.add(AccessibleState.MODAL);
            }
            if (LWWindow.this.isResizable()) {
                accessibleStateSet.add(AccessibleState.RESIZABLE);
            }
            return accessibleStateSet;
        }

        @Override
        public int getAccessibleChildrenCount() {
            int n;
            int n2 = n = LWWindow.this.getContent() instanceof Accessible ? 1 : 0;
            if (LWWindow.this.getMenuBar() != null) {
                ++n;
            }
            if (LWWindow.this._children != null) {
                n += LWWindow.this._children.size();
            }
            return n;
        }

        @Override
        public Accessible getAccessibleChild(int n) {
            Vector vector;
            LWMenuBar lWMenuBar;
            if (n < 0) {
                return null;
            }
            Component component = LWWindow.this.getContent();
            if (component instanceof Accessible) {
                if (n == 0) {
                    return (Accessible)((Object)component);
                }
                --n;
            }
            if ((lWMenuBar = LWWindow.this.getMenuBar()) != null) {
                if (n == 0) {
                    return lWMenuBar;
                }
                --n;
            }
            if ((vector = LWWindow.this._children) != null && n < vector.size()) {
                return (Accessible)vector.elementAt(n);
            }
            return null;
        }

        @Override
        public int getAccessibleActionCount() {
            int n = 0;
            if (LWWindow.this.isClosable()) {
                ++n;
            }
            if (LWWindow.this.isMaximizable()) {
                ++n;
            }
            if (LWWindow.this.isMinimizable()) {
                ++n;
            }
            return n;
        }

        @Override
        public String getAccessibleActionDescription(int n) {
            String string = null;
            if (LWWindow.this.isClosable()) {
                if (n == 0) {
                    string = "CLOSE_WINDOW";
                }
                --n;
            }
            if (LWWindow.this.isMaximizable()) {
                if (n == 0) {
                    string = "TOGGLE_MAXIMIZED";
                }
                --n;
            }
            if (LWWindow.this.isMinimizable()) {
                if (n == 0) {
                    string = "TOGGLE_MINIMIZED";
                }
                --n;
            }
            if (string != null) {
                ResourceBundle resourceBundle = ResourceBundle.getBundle(LWWindow._ACCESSIBILITY_BUNDLE, LocaleUtils.getTranslationLocale(this.getLocale()));
                return resourceBundle.getString(string);
            }
            return null;
        }

        @Override
        public boolean doAccessibleAction(int n) {
            if (LWWindow.this.isClosable()) {
                if (n == 0) {
                    LWWindow.this.close();
                    return true;
                }
                --n;
            }
            if (LWWindow.this.isMaximizable()) {
                if (n == 0) {
                    LWWindow.this.setMaximized(!LWWindow.this.isMaximized());
                    return true;
                }
                --n;
            }
            if (LWWindow.this.isMinimizable()) {
                if (n == 0) {
                    LWWindow.this.setMinimized(!LWWindow.this.isMinimized());
                    return true;
                }
                --n;
            }
            return false;
        }
    }

    private class MouseGrab
    implements MouseListener,
    MouseMotionListener {
        private MouseGrab() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.grabMouseEvent(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.grabMouseEvent(mouseEvent);
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            this.grabMouseEvent(mouseEvent);
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            this.grabMouseEvent(mouseEvent);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            this.grabMouseEvent(mouseEvent);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            this.grabMouseEvent(mouseEvent);
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            this.grabMouseEvent(mouseEvent);
        }

        public void grabMouseEvent(MouseEvent mouseEvent) {
            if (!mouseEvent.isConsumed() && LWWindow.this._modalStyle != null && LWWindow.this._modalStyle.grabMouseEvent(LWWindow.this, mouseEvent)) {
                mouseEvent.consume();
                if (mouseEvent.getID() == 501) {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        }
    }

    private class FocusTransferComp
    extends LWComponent {
        private boolean _forward;

        public FocusTransferComp(boolean bl) {
            this._forward = bl;
        }

        @Override
        public boolean isFocusTraversable() {
            return true;
        }

        @Override
        protected void processFocusEvent(FocusEvent focusEvent) {
            Component component = LWWindow.this.getRootFocusOwner();
            super.processFocusEvent(focusEvent);
            if (focusEvent.getID() == 1004) {
                Component component2 = LWWindow.this.getContent();
                Component component3 = null;
                component3 = this._forward ? LWWindow.this.__getFirstFocusableComponent(component2) : LWWindow.this._getLastFocusableComponent(component2);
                if (component3 != null) {
                    component3.requestFocus();
                } else {
                    LWWindow.this.setRootFocusOwner(component);
                    LWWindow.this._transferFocusToDesktop(LWWindow.this.getDesktop());
                }
            }
        }
    }
}

