/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.lwAWT.lwText;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.Serializable;
import java.util.Locale;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import oracle.ewt.LookAndFeel;
import oracle.ewt.UIDefaults;
import oracle.ewt.graphics.FontUtils;
import oracle.ewt.graphics.GraphicUtils;
import oracle.ewt.lwAWT.lwText.AccessibleLWTextComponent;
import oracle.ewt.lwAWT.lwText.AutoScroller;
import oracle.ewt.lwAWT.lwText.BIDIFilter;
import oracle.ewt.lwAWT.lwText.CursorUtils;
import oracle.ewt.lwAWT.lwText.LWCommonText;
import oracle.ewt.lwAWT.lwText.StaticTextPosition;
import oracle.ewt.lwAWT.lwText.TabbedFontMetrics;
import oracle.ewt.lwAWT.lwText.TextPosition;
import oracle.ewt.lwAWT.lwText.displayFilter.ChainDisplayFilter;
import oracle.ewt.lwAWT.lwText.displayFilter.DisplayStringFilter;
import oracle.ewt.lwAWT.lwText.displayFilter.IdentityDisplayFilter;
import oracle.ewt.lwAWT.lwText.displayFilter.Range;
import oracle.ewt.util.FocusUtils;
import oracle.ewt.util.InputEventUtils;
import oracle.ewt.util.LocaleUtils;
import oracle.ewt.util.StringUtils;

public class LWTextField
extends LWCommonText {
    public static final int ALIGNMENT_DEFAULT = 0;
    public static final int ALIGNMENT_LEFT = 1;
    public static final int ALIGNMENT_RIGHT = 2;
    public static final int ALIGNMENT_CENTER = 3;
    private static final int _DRAW_INSERTION_HACK = 0;
    private static final int _DEFAULT_TAB_STOP = 4;
    private static final int _MARGIN_LEFT = 1;
    private static final int _MARGIN_RIGHT = 1;
    private static final int _MARGIN_TOP = 1;
    private static final int _MARGIN_BOTTOM = 1;
    private static final int _MINSIZE_COLUMNS = 10;
    private static int _sInstanceCounter = 0;
    private String _text;
    private boolean _mouseDown;
    private boolean _bidiEnabled;
    private ActionListener _actionListener;
    private DisplayStringFilter _displayFilter;
    private boolean _mightDrag;
    private int _scrollPos = -1;
    private boolean _noSelectionOnNextFocus = false;
    private static boolean _sIsLeftJustified = false;
    private int _tabStop;
    private FontMetrics _metrics;

    public LWTextField() {
        this("");
    }

    public LWTextField(String string) {
        this._init(string);
    }

    public LWTextField(int n) {
        this("", n);
    }

    public LWTextField(String string, int n) {
        super(n);
        this._init(string);
    }

    @Override
    public Object getUIClassID() {
        return "TextFieldUI";
    }

    public void setDisplayStringFilter(DisplayStringFilter displayStringFilter) {
        if (displayStringFilter == null) {
            displayStringFilter = IdentityDisplayFilter.getDisplayStringFilter();
        }
        if (this._bidiEnabled) {
            DisplayStringFilter displayStringFilter2 = ((ChainDisplayFilter)this._displayFilter).getOuterFilter();
            displayStringFilter = new ChainDisplayFilter(displayStringFilter, displayStringFilter2);
        }
        if (this._displayFilter != displayStringFilter) {
            this._displayFilter = displayStringFilter;
            this.repaint(10L);
        }
    }

    public DisplayStringFilter getDisplayStringFilter() {
        return this._displayFilter;
    }

    public void addActionListener(ActionListener actionListener) {
        this._actionListener = AWTEventMulticaster.add(this._actionListener, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this._actionListener = AWTEventMulticaster.remove(this._actionListener, actionListener);
    }

    @Override
    public void setText(String string) {
        super.setText(string);
        this._scrollPos = this._getFirstFocusPosition();
        this._checkScroll();
    }

    @Override
    public String getText() {
        return this._text;
    }

    @Override
    public Dimension getPreferredSize() {
        return this._columnsToSize(this.getColumns());
    }

    @Override
    public Dimension getMinimumSize() {
        int n = this.getColumns();
        int n2 = n <= 10 ? n : 10;
        return this._columnsToSize(n2);
    }

    @Override
    public void removeNotify() {
        AutoScroller.getAutoScroller().cancel(this);
        super.removeNotify();
    }

    @Override
    public void setCanvasSize(int n, int n2) {
        super.setCanvasSize(n, n2);
        this._checkScroll();
    }

    @Override
    public void setAlignment(int n) {
        super.setAlignment(n);
        this._scrollPos = this._getFirstFocusPosition();
        this._checkScroll();
    }

    public static final void setTextAlwaysLeftAligned(boolean bl) {
        _sIsLeftJustified = bl;
    }

    public static final boolean isTextAlwaysLeftAligned() {
        return _sIsLeftJustified;
    }

    @Override
    protected void updateLocale(Locale locale, Locale locale2) {
        super.updateLocale(locale, locale2);
        this._updateBIDI(false);
    }

    @Override
    protected void updateReadingDirection(int n) {
        super.updateReadingDirection(n);
        this._updateBIDI(n == 2);
    }

    protected void processActionEvent(ActionEvent actionEvent) {
        if (this._actionListener != null) {
            this._actionListener.actionPerformed(actionEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processFocusEvent(FocusEvent focusEvent) {
        this.freezeRepaints();
        try {
            int n;
            Point point;
            super.processFocusEvent(focusEvent);
            if (!this.hasWindowFocus() && (point = this.scrollSelectionIntoView(this.getPosition(n = this._getFirstFocusPosition()))) != null) {
                this.setCanvasOrigin(point.x, point.y);
            }
            if (FocusUtils.areNewFocusAPIsAvailable()) {
                if (focusEvent.getID() == 1004) {
                    if (!this._noSelectionOnNextFocus) {
                        this._selectAll();
                    }
                    this._noSelectionOnNextFocus = false;
                } else if (focusEvent.getID() == 1005 && focusEvent.isTemporary()) {
                    this._noSelectionOnNextFocus = true;
                }
            }
        }
        finally {
            this.unfreezeRepaints();
        }
    }

    @Override
    protected void processEventImpl(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)aWTEvent);
        } else {
            super.processEventImpl(aWTEvent);
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
        if (!mouseEvent.isConsumed() && InputEventUtils.isLeftMouseButton(mouseEvent)) {
            int n = mouseEvent.getX() - this.getInnerOrigin().x;
            switch (mouseEvent.getID()) {
                case 501: {
                    int n2;
                    int n3;
                    if (!this.getInnerBounds().contains(mouseEvent.getX(), mouseEvent.getY()) || mouseEvent.getClickCount() != 1) break;
                    TextPosition textPosition = this.getPosition(this.canvasPixelToSelectionIndex(n));
                    if (this.getEWTDropTarget() != null && (n3 = this.getSelectionStart()) != (n2 = this.getSelectionEnd()) && textPosition.getIndex() >= n3 && textPosition.getIndex() <= n2) {
                        this._mightDrag = true;
                    }
                    if (!this._mightDrag) {
                        if (mouseEvent.isShiftDown()) {
                            this.growSelection(textPosition);
                        } else {
                            this.setCaretPosition(textPosition);
                        }
                        this._mouseDown = true;
                    }
                    if (!this.hasWindowFocus() && FocusUtils.areNewFocusAPIsAvailable()) {
                        this._noSelectionOnNextFocus = true;
                    }
                    this.requestFocus();
                    break;
                }
                case 500: {
                    int n4 = mouseEvent.getClickCount();
                    if (n4 <= 1) break;
                    if (n4 == 2) {
                        this._selectWord(this.canvasPixelToSelectionIndex(n));
                    } else {
                        this._selectAll();
                    }
                    this._mightDrag = false;
                    break;
                }
                case 502: {
                    AutoScroller.getAutoScroller().cancel();
                    this._mouseDown = false;
                    if (!this._mightDrag) break;
                    TextPosition textPosition = this.getPosition(this.canvasPixelToSelectionIndex(n));
                    if (mouseEvent.isShiftDown()) {
                        this.growSelection(textPosition);
                    } else {
                        this.setCaretPosition(textPosition);
                    }
                    this._mightDrag = false;
                }
            }
        }
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        super.processMouseMotionEvent(mouseEvent);
        if (!mouseEvent.isConsumed() && this._mouseDown && mouseEvent.getID() == 506 && this.getDropPosition() == null) {
            int n;
            AutoScroller autoScroller = AutoScroller.getAutoScroller();
            int n2 = FontUtils.getAverageWidth(this.getFont());
            int n3 = mouseEvent.getX() - this.getInnerOrigin().x;
            if (n3 < n2 || n3 > this.getInnerWidth() - n2) {
                n = n2 + (n2 - 1);
                n = n3 < n2 ? -n : (n -= this.getInnerWidth());
                autoScroller.schedule(this, (n3 + n) / n2);
            } else {
                autoScroller.cancel();
            }
            n = this.canvasPixelToSelectionIndex(n3);
            this.growSelection(this.getPosition(n));
        }
    }

    @Override
    protected void processKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
        if (keyEvent.isAltDown()) {
            return;
        }
        if (!keyEvent.isConsumed()) {
            int n = keyEvent.getID();
            boolean bl = n == 401;
            boolean bl2 = n == 400;
            boolean bl3 = true;
            int n2 = keyEvent.getKeyCode();
            switch (n2) {
                case 10: {
                    if (bl) {
                        this.processEvent(new ActionEvent(this, 1001, ""));
                    }
                    bl3 = false;
                    break;
                }
                case 35: 
                case 36: {
                    if (!bl) break;
                    int n3 = n2 == 36 ? 0 : this.getTextLength();
                    this._moveCursorAbsolute(this.getPosition(n3), keyEvent.isShiftDown());
                    break;
                }
                default: {
                    bl3 = false;
                }
            }
            if (bl2 && keyEvent.getKeyChar() == '\t' && this.isEditable()) {
                this._selectAll();
                bl3 = true;
            }
            if (bl3) {
                keyEvent.consume();
            }
        }
    }

    public int getTabStop() {
        return this._tabStop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTabStop(int n) {
        LWTextField lWTextField = this;
        synchronized (lWTextField) {
            if (this._tabStop == n) {
                return;
            }
            this._tabStop = n;
        }
        this._metrics = null;
        this.repaintInterior();
    }

    @Override
    TextPosition canvasToPosition(int n, int n2) {
        return this.getPosition(this.canvasPixelToSelectionIndex(n));
    }

    @Override
    protected String getDefaultName() {
        return this.getBaseClassName() + _sInstanceCounter++;
    }

    @Override
    protected Dimension layoutCanvas() {
        return new Dimension(this._calculateCanvasWidth(), this.getInnerHeight());
    }

    @Override
    protected void paintCanvasInterior(Graphics graphics) {
        boolean bl = this._isOKToDrawSelection;
        Font font = this.getFont();
        if (font != null) {
            TextPosition textPosition;
            FontMetrics fontMetrics = this._getFontMetrics();
            int n = this._getDrawingAdjustment();
            int n2 = (this.getInnerHeight() - fontMetrics.getHeight()) / 2;
            String string = this._getDisplayString();
            Color color = null;
            if (!this.isEnabled()) {
                color = graphics.getColor();
                graphics.setColor(this.__getDisabledTextColor());
            }
            if ((textPosition = this.getDropPosition()) != null) {
                this._paintSelection(graphics, n, n2, textPosition.getIndex(), textPosition.getIndex(), true);
            }
            if (string != null) {
                this._doDrawTabbedString(graphics, fontMetrics, string, 0, n, n2 + fontMetrics.getAscent());
                if (bl && this.hasWindowFocus()) {
                    this._paintSelection(graphics, n, n2, this.getSelectionStart(), this.getSelectionEnd(), this.hasGlobalFocus());
                }
            }
            if (color != null) {
                graphics.setColor(color);
            }
        }
    }

    @Override
    protected AccessibleContext createAccessibleContext() {
        return new Access();
    }

    @Override
    protected String paramString() {
        String string = super.paramString();
        DisplayStringFilter displayStringFilter = this.getDisplayStringFilter();
        if (displayStringFilter != null && displayStringFilter != this && displayStringFilter != IdentityDisplayFilter.getDisplayStringFilter()) {
            string = string + ", " + displayStringFilter.toString();
        }
        return string;
    }

    @Override
    String getPasteString(Transferable transferable) throws UnsupportedFlavorException, IOException {
        int n;
        String string = super.getPasteString(transferable);
        if (string != null && (n = string.indexOf(10)) != -1) {
            string = string.substring(0, n);
        }
        return string;
    }

    @Override
    boolean _isBIDIEnabled() {
        return this._bidiEnabled;
    }

    int canvasPixelToSelectionIndex(int n) {
        String string = this.getText();
        DisplayStringFilter displayStringFilter = this.getDisplayStringFilter();
        int n2 = LWTextField._pixelToIndex(displayStringFilter.convertString(string), this._getFontMetrics(), this._canvasPixelToStringPixel(n));
        if (this._bidiEnabled && this._canvasPixelToStringPixel(n) <= 0) {
            n2 = -1;
        }
        return displayStringFilter.displayIndexToValueIndex(string, n2);
    }

    @Override
    int findWordBoundary(int n, boolean bl) {
        DisplayStringFilter displayStringFilter = this.getDisplayStringFilter();
        String string = this.getText();
        String string2 = displayStringFilter.convertString(string);
        int n2 = displayStringFilter.valueIndexToDisplayIndex(string, n);
        char[] cArray = string2.toCharArray();
        if (!bl) {
            int n3 = LWTextField.findWordStart(cArray, n2);
            if (n3 == n2 && n3 > 0) {
                n3 = LWTextField.findWordStart(cArray, LWTextField.prevValidCursorIndex(cArray, n2));
            }
            n3 = displayStringFilter.displayIndexToValueIndex(string, n3);
            return n3;
        }
        int n4 = LWTextField.findWordEnd(cArray, n2);
        if (n4 == n2 && n4 < cArray.length) {
            n4 = LWTextField.findWordEnd(cArray, LWTextField.nextValidCursorIndex(cArray, n2));
        }
        n4 = displayStringFilter.displayIndexToValueIndex(string, n4);
        return n4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean deleteText(boolean bl) {
        Serializable serializable;
        TextPosition textPosition = null;
        boolean bl2 = false;
        if (super.deleteText(bl)) {
            serializable = this;
            synchronized (serializable) {
                int n = this.getTextLength();
                int n2 = this.getSelectionStart();
                boolean bl3 = true;
                if (bl) {
                    if (n2 <= 0) {
                        bl3 = false;
                    } else {
                        n2 = this.prevValidCursorIndex(n2);
                    }
                } else if (n2 >= n) {
                    bl3 = false;
                } else {
                    n2 = this.nextValidCursorIndex(n2);
                }
                bl2 = true;
                if (bl3) {
                    textPosition = this.getPosition(n2);
                }
            }
        }
        if (textPosition != null && (serializable = this.scrollSelectionIntoView(textPosition)) != null) {
            this.setCanvasOrigin(((Point)serializable).x, ((Point)serializable).y);
        }
        return bl2;
    }

    @Override
    char translateKeyChar(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\r': {
                return StringUtils.CHAR_UNDEFINED;
            }
        }
        return super.translateKeyChar(c);
    }

    @Override
    TextPosition getPosition(int n) {
        if (n == 0) {
            return StaticTextPosition.getZeroPosition();
        }
        return new StaticTextPosition(n);
    }

    @Override
    Point scrollSelectionIntoView(TextPosition textPosition) {
        int n = textPosition.getIndex();
        Font font = this.getFont();
        if (font != null) {
            boolean bl;
            String string = this.getText();
            DisplayStringFilter displayStringFilter = this.getDisplayStringFilter();
            String string2 = displayStringFilter.convertString(string);
            int n2 = displayStringFilter.valueIndexToDisplayIndex(string, n);
            if (n2 <= string2.length() - 1 && this.getActualAlignment() == 2 && n2 > 1) {
                ++n2;
            }
            FontMetrics fontMetrics = this._getFontMetrics();
            int n3 = n2 != 0 ? fontMetrics.stringWidth(string2.substring(0, n2)) : 0;
            int n4 = this._stringPixelToCanvasPixel(n3);
            int n5 = n4 - 1;
            int n6 = this.getInnerWidth() - 1 - 1;
            if (n6 <= 0) {
                return null;
            }
            int n7 = this.getCanvasOriginX();
            boolean bl2 = bl = n5 < 0;
            if (!bl) {
                boolean bl3 = bl = (n5 -= n6) > 0;
                if (!bl && n7 != 0) {
                    bl = (n5 += fontMetrics.stringWidth(string2.substring(n2))) < 0;
                }
            } else {
                int n8 = n6 - fontMetrics.stringWidth(string2.substring(n2));
                if (n8 > 0) {
                    n5 -= n8;
                }
            }
            if (bl) {
                if ((n7 -= n5) > 0) {
                    n7 = 0;
                }
                return new Point(n7, 0);
            }
        }
        return null;
    }

    @Override
    Rectangle replaceRangeValue(String string, int n, int n2) {
        int n3;
        if (!this._bidiEnabled && StringUtils.containsRightToLeft(string)) {
            this._updateBIDI(true);
        }
        String string2 = this._text;
        int n4 = string2.length();
        if (n == 0 && n2 == n4) {
            this._text = string;
        } else {
            n3 = string.length();
            StringBuffer stringBuffer = new StringBuffer(n4 - n2 + n + n3);
            if (n != 0) {
                stringBuffer.append(string2.substring(0, n));
            }
            if (n3 != 0) {
                stringBuffer.append(string);
            }
            if (n2 != n4) {
                stringBuffer.append(string2.substring(n2));
            }
            this._text = stringBuffer.toString();
        }
        n3 = this._calculateCanvasWidth();
        int n5 = this.getInnerHeight();
        this.setCanvasSize(n3, n5);
        return new Rectangle(0, 0, n3, n5);
    }

    @Override
    Rectangle getSelectionBounds(TextPosition textPosition, TextPosition textPosition2) {
        return new Rectangle(0, 0, this.getCanvasWidth(), this.getCanvasHeight());
    }

    private void _selectAll() {
        int n = this._getFirstFocusPosition();
        TextPosition textPosition = this.getPosition(n);
        TextPosition textPosition2 = this.getPosition(0);
        TextPosition textPosition3 = this.getPosition(this.getTextLength());
        this.select(textPosition2, textPosition3, textPosition);
    }

    private void _checkScroll() {
        if (this.getFont() != null && this.getInnerWidth() > 0 && this.getCanvasWidth() > 0 && this._scrollPos != -1) {
            Point point = this.scrollSelectionIntoView(this.getPosition(this._scrollPos));
            if (point != null) {
                this.setCanvasOrigin(point.x, point.y);
            }
            this._scrollPos = -1;
        }
    }

    private int _getFirstFocusPosition() {
        int n;
        if (this._bidiEnabled) {
            this._getDisplayString();
            ChainDisplayFilter chainDisplayFilter = (ChainDisplayFilter)this._displayFilter;
            BIDIFilter bIDIFilter = (BIDIFilter)chainDisplayFilter.getOuterFilter();
            int n2 = bIDIFilter.__getFirstR2LChar();
            if (n2 < 0) {
                return 0;
            }
            return n2 - 2;
        }
        if (this.getActualAlignment() == 2 && !LWTextField.isTextAlwaysLeftAligned() && this.getText() != null && (n = this.getText().length()) > 0) {
            return n - 1;
        }
        return 0;
    }

    private int _getAlignmentOffset() {
        int n = 0;
        int n2 = this.getActualAlignment();
        if (n2 != 1) {
            String string = this._getDisplayString();
            int n3 = string != null ? this._getFontMetrics().stringWidth(string) : 0;
            n = this.getInnerWidth() - 1 - 1 - n3;
            if (n2 == 3) {
                n >>= 1;
            }
            if (n < 0) {
                n = 0;
            }
        }
        return n;
    }

    private int _canvasPixelToStringPixel(int n) {
        return n - 1 - this.getCanvasOriginX() - this._getAlignmentOffset();
    }

    private int _getDrawingAdjustment() {
        return 1 + this._getAlignmentOffset();
    }

    private int _stringPixelToCanvasPixel(int n) {
        return n + this.getCanvasOriginX() + this._getDrawingAdjustment();
    }

    private static int _pixelToIndex(String string, FontMetrics fontMetrics, int n) {
        int n2;
        int n3;
        if (n <= 0 || string == null) {
            return 0;
        }
        char[] cArray = string.toCharArray();
        int n4 = FontUtils.getAverageWidth(fontMetrics);
        int n5 = n / n4;
        if (n5 > (n3 = cArray.length)) {
            n5 = n3;
        }
        if (n5 < n3) {
            n5 = LWTextField.prevValidCursorIndex(cArray, n5 + 1);
        }
        if ((n2 = fontMetrics.charsWidth(cArray, 0, n5)) < n) {
            while (n5 < n3) {
                int n6 = LWTextField.nextValidCursorIndex(cArray, n5);
                int n7 = fontMetrics.charsWidth(cArray, n5, n6 - n5);
                if ((n2 += n7) > n) {
                    if (n + (n7 >> 1) > n2) {
                        n5 = n6;
                    }
                    break;
                }
                n5 = n6;
            }
        } else {
            int n8 = 0;
            while (n2 > n && n5 > 0) {
                int n9 = LWTextField.prevValidCursorIndex(cArray, n5);
                n8 = fontMetrics.charsWidth(cArray, n9, n5 - n9);
                n2 -= n8;
                n5 = n9;
            }
            if (n - (n8 >> 1) > n2) {
                n5 = LWTextField.nextValidCursorIndex(cArray, n5);
            }
        }
        return n5;
    }

    private int _calculateCanvasWidth() {
        int n = 0;
        Font font = this.getFont();
        if (font != null) {
            FontMetrics fontMetrics = this._getFontMetrics();
            n = 1 + fontMetrics.stringWidth(this._getDisplayString()) + 1;
        }
        return Math.max(n, this.getInnerWidth());
    }

    private void _paintInsertionPoint(Graphics graphics, FontMetrics fontMetrics, int n, int n2, String string, int n3, int n4, boolean bl) {
        int n5 = n - 0;
        if (bl) {
            if (string != null) {
                n += fontMetrics.stringWidth(string.substring(0, n3));
            }
            int n6 = CursorUtils.getcaretWidth();
            graphics.fillRect(n, n2, n6, n4);
            Shape shape = graphics.getClip();
            Color color = graphics.getColor();
            graphics.setClip(n, n2, n6, n4);
            graphics.setColor(this.getUIDefaults().getColor(LookAndFeel.TEXT_HIGHLIGHT_TEXT));
            this._doDrawTabbedString(graphics, fontMetrics, string, 0, n5, n2 + fontMetrics.getAscent());
            graphics.setClip(shape);
            graphics.setColor(color);
        }
    }

    private void _paintSelectionRange(Graphics graphics, FontMetrics fontMetrics, int n, int n2, String string, int n3, int n4, int n5, boolean bl) {
        int n6 = fontMetrics.stringWidth(string.substring(0, n3));
        n += n6;
        int n7 = 0;
        string = string.substring(n3, n4);
        boolean bl2 = StringUtils.containsRightToLeft(string);
        while (string.length() > 0) {
            int n8 = string.indexOf(9);
            if (n8 < 0) {
                n7 += fontMetrics.stringWidth(string);
                break;
            }
            String string2 = string.substring(0, n8);
            n7 += fontMetrics.stringWidth(string2);
            n7 = this._getNextTab(n6 + n7, bl2) - n6;
            string = string.substring(n8 + 1);
        }
        graphics.clipRect(n, n2, n7, n5);
        graphics.fillRect(n, n2, n7, n5);
    }

    private Dimension _columnsToSize(int n) {
        FontMetrics fontMetrics;
        int n2 = 0;
        int n3 = 0;
        Font font = this.getFont();
        if (font != null && (fontMetrics = this._getFontMetrics()) != null) {
            n2 = FontUtils.getAverageWidth(fontMetrics) * n;
            n3 = fontMetrics.getHeight();
        }
        return this.convertInnerToOuterSize(n2 + 1 + 1, n3 + 1 + 1);
    }

    private void _selectWord(int n) {
        int n2;
        int n3;
        int n4;
        DisplayStringFilter displayStringFilter = this.getDisplayStringFilter();
        String string = this.getText();
        String string2 = displayStringFilter.convertString(string);
        n = displayStringFilter.valueIndexToDisplayIndex(string, n);
        char[] cArray = string2.toCharArray();
        int n5 = LWTextField.findWordStart(cArray, n);
        int n6 = displayStringFilter.displayIndexToValueIndex(string, n5);
        if (n6 > (n4 = displayStringFilter.displayIndexToValueIndex(string, (n3 = LWTextField.findWordEnd(cArray, n)) > 0 ? LWTextField.prevValidCursorIndex(cArray, n3) : 0))) {
            n2 = n5;
            n5 = n3;
            n3 = n2;
            n6 = displayStringFilter.displayIndexToValueIndex(string, n5 > 0 ? LWTextField.prevValidCursorIndex(cArray, n5) : 0);
            n4 = displayStringFilter.displayIndexToValueIndex(string, n3);
        }
        this.select(n6, n4 < (n2 = string.length()) ? LWTextField.nextValidCursorIndex(string, n4) : n2);
    }

    private void _init(String string) {
        this._text = string;
        if (this._displayFilter == null) {
            this._displayFilter = IdentityDisplayFilter.getDisplayStringFilter();
        }
        this._scrollPos = this._getFirstFocusPosition();
        this._tabStop = 4;
        this.enableEvents(184L);
    }

    private String _getDisplayString() {
        return this.getDisplayStringFilter().convertString(this.getText());
    }

    private void _paintSelection(Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
        DisplayStringFilter displayStringFilter = this.getDisplayStringFilter();
        String string = this.getText();
        String string2 = displayStringFilter.convertString(string);
        FontMetrics fontMetrics = this._getFontMetrics();
        int n5 = fontMetrics.getAscent() + fontMetrics.getDescent();
        if (n3 == n4) {
            this._paintInsertionPoint(graphics, fontMetrics, n += 0, n2, string2, displayStringFilter.valueIndexToDisplayIndex(string, n3), n5, bl);
        } else {
            Shape shape = graphics.getClip();
            Color color = graphics.getColor();
            Range[] rangeArray = displayStringFilter.getDisplaySelectionRanges(string, n3, n4);
            int n6 = n2 + fontMetrics.getAscent();
            UIDefaults uIDefaults = this.getUIDefaults();
            Object object = this.hasGlobalFocus() ? LookAndFeel.TEXT_HIGHLIGHT : LookAndFeel.SECONDARY_TEXT_HIGHLIGHT;
            Color color2 = uIDefaults.getColor(object);
            Color color3 = uIDefaults.getColor(LookAndFeel.TEXT_HIGHLIGHT_TEXT);
            for (int i = 0; i < rangeArray.length; ++i) {
                graphics.setColor(color2);
                this._paintSelectionRange(graphics, fontMetrics, n, n2, string2, rangeArray[i].start, rangeArray[i].end, n5, bl);
                graphics.setColor(color3);
                this._doDrawTabbedString(graphics, fontMetrics, string2, 0, n, n6);
                graphics.setClip(shape);
            }
            graphics.setColor(color);
        }
    }

    private void _updateBIDI(boolean bl) {
        if (bl || this._bidiEnabled) {
            DisplayStringFilter displayStringFilter = this._bidiEnabled ? ((ChainDisplayFilter)this._displayFilter).getInnerFilter() : this._displayFilter;
            this._bidiEnabled = true;
            this._displayFilter = new ChainDisplayFilter(displayStringFilter, new BIDIFilter(this.getActualReadingDirection(), LocaleUtils.getDefaultableLocale(this)));
            this.repaint(10L);
        }
    }

    private FontMetrics _getFontMetrics() {
        FontMetrics fontMetrics = this._metrics;
        Font font = this.getFont();
        if ((fontMetrics == null || fontMetrics.getFont() != font) && font != null) {
            this._metrics = fontMetrics = new TabbedFontMetrics(this.getFontMetrics(font), this.getTabStop());
        }
        return fontMetrics;
    }

    private int _getNextTab(int n, boolean bl) {
        return ((TabbedFontMetrics)this._getFontMetrics()).getNextTab(n, bl);
    }

    private void _doDrawString(Graphics graphics, String string, int n, int n2) {
        boolean bl = this.getInputMethodManager().paintText(graphics, n, n2);
        if (!bl) {
            GraphicUtils.drawString(graphics, string, n, n2);
        }
    }

    private void _doDrawTabbedString(Graphics graphics, FontMetrics fontMetrics, String string, int n, int n2, int n3) {
        boolean bl;
        boolean bl2 = StringUtils.containsRightToLeft(string);
        boolean bl3 = bl = string.length() > 0 && string.charAt(0) == '\u202d';
        while (string.length() > 0) {
            int n4 = string.indexOf(9);
            if (n4 < 0) {
                this._doDrawString(graphics, string, n + n2, n3);
                break;
            }
            String string2 = string.substring(0, n4);
            this._doDrawString(graphics, string2, n + n2, n3);
            n = this._getNextTab(n + fontMetrics.stringWidth(string2), bl2);
            if (bl) {
                string = '\u202d' + string.substring(n4 + 1);
                continue;
            }
            string = string.substring(n4 + 1);
        }
    }

    protected class Access
    extends AccessibleLWTextComponent {
        public Access() {
            super(LWTextField.this);
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            accessibleStateSet.add(AccessibleState.SINGLE_LINE);
            return accessibleStateSet;
        }

        @Override
        public int getIndexAtPoint(Point point) {
            if (this.getFont() == null) {
                return -1;
            }
            return LWTextField.this.canvasPixelToSelectionIndex(point.x - LWTextField.this.getInnerOrigin().x);
        }

        @Override
        public int getSelectionStart() {
            DisplayStringFilter displayStringFilter = LWTextField.this.getDisplayStringFilter();
            return displayStringFilter.valueIndexToDisplayIndex(LWTextField.this.getText(), super.getSelectionStart());
        }

        @Override
        public int getSelectionEnd() {
            DisplayStringFilter displayStringFilter = LWTextField.this.getDisplayStringFilter();
            return displayStringFilter.valueIndexToDisplayIndex(LWTextField.this.getText(), super.getSelectionEnd());
        }

        @Override
        public String getSelectedText() {
            int n;
            DisplayStringFilter displayStringFilter = LWTextField.this.getDisplayStringFilter();
            String string = displayStringFilter.convertString(LWTextField.this.getText());
            if (string == null) {
                return null;
            }
            int n2 = this.getSelectionStart();
            return n2 == (n = this.getSelectionEnd()) ? null : string.substring(n2, n);
        }

        @Override
        protected String getActualText() {
            String string = LWTextField.this.getText();
            if (string == null) {
                return null;
            }
            DisplayStringFilter displayStringFilter = LWTextField.this.getDisplayStringFilter();
            return displayStringFilter.convertString(string);
        }

        @Override
        public Rectangle getCharacterBounds(int n) {
            String string = LWTextField.this.getText();
            Font font = this.getFont();
            if (font == null || n < 0 || n >= string.length()) {
                return new Rectangle();
            }
            DisplayStringFilter displayStringFilter = LWTextField.this.getDisplayStringFilter();
            String string2 = displayStringFilter.convertString(string);
            int n2 = displayStringFilter.valueIndexToDisplayIndex(string, n);
            int n3 = displayStringFilter.valueIndexToDisplayIndex(string, n + 1);
            FontMetrics fontMetrics = LWTextField.this._getFontMetrics();
            Point point = LWTextField.this.convertCanvasToOuter(fontMetrics.stringWidth(string2.substring(0, n2)), 0);
            int n4 = fontMetrics.stringWidth(string2.substring(n2, n3));
            return new Rectangle(point.x, point.y, n4, LWTextField.this.getInnerSize().height);
        }
    }
}

