/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.lwAWT.lwText;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleState;
import oracle.bali.share.util.IntegerUtils;
import oracle.ewt.EwtComponent;
import oracle.ewt.border.Border;
import oracle.ewt.event.ListenerManager;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.lwAWT.lwText.CursorIdler;
import oracle.ewt.lwAWT.lwText.SelectionEvent;
import oracle.ewt.lwAWT.lwText.SelectionListener;
import oracle.ewt.lwAWT.lwText.TextPosition;
import oracle.ewt.lwAWT.lwText.im.InputMethodManager;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.plaf.TextUI;
import oracle.ewt.util.ClipboardProxy;
import oracle.ewt.util.InputEventUtils;

public abstract class LWTextComponent
extends EwtComponent {
    private TextListener _textListener;
    private ListenerManager _selectionListeners;
    private TextPosition _selectionStart;
    private TextPosition _selectionEnd;
    private transient boolean _isSelectionAnchoredAtStart = true;
    private boolean _isEditable = true;
    private boolean _isFocusable = true;
    transient boolean _isOKToDrawSelection = true;

    public static final void setBlinkRate(long l) {
        CursorIdler.getCursorIdler().setBlinkRate(l);
    }

    public static final long getBlinkRate() {
        return CursorIdler.getCursorIdler().getBlinkRate();
    }

    protected LWTextComponent() {
        this.enableEvents(1052L);
        this._selectionStart = this._selectionEnd = this.getPosition(0);
        this.enableInputMethods(true);
    }

    @Override
    public Object getUIClassID() {
        return "TextUI";
    }

    public void setText(String string) {
        this.__endComposition();
        this.__setTextWithoutCommit(string);
    }

    public abstract String getText();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSelectedText() {
        String string = null;
        LWTextComponent lWTextComponent = this;
        synchronized (lWTextComponent) {
            String string2 = this.getText();
            if (string2 != null) {
                string = string2.substring(this.getSelectionStart(), this.getSelectionEnd());
            }
        }
        return string;
    }

    public int getTextLength() {
        String string = this.getText();
        if (string == null) {
            return 0;
        }
        return string.length();
    }

    public BorderPainter getDefaultBorderPainter() {
        return this.getUI().getDefaultBorderPainter(this);
    }

    public static Border getDefaultBorder() {
        return null;
    }

    @Override
    public void setFocusable(boolean bl) {
        if (this._isFocusable != bl) {
            this._isFocusable = bl;
            this.setCursor(((TextUI)this.getUI()).getCursor(this));
            if (!bl && this.hasWindowFocus()) {
                this.transferFocus();
            }
        }
    }

    @Override
    public boolean isFocusable() {
        return this._isFocusable;
    }

    public void setEditable(boolean bl) {
        if (this._isEditable != bl) {
            this._isEditable = bl;
            this.enableInputMethods(this.isEnabled() && bl);
            this.repaint();
            AccessibleContext accessibleContext = this.accessAccessibleContext();
            if (accessibleContext != null) {
                accessibleContext.firePropertyChange("AccessibleState", bl ? null : AccessibleState.EDITABLE, bl ? AccessibleState.EDITABLE : null);
            }
        }
    }

    public boolean isEditable() {
        return this._isEditable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void select(int n, int n2) {
        Object object = this.getTreeLock();
        synchronized (object) {
            LWTextComponent lWTextComponent = this;
            synchronized (lWTextComponent) {
                this.select(this.getPosition(n), this.getPosition(n2));
            }
        }
    }

    public final void selectAll() {
        this.select(0, this.getTextLength());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setSelectionStart(int n) {
        Object object = this.getTreeLock();
        synchronized (object) {
            LWTextComponent lWTextComponent = this;
            synchronized (lWTextComponent) {
                this.select(this.getPosition(n), this.getSelectionEndPos());
            }
        }
    }

    public int getSelectionStart() {
        TextPosition textPosition = this._selectionStart;
        return textPosition != null ? textPosition.getIndex() : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setSelectionEnd(int n) {
        Object object = this.getTreeLock();
        synchronized (object) {
            LWTextComponent lWTextComponent = this;
            synchronized (lWTextComponent) {
                this.select(this.getSelectionStartPos(), this.getPosition(n));
            }
        }
    }

    public int getSelectionEnd() {
        TextPosition textPosition = this._selectionEnd;
        return textPosition != null ? textPosition.getIndex() : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setCaretPosition(int n) {
        Object object = this.getTreeLock();
        synchronized (object) {
            LWTextComponent lWTextComponent = this;
            synchronized (lWTextComponent) {
                this.setCaretPosition(this.getPosition(n));
            }
        }
    }

    public final int getCaretPosition() {
        return this.getSelectionEnd();
    }

    public void addTextListener(TextListener textListener) {
        this._textListener = AWTEventMulticaster.add(this._textListener, textListener);
    }

    public void removeTextListener(TextListener textListener) {
        this._textListener = AWTEventMulticaster.remove(this._textListener, textListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        if (this._selectionListeners == null) {
            this._selectionListeners = new ListenerManager();
        }
        this._selectionListeners.addListener(selectionListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this._selectionListeners.removeListener(selectionListener);
    }

    public void insert(String string, int n) {
        this.replaceRange(string, n, n);
    }

    public synchronized void append(String string) {
        this.__endComposition();
        int n = this.getTextLength();
        this.replaceRangeWithoutCommit(string, n, n);
    }

    public void replaceRange(String string, int n, int n2) {
        this.__endComposition();
        this.replaceRangeWithoutCommit(string, n, n2);
    }

    public final void replaceRangeWithoutCommit(String string, int n, int n2) {
        Rectangle rectangle = this.replaceRangeDamage(string, n, n2, true);
        if (rectangle != null) {
            this.repaintCanvas(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        this._fireAccessibleText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cut() {
        Rectangle rectangle = null;
        LWTextComponent lWTextComponent = this;
        synchronized (lWTextComponent) {
            this.copy();
            if (this.isEditable()) {
                int n = this.getSelectionStart();
                int n2 = this.getSelectionEnd();
                rectangle = this.replaceRangeDamage(null, n, n2, true);
            }
        }
        this.paintText(rectangle, true);
        this.deliverTextChangedIfNecessary(rectangle);
    }

    public void copy() {
        String string = this.getSelectedText();
        if (string.length() != 0) {
            String string2 = new String(string);
            StringSelection stringSelection = new StringSelection(string2);
            Clipboard clipboard = ClipboardProxy.getSystemClipboard();
            clipboard.setContents(stringSelection, stringSelection);
        }
    }

    public boolean isOKToPaste(Transferable transferable) {
        boolean bl = this.isEditable() && transferable != null && (this._isStringFlavorSupported(transferable) || transferable.isDataFlavorSupported(DataFlavor.plainTextFlavor));
        return bl;
    }

    private boolean _isStringFlavorSupported(Transferable transferable) {
        try {
            return transferable.isDataFlavorSupported(DataFlavor.stringFlavor);
        }
        catch (NullPointerException nullPointerException) {
            return true;
        }
    }

    public void paste() {
        Clipboard clipboard = ClipboardProxy.getSystemClipboard();
        this._pasteImpl(clipboard);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Rectangle rectangle;
        LWTextComponent lWTextComponent = this;
        synchronized (lWTextComponent) {
            int n = this.getSelectionStart();
            int n2 = this.getSelectionEnd();
            rectangle = this.replaceRangeDamage(null, n, n2, true);
        }
        this.paintText(rectangle, true);
        this.deliverTextChangedIfNecessary(rectangle);
    }

    @Override
    public boolean isFocusTraversable() {
        return this._isFocusable;
    }

    @Override
    public void enableInputMethods(boolean bl) {
        if (InputMethodManager.isInlineIMEEnabled()) {
            super.enableInputMethods(bl);
        }
    }

    public Color getBorderBackground() {
        return this.getParent().getBackground();
    }

    public Color getBorderForeground() {
        return this.getParent().getForeground();
    }

    @Override
    public void setEnabled(boolean bl) {
        if (bl != this.isEnabled()) {
            super.setEnabled(bl);
            this.enableInputMethods(bl && this.isEditable());
            this.repaintInterior();
        }
    }

    @Override
    public void addNotify() {
        CursorIdler.getCursorIdler().addRef();
        super.addNotify();
        if (this.hasGlobalFocus()) {
            CursorIdler.getCursorIdler().setIdlee(this);
        }
    }

    @Override
    public void removeNotify() {
        CursorIdler cursorIdler = CursorIdler.getCursorIdler();
        cursorIdler.cancel(this);
        cursorIdler.release();
        super.removeNotify();
    }

    @Override
    public void requestFocus() {
        if (this.isFocusable()) {
            super.requestFocus();
        }
    }

    @Override
    public void setFont(Font font) {
        if (font != this.getFont()) {
            super.setFont(font);
            this.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean changeSelection(TextPosition textPosition, TextPosition textPosition2) {
        boolean bl = false;
        if (textPosition.getIndex() < 0) {
            textPosition = this.getPosition(0);
        }
        int n = this.getTextLength();
        if (textPosition2.getIndex() > n) {
            textPosition2 = this.getPosition(n);
        }
        if (textPosition.getIndex() > textPosition2.getIndex()) {
            textPosition = textPosition2;
        } else if (textPosition.getIndex() == textPosition2.getIndex()) {
            textPosition2 = textPosition;
        }
        if (!this._selectionStart.equals(textPosition) || !this._selectionEnd.equals(textPosition2)) {
            CursorIdler cursorIdler = CursorIdler.getCursorIdler();
            if (textPosition == textPosition2) {
                cursorIdler.schedule(this);
            } else {
                cursorIdler.cancel(this);
            }
            LWTextComponent lWTextComponent = this;
            synchronized (lWTextComponent) {
                this._selectionStart = textPosition;
                this._selectionEnd = textPosition2;
                this.setSelectionAnchoredAtStart(true);
            }
            bl = true;
        }
        this.__copySelectedText();
        return bl;
    }

    void __copySelectedText() {
        String string;
        Clipboard clipboard = ClipboardProxy.getSystemSelection(this.getToolkit());
        if (clipboard != null && (string = this.getSelectedText()) != null && string.length() > 0) {
            StringSelection stringSelection = new StringSelection(this.getSelectedText());
            clipboard.setContents(stringSelection, stringSelection);
        }
    }

    @Override
    protected Object getPaintData(Object object) {
        if (object == TextUI.TEXT_IS_EDITABLE_KEY) {
            if (this.isEditable()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return super.getPaintData(object);
    }

    protected void processTextEvent(TextEvent textEvent) {
        if (this._textListener != null) {
            this._textListener.textValueChanged(textEvent);
        }
    }

    @Override
    protected void processEventImpl(AWTEvent aWTEvent) {
        if (aWTEvent instanceof TextEvent) {
            this.processTextEvent((TextEvent)aWTEvent);
        } else {
            super.processEventImpl(aWTEvent);
        }
    }

    @Override
    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        int n = focusEvent.getID();
        if (n == 1004 || n == 1005) {
            LWComponent lWComponent = LWComponent.getFocusedComponent();
            LWTextComponent lWTextComponent = lWComponent instanceof LWTextComponent ? (LWTextComponent)lWComponent : null;
            CursorIdler.getCursorIdler().setIdlee(lWTextComponent);
            this.paintSelection();
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent mouseEvent) {
        Clipboard clipboard;
        super.processMouseEvent(mouseEvent);
        if (mouseEvent.getID() == 500 && mouseEvent.getClickCount() == 1 && InputEventUtils.isMiddleMouseButton(mouseEvent) && this.isEnabled() && (clipboard = ClipboardProxy.getSystemSelection(this.getToolkit())) != null) {
            this._pasteImpl(clipboard);
            mouseEvent.consume();
        }
        if (!mouseEvent.isConsumed() && !this.isEnabled()) {
            mouseEvent.consume();
        }
    }

    @Override
    protected void processKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
        if (!keyEvent.isConsumed()) {
            boolean bl = keyEvent.getID() == 401;
            int n = keyEvent.getKeyCode();
            boolean bl2 = InputEventUtils.getMods(keyEvent) == Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
            boolean bl3 = true;
            switch (n) {
                case 127: {
                    if (!this.isEditable()) {
                        if (!bl) break;
                        Toolkit.getDefaultToolkit().beep();
                        break;
                    }
                    if (keyEvent.isShiftDown()) {
                        if (!bl) break;
                        this.cut();
                        break;
                    }
                    bl3 = false;
                    break;
                }
                case 155: {
                    if (keyEvent.isShiftDown()) {
                        if (!bl) break;
                        this.paste();
                        break;
                    }
                    if (bl2) {
                        if (!bl) break;
                        this.copy();
                        break;
                    }
                    bl3 = false;
                    break;
                }
                case 67: {
                    if (bl2) {
                        if (!bl) break;
                        this.copy();
                        break;
                    }
                    bl3 = false;
                    break;
                }
                case 86: {
                    if (bl2) {
                        if (!bl) break;
                        this.paste();
                        break;
                    }
                    bl3 = false;
                    break;
                }
                case 88: {
                    if (bl2) {
                        if (!bl) break;
                        this.cut();
                        break;
                    }
                    bl3 = false;
                    break;
                }
                default: {
                    bl3 = false;
                }
            }
            if (bl3) {
                keyEvent.consume();
            }
        }
    }

    @Override
    protected String paramString() {
        String string = super.paramString();
        String string2 = this.getText();
        if (string2 != null && string2.length() > 40) {
            string2 = string2.substring(0, 40);
        }
        string = string + ", text = " + string2;
        if (this.isEditable()) {
            string = string + ", editable";
        }
        string = string + ", selection = " + this.getSelectionStart() + " - " + this.getSelectionEnd();
        return string;
    }

    abstract Point scrollSelectionIntoView(TextPosition var1);

    abstract Rectangle getSelectionBounds(TextPosition var1, TextPosition var2);

    abstract TextPosition getPosition(int var1);

    abstract Rectangle replaceRangeValue(String var1, int var2, int var3);

    final synchronized Rectangle getSelectionBounds() {
        return this.getSelectionBounds(this.getSelectionStartPos(), this.getSelectionEndPos());
    }

    String getPasteString(Transferable transferable) throws UnsupportedFlavorException, IOException {
        if (this._isStringFlavorSupported(transferable)) {
            return (String)transferable.getTransferData(DataFlavor.stringFlavor);
        }
        if (transferable.isDataFlavorSupported(DataFlavor.plainTextFlavor)) {
            byte[] byArray = (byte[])transferable.getTransferData(DataFlavor.plainTextFlavor);
            try {
                return new String(byArray, 0, byArray.length, "8859_1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return null;
            }
        }
        throw new UnsupportedFlavorException(DataFlavor.stringFlavor);
    }

    TextPosition getSelectionStartPos() {
        return this._selectionStart;
    }

    TextPosition getSelectionEndPos() {
        return this._selectionEnd;
    }

    void setSelectionAnchoredAtStart(boolean bl) {
        this._isSelectionAnchoredAtStart = bl;
    }

    boolean isSelectionAnchoredAtStart() {
        return this._isSelectionAnchoredAtStart;
    }

    final void select(TextPosition textPosition, TextPosition textPosition2) {
        this.select(textPosition, textPosition2, textPosition);
    }

    public final void setCaretPosition(TextPosition textPosition) {
        this.select(textPosition, textPosition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void select(TextPosition textPosition, TextPosition textPosition2, TextPosition textPosition3) {
        boolean bl = false;
        int n = this._getCaret();
        LWTextComponent lWTextComponent = this;
        synchronized (lWTextComponent) {
            TextPosition textPosition4 = this.getSelectionStartPos();
            TextPosition textPosition5 = this.getSelectionEndPos();
            if (this.changeSelection(textPosition, textPosition2)) {
                Cloneable cloneable;
                bl = true;
                if (this.hasWindowFocus() && (cloneable = this.getChangedSelectionBounds(textPosition4, textPosition5)) != null) {
                    this.paintText((Rectangle)cloneable, true);
                }
                if ((cloneable = this.scrollSelectionIntoView(textPosition3)) != null) {
                    this.setCanvasOrigin(cloneable.x, cloneable.y);
                }
            }
        }
        if (bl) {
            this._fireSelectionChanged(textPosition.equals(textPosition2), n);
        }
    }

    String replaceRangeFilter(String string, int n, int n2) {
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Rectangle replaceRangeDamage(String string, int n, int n2, boolean bl) {
        Point point = null;
        Rectangle rectangle = null;
        boolean bl2 = false;
        int n3 = this._getCaret();
        LWTextComponent lWTextComponent = this;
        synchronized (lWTextComponent) {
            string = string == null ? "" : this.replaceRangeFilter(string, n, n2);
            int n4 = string.length();
            if ((n4 != 0 || n != n2) && this.__isOKToReplace(string, n, n2)) {
                Object object;
                Rectangle rectangle2 = this.getSelectionBounds();
                int n5 = n;
                if (bl) {
                    n5 += n4;
                }
                int n6 = this.getTextLength() - (n2 - n) + n4;
                if (this.getSelectionEnd() > n6) {
                    object = this.getPosition(n5);
                    this.changeSelection((TextPosition)object, (TextPosition)object);
                    bl2 = true;
                }
                object = this.replaceRangeValue(string, n, n2);
                TextPosition textPosition = this.getPosition(n5);
                if (this.changeSelection(textPosition, textPosition)) {
                    bl2 = true;
                }
                point = this.scrollSelectionIntoView(textPosition);
                Rectangle rectangle3 = this.getSelectionBounds();
                rectangle = LWTextComponent._unionRectangles(LWTextComponent._unionRectangles(rectangle2, rectangle3), (Rectangle)object);
            }
        }
        if (point != null) {
            this.setCanvasOrigin(point.x, point.y);
        }
        if (bl2) {
            this._fireSelectionChanged(true, n3);
        }
        return rectangle;
    }

    void paintText(Rectangle rectangle, boolean bl) {
        this._isOKToDrawSelection = bl;
        if (rectangle != null) {
            this.paintImmediateCanvas(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    void paintSelection() {
        this.paintText(this.getSelectionBounds(), true);
    }

    void eraseSelection() {
        this.paintText(this.getSelectionBounds(), false);
    }

    void deliverTextChangedIfNecessary(Rectangle rectangle) {
        if (rectangle != null) {
            this.processEvent(new TextEvent(this, 900));
            this._fireAccessibleText();
        }
    }

    boolean __isOKToReplace(String string, int n, int n2) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void __setTextWithoutCommit(String string) {
        LWTextComponent lWTextComponent = this;
        synchronized (lWTextComponent) {
            Rectangle rectangle = this.replaceRangeDamage(string, 0, this.getTextLength(), false);
        }
        this.repaintInterior();
        this._fireAccessibleText();
    }

    abstract void __endComposition();

    private int _getCaret() {
        return this.isSelectionAnchoredAtStart() ? this.getSelectionEnd() : this.getSelectionStart();
    }

    private static Rectangle _unionRectangles(Rectangle rectangle, Rectangle rectangle2) {
        if (rectangle == null && rectangle2 == null) {
            return null;
        }
        return rectangle == null ? rectangle2 : (rectangle2 == null ? rectangle : rectangle.union(rectangle2));
    }

    Rectangle getChangedSelectionBounds(TextPosition textPosition, TextPosition textPosition2) {
        if (!this.hasWindowFocus()) {
            return null;
        }
        Rectangle rectangle = this.getSelectionBounds(textPosition, textPosition2);
        Rectangle rectangle2 = this.getSelectionBounds();
        return LWTextComponent._unionRectangles(rectangle, rectangle2);
    }

    private void _fireAccessibleText() {
        AccessibleContext accessibleContext = this.accessAccessibleContext();
        if (accessibleContext != null) {
            accessibleContext.firePropertyChange("AccessibleText", Boolean.FALSE, Boolean.TRUE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _pasteImpl(Clipboard clipboard) {
        Transferable transferable = clipboard.getContents(this);
        if (transferable != null && this.isOKToPaste(transferable)) {
            try {
                Rectangle rectangle;
                LWTextComponent lWTextComponent = this;
                synchronized (lWTextComponent) {
                    int n = this.getSelectionStart();
                    int n2 = this.getSelectionEnd();
                    rectangle = this.replaceRangeDamage(this.getPasteString(transferable), n, n2, true);
                }
                this.paintText(rectangle, true);
                this.deliverTextChangedIfNecessary(rectangle);
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void _fireSelectionChanged(boolean bl, int n) {
        Object object;
        ListenerManager listenerManager = this._selectionListeners;
        if (listenerManager != null && (object = listenerManager.getListeners()) != null && object.hasMoreElements()) {
            SelectionEvent selectionEvent = new SelectionEvent(this, 2000, bl);
            while (object.hasMoreElements()) {
                ((SelectionListener)object.nextElement()).selectionChanged(selectionEvent);
            }
        }
        if ((object = this.accessAccessibleContext()) != null) {
            int n2 = this._getCaret();
            if (n != n2) {
                ((AccessibleContext)object).firePropertyChange("AccessibleCaret", IntegerUtils.getInteger(n), IntegerUtils.getInteger(n2));
            }
            ((AccessibleContext)object).firePropertyChange("AccessibleSelection", Boolean.FALSE, Boolean.TRUE);
        }
    }
}

