/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.lwAWT.lwMenu;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;
import oracle.ewt.lwAWT.VirtualComponent;

class PreferredRowLayout
implements LayoutManager {
    private static LayoutManager _sInstance;

    private PreferredRowLayout() {
    }

    public static LayoutManager getInstance() {
        if (_sInstance == null) {
            _sInstance = new PreferredRowLayout();
        }
        return _sInstance;
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
    }

    @Override
    public void removeLayoutComponent(Component component) {
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        Serializable serializable;
        int n = container.getComponentCount();
        Dimension dimension = new Dimension(0, 0);
        for (int i = 0; i < n; ++i) {
            serializable = container.getComponent(i);
            if (!((Component)serializable).isVisible()) continue;
            Dimension dimension2 = ((Component)serializable).getPreferredSize();
            dimension.width += dimension2.width;
            dimension.height = Math.max(dimension2.height, dimension.height);
        }
        serializable = container.getInsets();
        dimension.width += ((Insets)serializable).left + ((Insets)serializable).right;
        dimension.height += ((Insets)serializable).top + ((Insets)serializable).left;
        return dimension;
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    @Override
    public void layoutContainer(Container container) {
        int n;
        Dimension dimension = container.getSize();
        Insets insets = container.getInsets();
        int n2 = container.getComponentCount();
        int n3 = dimension.height - (insets.top + insets.bottom);
        if (this._isLeftToRight(container)) {
            int n4 = insets.left;
            for (n = 0; n < n2; ++n) {
                Component component = container.getComponent(n);
                if (!component.isVisible()) continue;
                Dimension dimension2 = component.getPreferredSize();
                component.setBounds(n4, insets.top, dimension2.width, n3);
                n4 += dimension2.width;
            }
        } else {
            int n5 = dimension.width - insets.right;
            while (n < n2) {
                Component component = container.getComponent(n);
                if (component.isVisible()) {
                    Dimension dimension3 = component.getPreferredSize();
                    component.setBounds(n5 -= dimension3.width, insets.top, dimension3.width, n3);
                }
                ++n;
            }
        }
    }

    private boolean _isLeftToRight(Component component) {
        return !(component instanceof VirtualComponent) || ((VirtualComponent)((Object)component)).getActualReadingDirection() != 2;
    }
}

