/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.lwAWT.lwMenu;

import java.awt.Component;
import java.awt.Container;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleValue;
import oracle.bali.share.util.IntegerUtils;
import oracle.ewt.lwAWT.lwMenu.LWMenuItem;
import oracle.ewt.lwAWT.lwMenu.LWMenuItemGroup;

public class LWRadioButtonMenuItem
extends LWMenuItem {
    public static String PROPERTY_STATE = "state";
    private boolean _state;
    private LWMenuItemGroup _group;

    public LWRadioButtonMenuItem() {
        this("", false);
    }

    public LWRadioButtonMenuItem(String string) {
        this(string, false);
    }

    public LWRadioButtonMenuItem(String string, boolean bl) {
        super(string);
        this._state = bl;
    }

    @Override
    public void activate() {
        this.setState(true);
        super.activate();
    }

    public LWMenuItemGroup getMenuItemGroup() {
        return this._group;
    }

    public boolean getState() {
        return this._state;
    }

    public void setMenuItemGroup(LWMenuItemGroup lWMenuItemGroup) {
        LWMenuItemGroup lWMenuItemGroup2 = this.getMenuItemGroup();
        if (lWMenuItemGroup != lWMenuItemGroup2) {
            if (lWMenuItemGroup2 != null && lWMenuItemGroup2.getSelectedMenuItem() == this) {
                lWMenuItemGroup2.setSelectedMenuItem(null);
            }
            this._group = lWMenuItemGroup;
            if (lWMenuItemGroup != null && this.getState()) {
                lWMenuItemGroup.setSelectedMenuItem(this);
            }
        }
    }

    public void setState(boolean bl) {
        if (this._state != bl) {
            this._state = bl;
            this.repaint();
            this.fireBooleanPropertyChange(PROPERTY_STATE, bl);
            AccessibleContext accessibleContext = this.accessAccessibleContext();
            if (accessibleContext != null) {
                AccessibleState accessibleState = AccessibleState.CHECKED;
                accessibleContext.firePropertyChange("AccessibleState", bl ? null : accessibleState, bl ? accessibleState : null);
            }
            if (bl) {
                this._autocoordinate();
            }
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.getState()) {
            this._autocoordinate();
        }
    }

    @Override
    public Object getUIClassID() {
        return "RadioButtonMenuItemUI";
    }

    @Override
    protected int getPaintState() {
        return super.getPaintState() | (this.getState() ? 8 : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _autocoordinate() {
        LWMenuItemGroup lWMenuItemGroup = this.getMenuItemGroup();
        if (lWMenuItemGroup != null) {
            lWMenuItemGroup.setSelectedMenuItem(this);
            return;
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            LWRadioButtonMenuItem lWRadioButtonMenuItem;
            int n;
            Container container = this.getParent();
            if (container == null) {
                return;
            }
            Component[] componentArray = container.getComponents();
            for (int i = 0; i < componentArray.length && componentArray[i] != this; ++i) {
            }
            for (n = i + 1; n < componentArray.length && componentArray[n] instanceof LWRadioButtonMenuItem && (lWRadioButtonMenuItem = (LWRadioButtonMenuItem)componentArray[n]).getMenuItemGroup() == null; ++n) {
                lWRadioButtonMenuItem.setState(false);
            }
            for (n = i - 1; n >= 0 && componentArray[n] instanceof LWRadioButtonMenuItem && (lWRadioButtonMenuItem = (LWRadioButtonMenuItem)componentArray[n]).getMenuItemGroup() == null; --n) {
                lWRadioButtonMenuItem.setState(false);
            }
        }
    }

    @Override
    protected AccessibleContext createAccessibleContext() {
        return new RadioAccess();
    }

    private class RadioAccess
    extends LWMenuItem.Access
    implements AccessibleValue {
        private RadioAccess() {
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.RADIO_BUTTON;
        }

        @Override
        public AccessibleValue getAccessibleValue() {
            return this;
        }

        @Override
        public Number getCurrentAccessibleValue() {
            return IntegerUtils.getInteger(LWRadioButtonMenuItem.this.getState() ? 1 : 0);
        }

        @Override
        public boolean setCurrentAccessibleValue(Number number) {
            LWRadioButtonMenuItem.this.setState(number.intValue() != 0);
            return true;
        }

        @Override
        public Number getMinimumAccessibleValue() {
            return IntegerUtils.getInteger(0);
        }

        @Override
        public Number getMaximumAccessibleValue() {
            return IntegerUtils.getInteger(1);
        }
    }
}

