/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.lwAWT.lwMenu;

import java.awt.AWTEvent;
import java.awt.Container;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Enumeration;
import java.util.ResourceBundle;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import oracle.ewt.access.AccessibleLWComponent;
import oracle.ewt.event.KeyStroke;
import oracle.ewt.event.ListenerManager;
import oracle.ewt.graphics.ImageSet;
import oracle.ewt.graphics.SynthesizingImageSet;
import oracle.ewt.lwAWT.AbstractPainterComponent;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.lwAWT.lwMenu.LWMenuBar;
import oracle.ewt.lwAWT.lwMenu.LWMenuItemContainer;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.painter.Painter;
import oracle.ewt.plaf.MenuItemUI;
import oracle.ewt.util.LocaleUtils;
import oracle.ewt.util.StringUtils;

public class LWMenuItem
extends AbstractPainterComponent {
    public static final String PROPERTY_SELECTED = "selected";
    static final String __CLIENTPROP_MENU_ITEM_CONSTRAINTS = "_miConstraints";
    static final String _RESOURCE_BUNDLE = "oracle.ewt.access.resource.AccessibilityBundle";
    private static final String _KEY_MNEMONIC = "LWMENUITEM.MNEMONIC";
    private static final String _KEY_SHORTCUT = "LWMENUITEM.SHORTCUT";
    private String _label;
    private ImageSet _imageSet;
    private String _command;
    private KeyStroke _accelerator;
    private PropertyChangeSupport _propSupport;
    private ListenerManager _actionListeners;
    private static final String _HELP_TEXT = "_lwMenuItemHelpText";

    public LWMenuItem() {
        this(null);
    }

    public LWMenuItem(String string) {
        this._label = string;
    }

    public void activate() {
        this.processEvent(new ActionEvent(this, 1001, this.getActionCommand()));
    }

    public void addActionListener(ActionListener actionListener) {
        if (this._actionListeners == null) {
            this._actionListeners = new ListenerManager();
        }
        this._actionListeners.addListener(actionListener);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._propSupport == null) {
            this._propSupport = new PropertyChangeSupport(this);
        }
        this._propSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public String getActionCommand() {
        return this._command == null ? this.getLabel() : this._command;
    }

    public String getHelpText() {
        return (String)this.getClientProperty(_HELP_TEXT);
    }

    public ImageSet getImageSet() {
        return this._imageSet;
    }

    public String getLabel() {
        return this._label;
    }

    public LWMenuItemContainer getMenuItemContainer() {
        for (Container container = this.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof LWMenuItemContainer)) continue;
            return (LWMenuItemContainer)((Object)container);
        }
        return null;
    }

    public KeyStroke getAccelerator() {
        return this._accelerator;
    }

    public void handleMnemonic(KeyEvent keyEvent) {
        if (this.eventMatchesMnemonic(keyEvent)) {
            LWMenuBar lWMenuBar;
            this.activate();
            keyEvent.consume();
            if (LWMenuBar.isMnemonicHandled() && (lWMenuBar = this._getMenuBar()) != null && keyEvent.getKeyCode() != 18 && keyEvent.isAltDown()) {
                lWMenuBar.__setMnemonicHandled(true);
            }
        }
    }

    public void handleAccelerator(KeyEvent keyEvent) {
        KeyStroke keyStroke = this.getAccelerator();
        if (this.isEnabled() && keyStroke != null && keyStroke.equals(keyEvent)) {
            this.activate();
            keyEvent.consume();
        }
    }

    public boolean isSelected() {
        LWMenuItemContainer lWMenuItemContainer = this.getMenuItemContainer();
        if (lWMenuItemContainer == null) {
            return false;
        }
        return lWMenuItemContainer.getSelectedItem() == this;
    }

    public void processMenuKeyEvent(KeyEvent keyEvent) {
        this.processKeyEvent(keyEvent);
    }

    public void removeActionListener(ActionListener actionListener) {
        if (this._actionListeners != null) {
            this._actionListeners.removeListener(actionListener);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._propSupport != null) {
            this._propSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public void setActionCommand(String string) {
        this._command = string;
    }

    public void setHelpText(String string) {
        this.putClientProperty(_HELP_TEXT, string);
    }

    public final void setImage(Image image) {
        SynthesizingImageSet synthesizingImageSet = null;
        if (image != null) {
            synthesizingImageSet = new SynthesizingImageSet(image);
        }
        this.setImageSet(synthesizingImageSet);
    }

    public void setImageSet(ImageSet imageSet) {
        if (this._imageSet != imageSet) {
            this._imageSet = imageSet;
            this.invalidate();
            this.repaint();
        }
    }

    public void setLabel(String string) {
        if (this._label != string) {
            AccessibleContext accessibleContext = this.accessAccessibleContext();
            String string2 = accessibleContext == null ? null : accessibleContext.getAccessibleName();
            String string3 = this._label;
            this._label = string;
            if (accessibleContext != null) {
                accessibleContext.firePropertyChange("AccessibleVisibleData", string3, string);
                String string4 = accessibleContext.getAccessibleName();
                if (string4 != string2) {
                    accessibleContext.firePropertyChange("AccessibleName", string2, string4);
                }
            }
            this.invalidate();
            this.repaint();
        }
    }

    public void setAccelerator(KeyStroke keyStroke) {
        if (this._accelerator != keyStroke) {
            this._accelerator = keyStroke;
            this.invalidate();
            this.repaint();
        }
    }

    public final void setSelected(boolean bl) {
        this.setSelected(bl, true);
    }

    @Override
    public Object getUIClassID() {
        return "MenuItemUI";
    }

    protected void fireBooleanPropertyChange(String string, boolean bl) {
        if (this._propSupport != null) {
            if (bl) {
                this._propSupport.firePropertyChange(string, Boolean.FALSE, Boolean.TRUE);
            } else {
                this._propSupport.firePropertyChange(string, Boolean.TRUE, Boolean.FALSE);
            }
        }
    }

    @Override
    protected int getInvalidateFlags() {
        if (this.getPainter() != null) {
            return super.getInvalidateFlags();
        }
        return 0;
    }

    @Override
    protected Object getPaintData(Object object) {
        if (object == null || object == PaintContext.LABEL_KEY) {
            return this.getLabel();
        }
        if (object == "accelerator") {
            return this.getAccelerator();
        }
        if (object == PaintContext.IMAGESET_KEY) {
            return this.getImageSet();
        }
        if (object == "constraints") {
            return this.getClientProperty(__CLIENTPROP_MENU_ITEM_CONSTRAINTS);
        }
        return super.getPaintData(object);
    }

    @Override
    protected Painter getPainter() {
        return ((MenuItemUI)this.getUI()).getPainter(this);
    }

    @Override
    protected boolean interiorContains(int n, int n2, int n3, int n4) {
        return this.pointInInterior(n, n2, n3, n4);
    }

    @Override
    protected int getPaintState() {
        int n = super.getPaintState();
        if (this.isSelected()) {
            n |= 0x82;
        }
        return n;
    }

    @Override
    protected int getRepaintFlags() {
        if (this.getPainter() != null) {
            return super.getRepaintFlags();
        }
        return 0;
    }

    @Override
    protected String paramString() {
        String string = super.paramString();
        string = string + ", " + this.getLabel();
        return string;
    }

    @Override
    protected void processEventImpl(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)aWTEvent);
        } else {
            super.processEventImpl(aWTEvent);
        }
    }

    protected void processActionEvent(ActionEvent actionEvent) {
        Enumeration enumeration;
        Object object;
        LWMenuItemContainer lWMenuItemContainer = this.getMenuItemContainer();
        if (lWMenuItemContainer != null && (object = lWMenuItemContainer.getMenuInvoker()) != null) {
            object.dismissMenu();
        }
        if ((object = this._actionListeners) != null && (enumeration = ((ListenerManager)object).getListeners()) != null) {
            while (enumeration.hasMoreElements()) {
                ActionListener actionListener = (ActionListener)enumeration.nextElement();
                switch (actionEvent.getID()) {
                    case 1001: {
                        actionListener.actionPerformed(actionEvent);
                        break;
                    }
                }
            }
        }
    }

    protected void setSelected(boolean bl, boolean bl2) {
        if (bl != this.isSelected()) {
            Object object;
            if (bl2) {
                object = this.getMenuItemContainer();
                if (object == null) {
                    return;
                }
                object.itemSelectionChange(this, bl);
            }
            this.paintImmediate();
            this.fireBooleanPropertyChange(PROPERTY_SELECTED, bl);
            object = this.accessAccessibleContext();
            if (object != null) {
                ((AccessibleContext)object).firePropertyChange("AccessibleState", bl ? null : AccessibleState.ARMED, bl ? AccessibleState.ARMED : null);
            }
        }
    }

    @Override
    protected AccessibleContext createAccessibleContext() {
        return new Access();
    }

    private LWMenuBar _getMenuBar() {
        LWMenuBar lWMenuBar = null;
        for (Container container = this.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof LWMenuBar)) continue;
            lWMenuBar = (LWMenuBar)container;
        }
        return lWMenuBar;
    }

    MenuItemUI.MenuItemConstraints __getMenuItemConstraints() {
        MenuItemUI menuItemUI = (MenuItemUI)this.getUI();
        return menuItemUI.getConstraints(this);
    }

    @Override
    public void requestFocus() {
    }

    class Access
    extends AccessibleLWComponent
    implements AccessibleAction {
        public Access() {
            super(LWMenuItem.this);
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            accessibleStateSet.add(AccessibleState.SELECTABLE);
            accessibleStateSet.add(AccessibleState.FOCUSABLE);
            if (LWMenuItem.this.isSelected()) {
                accessibleStateSet.add(AccessibleState.ARMED);
                accessibleStateSet.add(AccessibleState.FOCUSED);
            }
            return accessibleStateSet;
        }

        @Override
        public String getAccessibleName() {
            String string = super.getAccessibleName();
            if (string == null || "".equals(string)) {
                string = LWMenuItem.this.getLabel();
            }
            return string;
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.MENU_ITEM;
        }

        @Override
        public AccessibleAction getAccessibleAction() {
            return this;
        }

        @Override
        public int getAccessibleActionCount() {
            return 1;
        }

        @Override
        public String getAccessibleActionDescription(int n) {
            if (n == 0) {
                ResourceBundle resourceBundle = ResourceBundle.getBundle(LWMenuItem._RESOURCE_BUNDLE, LocaleUtils.getTranslationLocale(this.getLocale()));
                return resourceBundle.getString("CLICK");
            }
            return null;
        }

        @Override
        public boolean doAccessibleAction(int n) {
            if (this.isEnabled() && n == 0) {
                LWMenuItem.this.activate();
                return true;
            }
            return false;
        }

        @Override
        protected String getMnemonicName(LWComponent lWComponent) {
            KeyStroke keyStroke;
            if (this.getAccessibleParent() != null && this.getAccessibleParent().getAccessibleContext().getAccessibleRole() == AccessibleRole.MENU_BAR) {
                return super.getMnemonicName(lWComponent);
            }
            ResourceBundle resourceBundle = ResourceBundle.getBundle(LWMenuItem._RESOURCE_BUNDLE, LocaleUtils.getTranslationLocale(this.getLocale()));
            String string = resourceBundle.getString(LWMenuItem._KEY_MNEMONIC);
            String string2 = resourceBundle.getString(LWMenuItem._KEY_SHORTCUT);
            String string3 = "";
            char c = lWComponent.getMnemonicChar();
            if (c != '\u0000') {
                string3 = " " + string + " " + c;
            }
            if ((keyStroke = LWMenuItem.this.getAccelerator()) != null) {
                String string4 = " " + string2 + " " + KeyEvent.getKeyModifiersText(keyStroke.getModifiers()) + " ";
                string4 = keyStroke.getKeyChar() != StringUtils.CHAR_UNDEFINED ? string4 + keyStroke.getKeyChar() : (keyStroke.getKeyCode() != 0 ? string4 + KeyEvent.getKeyText(keyStroke.getKeyCode()) : null);
                if (string4 != null) {
                    string3 = string3 + string4;
                }
            }
            return string3;
        }
    }
}

