/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.lwAWT.lwMenu;

import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleValue;
import oracle.bali.share.util.IntegerUtils;
import oracle.ewt.lwAWT.lwMenu.LWMenuItem;

public class LWCheckboxMenuItem
extends LWMenuItem {
    public static String PROPERTY_STATE = "state";
    private boolean _state;

    public LWCheckboxMenuItem() {
        this("", false);
    }

    public LWCheckboxMenuItem(String string) {
        this(string, false);
    }

    public LWCheckboxMenuItem(String string, boolean bl) {
        super(string);
        this._state = bl;
    }

    @Override
    public void activate() {
        this.setState(!this.getState());
        super.activate();
    }

    public boolean getState() {
        return this._state;
    }

    public void setState(boolean bl) {
        if (this._state != bl) {
            this._state = bl;
            this.repaint();
            this.fireBooleanPropertyChange(PROPERTY_STATE, bl);
            AccessibleContext accessibleContext = this.accessAccessibleContext();
            if (accessibleContext != null) {
                AccessibleState accessibleState = AccessibleState.CHECKED;
                accessibleContext.firePropertyChange("AccessibleState", bl ? null : accessibleState, bl ? accessibleState : null);
            }
        }
    }

    @Override
    public Object getUIClassID() {
        return "CheckboxMenuItemUI";
    }

    @Override
    protected int getPaintState() {
        return super.getPaintState() | (this.getState() ? 8 : 0);
    }

    @Override
    protected AccessibleContext createAccessibleContext() {
        return new CheckAccess();
    }

    private class CheckAccess
    extends LWMenuItem.Access
    implements AccessibleValue {
        private CheckAccess() {
            super(LWCheckboxMenuItem.this);
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            accessibleStateSet.add(AccessibleState.SELECTABLE);
            accessibleStateSet.add(AccessibleState.FOCUSABLE);
            if (LWCheckboxMenuItem.this.isSelected()) {
                accessibleStateSet.add(AccessibleState.ARMED);
                accessibleStateSet.add(AccessibleState.SELECTED);
                accessibleStateSet.add(AccessibleState.FOCUSED);
            }
            if (LWCheckboxMenuItem.this.getState()) {
                accessibleStateSet.add(AccessibleState.CHECKED);
            }
            return accessibleStateSet;
        }

        @Override
        public AccessibleValue getAccessibleValue() {
            return this;
        }

        @Override
        public Number getCurrentAccessibleValue() {
            return IntegerUtils.getInteger(LWCheckboxMenuItem.this.getState() ? 1 : 0);
        }

        @Override
        public boolean setCurrentAccessibleValue(Number number) {
            LWCheckboxMenuItem.this.setState(number.intValue() != 0);
            return true;
        }

        @Override
        public Number getMinimumAccessibleValue() {
            return IntegerUtils.getInteger(0);
        }

        @Override
        public Number getMaximumAccessibleValue() {
            return IntegerUtils.getInteger(1);
        }
    }
}

