/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.lwAWT;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.util.Enumeration;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleValue;
import oracle.bali.share.util.IntegerUtils;
import oracle.ewt.event.ListenerManager;
import oracle.ewt.graphics.ImageSet;
import oracle.ewt.graphics.SynthesizingImageSet;
import oracle.ewt.lwAWT.AbstractButton;
import oracle.ewt.lwAWT.LWCheckboxGroup;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.painter.Painter;
import oracle.ewt.plaf.ToggleButtonUI;

public class LWCheckbox
extends AbstractButton
implements ItemSelectable {
    private String _label;
    private boolean _state;
    private LWCheckboxGroup _group;
    private boolean _armed;
    private ImageSet _imageSet;
    private ListenerManager _listeners;
    private static int _sInstanceCounter = 0;

    public LWCheckbox() {
        this(null);
    }

    public LWCheckbox(String string) {
        this(string, false);
    }

    public LWCheckbox(String string, boolean bl) {
        this(string, bl, null);
    }

    public LWCheckbox(String string, boolean bl, LWCheckboxGroup lWCheckboxGroup) {
        this._init(string, bl, lWCheckboxGroup);
    }

    public LWCheckbox(String string, LWCheckboxGroup lWCheckboxGroup, boolean bl) {
        this(string, bl, lWCheckboxGroup);
    }

    @Override
    protected void updateUI(Class clazz) {
        if (clazz == LWCheckbox.class) {
            this.updateUI();
        }
    }

    @Override
    public Object getUIClassID() {
        return this.getCheckboxGroup() != null ? "RadioButtonUI" : "CheckBoxUI";
    }

    @Override
    public int getPaintState() {
        int n = super.getPaintState();
        if (this.getState()) {
            n |= 8;
        }
        return n;
    }

    @Override
    protected Object getPaintData(Object object) {
        Object object2 = null;
        if (object == null || object == PaintContext.LABEL_KEY) {
            String string = this.getLabel();
            if (string != null && string.length() > 0) {
                object2 = string;
            }
        } else if (object == PaintContext.IMAGESET_KEY) {
            object2 = this.getImageSet();
        }
        if (object2 == null) {
            object2 = super.getPaintData(object);
        }
        return object2;
    }

    public final void setImage(Image image) {
        SynthesizingImageSet synthesizingImageSet = image != null ? new SynthesizingImageSet(image) : null;
        this.setImageSet(synthesizingImageSet);
    }

    public void setImageSet(ImageSet imageSet) {
        if (this._imageSet != imageSet) {
            this._imageSet = imageSet;
            this.invalidate();
            this.repaint();
        }
    }

    public ImageSet getImageSet() {
        return this._imageSet;
    }

    public String getLabel() {
        return this._label;
    }

    public void setLabel(String string) {
        AccessibleContext accessibleContext = this.accessAccessibleContext();
        String string2 = accessibleContext == null ? null : accessibleContext.getAccessibleName();
        String string3 = this._label;
        this._label = string;
        if (accessibleContext != null) {
            accessibleContext.firePropertyChange("AccessibleVisibleData", string3, string);
            String string4 = accessibleContext.getAccessibleName();
            if (string4 != string2) {
                accessibleContext.firePropertyChange("AccessibleName", string2, string4);
            }
        }
        this.invalidate();
        this.repaint();
    }

    public boolean getState() {
        return this._state;
    }

    public void setState(boolean bl) {
        LWCheckboxGroup lWCheckboxGroup = this._group;
        if (lWCheckboxGroup != null && bl) {
            lWCheckboxGroup.setSelectedCheckbox(this);
        }
        this.setStateInternal(bl, false);
    }

    @Override
    public Object[] getSelectedObjects() {
        if (this.getState()) {
            Object[] objectArray = new Object[]{this.getLabel()};
            return objectArray;
        }
        return null;
    }

    public LWCheckboxGroup getCheckboxGroup() {
        return this._group;
    }

    public void setCheckboxGroup(LWCheckboxGroup lWCheckboxGroup) {
        LWCheckboxGroup lWCheckboxGroup2 = this._group;
        boolean bl = this.getState();
        if (lWCheckboxGroup2 != null && bl) {
            lWCheckboxGroup2.setSelectedCheckbox(null);
        }
        this._group = lWCheckboxGroup;
        if (lWCheckboxGroup != null && bl) {
            lWCheckboxGroup.setSelectedCheckbox(this);
        }
        if (lWCheckboxGroup2 == null != (lWCheckboxGroup == null)) {
            this.updateUI();
            this.invalidate();
            this.repaint();
        }
    }

    @Override
    public synchronized void addItemListener(ItemListener itemListener) {
        if (this._listeners == null) {
            this._listeners = new ListenerManager();
        }
        this._listeners.addListener(itemListener);
    }

    @Override
    public synchronized void removeItemListener(ItemListener itemListener) {
        this._listeners.removeListener(itemListener);
    }

    @Override
    public boolean isFocusTraversable() {
        return true;
    }

    @Override
    protected Painter getPainter() {
        return ((ToggleButtonUI)this.getUI()).getPainter(this);
    }

    @Override
    protected void processEventImpl(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ItemEvent) {
            this.processItemEvent((ItemEvent)aWTEvent);
        } else {
            super.processEventImpl(aWTEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processKeyEvent(KeyEvent keyEvent) {
        int n;
        super.processKeyEvent(keyEvent);
        if (keyEvent.isConsumed()) {
            return;
        }
        LWCheckboxGroup lWCheckboxGroup = this.getCheckboxGroup();
        if (lWCheckboxGroup != null && keyEvent.getID() == 401 && !keyEvent.isAltDown() && (n = keyEvent.getKeyCode()) >= 37 && n <= 40) {
            boolean bl = n == 37 || n == 38;
            AbstractButton abstractButton = null;
            Object object = this.getTreeLock();
            synchronized (object) {
                Container container = this.getParent();
                if (container != null) {
                    Component[] componentArray = container.getComponents();
                    int n2 = 0;
                    while (componentArray[n2] != this) {
                        ++n2;
                    }
                    if (n == 37 || n == 38) {
                        while (--n2 >= 0) {
                            Component component = componentArray[n2];
                            if (!component.isEnabled() || !component.isVisible() || !(component instanceof LWCheckbox) || ((LWCheckbox)component).getCheckboxGroup() != lWCheckboxGroup) continue;
                            abstractButton = (LWCheckbox)component;
                            break;
                        }
                    } else {
                        while (++n2 < componentArray.length) {
                            Component component = componentArray[n2];
                            if (!component.isEnabled() || !component.isVisible() || !(component instanceof LWCheckbox) || ((LWCheckbox)component).getCheckboxGroup() != lWCheckboxGroup) continue;
                            abstractButton = (LWCheckbox)component;
                            break;
                        }
                    }
                }
            }
            if (abstractButton != null) {
                abstractButton.requestFocus();
                ((LWCheckbox)abstractButton).activate(keyEvent.getModifiers());
                keyEvent.consume();
            }
        }
    }

    protected void processItemEvent(ItemEvent itemEvent) {
        Enumeration enumeration;
        ListenerManager listenerManager = this._listeners;
        if (listenerManager != null && (enumeration = listenerManager.getListeners()) != null) {
            while (enumeration.hasMoreElements()) {
                ItemListener itemListener = (ItemListener)enumeration.nextElement();
                itemListener.itemStateChanged(itemEvent);
            }
        }
    }

    @Override
    protected void activate(int n) {
        if (this._group != null) {
            if (this.getState()) {
                this.repaint();
            } else {
                this._group.setSelectedCheckboxInternal(this, true);
            }
        } else {
            this.setStateInternal(!this.getState(), true);
        }
    }

    @Override
    protected String paramString() {
        String string = super.paramString();
        String string2 = this._label;
        if (string2 != null) {
            string = string + ",label=" + string2;
        }
        return string + ",state=" + this._state;
    }

    @Override
    protected boolean isArmed() {
        return this._armed;
    }

    @Override
    protected void setArmed(boolean bl) {
        if (this._armed != bl) {
            this._armed = bl;
            this.paintImmediate();
        }
    }

    @Override
    protected AccessibleContext createAccessibleContext() {
        return new AccessibleLWCheckbox();
    }

    @Override
    protected String getDefaultName() {
        return this.getBaseClassName() + _sInstanceCounter++;
    }

    void setStateInternal(boolean bl, boolean bl2) {
        if (bl != this._state) {
            AccessibleContext accessibleContext;
            this._state = bl;
            this.repaint();
            if (bl2) {
                this.processEvent(new ItemEvent(this, 701, this._label, bl ? 1 : 2));
            }
            if ((accessibleContext = this.accessAccessibleContext()) != null) {
                AccessibleState accessibleState = AccessibleState.CHECKED;
                accessibleContext.firePropertyChange("AccessibleState", bl ? null : accessibleState, bl ? accessibleState : null);
            }
        }
    }

    private void _init(String string, boolean bl, LWCheckboxGroup lWCheckboxGroup) {
        this.enableEvents(512L);
        this._label = string;
        this._state = bl;
        this._group = lWCheckboxGroup;
        if (bl && lWCheckboxGroup != null) {
            lWCheckboxGroup.setSelectedCheckbox(this);
        }
        this.updateUI(LWCheckbox.class);
    }

    private class AccessibleLWCheckbox
    extends AbstractButton.AccessibleAbstractButton
    implements AccessibleValue {
        private AccessibleLWCheckbox() {
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            if (LWCheckbox.this.getCheckboxGroup() != null) {
                return AccessibleRole.RADIO_BUTTON;
            }
            return AccessibleRole.CHECK_BOX;
        }

        @Override
        public AccessibleValue getAccessibleValue() {
            return this;
        }

        @Override
        public Number getCurrentAccessibleValue() {
            return IntegerUtils.getInteger(LWCheckbox.this.getState() ? 1 : 0);
        }

        @Override
        public boolean setCurrentAccessibleValue(Number number) {
            LWCheckbox.this.setState(number.intValue() != 0);
            return true;
        }

        @Override
        public Number getMinimumAccessibleValue() {
            return IntegerUtils.getInteger(0);
        }

        @Override
        public Number getMaximumAccessibleValue() {
            return IntegerUtils.getInteger(1);
        }
    }
}

