/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.lwAWT;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import oracle.ewt.ColorScheme;
import oracle.ewt.LookAndFeel;
import oracle.ewt.UIDefaults;
import oracle.ewt.UIManager;
import oracle.ewt.access.AccessibleComponentImpl;
import oracle.ewt.event.AnyEventListener;
import oracle.ewt.event.AnyEventMulticaster;
import oracle.ewt.help.HelpCapable;
import oracle.ewt.help.HelpProvider;
import oracle.ewt.lwAWT.DoubleBuffer;
import oracle.ewt.lwAWT.DoubleBufferer;
import oracle.ewt.lwAWT.ImmediatePainter;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.lwAWT.NullDoubleBuffer;
import oracle.ewt.lwAWT.SharedPainter;
import oracle.ewt.lwAWT.VComponentPaintContext;
import oracle.ewt.lwAWT.VirtualComponent;
import oracle.ewt.lwAWT.WaitingDoubleBuffer;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.painter.Painter;
import oracle.ewt.popup.PopupPanel;
import oracle.ewt.util.FocusUtils;
import oracle.ewt.util.ImmInsets;
import oracle.ewt.util.LocaleUtils;
import oracle.ewt.util.WindowUtils;

public class BufferedPanel
extends PopupPanel
implements ImmediatePainter,
DoubleBufferer,
HelpCapable,
VirtualComponent,
Accessible {
    private static int _sInstanceCounter = 0;
    private SharedPainter _painter;
    private AnyEventListener _anyListener;
    private static DoubleBuffer _sDoubleBuffer;
    private LookAndFeel _laf = UIManager.getLookAndFeel();
    private ColorScheme _colorScheme = this._laf.getDefaultColorScheme();
    private Object _helpBook;
    private String _helpTopic;
    private HelpProvider _helpProvider;
    private PaintContext _paintContext;
    private int _readingDirection = -1;
    private boolean _isReadingDirectionDefaulted = true;
    private boolean _isLocaleDefaulted = true;
    private transient AccessibleContext _accessibleContext;

    public BufferedPanel() {
        this.setName(this.getDefaultName());
        this._painter = new SharedPainter(this, this.getUIDefaults().getPainter(LookAndFeel.BACKGROUND_PAINTER));
        this.setReadingDirection(0);
    }

    @Override
    public void setLookAndFeel(LookAndFeel lookAndFeel) {
        if (lookAndFeel == null) {
            lookAndFeel = UIManager.getLookAndFeel();
        }
        if (this._laf != lookAndFeel) {
            this._laf = lookAndFeel;
            if (this._colorScheme != null) {
                this._colorScheme = lookAndFeel.getColorScheme(this._colorScheme);
            }
        }
    }

    @Override
    public LookAndFeel getLookAndFeel() {
        return this._laf;
    }

    @Override
    public void setColorScheme(ColorScheme colorScheme) {
        this._colorScheme = colorScheme;
    }

    @Override
    public ColorScheme getColorScheme() {
        return this._colorScheme;
    }

    public synchronized void addAnyEventListener(AnyEventListener anyEventListener) {
        this._anyListener = AnyEventMulticaster.add(this._anyListener, anyEventListener);
    }

    public synchronized void removeAnyEventListener(AnyEventListener anyEventListener) {
        this._anyListener = AnyEventMulticaster.remove(this._anyListener, anyEventListener);
    }

    @Override
    public String getHelpTopic() {
        HelpCapable helpCapable;
        String string = this._helpTopic;
        if (string != null) {
            return string;
        }
        if (this._helpBook == null && this._helpProvider == null && (helpCapable = LWComponent._getParentHelpCapable(this)) != null) {
            return helpCapable.getHelpTopic();
        }
        return null;
    }

    public void setHelpTopic(String string) {
        this._helpTopic = string;
    }

    @Override
    public Object getHelpBook() {
        HelpCapable helpCapable;
        Object object = this._helpBook;
        if (object != null) {
            return object;
        }
        if (this._helpProvider == null && (helpCapable = LWComponent._getParentHelpCapable(this)) != null) {
            return helpCapable.getHelpBook();
        }
        return null;
    }

    public void setHelpBook(Object object) {
        this._helpBook = object;
    }

    @Override
    public HelpProvider getHelpProvider() {
        HelpProvider helpProvider = this._helpProvider;
        if (helpProvider == null) {
            HelpCapable helpCapable = LWComponent._getParentHelpCapable(this);
            if (helpCapable != null) {
                helpProvider = helpCapable.getHelpProvider();
            }
            if (helpProvider == null) {
                helpProvider = LWComponent.getDefaultHelpProvider();
            }
        }
        return helpProvider;
    }

    public void setHelpProvider(HelpProvider helpProvider) {
        this._helpProvider = helpProvider;
    }

    @Override
    public void showHelp() {
        this._painter.showHelp();
    }

    @Override
    public void setLocale(Locale locale) {
        Locale locale2 = LocaleUtils.getDefaultableLocale(this);
        Locale locale3 = locale;
        if (locale == null) {
            this._isLocaleDefaulted = true;
            Container container = this.getParent();
            if (container != null) {
                locale3 = LocaleUtils.getDefaultableLocale(container);
            }
        } else {
            this._isLocaleDefaulted = false;
        }
        if (!locale3.equals(locale2)) {
            this.updateLocale(locale3, locale2);
        } else {
            super.setLocale(locale);
        }
    }

    public void setReadingDirection(int n) {
        this._setReadingDirection(n, true);
    }

    public int getReadingDirection() {
        if (this._isReadingDirectionDefaulted) {
            return 0;
        }
        return this._readingDirection;
    }

    @Override
    public int getActualReadingDirection() {
        return this._readingDirection;
    }

    public void setFill(Painter painter) {
        this._painter.setFill(painter);
    }

    public Painter getFill() {
        return this._painter.getFill();
    }

    @Override
    public BorderPainter getBorderPainter() {
        return null;
    }

    @Override
    public boolean isTransparent() {
        return false;
    }

    public boolean isPaintPropagationRequired() {
        return false;
    }

    @Override
    public final Insets insets() {
        return this.getInsets();
    }

    @Override
    public final Insets getInsets() {
        return this.getBorderInsets().toInsets();
    }

    public final ImmInsets getBorderInsets() {
        BorderPainter borderPainter = this.getBorderPainter();
        if (borderPainter != null) {
            return borderPainter.getInsets(this.getPaintContext());
        }
        return ImmInsets.getEmptyInsets();
    }

    @Override
    public void freezeRepaints() {
        this._painter.freezeRepaints();
    }

    @Override
    public void unfreezeRepaints() {
        this._painter.unfreezeRepaints(this.getDoubleBuffer());
    }

    public void paintImmediate(int n, int n2, int n3, int n4) {
        this._painter.paintImmediate(n, n2, n3, n4, this.getDoubleBuffer());
    }

    @Override
    public void paintImmediateUnclipped(int n, int n2, int n3, int n4) {
        this.paintImmediate(n, n2, n3, n4);
    }

    @Override
    public boolean isChildClipped(Component component) {
        return this._painter.isChildClipped(component);
    }

    @Override
    public void repaint(long l, int n, int n2, int n3, int n4) {
        if (this._painter != null && this._painter.repaint(n, n2, n3, n4)) {
            super.repaint(l, n, n2, n3, n4);
        }
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.isShowing()) {
            this._painter.paint(graphics, this.getDoubleBuffer(), this);
        }
    }

    @Override
    public void paintInterior(Graphics graphics) {
    }

    @Override
    public UIDefaults getUIDefaults() {
        return this._laf.getDefaults(this.getPaintContext());
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this._accessibleContext == null) {
            this._accessibleContext = new Access();
        }
        return this._accessibleContext;
    }

    @Override
    public boolean isActive() {
        return WindowUtils.getWindow(this) == WindowUtils.getActiveWindow();
    }

    @Override
    public PaintContext getPaintContext() {
        if (this._paintContext == null) {
            this._paintContext = new VComponentPaintContext(this);
        }
        return this._paintContext;
    }

    @Override
    public PaintContext getBorderContext() {
        return this.getPaintContext();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this._isLocaleDefaulted) {
            Locale locale = LocaleUtils.getDefaultableLocale(this);
            super.setLocale(locale);
            this.updateLocale(locale, Locale.getDefault());
        }
    }

    @Override
    public void invalidate() {
        if (this._painter != null) {
            this._painter.clearClipCache();
        }
        super.invalidate();
    }

    @Override
    public void doLayout() {
        this._painter.clearClipCache();
        super.doLayout();
    }

    @Override
    public void reshape(int n, int n2, int n3, int n4) {
        Dimension dimension = null;
        if ((this.getFill().getRepaintFlags(this.getPaintContext()) & 0x80) != 0) {
            dimension = this.getSize();
        }
        super.reshape(n, n2, n3, n4);
        if (dimension != null && (dimension.width != n3 || dimension.height != n4)) {
            this.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(int n) {
        Component component;
        Object object = this.getTreeLock();
        synchronized (object) {
            component = this.getComponent(n);
            if (!component.isLightweight()) {
                component = null;
            }
            super.remove(n);
            this._painter.remove(n);
        }
        if (component != null && component.isVisible()) {
            object = component.getBounds();
            this.repaint(((Rectangle)object).x, ((Rectangle)object).y, ((Rectangle)object).width, ((Rectangle)object).height);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAll() {
        Rectangle rectangle;
        Object object = this.getTreeLock();
        synchronized (object) {
            rectangle = LWComponent._getLWChildBounds(this);
            super.removeAll();
            this._painter.removeAll();
        }
        if (rectangle != null) {
            this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    @Override
    public void removeNotify() {
        boolean bl = false;
        bl = LWComponent._loseFocusIfChild(this);
        super.removeNotify();
        if (bl) {
            this.transferFocus();
        }
        if (FocusUtils.areNewFocusAPIsAvailable()) {
            this.getDoubleBuffer().flush();
            LWComponent._flushDoubleBuffer(this);
        }
    }

    protected void updateLocale(Locale locale, Locale locale2) {
        super.setLocale(locale);
        if (this._isReadingDirectionDefaulted) {
            this._setReadingDirection(0, false);
        }
        this._painter.propagateLocale(locale, locale2);
    }

    @Override
    protected final void processEvent(AWTEvent aWTEvent) {
        AnyEventListener anyEventListener = this._anyListener;
        if (anyEventListener != null) {
            anyEventListener.processEventStart(aWTEvent);
        }
        this.processEventImpl(aWTEvent);
        if (anyEventListener != null) {
            anyEventListener.processEventEnd(aWTEvent);
        }
    }

    protected void processEventImpl(AWTEvent aWTEvent) {
        super.processEvent(aWTEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addImpl(Component component, Object object, int n) {
        Object object2 = this.getTreeLock();
        synchronized (object2) {
            super.addImpl(component, object, n);
            this._painter.add(component, n);
        }
        if (component.isLightweight() && component.isVisible()) {
            component.repaint();
        }
    }

    protected DoubleBuffer getDoubleBuffer() {
        return BufferedPanel._getDoubleBuffer();
    }

    protected String getDefaultName() {
        return this.getBaseClassName() + _sInstanceCounter++;
    }

    protected String getBaseClassName() {
        String string = this.getClass().getName();
        return string.substring(string.lastIndexOf(46) + 1);
    }

    static DoubleBuffer _getDoubleBuffer() {
        if (LWComponent.isDoubleBufferingEnabled()) {
            if (_sDoubleBuffer == null) {
                _sDoubleBuffer = new WaitingDoubleBuffer();
            }
            return _sDoubleBuffer;
        }
        return NullDoubleBuffer.getDoubleBuffer();
    }

    private void _setReadingDirection(int n, boolean bl) {
        if (n == 0) {
            this._isReadingDirectionDefaulted = true;
            Container container = this.getParent();
            n = this._isLocaleDefaulted && container instanceof VirtualComponent ? ((VirtualComponent)((Object)container)).getActualReadingDirection() : LocaleUtils.getReadingDirectionForLocale(LocaleUtils.getDefaultableLocale(this));
        } else {
            this._isReadingDirectionDefaulted = false;
        }
        if (n != this._readingDirection) {
            this._readingDirection = n;
            if (bl) {
                this._painter.propagateReadingDirection(n);
            }
        }
    }

    private class Access
    extends AccessibleComponentImpl {
        public Access() {
            super(BufferedPanel.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PANEL;
        }
    }
}

