/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.laf.oracle;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import oracle.ewt.UIDefaults;
import oracle.ewt.laf.oracle.OracleColorScheme;
import oracle.ewt.painter.AbstractBorderPainter;
import oracle.ewt.painter.NullPainter;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.painter.Painter;
import oracle.ewt.util.ImmInsets;

class OracleGroupBoxPainter
extends AbstractBorderPainter {
    public static final int TOP_SIDE = 0;
    public static final int LEFT_SIDE = 1;
    public static final int BOTTOM_SIDE = 2;
    public static final int RIGHT_SIDE = 3;
    private static final int _LABEL_INSET = 10;
    private static final int _BORDER_INSET = 3;
    private static final int _CORNER_INSET = 3;
    private Painter _labelPainter;
    private float _alignment;
    private int _side;

    public OracleGroupBoxPainter() {
        this(null, null);
    }

    public OracleGroupBoxPainter(Painter painter, Painter painter2) {
        this(painter, painter2, 0.0f);
    }

    public OracleGroupBoxPainter(Painter painter, Painter painter2, float f) {
        this(painter, painter2, f, 0);
    }

    public OracleGroupBoxPainter(Painter painter, Painter painter2, float f, int n) {
        super(painter);
        if (painter2 == null) {
            painter2 = NullPainter.getPainter();
        }
        this._labelPainter = painter2;
        this._alignment = f;
        this._side = n;
    }

    public Painter getLabelPainter() {
        return this._labelPainter;
    }

    @Override
    protected ImmInsets getOwnInsets(PaintContext paintContext) {
        int n = 3;
        int n2 = 3;
        int n3 = 3;
        int n4 = 3;
        Dimension dimension = this._labelPainter.getPreferredSize(paintContext);
        switch (this._side) {
            case 0: {
                if (n >= dimension.height) break;
                n = dimension.height;
                break;
            }
            case 1: {
                if (n2 >= dimension.width) break;
                n2 = dimension.width;
                break;
            }
            case 2: {
                if (n3 >= dimension.height) break;
                n3 = dimension.height;
                break;
            }
            case 3: {
                if (n4 >= dimension.width) break;
                n4 = dimension.width;
            }
        }
        return new ImmInsets(n, n2, n3, n4);
    }

    @Override
    public void paintBorder(PaintContext paintContext, Graphics graphics, int n, int n2, int n3, int n4) {
        Rectangle rectangle = this._getLabelBounds(paintContext, n, n2, n3, n4);
        Color color = graphics.getColor();
        UIDefaults uIDefaults = paintContext.getPaintUIDefaults();
        graphics.setColor(uIDefaults.getColor(OracleColorScheme.GROUP_BOX_TEXT));
        this._labelPainter.paint(paintContext, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setColor(uIDefaults.getColor(OracleColorScheme.GROUP_BOX));
        int n5 = n + n3 - 1;
        int n6 = n2 + n4 - 1;
        int n7 = this._side;
        if (n7 == 0 || n7 == 2) {
            int n8 = rectangle.height / 2;
            int n9 = n7 == 0 ? (n2 += n8) : (n6 -= n8);
            graphics.drawLine(n + 3, n9, rectangle.x, n9);
            graphics.drawLine(rectangle.x + rectangle.width, n9, n5 - 3, n9);
        } else {
            int n10 = rectangle.width / 2;
            int n11 = n7 == 1 ? (n += n10) : (n5 -= n10);
            graphics.drawLine(n11, n2 + 3, n11, rectangle.y);
            graphics.drawLine(n11, rectangle.y + rectangle.height, n11, n6 - 3);
        }
        graphics.drawLine(n, n2 + 3, n + 3, n2);
        graphics.drawLine(n + 1, n2 + 1, n + 1, n2 + 1);
        graphics.drawLine(n5 - 3, n2, n5, n2 + 3);
        graphics.drawLine(n5 - 1, n2 + 1, n5 - 1, n2 + 1);
        graphics.drawLine(n, n6 - 3, n + 3, n6);
        graphics.drawLine(n + 1, n6 - 1, n + 1, n6 - 1);
        graphics.drawLine(n5 - 3, n6, n5, n6 - 3);
        graphics.drawLine(n5 - 1, n6 - 1, n5 - 1, n6 - 1);
        if (n7 != 0) {
            graphics.drawLine(n + 3, n2, n5 - 3, n2);
        }
        if (n7 != 1) {
            graphics.drawLine(n, n2 + 3, n, n6 - 3);
        }
        if (n7 != 2) {
            graphics.drawLine(n + 3, n6, n5 - 3, n6);
        }
        if (n7 != 3) {
            graphics.drawLine(n5, n2 + 3, n5, n6 - 3);
        }
        graphics.setColor(color);
    }

    @Override
    protected Painter getBorderPainterAt(PaintContext paintContext, int n, int n2, int n3, int n4, Painter painter) {
        Rectangle rectangle = this._getLabelBounds(paintContext, n3, n4, n, n2);
        Painter painter2 = this._labelPainter.getPainterAt(paintContext, rectangle.width, rectangle.height, n3 - rectangle.x, n4 - rectangle.y, painter);
        if (painter == this && painter2 != null) {
            painter2 = this;
        }
        return painter2;
    }

    @Override
    public boolean isBorderTransparent(PaintContext paintContext) {
        return true;
    }

    @Override
    public int getRepaintFlags(PaintContext paintContext) {
        return this._labelPainter.getRepaintFlags(paintContext);
    }

    @Override
    public int getInvalidateFlags(PaintContext paintContext) {
        return this._labelPainter.getInvalidateFlags(paintContext);
    }

    private Rectangle _getLabelBounds(PaintContext paintContext, int n, int n2, int n3, int n4) {
        Rectangle rectangle = new Rectangle();
        Dimension dimension = this._labelPainter.getPreferredSize(paintContext);
        int n5 = dimension.width;
        int n6 = dimension.height;
        int n7 = 0;
        int n8 = this._side;
        if (n8 == 0 || n8 == 2) {
            if (n6 < 3) {
                n7 = 1;
            }
            int n9 = n8 == 0 ? n7 : (rectangle.y = n4 - (n7 == 0 ? n6 : n7));
            if ((n3 -= 20) < n5) {
                n5 = n3;
                rectangle.x = 10;
            } else {
                rectangle.x = 10 + (int)((float)(n3 - n5) * this._alignment);
            }
        } else {
            if (n5 < 3) {
                n7 = 1;
            }
            int n10 = n8 == 1 ? n7 : (rectangle.x = n3 - (n7 == 0 ? n5 : n7));
            if ((n4 -= 20) < n6) {
                n6 = n4;
                rectangle.y = 10;
            } else {
                rectangle.y = 10 + (int)((float)(n4 - n6) * this._alignment);
            }
        }
        rectangle.x += n;
        rectangle.y += n2;
        rectangle.width = n5;
        rectangle.height = n6;
        return rectangle;
    }
}

