/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.laf.oracle;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import oracle.ewt.LookAndFeel;
import oracle.ewt.UIDefaults;
import oracle.ewt.comboBox.ComboBox;
import oracle.ewt.laf.oracle.ComboBoxBorderPainter;
import oracle.ewt.laf.oracle.ComboBoxButtonBorder;
import oracle.ewt.laf.oracle.OracleChoiceUI;
import oracle.ewt.laf.oracle.OracleLookAndFeel;
import oracle.ewt.laf.oracle.OraclePopupMenuBorder;
import oracle.ewt.lwAWT.LWChoice;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.lwAWT.LWDataSourceList;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.ewt.painter.NullPainter;
import oracle.ewt.painter.Painter;
import oracle.ewt.plaf.ComboBoxUI;
import oracle.ewt.popup.PopupOwner;
import oracle.ewt.popup.PopupUtils;
import oracle.ewt.util.ImmInsets;

public class OracleComboBoxUI
extends OracleChoiceUI
implements ComboBoxUI {
    private static final BorderPainter _COMBO_BORDER = new ComboBoxBorderPainter();
    private static final BorderPainter _BUTTON_BORDER = new ComboBoxButtonBorder();
    private static final ImmInsets _BUTTON_INSETS = new ImmInsets(-1, -1, -1, -1);
    private static FixedBorderPainter _sFieldPainter;
    private static Painter _sComboButtonPainter;

    public OracleComboBoxUI(LWComponent lWComponent) {
        super(lWComponent);
    }

    @Override
    public BorderPainter getFieldBorderPainter(LWComponent lWComponent) {
        if (_sFieldPainter == null) {
            _sFieldPainter = new FixedBorderPainter(null, 1, 2, 1, 1, true);
        }
        return _sFieldPainter;
    }

    @Override
    public Painter getPainter(LWComponent lWComponent) {
        if (this._isEditable(lWComponent)) {
            return NullPainter.getPainter();
        }
        return super.getPainter(lWComponent);
    }

    @Override
    public BorderPainter getDefaultBorderPainter(LWComponent lWComponent) {
        if (this._isEditable(lWComponent)) {
            return _COMBO_BORDER;
        }
        return super.getDefaultBorderPainter(lWComponent);
    }

    @Override
    public BorderPainter getButtonBorderPainter(LWComponent lWComponent) {
        if (this._isEditable(lWComponent)) {
            return _BUTTON_BORDER;
        }
        return super.getButtonBorderPainter(lWComponent);
    }

    @Override
    public ImmInsets getButtonInsets(LWComponent lWComponent) {
        if (this._isEditable(lWComponent)) {
            return _BUTTON_INSETS;
        }
        return ImmInsets.getEmptyInsets();
    }

    @Override
    public Color getDefaultBackground(LWComponent lWComponent) {
        OracleLookAndFeel oracleLookAndFeel = (OracleLookAndFeel)lWComponent.getLookAndFeel();
        UIDefaults uIDefaults = oracleLookAndFeel.__getLightDefaults(lWComponent);
        if (this._isEditable(lWComponent)) {
            return uIDefaults.getColor(LookAndFeel.TEXT);
        }
        return uIDefaults.getColor(LookAndFeel.CONTROL);
    }

    @Override
    protected BorderPainter getListBorderPainter(LWComponent lWComponent) {
        if (this._isEditable(lWComponent)) {
            return OraclePopupMenuBorder.getRaisedBorderPainter();
        }
        return super.getListBorderPainter(lWComponent);
    }

    protected boolean tryAlternateStrategy(LWChoice lWChoice, LWDataSourceList lWDataSourceList, Rectangle rectangle, Dimension dimension, Dimension dimension2, int n, int n2) {
        if (n2 == 1) {
            int n3 = 17;
            rectangle.setLocation(n, -2);
            PopupOwner popupOwner = PopupUtils.displayPopupRelativeTo((Component)lWChoice, (Component)lWDataSourceList, rectangle, dimension, dimension2, n3);
            if (popupOwner != null) {
                return true;
            }
            n3 = 16;
            rectangle.setLocation(n, 2);
            popupOwner = PopupUtils.displayPopupRelativeTo((Component)lWChoice, (Component)lWDataSourceList, rectangle, dimension, dimension2, n3);
            if (popupOwner != null) {
                return true;
            }
        }
        return false;
    }

    private boolean _isEditable(LWComponent lWComponent) {
        return ((ComboBox)lWComponent).isEditable();
    }
}

