/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.laf.generic;

import oracle.ewt.UIDefaults;
import oracle.ewt.laf.basic.BasicComponentUI;
import oracle.ewt.laf.generic.GenericInsetBorderPainter;
import oracle.ewt.laf.generic.GenericScrollArrowPainter;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.lwAWT.LWScrollbar;
import oracle.ewt.painter.FGBGColorChange;
import oracle.ewt.painter.FilledRectPainter;
import oracle.ewt.painter.FixedImagePainter;
import oracle.ewt.painter.Painter;
import oracle.ewt.painter.PainterTiler;
import oracle.ewt.plaf.ScrollBarUI;

public class GenericScrollBarUI
extends BasicComponentUI
implements ScrollBarUI {
    private static Painter _sThumbPainter;
    private static Painter _sTrackPainter;
    private static final Painter _BLOCK_TRACK_PAINTER;

    public GenericScrollBarUI(LWComponent lWComponent) {
        super(lWComponent);
    }

    @Override
    public Painter getIncrementPainter(LWComponent lWComponent) {
        int n = this._isHorizontal(lWComponent) ? 3 : 1;
        return GenericScrollArrowPainter.getPainter(n);
    }

    @Override
    public Painter getDecrementPainter(LWComponent lWComponent) {
        int n = this._isHorizontal(lWComponent) ? 2 : 0;
        return GenericScrollArrowPainter.getPainter(n);
    }

    @Override
    public Painter getThumbPainter(LWComponent lWComponent) {
        if (_sThumbPainter == null) {
            _sThumbPainter = new GenericInsetBorderPainter(new FGBGColorChange(FilledRectPainter.getPainter(), false), true, false);
        }
        return _sThumbPainter;
    }

    @Override
    public Painter getTrackPainter(LWComponent lWComponent) {
        if (_sTrackPainter == null) {
            UIDefaults uIDefaults = this.getUIDefaults(lWComponent);
            _sTrackPainter = new PainterTiler(new FixedImagePainter(uIDefaults.getImage("ScrollBar.alleyImage")));
        }
        return _sTrackPainter;
    }

    @Override
    public Painter getThumbDragPainter(LWComponent lWComponent) {
        return this.getThumbPainter(lWComponent);
    }

    @Override
    public Painter getBlockTrackPainter(LWComponent lWComponent) {
        return _BLOCK_TRACK_PAINTER;
    }

    private boolean _isHorizontal(LWComponent lWComponent) {
        return ((LWScrollbar)lWComponent).getOrientation() == 0;
    }

    static {
        _BLOCK_TRACK_PAINTER = new FGBGColorChange(FilledRectPainter.getPainter(), true);
    }
}

