/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.laf.basic;

import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import javax.accessibility.AccessibleContext;
import oracle.bali.share.util.IntegerUtils;
import oracle.ewt.UIDefaults;
import oracle.ewt.button.PushButton;
import oracle.ewt.graphics.ImageSet;
import oracle.ewt.graphics.SynthesizingImageSet;
import oracle.ewt.laf.basic.BasicComponentUI;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.lwAWT.lwMenu.LWMenuItem;
import oracle.ewt.lwAWT.lwMenu.LWPopupMenu;
import oracle.ewt.lwAWT.lwMenu.LWPopupMenuAdapter;
import oracle.ewt.lwAWT.lwMenu.LWPopupMenuEvent;
import oracle.ewt.plaf.TabBarUI;
import oracle.ewt.tabBar.TabBar;
import oracle.ewt.tabBar.TabBarItem;
import oracle.ewt.util.ComponentUtils;
import oracle.ewt.util.LocaleUtils;

public abstract class BasicTabBarUI
extends BasicComponentUI
implements TabBarUI {
    private static final boolean isAtLeastJava11;
    static final int[] _sTopJustifications;
    static final int[] _sBottomJustifications;
    static final int[] _sLeftJustifications;
    static final int[] _sRightJustifications;

    protected BasicTabBarUI(LWComponent lWComponent) {
        super(lWComponent);
    }

    @Override
    public PushButton getScrollButton(LWComponent lWComponent) {
        Scroller scroller = new Scroller((TabBar)lWComponent);
        scroller.setImageSet(this.getScrollImageSet(lWComponent, true, false));
        return scroller;
    }

    @Override
    public void showDropDownMenu(LWComponent lWComponent, LWComponent lWComponent2) {
        if (lWComponent2 instanceof Scroller) {
            ((Scroller)lWComponent2).showPopup();
        }
    }

    @Override
    public ImageSet getScrollImageSet(LWComponent lWComponent, boolean bl, boolean bl2) {
        UIDefaults uIDefaults = this.getUIDefaults(lWComponent);
        Image image = bl ? uIDefaults.getImage("TabBar.scrollLeft") : (bl2 ? uIDefaults.getImage("TabBar.scrollRight") : uIDefaults.getImage("TabBar.scrollBoth"));
        if (image != null) {
            return new SynthesizingImageSet(image);
        }
        return null;
    }

    static /* synthetic */ boolean access$100() {
        return isAtLeastJava11;
    }

    static {
        String string = System.getProperty("java.version");
        isAtLeastJava11 = !string.startsWith("1.") && !string.startsWith("9") && !string.startsWith("10");
        _sTopJustifications = new int[]{22};
        _sBottomJustifications = new int[]{21};
        _sLeftJustifications = new int[]{14};
        _sRightJustifications = new int[]{5};
    }

    private static class Menu
    extends LWPopupMenu {
        private Menu() {
        }

        @Override
        protected AccessibleContext createAccessibleContext() {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("oracle.ewt.access.resource.AccessibilityBundle", LocaleUtils.getTranslationLocale(this.getLocale()));
            String string = resourceBundle.getString("TABBAR.MENU_NAME");
            AccessibleContext accessibleContext = super.createAccessibleContext();
            accessibleContext.setAccessibleName(string);
            return accessibleContext;
        }

        @Override
        protected void processGrabbedMouseEvent(MouseEvent mouseEvent) {
            Component component = this.getMenuInvoker().getInvokerComponent();
            Component component2 = mouseEvent.getComponent();
            int n = mouseEvent.getID();
            if (n == 501) {
                super.processGrabbedMouseEvent(mouseEvent);
                if (component2 == component) {
                    mouseEvent.consume();
                }
            } else if (n == 502) {
                Component component3 = ComponentUtils.getTargetComponentOutside(component2, new Point(mouseEvent.getX(), mouseEvent.getY()));
                if (component3 != component) {
                    super.processGrabbedMouseEvent(mouseEvent);
                }
            } else {
                super.processGrabbedMouseEvent(mouseEvent);
            }
        }
    }

    public static class Scroller
    extends PushButton
    implements ActionListener {
        private LWPopupMenu _menu;
        private TabBar _bar;

        public Scroller(TabBar tabBar) {
            this.setFocusable(false);
            this._bar = tabBar;
        }

        public void showPopup() {
            LWPopupMenu lWPopupMenu = this._menu;
            if (lWPopupMenu != null && lWPopupMenu.isPoppedUp()) {
                return;
            }
            lWPopupMenu = new Menu();
            lWPopupMenu.setReadingDirection(this.getActualReadingDirection());
            Container container = lWPopupMenu.getContent();
            Font font = this._bar.getFont();
            Font font2 = new Font(font.getName(), font.getStyle() | 1, font.getSize());
            UIDefaults uIDefaults = this.getUIDefaults();
            for (int i = 0; i < this._bar.getItemCount(); ++i) {
                TabBarItem tabBarItem = this._bar.getItem(i);
                if (!tabBarItem.isVisible()) continue;
                LWMenuItem lWMenuItem = new LWMenuItem();
                lWMenuItem.setLabel(tabBarItem.getLabel());
                lWMenuItem.setMnemonicIndex(tabBarItem.getMnemonicIndex());
                lWMenuItem.setActionCommand(IntegerUtils.getString(i));
                lWMenuItem.addActionListener(this);
                boolean bl = this._isItemVisible(tabBarItem);
                if (this._isItemVisible(tabBarItem)) {
                    lWMenuItem.setFont(font2);
                    lWMenuItem.setImageSet(uIDefaults.getImageSet("TabBar.visible"));
                } else {
                    lWMenuItem.setFont(font);
                }
                lWMenuItem.setEnabled(tabBarItem.isEnabled());
                container.add(lWMenuItem);
                if (!tabBarItem.isSelected()) continue;
                lWMenuItem.setSelected(true);
            }
            this._menu = lWPopupMenu;
            lWPopupMenu.addPopupMenuListener(new LWPopupMenuAdapter(){

                @Override
                public void menuPoppedDown(LWPopupMenuEvent lWPopupMenuEvent) {
                    this.repaint();
                }
            });
            int[] nArray = this._bar.getOrientation() == 0 ? _sTopJustifications : (this._bar.getOrientation() == 1 ? _sBottomJustifications : (this._bar.getOrientation() == 2 ? _sLeftJustifications : _sRightJustifications));
            lWPopupMenu.popup((Component)this, nArray, null);
            this.repaint();
        }

        @Override
        protected boolean isArmed() {
            LWPopupMenu lWPopupMenu = this._menu;
            return super.isArmed() || lWPopupMenu != null && lWPopupMenu.isPoppedUp();
        }

        @Override
        protected void setArmed(boolean bl) {
            super.setArmed(bl);
            if (bl) {
                this.showPopup();
                LWPopupMenu lWPopupMenu = this._menu;
                if (lWPopupMenu != null) {
                    lWPopupMenu.addPopupMenuListener(new LWPopupMenuAdapter(){

                        @Override
                        public void menuPoppedDown(LWPopupMenuEvent lWPopupMenuEvent) {
                            this.setArmed(false);
                        }
                    });
                }
            }
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void postProcessKey(KeyEvent var1_1) {
            super.postProcessKey(var1_1);
            if (this._bar.getOrientation() == 0) ** GOTO lbl-1000
            if (this._bar.getOrientation() == 1) lbl-1000:
            // 2 sources

            {
                v0 = true;
            } else {
                v0 = false;
            }
            var2_2 = v0;
            var3_3 = var2_2 != false ? 38 : 37;
            v1 = var4_4 = var2_2 != false ? 40 : 39;
            if (!var1_1.isConsumed() && var1_1.getID() == 401 && (var1_1.getKeyCode() == var4_4 || var1_1.getKeyCode() == var3_3) && ((var5_5 = var1_1.getComponent()) == this._bar || this._isParentOf(this._bar.getParent(), var5_5) && var1_1.isAltDown())) {
                var1_1.consume();
                var6_6 = var1_1.getKeyCode() == var4_4;
                this.setArmed(var6_6);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void actionPerformed(ActionEvent var1_1) {
            block8: {
                var2_2 = this._bar;
                this._menu = null;
                var2_2.freezeRepaints();
                try {
                    var3_3 = Integer.parseInt(var1_1.getActionCommand());
                    var4_5 = var2_2.getItem(var3_3);
                    var5_6 = this._isItemVisible(var4_5);
                    var4_5.setSelected(true);
                    if (BasicTabBarUI.access$100()) {
                        var2_2.requestFocus();
                    }
                    if (var5_6) break block8;
                    var6_7 = var4_5.getBounds();
                    var7_8 = var2_2.getInnerSize();
                    if (var2_2.getOrientation() == 0) ** GOTO lbl-1000
                    if (var2_2.getOrientation() == 1) lbl-1000:
                    // 2 sources

                    {
                        var8_9 = -(var6_7.x + var6_7.width / 2) + var7_8.width / 2;
                        var2_2.setCanvasOrigin(var2_2.getHOffsetOfValue(var2_2.getHValueOfOffset(var8_9)), 0);
                    } else {
                        var8_10 = -(var6_7.y + var6_7.height / 2) + var7_8.height / 2;
                        var2_2.setCanvasOrigin(0, var2_2.getVOffsetOfValue(var2_2.getVValueOfOffset(var8_10)));
                    }
                    if (!this._isItemVisible(var4_5)) {
                        var2_2.scrollIntoView(var4_5);
                    }
                }
                catch (NumberFormatException var3_4) {
                }
                finally {
                    var2_2.unfreezeRepaints();
                }
            }
        }

        private boolean _isItemVisible(TabBarItem tabBarItem) {
            TabBarUI tabBarUI;
            Rectangle rectangle;
            block5: {
                block4: {
                    if (!this.isVisible()) {
                        return true;
                    }
                    rectangle = tabBarItem.getOuterBounds();
                    tabBarUI = (TabBarUI)this._bar.getUI();
                    if (this._bar.getOrientation() == 0) break block4;
                    if (this._bar.getOrientation() != 1) break block5;
                }
                return rectangle.x >= 0 && rectangle.x + rectangle.width - tabBarUI.getTabOverlap(this._bar) < this.getLocation().x;
            }
            return rectangle.y >= 0 && rectangle.y + rectangle.height - tabBarUI.getTabOverlap(this._bar) < this.getLocation().y;
        }

        private boolean _isParentOf(Component component, Component component2) {
            while (component2 != null) {
                if (component2 == component) {
                    return true;
                }
                component2 = component2.getParent();
            }
            return false;
        }
    }
}

