/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.laf.basic;

import java.awt.Image;
import oracle.bali.share.collection.StringKey;
import oracle.ewt.LookAndFeel;
import oracle.ewt.UIDefaults;
import oracle.ewt.graphics.ImageUtils;
import oracle.ewt.laf.basic.DisabledBGPainter;
import oracle.ewt.laf.basic.DisablingPainter;
import oracle.ewt.painter.AbstractWrappingPainter;
import oracle.ewt.painter.FGBGColorChange;
import oracle.ewt.painter.FilledRectPainter;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.ewt.painter.FixedTextPainter;
import oracle.ewt.painter.ImagePainter;
import oracle.ewt.painter.ImageSetPainter;
import oracle.ewt.painter.Painter;
import oracle.ewt.painter.TextPainter;
import oracle.ewt.painter.TruncatingTextPainter;

public abstract class BasicLookAndFeel
extends LookAndFeel {
    public static final Object DEFAULT_TEXT_PAINTER = new StringKey("DefaultTextPainter");
    public static final Object TRUNCATING_TEXT_PAINTER = new StringKey("TruncatingTextPainter");
    public static final Object TEXT_PAINTER = new StringKey("TextPainter");
    public static final Object DISABLED_BG_PAINTER = new StringKey("DisabledBGPainter");
    public static final Object WINDOW_ACTIVATION_REPAINTING = new StringKey("WindowActivationRepainting");
    private static final String[] _ARROW_NAMES = new String[]{"rightArrow.gif", "upArrow.gif", "downArrow.gif", "leftArrow.gif"};
    private static Image[] _sArrowImages = new Image[4];

    public static Image getArrowImage(int n) {
        Image image = _sArrowImages[n];
        if (image == null) {
            BasicLookAndFeel._sArrowImages[n] = image = BasicLookAndFeel._getImage(_ARROW_NAMES[n]);
        }
        return image;
    }

    @Override
    protected Painter getGroupBoxLabelPainter(String string) {
        return new FixedBorderPainter(new DisablingPainter(new FixedTextPainter(string), false), 0, 5, 0, 5, false);
    }

    protected String getGroupBoxTitleFromLabelPainter(Painter painter) {
        FixedTextPainter fixedTextPainter = BasicLookAndFeel._getTextPainter(painter);
        return fixedTextPainter == null ? null : fixedTextPainter.getText();
    }

    protected static void initCommonFixedDefaults(UIDefaults uIDefaults) {
        uIDefaults.put(IMAGE_PAINTER, new ImagePainter());
        uIDefaults.put(IMAGE_SET_PAINTER, new ImageSetPainter());
        uIDefaults.put(BACKGROUND_PAINTER, new FGBGColorChange(FilledRectPainter.getPainter(), false));
        uIDefaults.put(DISABLED_BG_PAINTER, new DisabledBGPainter(FilledRectPainter.getPainter()));
        uIDefaults.put(TEXT_PAINTER, new TextPainter());
        TruncatingTextPainter truncatingTextPainter = new TruncatingTextPainter();
        uIDefaults.put(TRUNCATING_TEXT_PAINTER, truncatingTextPainter);
        uIDefaults.put(DEFAULT_TEXT_PAINTER, new DisablingPainter(truncatingTextPainter));
    }

    private static Image _getImage(String string) {
        return ImageUtils.getImageResource(BasicLookAndFeel.class, "images/" + string);
    }

    private static FixedTextPainter _getTextPainter(Painter painter) {
        if (painter instanceof FixedTextPainter) {
            return (FixedTextPainter)painter;
        }
        if (painter instanceof AbstractWrappingPainter) {
            painter = ((AbstractWrappingPainter)painter).getWrappedPainter();
            return BasicLookAndFeel._getTextPainter(painter);
        }
        return null;
    }
}

