/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.graphics;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.CropImageFilter;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageObserver;
import oracle.ewt.graphics.HitTestMask;
import oracle.ewt.graphics.ImageSet;
import oracle.ewt.graphics.ImageUtils;
import oracle.ewt.graphics.TransparencyTester;

public class ImageStrip
implements ImageSet {
    private static final int _COMPUTING_TRANSPARENCY = -1;
    private static final int _IS_NOT_TRANSPARENT = 0;
    private static final int _IS_TRANSPARENT = 1;
    private transient boolean _imageLoaded;
    private transient int _width;
    private transient int _height;
    private transient int _isTransparent = -1;
    private int _suppliedImagesMask;
    private Image _baseImage;
    private transient int[] _imageIndices;
    private transient HitTestMask _hitTester;

    public ImageStrip(Image image) {
        this(image, 0);
    }

    public ImageStrip(Image image, int n) {
        if (image == null) {
            throw new IllegalArgumentException();
        }
        this._baseImage = image;
        this._suppliedImagesMask = n;
    }

    @Override
    public Dimension getSize() {
        this._loadImageIfNecessary();
        return new Dimension(this._width, this._height);
    }

    @Override
    public void paintImage(int n, Graphics graphics, int n2, int n3, ImageObserver imageObserver) {
        this._loadImageIfNecessary();
        int n4 = this._imageIndices[n];
        graphics.drawImage(this._baseImage, n2, n3, n2 + this._width, n3 + this._height, 0, this._height * n4, this._width, this._height * (n4 + 1), imageObserver);
    }

    @Override
    public boolean contains(int n, int n2) {
        if (n >= 0 && n2 >= 0 && n < this._width && n2 < this._height) {
            if (this.isTransparent()) {
                if (this._hitTester == null) {
                    int n3 = this._imageIndices[16];
                    this._hitTester = new HitTestMask(new FilteredImageSource(this._baseImage.getSource(), new CropImageFilter(0, this._height * n3, this._width, this._height)));
                }
                return this._hitTester.contains(n, n2);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isTransparent() {
        if (this._isTransparent == -1) {
            TransparencyTester transparencyTester = new TransparencyTester(new FilteredImageSource(this._baseImage.getSource(), new CropImageFilter(0, 0, this._width, this._height)));
            this._isTransparent = transparencyTester.isTransparent() ? 1 : 0;
        }
        return this._isTransparent != 0;
    }

    @Override
    public int getAvailableImageFlags() {
        return this._suppliedImagesMask;
    }

    private void _loadImageIfNecessary() {
        if (!this._imageLoaded) {
            Image image = this._baseImage;
            this._imageLoaded = ImageUtils.loadImage(image);
            int n = this._suppliedImagesMask;
            int n2 = ImageStrip._numImages(n);
            this._width = image.getWidth(null);
            this._height = image.getHeight(null) / n2;
            int n3 = ~n;
            this._imageIndices = new int[160];
            int n4 = 0;
            for (int i = 0; i < 160; ++i) {
                this._imageIndices[i] = ((n3 ^ i) & n3) == n3 ? n4++ : this._imageIndices[i & n];
            }
        }
    }

    private static int _numImages(int n) {
        int n2 = 0;
        while (n != 0) {
            if ((n & 1) != 0) {
                ++n2;
            }
            n >>= 1;
        }
        return 1 << n2;
    }
}

