/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.graphics;

import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.util.Hashtable;

class HitTestMask
implements ImageConsumer {
    private ImageProducer _producer;
    private transient boolean _doneGrabbing;
    private transient int _width;
    private transient int _height;
    private transient byte[] _transparentMask;

    public HitTestMask(Image image) {
        this(image.getSource());
    }

    public HitTestMask(ImageProducer imageProducer) {
        this._producer = imageProducer;
    }

    public synchronized boolean contains(int n, int n2) {
        if (n >= 0 && n2 >= 0) {
            if (!this._doneGrabbing) {
                this._producer.startProduction(this);
                while (!this._doneGrabbing) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        return true;
                    }
                }
            }
            if (this._transparentMask != null) {
                if (n < this._width && n2 < this._height) {
                    byte by = this._transparentMask[n2 * this._getWidthBytes() + n / 8];
                    return (by & 128 >> (n & 7)) != 0;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    @Override
    public void setDimensions(int n, int n2) {
        this._width = n;
        this._height = n2;
        this._transparentMask = new byte[this._getWidthBytes() * this._height];
    }

    public void setProperties(Hashtable hashtable) {
    }

    @Override
    public void setColorModel(ColorModel colorModel) {
    }

    @Override
    public void setHints(int n) {
    }

    @Override
    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
        int n7 = n2 + n4;
        int n8 = n + n3;
        int n9 = n + 7 & 0xFFFFFFF8;
        int n10 = n8 & 0xFFFFFFF8;
        int n11 = this._getWidthBytes();
        int n12 = n11 * n2 + n / 8;
        while (n2 < n7) {
            int n13;
            int n14;
            int n15;
            int n16 = n;
            int n17 = 0;
            int n18 = n5;
            if (n != n9) {
                if (n9 > n8) {
                    n9 = n8;
                }
                n15 = 0;
                while (n16 < n9) {
                    n15 = (byte)(n15 << 1);
                    if (colorModel.getAlpha(byArray[n18]) != 0) {
                        n15 = (byte)(n15 | 1);
                    }
                    ++n18;
                    ++n16;
                }
                int n19 = n12 + n17;
                this._transparentMask[n19] = (byte)(this._transparentMask[n19] | n15);
                ++n17;
            }
            while (n16 < n10) {
                n15 = 0;
                for (n14 = 0; n14 < 8; ++n14) {
                    n15 = (byte)(n15 << 1);
                    n13 = byArray[n18];
                    if (n13 < 0) {
                        n13 += 256;
                    }
                    if (colorModel.getAlpha(n13) != 0) {
                        n15 = (byte)(n15 | 1);
                    }
                    ++n18;
                }
                n16 += 8;
                this._transparentMask[n12 + n17] = n15;
                ++n17;
            }
            if (n16 < n8) {
                n15 = 8 - n8 + n16;
                n14 = 0;
                while (n16 < n8) {
                    n14 = (byte)(n14 << 1);
                    n13 = byArray[n18];
                    if (n13 < 0) {
                        n13 += 256;
                    }
                    if (colorModel.getAlpha(n13) != 0) {
                        n14 = (byte)(n14 | 1);
                    }
                    ++n18;
                    ++n16;
                }
                n14 = (byte)(n14 << n15);
                int n20 = n12 + n17;
                this._transparentMask[n20] = (byte)(this._transparentMask[n20] | n14);
            }
            n12 += n11;
            n5 += n6;
            ++n2;
        }
    }

    @Override
    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
        int n7 = n2 + n4;
        int n8 = n + n3;
        int n9 = n + 7 & 0xFFFFFFF8;
        int n10 = n8 & 0xFFFFFFF8;
        int n11 = this._getWidthBytes();
        int n12 = n11 * n2 + n / 8;
        while (n2 < n7) {
            int n13;
            int n14;
            int n15 = n;
            int n16 = 0;
            int n17 = n5;
            if (n != n9) {
                if (n9 > n8) {
                    n9 = n8;
                }
                n14 = 0;
                while (n15 < n9) {
                    n14 = (byte)(n14 << 1);
                    if (colorModel.getAlpha(nArray[n17]) != 0) {
                        n14 = (byte)(n14 | 1);
                    }
                    ++n17;
                    ++n15;
                }
                int n18 = n12 + n16;
                this._transparentMask[n18] = (byte)(this._transparentMask[n18] | n14);
                ++n16;
            }
            while (n15 < n10) {
                n14 = 0;
                for (n13 = 0; n13 < 8; ++n13) {
                    n14 = (byte)(n14 << 1);
                    if (colorModel.getAlpha(nArray[n17]) != 0) {
                        n14 = (byte)(n14 | 1);
                    }
                    ++n17;
                }
                n15 += 8;
                this._transparentMask[n12 + n16] = n14;
                ++n16;
            }
            if (n15 < n8) {
                n14 = 8 - n8 + n15;
                n13 = 0;
                while (n15 < n8) {
                    n13 = (byte)(n13 << 1);
                    if (colorModel.getAlpha(nArray[n17]) != 0) {
                        n13 = (byte)(n13 | 1);
                    }
                    ++n17;
                    ++n15;
                }
                n13 = (byte)(n13 << n14);
                int n19 = n12 + n16;
                this._transparentMask[n19] = (byte)(this._transparentMask[n19] | n13);
            }
            n12 += n11;
            n5 += n6;
            ++n2;
        }
    }

    @Override
    public synchronized void imageComplete(int n) {
        if (n != 3) {
            this._transparentMask = null;
        }
        this._doneGrabbing = true;
        this._producer.removeConsumer(this);
        this.notifyAll();
    }

    private int _getWidthBytes() {
        return (this._width + 7) / 8;
    }
}

