/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.dTree;

import oracle.ewt.dTree.DTree;
import oracle.ewt.dTree.DTreeItem;
import oracle.ewt.dTree.DTreeItemEvent;
import oracle.ewt.dTree.DTreeRange;
import oracle.ewt.dTree.DTreeRangeSet;
import oracle.ewt.dTree.DTreeSelection;
import oracle.ewt.event.Cancelable;

public class DTreeSingleSelection
implements DTreeSelection {
    private DTree _tree;
    private DTreeItem _selected;

    @Override
    public void setTree(DTree dTree) {
        if (dTree != this._tree) {
            this._tree = dTree;
            this._selected = null;
        }
    }

    @Override
    public boolean extendSelection(DTreeItem dTreeItem) {
        return this.selectItem(dTreeItem);
    }

    @Override
    public boolean getHasSelection() {
        return this._selected != null;
    }

    @Override
    public DTreeRangeSet getSelectionRanges() {
        DTreeItem dTreeItem;
        DTreeRangeSet dTreeRangeSet = new DTreeRangeSet();
        if (this._selected != null && (dTreeItem = this._selected.getParent()) != null) {
            int n = this._selected.getIndex();
            dTreeRangeSet.addRange(new DTreeRange(dTreeItem, n, 1));
        }
        return dTreeRangeSet;
    }

    @Override
    public DTree getTree() {
        return this._tree;
    }

    @Override
    public boolean isSelected(DTreeItem dTreeItem) {
        return dTreeItem == this._selected;
    }

    @Override
    public void itemCollapsing(DTreeItemEvent dTreeItemEvent) {
        DTreeItem dTreeItem = dTreeItemEvent.getItem();
        if (this._selected != null && this._selected != dTreeItem && DTree.isItemDescendent(this._selected, dTreeItem) && !this.selectItem(dTreeItem)) {
            ((Cancelable)((Object)dTreeItemEvent)).cancel();
        }
    }

    @Override
    public void itemsAdded(DTreeItem dTreeItem, int n, int n2) {
    }

    @Override
    public void itemsRemoved(DTreeItem dTreeItem, int n, int n2) {
        if (this._selected != null && this._selected.getTree() == null) {
            this._selected = null;
            this._setSelection(null, null, true);
        }
    }

    @Override
    public boolean selectItem(DTreeItem dTreeItem) {
        if (this._tree != null && this._tree.getRoot() == dTreeItem) {
            return false;
        }
        boolean bl = this._setSelection(dTreeItem, dTreeItem, false);
        return bl;
    }

    @Override
    public boolean setSelectionRanges(DTreeRangeSet dTreeRangeSet) {
        DTreeItem dTreeItem = null;
        if (dTreeRangeSet != null && dTreeRangeSet.getCount() > 0) {
            DTreeRange dTreeRange = dTreeRangeSet.getRange(0);
            int n = dTreeRange.getStartIndex();
            int n2 = dTreeRange.getCount();
            if (dTreeRange.getCount() > 0) {
                DTreeItem dTreeItem2 = dTreeRange.getParent();
                dTreeItem = dTreeItem2.getItem(dTreeRange.getStartIndex());
            }
        }
        return this._setSelection(dTreeItem, null, false);
    }

    @Override
    public boolean toggleItem(DTreeItem dTreeItem) {
        if (this.isSelected(dTreeItem)) {
            return this.selectItem(null);
        }
        return this.selectItem(dTreeItem);
    }

    private boolean _setSelection(DTreeItem dTreeItem, DTreeItem dTreeItem2, boolean bl) {
        if (this._selected == dTreeItem && !bl) {
            return true;
        }
        DTreeRangeSet dTreeRangeSet = this.getSelectionRanges();
        DTreeRangeSet dTreeRangeSet2 = new DTreeRangeSet();
        if (dTreeItem != null) {
            DTreeItem dTreeItem3 = dTreeItem.getParent();
            int n = dTreeItem.getIndex();
            dTreeRangeSet2.addRange(new DTreeRange(dTreeItem3, n, 1));
        }
        if (this._tree.selectionChanging(dTreeRangeSet, dTreeRangeSet2)) {
            return false;
        }
        this._selected = dTreeItem;
        if (dTreeItem2 != null) {
            this._tree.setFocusedItem(dTreeItem2);
        }
        this._tree.selectionChanged(dTreeRangeSet, dTreeRangeSet2);
        return true;
    }
}

