/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.dTree;

import java.awt.AWTEvent;
import java.awt.Adjustable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import oracle.ewt.EwtComponent;
import oracle.ewt.access.AccessibleLWComponent;
import oracle.ewt.dTree.DTreeActivateListener;
import oracle.ewt.dTree.DTreeDecoration;
import oracle.ewt.dTree.DTreeEditListener;
import oracle.ewt.dTree.DTreeEmptyDecoration;
import oracle.ewt.dTree.DTreeEvent;
import oracle.ewt.dTree.DTreeExpandedEnumeration;
import oracle.ewt.dTree.DTreeExpansionListener;
import oracle.ewt.dTree.DTreeItem;
import oracle.ewt.dTree.DTreeItemEvent;
import oracle.ewt.dTree.DTreeItemValidateEvent;
import oracle.ewt.dTree.DTreeRange;
import oracle.ewt.dTree.DTreeRangeSet;
import oracle.ewt.dTree.DTreeRootItem;
import oracle.ewt.dTree.DTreeSelValidateEvent;
import oracle.ewt.dTree.DTreeSelection;
import oracle.ewt.dTree.DTreeSelectionEvent;
import oracle.ewt.dTree.DTreeSelectionListener;
import oracle.ewt.dTree.DTreeSingleSelection;
import oracle.ewt.event.ListenerManager;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.scrolling.ScrollableException;
import oracle.ewt.util.ImmInsets;
import oracle.ewt.util.InputEventUtils;

public class DTree
extends EwtComponent {
    public static int DROP_STYLE_NONE = 0;
    public static final int DROP_STYLE_INTO = 1;
    public static final int DROP_STYLE_BEFORE = 2;
    public static final int DROP_STYLE_AFTER = 3;
    private DTreeRootItem _root;
    private DTreeItem _focused;
    private int _indentwd;
    private int _rowheight;
    private int _nositems;
    private int _noslevels;
    private int _layoutFrozenLevel;
    private DTreeSelection _selection;
    private DTreeDecoration _decoration;
    private ListenerManager _activatelm;
    private ListenerManager _editlm;
    private ListenerManager _expandlm;
    private ListenerManager _selectlm;
    private Adjustable _hAdjustable;
    private Adjustable _vAdjustable;
    private DTreeItem _mousePressItem;
    private DTreeItem _dropItem;
    private int _dropStyle;
    private boolean _editable;
    private DTreeItem _editItem;
    private Component _editor;
    private EditDismisser _editDismisser;
    private boolean _selectedAtPress;
    private Vector _rangeSets;
    private static final int _DEFAULT_INDENTWIDTH = 18;
    private static final int _DEFAULT_ITEMS_ON_SCREEN = 20;
    private static final int _DEFAULT_LEVELS_ON_SCREEN = 5;
    private static final int _PREFERRED_WIDTH_ADJUSTMENT = 100;

    public static DTreeItem getCommonAncestor(DTreeItem dTreeItem, DTreeItem dTreeItem2) {
        for (DTreeItem dTreeItem3 = dTreeItem; dTreeItem3 != null; dTreeItem3 = dTreeItem3.getParent()) {
            if (!DTree.isItemDescendent(dTreeItem2, dTreeItem3)) continue;
            return dTreeItem3;
        }
        return null;
    }

    public static boolean isItemBefore(DTreeItem dTreeItem, DTreeItem dTreeItem2) {
        DTreeItem dTreeItem3 = DTree.getCommonAncestor(dTreeItem, dTreeItem2);
        if (dTreeItem3 == dTreeItem) {
            return true;
        }
        if (dTreeItem3 == dTreeItem2) {
            return false;
        }
        DTreeItem dTreeItem4 = dTreeItem;
        DTreeItem dTreeItem5 = dTreeItem2;
        while (dTreeItem4.getParent() != dTreeItem3) {
            dTreeItem4 = dTreeItem4.getParent();
        }
        while (dTreeItem5.getParent() != dTreeItem3) {
            dTreeItem5 = dTreeItem5.getParent();
        }
        return dTreeItem4.getIndex() < dTreeItem5.getIndex();
    }

    public static boolean isItemDescendent(DTreeItem dTreeItem, DTreeItem dTreeItem2) {
        while (dTreeItem != null) {
            if (dTreeItem == dTreeItem2) {
                return true;
            }
            dTreeItem = dTreeItem.getParent();
        }
        return false;
    }

    public static boolean isItemVisible(DTreeItem dTreeItem) {
        DTreeItem dTreeItem2 = dTreeItem.getParent();
        if (dTreeItem2 == null) {
            return dTreeItem.getTree() != null;
        }
        return dTreeItem2.isExpanded() && DTree.isItemVisible(dTreeItem2);
    }

    public DTree() {
        this(null);
    }

    public DTree(DTreeRootItem dTreeRootItem) {
        this._setRoot(dTreeRootItem);
        this._selection = new DTreeSingleSelection();
        this._selection.setTree(this);
        if (this._decoration == null) {
            this._decoration = DTreeEmptyDecoration.getInstance();
        }
        this._indentwd = 18;
        this._nositems = 20;
        this._noslevels = 5;
        this.enableEvents(56L);
    }

    public final void addActivateListener(DTreeActivateListener dTreeActivateListener) {
        if (this._activatelm == null) {
            this._activatelm = new ListenerManager();
        }
        this._activatelm.addListener(dTreeActivateListener);
    }

    public final void addEditListener(DTreeEditListener dTreeEditListener) {
        if (this._editlm == null) {
            this._editlm = new ListenerManager();
        }
        this._editlm.addListener(dTreeEditListener);
    }

    public final void addExpansionListener(DTreeExpansionListener dTreeExpansionListener) {
        if (this._expandlm == null) {
            this._expandlm = new ListenerManager();
        }
        this._expandlm.addListener(dTreeExpansionListener);
    }

    public final void addSelectionListener(DTreeSelectionListener dTreeSelectionListener) {
        if (this._selectlm == null) {
            this._selectlm = new ListenerManager();
        }
        this._selectlm.addListener(dTreeSelectionListener);
    }

    public void cancelEdit() {
        this._endEdit(false);
    }

    public boolean commitEdit() {
        return this._endEdit(true);
    }

    public void freezeLayouts() {
        ++this._layoutFrozenLevel;
    }

    public DTreeDecoration getDecoration() {
        return this._decoration;
    }

    public DTreeItem getDropHighlightItem() {
        return this._dropItem;
    }

    public int getDropHighlightStyle() {
        return this._dropStyle;
    }

    public Enumeration getExpandedEnumeration() {
        return new DTreeExpandedEnumeration(this);
    }

    public DTreeItem getFocusedItem() {
        if (this._focused == null || this._focused.getParent() == null || this._focused.getTree() == null) {
            DTreeRootItem dTreeRootItem = this.getRoot();
            this._focused = dTreeRootItem == null || dTreeRootItem.getItemCount() <= 0 ? null : dTreeRootItem.getItem(0);
        }
        return this._focused;
    }

    public int getIndentWidth() {
        return this._indentwd;
    }

    public DTreeItem getItemAt(int n, int n2) {
        if (this._root == null) {
            return null;
        }
        return this._root.getItemAt(n, n2);
    }

    public DTreeItem getDraggableItemAt(int n, int n2) {
        DTreeItem dTreeItem = this.getItemAt(n, n2);
        if (dTreeItem == null) {
            return null;
        }
        Point point = this.convertCanvasToOuter(dTreeItem.getX(), dTreeItem.getY());
        Rectangle rectangle = dTreeItem.getEditBounds();
        int n3 = point.x;
        int n4 = point.x + rectangle.x + rectangle.width;
        if (n3 < n && n < n4) {
            return dTreeItem;
        }
        return null;
    }

    public int getPreferredItemsOnScreen() {
        return this._nositems;
    }

    public int getPreferredLevelsOnScreen() {
        return this._noslevels;
    }

    public DTreeItem getPreviousVisibleItem(DTreeItem dTreeItem) {
        DTreeItem dTreeItem2 = null;
        DTreeItem dTreeItem3 = dTreeItem.getParent();
        int n = dTreeItem.getIndex();
        if (n > 0) {
            dTreeItem2 = dTreeItem3.getItem(n - 1);
        }
        if (dTreeItem2 == null) {
            dTreeItem2 = dTreeItem3;
        } else if (dTreeItem2.isExpanded()) {
            dTreeItem2 = this._getLastVisibleItem(dTreeItem2);
        }
        if (dTreeItem2 == this.getRoot()) {
            dTreeItem2 = null;
        }
        return dTreeItem2;
    }

    public final DTreeItem getNextVisibleItem(DTreeItem dTreeItem) {
        if (dTreeItem.isExpanded() && dTreeItem.getItemCount() > 0) {
            return dTreeItem.getItem(0);
        }
        DTreeItem dTreeItem2 = dTreeItem.getParent();
        if (dTreeItem2 == null) {
            return dTreeItem.getItemCount() != 0 ? dTreeItem.getItem(0) : dTreeItem;
        }
        int n = dTreeItem.getIndex();
        if (n < dTreeItem2.getItemCount() - 1) {
            return dTreeItem2.getItem(n + 1);
        }
        while (dTreeItem2 != null) {
            DTreeItem dTreeItem3 = dTreeItem2.getParent();
            if (dTreeItem3 != null && (n = dTreeItem2.getIndex()) < dTreeItem3.getItemCount() - 1) {
                return dTreeItem3.getItem(n + 1);
            }
            dTreeItem2 = dTreeItem3;
        }
        return null;
    }

    public DTreeRootItem getRoot() {
        return this._root;
    }

    public DTreeSelection getSelection() {
        return this._selection;
    }

    public boolean isEditable() {
        return this._editable;
    }

    public boolean isEditing() {
        return this._editItem != null;
    }

    public void itemActivate(DTreeItem dTreeItem) {
        this.processEvent(new DTreeItemEvent(this, 2004, dTreeItem));
    }

    public void itemExpansionChanged(DTreeItem dTreeItem, boolean bl) {
        int n = bl ? 2001 : 2003;
        this.processEvent(new DTreeItemEvent(this, n, dTreeItem));
        this.invalidateCanvas();
        if (n == 2003) {
            DTreeItem dTreeItem2 = this.getFocusedItem();
            if (DTree.isItemDescendent(dTreeItem2, dTreeItem)) {
                this.setFocusedItem(dTreeItem);
            } else {
                this._paintItemImmediate(dTreeItem);
            }
        } else if (this._layoutFrozenLevel == 0) {
            this.invalidate();
            this.repaintCanvas();
            this._makeChildrenVisible(dTreeItem);
        }
    }

    public boolean itemExpansionChanging(DTreeItem dTreeItem, boolean bl) {
        int n = bl ? 2000 : 2002;
        DTreeItemValidateEvent dTreeItemValidateEvent = new DTreeItemValidateEvent(this, n, dTreeItem);
        this.processEvent(dTreeItemValidateEvent);
        if (!dTreeItemValidateEvent.isCancelled() && n == 2002) {
            DTreeSelection dTreeSelection = this.getSelection();
            dTreeSelection.itemCollapsing(dTreeItemValidateEvent);
        }
        return dTreeItemValidateEvent.isCancelled();
    }

    public void itemsAdded(DTreeItem dTreeItem, int n, int n2) {
        Cloneable cloneable;
        Object object;
        if (!DTree.isItemVisible(dTreeItem) || !dTreeItem.isExpanded()) {
            return;
        }
        DTreeSelection dTreeSelection = this.getSelection();
        dTreeSelection.itemsAdded(dTreeItem, n, n2);
        if (this._rangeSets != null) {
            object = this._rangeSets.elements();
            while (object.hasMoreElements()) {
                cloneable = (DTreeRangeSet)object.nextElement();
                cloneable.__itemsAdded(dTreeItem, n, n2);
            }
        }
        if (this._layoutFrozenLevel > 0) {
            return;
        }
        object = this.layoutCanvas();
        this.setCanvasSize(((Dimension)object).width, ((Dimension)object).height);
        cloneable = this.getCanvasOrigin();
        Dimension dimension = this.getInnerSize();
        DTreeItem dTreeItem2 = dTreeItem.getItem(n);
        if (dTreeItem2 == null) {
            return;
        }
        int n3 = dTreeItem2.getY();
        if (n3 < -((Point)cloneable).y) {
            this.repaint();
        } else if (n3 < -((Point)cloneable).y + dimension.height) {
            this.repaint();
        }
        this._fireVisibleDataPropertyChange();
    }

    public void itemsInvalidated(DTreeItem dTreeItem, int n, int n2) {
        if (!this.isValid()) {
            this.repaint();
        } else {
            DTreeItem dTreeItem2 = dTreeItem.getItem(n);
            DTreeItem dTreeItem3 = dTreeItem.getItem(n + n2 - 1);
            Dimension dimension = this.getInnerSize();
            Point point = this._convertCanvasToInner(0, dTreeItem2.getY());
            Point point2 = this._convertCanvasToInner(0, dTreeItem3.getY());
            point2.y += dTreeItem3.getSize().height;
            if (point.y < dimension.height && point2.y > 0) {
                this.repaint();
            }
        }
        this._fireVisibleDataPropertyChange();
    }

    public void itemsRemoved(DTreeItem dTreeItem, int n, int n2) {
        if (DTree.isItemVisible(dTreeItem) && dTreeItem.isExpanded()) {
            this.invalidateCanvas();
        }
        DTreeSelection dTreeSelection = this.getSelection();
        dTreeSelection.itemsRemoved(dTreeItem, n, n2);
        if (this._rangeSets != null) {
            Enumeration enumeration = this._rangeSets.elements();
            while (enumeration.hasMoreElements()) {
                DTreeRangeSet dTreeRangeSet = (DTreeRangeSet)enumeration.nextElement();
                dTreeRangeSet.__itemsRemoved(dTreeItem, n, n2);
            }
        }
        this._fireVisibleDataPropertyChange();
    }

    public void makeVisible(DTreeItem dTreeItem) {
        Object object;
        if (!DTree.isItemVisible(dTreeItem)) {
            for (object = dTreeItem.getParent(); object != null; object = object.getParent()) {
                if (object.isExpanded()) continue;
                object.setExpanded(true);
            }
        }
        this.validate();
        object = this.getCanvasOrigin();
        Rectangle rectangle = this.getInnerBounds();
        int n = dTreeItem.getY();
        Point point = this._convertCanvasToInner(0, n);
        int n2 = dTreeItem.getSize().height;
        int n3 = ((Point)object).y;
        if (point.y < 0) {
            n3 = -n;
        } else if (point.y + n2 > rectangle.height) {
            n3 = rectangle.height - (n + n2);
        }
        if (((Point)object).y != n3) {
            this.setCanvasOrigin(((Point)object).x, n3);
        }
    }

    public void removeActivateListener(DTreeActivateListener dTreeActivateListener) {
        if (this._activatelm != null) {
            this._activatelm.removeListener(dTreeActivateListener);
        }
    }

    public void removeEditListener(DTreeEditListener dTreeEditListener) {
        if (this._editlm != null) {
            this._editlm.removeListener(dTreeEditListener);
        }
    }

    public void removeExpansionListener(DTreeExpansionListener dTreeExpansionListener) {
        if (this._expandlm != null) {
            this._expandlm.removeListener(dTreeExpansionListener);
        }
    }

    public void removeSelectionListener(DTreeSelectionListener dTreeSelectionListener) {
        if (this._selectlm != null) {
            this._selectlm.removeListener(dTreeSelectionListener);
        }
    }

    public void selectionChanged(DTreeRangeSet dTreeRangeSet, DTreeRangeSet dTreeRangeSet2) {
        this.processEvent(new DTreeSelectionEvent(this, 2006, dTreeRangeSet, dTreeRangeSet2));
    }

    public boolean selectionChanging(DTreeRangeSet dTreeRangeSet, DTreeRangeSet dTreeRangeSet2) {
        DTreeSelValidateEvent dTreeSelValidateEvent = new DTreeSelValidateEvent(this, 2005, dTreeRangeSet, dTreeRangeSet2);
        this.processEvent(dTreeSelValidateEvent);
        return dTreeSelValidateEvent.isCancelled();
    }

    public void setDecoration(DTreeDecoration dTreeDecoration) {
        DTreeDecoration dTreeDecoration2 = this.getDecoration();
        if (dTreeDecoration2 != dTreeDecoration) {
            if (dTreeDecoration == null) {
                dTreeDecoration = DTreeEmptyDecoration.getInstance();
            }
            this._decoration = dTreeDecoration;
            this.invalidateCanvas();
        }
    }

    public void setDropHighlightItem(DTreeItem dTreeItem) {
        DTreeItem dTreeItem2 = this.getDropHighlightItem();
        if (dTreeItem2 != dTreeItem) {
            this._dropItem = dTreeItem;
            if (dTreeItem2 != null) {
                this._paintItemImmediate(dTreeItem2);
            }
            if (this._dropItem != null) {
                this._paintItemImmediate(this._dropItem);
                this.makeVisible(this._dropItem);
            }
        }
    }

    public void setDropHighlightStyle(int n) {
        int n2 = this.getDropHighlightStyle();
        if (n2 != n) {
            this._dropStyle = n;
            DTreeItem dTreeItem = this.getDropHighlightItem();
            if (dTreeItem != null) {
                this._paintItemImmediate(dTreeItem);
            }
        }
    }

    public void setEditable(boolean bl) {
        this._editable = bl;
    }

    public void setFocusedItem(DTreeItem dTreeItem) {
        DTreeItem dTreeItem2 = this.getFocusedItem();
        if (dTreeItem2 != dTreeItem) {
            AccessibleContext accessibleContext;
            this._focused = dTreeItem;
            if (dTreeItem2 != null) {
                this._paintItemImmediate(dTreeItem2);
            }
            if (this._focused != null) {
                this._paintItemImmediate(this._focused);
                this.makeVisible(this._focused);
            }
            if ((accessibleContext = this.accessAccessibleContext()) != null) {
                accessibleContext.firePropertyChange("AccessibleActiveDescendant", dTreeItem2, dTreeItem);
            }
        } else if (dTreeItem != null) {
            this._paintItemImmediate(dTreeItem);
            this.makeVisible(dTreeItem);
        }
    }

    public void setIndentWidth(int n) {
        if (n != this._indentwd) {
            this._indentwd = n;
            this.invalidateCanvas();
        }
    }

    public void setPreferredItemsOnScreen(int n) {
        if (n != this._nositems) {
            this._nositems = n;
            this.invalidate();
        }
    }

    public void setPreferredLevelsOnScreen(int n) {
        if (n != this._noslevels) {
            this._noslevels = n;
            this.invalidate();
        }
    }

    public void setSelection(DTreeSelection dTreeSelection) {
        if (this._selection != dTreeSelection) {
            this._selection.setTree(null);
            this._selection = dTreeSelection == null ? new DTreeSingleSelection() : dTreeSelection;
            this._selection.setTree(this);
            this.repaintInterior();
        }
    }

    public void setRoot(DTreeRootItem dTreeRootItem) {
        this._setRoot(dTreeRootItem);
    }

    public boolean startEdit(DTreeItem dTreeItem) {
        if (!this.isEditable()) {
            return false;
        }
        this.cancelEdit();
        Component component = dTreeItem.startEdit();
        if (component == null) {
            return false;
        }
        DTreeItemValidateEvent dTreeItemValidateEvent = new DTreeItemValidateEvent(this, 2007, dTreeItem);
        this.processEvent(dTreeItemValidateEvent);
        if (dTreeItemValidateEvent.isCancelled()) {
            return false;
        }
        this._makeHorizontalVisible(dTreeItem);
        this._editor = component;
        this._editItem = dTreeItem;
        this._editDismisser = new EditDismisser();
        component.addKeyListener(this._editDismisser);
        component.addFocusListener(this._editDismisser);
        this.add(component);
        component.setBounds(this._getEditBounds(dTreeItem));
        component.requestFocus();
        return true;
    }

    public void unfreezeLayouts() {
        --this._layoutFrozenLevel;
        if (this._layoutFrozenLevel == 0) {
            this.invalidateCanvas();
        }
    }

    @Override
    public void attachHAdjustable(Adjustable adjustable) {
        this._hAdjustable = adjustable;
    }

    @Override
    public void attachVAdjustable(Adjustable adjustable) {
        this._vAdjustable = adjustable;
    }

    @Override
    public void detachAdjustable(Adjustable adjustable) throws ScrollableException {
        if (this._hAdjustable == adjustable) {
            this._hAdjustable = null;
        } else if (this._vAdjustable == adjustable) {
            this._vAdjustable = null;
        } else {
            super.detachAdjustable(adjustable);
        }
    }

    @Override
    public Adjustable getHAdjustable() {
        return this._hAdjustable;
    }

    @Override
    public int getInvalidateFlags() {
        return super.getInvalidateFlags() | 0x4000;
    }

    @Override
    public int getRepaintFlags() {
        return super.getRepaintFlags() | 0x4000;
    }

    @Override
    public Adjustable getVAdjustable() {
        return this._vAdjustable;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.convertInnerToOuterSize(this.getIndentWidth(), this._rowheight);
    }

    @Override
    public Rectangle getPageBounds(PaintContext paintContext, Dictionary dictionary, int n, int n2, int n3, int n4) {
        DTreeItem dTreeItem = this.getItemAt(0, n + n4);
        if (dTreeItem != null) {
            n4 = dTreeItem.getY() - n;
        }
        return new Rectangle(n3, n4, n3, n4);
    }

    @Override
    public Dimension getPreferredSize() {
        this.validate();
        int n = this.getIndentWidth() * this.getPreferredLevelsOnScreen();
        int n2 = this._rowheight * this.getPreferredItemsOnScreen();
        return this.convertInnerToOuterSize(n += 100, n2);
    }

    @Override
    public Object getUIClassID() {
        return "TreeUI";
    }

    @Override
    public void handleHScroll(int n, int n2) throws ScrollableException {
        this.commitEdit();
        super.handleHScroll(n, n2);
    }

    @Override
    public void handleVScroll(int n, int n2) throws ScrollableException {
        this.commitEdit();
        super.handleVScroll(n, n2);
    }

    @Override
    public boolean isFocusTraversable() {
        return true;
    }

    @Override
    public boolean isHScrollable() {
        return true;
    }

    @Override
    public boolean isVScrollable() {
        return true;
    }

    @Override
    public void reshape(int n, int n2, int n3, int n4) {
        if (this.getActualReadingDirection() == 2) {
            Dimension dimension = this.getSize();
            Rectangle rectangle = this.getCanvasBounds();
            if (rectangle.width > n3) {
                this.storeCanvasOrigin(rectangle.x - dimension.width + n3, rectangle.y);
            }
        }
        super.reshape(n, n2, n3, n4);
    }

    @Override
    public void setCanvasOrigin(int n, int n2) throws ScrollableException {
        this.commitEdit();
        super.setCanvasOrigin(n, n2);
    }

    protected int getRowCount() {
        return this._getVisibleItemCount();
    }

    @Override
    protected int getVMaximum() {
        int n;
        Dimension dimension = this.getCanvasSize();
        if (this._rowheight == 0) {
            n = 0;
        } else {
            n = dimension.height / this._rowheight;
            if (dimension.height % this._rowheight != 0) {
                ++n;
            }
        }
        return n;
    }

    @Override
    protected int getVOffsetOfValue(int n) {
        int n2 = -n * this._rowheight;
        int n3 = this.getCanvasHeight();
        int n4 = this.getInnerHeight();
        if (n2 < 0 && n2 + n3 < n4 && (n2 = n4 - n3) > 0) {
            n2 = 0;
        }
        return n2;
    }

    @Override
    protected int getVValueOfOffset(int n) {
        int n2 = 0;
        if (this._rowheight != 0) {
            n2 = -n / this._rowheight;
            if (-n % this._rowheight != 0) {
                ++n2;
            }
        }
        return n2;
    }

    @Override
    protected Dimension layoutCanvas() {
        if (this._root == null) {
            return new Dimension(0, 0);
        }
        DTreeDecoration dTreeDecoration = this.getDecoration();
        ImmInsets immInsets = dTreeDecoration.getDecorationInsets(this);
        this._root.layout(immInsets.left, immInsets.top);
        int n = this._root.getSubTreeHeight() + immInsets.top + immInsets.bottom;
        int n2 = this.getRowCount();
        this._rowheight = n2 == 0 ? 0 : n / n2;
        return new Dimension(this.getCanvasSize().width, n);
    }

    @Override
    protected void paintCanvasInterior(Graphics graphics) {
        boolean bl;
        Rectangle rectangle = graphics.getClipBounds();
        DTreeItem dTreeItem = this.getItemAt(0, rectangle.y);
        if (dTreeItem == null) {
            return;
        }
        boolean bl2 = bl = this.getActualReadingDirection() == 2;
        if (bl) {
            this._updateCanvasBounds(rectangle, dTreeItem);
        }
        DTreeSelection dTreeSelection = this.getSelection();
        DTreeItem dTreeItem2 = this.getFocusedItem();
        DTreeItem dTreeItem3 = this.getDropHighlightItem();
        int n = this.getDropHighlightStyle();
        DTreeDecoration dTreeDecoration = this.getDecoration();
        Dimension dimension = this.getCanvasSize();
        int n2 = dimension.width;
        ImmInsets immInsets = dTreeDecoration.getDecorationInsets(this);
        PaintContext paintContext = this.getPaintContext();
        this._repairDecoration(paintContext, graphics, dTreeItem.getParent(), dTreeDecoration, dimension.width);
        while (dTreeItem != null) {
            int n3 = dTreeItem.getX();
            int n4 = dTreeItem.getY();
            if (n4 > rectangle.y + rectangle.height) break;
            Dimension dimension2 = dTreeItem.getSize();
            DTreeItem dTreeItem4 = this.getNextVisibleItem(dTreeItem);
            if (n4 + dimension2.height > rectangle.y) {
                graphics.translate(0, n4);
                dTreeDecoration.paintDecoration(paintContext, graphics, dTreeItem, bl ? dimension.width - (n3 + dimension2.width) : n3, dimension2.height);
                graphics.translate(n3, 0);
                boolean bl3 = this._editItem != dTreeItem && dTreeSelection.isSelected(dTreeItem) || dTreeItem == dTreeItem3 && n == 1;
                this.paintItem(graphics, dTreeItem, bl3, dTreeItem == dTreeItem2, dimension2.width, dimension2.height);
                graphics.translate(-n3, -n4);
            } else if (dTreeItem4 != null && n4 < rectangle.y && rectangle.y < dTreeItem4.getY()) {
                graphics.translate(0, n4);
                dTreeDecoration.paintDecoration(paintContext, graphics, dTreeItem, bl ? dimension.width - (n3 + dimension2.width) : n3, dimension2.height);
                graphics.translate(0, -n4);
            }
            if (n3 + dimension2.width + immInsets.right > n2) {
                n2 = n3 + dimension2.width + immInsets.right;
            }
            dTreeItem = dTreeItem4;
        }
        if (n2 > dimension.width) {
            this.setCanvasSize(n2, dimension.height);
            this.repaintInterior();
        }
    }

    protected void paintItem(Graphics graphics, DTreeItem dTreeItem, boolean bl, boolean bl2, int n, int n2) {
        dTreeItem.paint(graphics, bl, this.hasFocus() && bl2, n, n2);
    }

    protected void processActivateEvent(DTreeItemEvent dTreeItemEvent) {
        Enumeration enumeration;
        if (this._activatelm == null || (enumeration = this._activatelm.getListeners()) == null) {
            return;
        }
        if (dTreeItemEvent.getID() == 2004) {
            while (enumeration.hasMoreElements()) {
                DTreeActivateListener dTreeActivateListener = (DTreeActivateListener)enumeration.nextElement();
                dTreeActivateListener.dTreeItemActivate(dTreeItemEvent);
            }
        }
    }

    @Override
    protected void processEventImpl(AWTEvent aWTEvent) {
        if (aWTEvent instanceof DTreeEvent) {
            switch (aWTEvent.getID()) {
                case 2000: 
                case 2001: 
                case 2002: 
                case 2003: {
                    this.processExpansionEvent((DTreeItemEvent)aWTEvent);
                    break;
                }
                case 2004: {
                    this.processActivateEvent((DTreeItemEvent)aWTEvent);
                    break;
                }
                case 2005: 
                case 2006: {
                    this.processSelectionEvent((DTreeSelectionEvent)aWTEvent);
                    break;
                }
                case 2007: 
                case 2008: 
                case 2009: {
                    this.processEditEvent((DTreeItemEvent)aWTEvent);
                    break;
                }
            }
        }
        super.processEventImpl(aWTEvent);
    }

    protected void processEditEvent(DTreeItemEvent dTreeItemEvent) {
        Enumeration enumeration;
        if (this._editlm == null || (enumeration = this._editlm.getListeners()) == null) {
            return;
        }
        int n = dTreeItemEvent.getID();
        while (enumeration.hasMoreElements()) {
            DTreeEditListener dTreeEditListener = (DTreeEditListener)enumeration.nextElement();
            switch (n) {
                case 2007: {
                    dTreeEditListener.dTreeItemEditing(dTreeItemEvent);
                    break;
                }
                case 2008: {
                    dTreeEditListener.dTreeItemEdited(dTreeItemEvent);
                    break;
                }
                case 2009: {
                    dTreeEditListener.dTreeItemEditCancelled(dTreeItemEvent);
                }
            }
        }
    }

    protected void processExpansionEvent(DTreeItemEvent dTreeItemEvent) {
        Enumeration enumeration;
        if (this._expandlm == null || (enumeration = this._expandlm.getListeners()) == null) {
            return;
        }
        int n = dTreeItemEvent.getID();
        while (enumeration.hasMoreElements()) {
            DTreeExpansionListener dTreeExpansionListener = (DTreeExpansionListener)enumeration.nextElement();
            switch (n) {
                case 2000: {
                    dTreeExpansionListener.dTreeItemExpanding(dTreeItemEvent);
                    break;
                }
                case 2001: {
                    dTreeExpansionListener.dTreeItemExpanded(dTreeItemEvent);
                    break;
                }
                case 2002: {
                    dTreeExpansionListener.dTreeItemCollapsing(dTreeItemEvent);
                    break;
                }
                case 2003: {
                    dTreeExpansionListener.dTreeItemCollapsed(dTreeItemEvent);
                }
            }
        }
    }

    @Override
    protected void processFocusEvent(FocusEvent focusEvent) {
        AccessibleContext accessibleContext;
        super.processFocusEvent(focusEvent);
        int n = focusEvent.getID();
        if (n == 1004 || n == 1005) {
            this.repaint();
        }
        if ((accessibleContext = this.accessAccessibleContext()) != null && n == 1004) {
            accessibleContext.firePropertyChange("AccessibleActiveDescendant", null, this.getFocusedItem());
        }
    }

    @Override
    protected void processKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
        if (keyEvent.isConsumed()) {
            return;
        }
        DTreeItem dTreeItem = this.getFocusedItem();
        boolean bl = false;
        if (dTreeItem != null) {
            bl = dTreeItem.isExpanded();
            dTreeItem.processKeyEvent(keyEvent);
            if (keyEvent.isConsumed()) {
                return;
            }
        }
        if (keyEvent.getID() == 401 && !keyEvent.isAltDown()) {
            this._handleKeyboardAction(keyEvent, dTreeItem, bl);
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
        if (mouseEvent.isConsumed() || !this.isEnabled()) {
            return;
        }
        int n = mouseEvent.getID();
        if (n == 501) {
            this.requestFocus();
            Point point = this.convertOuterToCanvas(mouseEvent.getX(), mouseEvent.getY());
            DTreeItem dTreeItem = this.getItemAt(point.x, point.y);
            if (dTreeItem != null) {
                this._mousePressItem = dTreeItem;
                DTreeSelection dTreeSelection = this.getSelection();
                this._selectedAtPress = dTreeSelection.isSelected(dTreeItem);
                ImmInsets immInsets = this.getBorderInsets();
                Point point2 = this.getCanvasOrigin();
                int n2 = dTreeItem.getX();
                int n3 = dTreeItem.getY();
                mouseEvent.translatePoint(-point2.x - immInsets.left, -point2.y - immInsets.top - n3);
                DTreeDecoration dTreeDecoration = this.getDecoration();
                dTreeDecoration.processMouseEvent(mouseEvent, dTreeItem);
                if (mouseEvent.isConsumed()) {
                    return;
                }
                mouseEvent.translatePoint(-n2, 0);
                dTreeItem.processMouseEvent(mouseEvent);
                mouseEvent.translatePoint(point2.x + immInsets.left + n2, point2.y + immInsets.top + n3);
                if (mouseEvent.isConsumed()) {
                    return;
                }
            }
            if (dTreeItem == null || !this._selectedAtPress) {
                this._handleMouseSelection(mouseEvent, dTreeItem, point);
            }
        } else if (n == 502) {
            if (this._mousePressItem != null) {
                if (this._mousePressItem.getTree() == this) {
                    this._dispatchItemMouseEvent(mouseEvent, this._mousePressItem);
                }
                this._mousePressItem = null;
            }
        } else if (n == 500) {
            Point point = this.convertOuterToCanvas(mouseEvent.getX(), mouseEvent.getY());
            DTreeItem dTreeItem = this.getItemAt(point.x, point.y);
            if (dTreeItem != null) {
                this._dispatchItemMouseEvent(mouseEvent, dTreeItem);
                if (mouseEvent.isConsumed()) {
                    return;
                }
                if (this._selectedAtPress && mouseEvent.getClickCount() == 1) {
                    this._handleMouseSelection(mouseEvent, dTreeItem, point);
                }
                this._handleMouseEdit(mouseEvent, dTreeItem);
            }
        }
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        super.processMouseMotionEvent(mouseEvent);
        if (mouseEvent.isConsumed() || !this.isEnabled()) {
            return;
        }
        if (mouseEvent.getID() == 503) {
            Point point = this.convertOuterToCanvas(mouseEvent.getX(), mouseEvent.getY());
            DTreeItem dTreeItem = this.getItemAt(point.x, point.y);
            if (dTreeItem != null) {
                this._dispatchItemMouseEvent(mouseEvent, dTreeItem);
            }
        } else if (mouseEvent.getID() == 506 && this._mousePressItem != null) {
            if (this._mousePressItem.getTree() != this) {
                this._mousePressItem = null;
            } else {
                this._dispatchItemMouseEvent(mouseEvent, this._mousePressItem);
            }
        }
    }

    protected void processSelectionEvent(DTreeSelectionEvent dTreeSelectionEvent) {
        Enumeration enumeration;
        int n = dTreeSelectionEvent.getID();
        if (n == 2006) {
            this._paintSelectionChanges(dTreeSelectionEvent);
        }
        if (this._selectlm != null && (enumeration = this._selectlm.getListeners()) != null) {
            while (enumeration.hasMoreElements()) {
                DTreeSelectionListener dTreeSelectionListener = (DTreeSelectionListener)enumeration.nextElement();
                switch (n) {
                    case 2005: {
                        dTreeSelectionListener.dTreeSelectionChanging(dTreeSelectionEvent);
                        break;
                    }
                    case 2006: {
                        dTreeSelectionListener.dTreeSelectionChanged(dTreeSelectionEvent);
                    }
                }
            }
        }
    }

    @Override
    protected AccessibleContext createAccessibleContext() {
        return new Access();
    }

    void __fireAccessibleEvent(String string, Object object, Object object2) {
        AccessibleContext accessibleContext = this.accessAccessibleContext();
        if (accessibleContext == null) {
            return;
        }
        if ("AccessibleChild".equals(string)) {
            if (object instanceof Accessible) {
                object = ((Accessible)object).getAccessibleContext();
            }
            if (object2 instanceof Accessible) {
                object2 = ((Accessible)object2).getAccessibleContext();
            }
        }
        accessibleContext.firePropertyChange(string, object, object2);
    }

    void __addRangeSet(DTreeRangeSet dTreeRangeSet) {
        if (this._rangeSets == null) {
            this._rangeSets = new Vector(1, 1);
        }
        this._rangeSets.addElement(dTreeRangeSet);
    }

    void __removeRangeSet(DTreeRangeSet dTreeRangeSet) {
        this._rangeSets.removeElement(dTreeRangeSet);
    }

    private Point _convertCanvasToInner(int n, int n2) {
        Point point = this.getCanvasOrigin();
        point.x += n;
        point.y += n2;
        return point;
    }

    private void _dispatchItemMouseEvent(MouseEvent mouseEvent, DTreeItem dTreeItem) {
        ImmInsets immInsets = this.getBorderInsets();
        Point point = this.getCanvasOrigin();
        int n = dTreeItem.getX();
        int n2 = dTreeItem.getY();
        mouseEvent.translatePoint(-point.x - immInsets.left - n, -point.y - immInsets.top - n2);
        dTreeItem.processMouseEvent(mouseEvent);
        mouseEvent.translatePoint(point.x + immInsets.left + n, point.y + immInsets.top + n2);
    }

    private boolean _endEdit(boolean bl) {
        if (!this.isEditing()) {
            return false;
        }
        this._editor.removeKeyListener(this._editDismisser);
        this._editor.removeFocusListener(this._editDismisser);
        this.remove(this._editor);
        this.requestFocus();
        int n = 2009;
        if (bl && this._editItem.commitEdit(this._editor)) {
            n = 2008;
        }
        DTreeItem dTreeItem = this._editItem;
        this._editItem = null;
        this._editor = null;
        this._editDismisser = null;
        this.processEvent(new DTreeItemEvent(this, n, dTreeItem));
        return n == 2008;
    }

    private void _fireVisibleDataPropertyChange() {
        Access access = (Access)this.accessAccessibleContext();
        if (access != null) {
            access.fireVisibleDataPropertyChange();
        }
    }

    private Rectangle _getEditBounds(DTreeItem dTreeItem) {
        Point point = this.convertCanvasToOuter(dTreeItem.getX(), dTreeItem.getY());
        Rectangle rectangle = dTreeItem.getEditBounds();
        int n = this.getInnerSize().width - rectangle.x - point.x;
        int n2 = point.x + rectangle.x;
        if (this.getActualReadingDirection() == 2) {
            n2 = 0;
            n = point.x + rectangle.width;
        }
        return new Rectangle(n2, point.y + rectangle.y, n, rectangle.height);
    }

    private Rectangle _getEditableBounds(DTreeItem dTreeItem) {
        Point point = this.convertCanvasToOuter(dTreeItem.getX(), dTreeItem.getY());
        Rectangle rectangle = dTreeItem.getEditBounds();
        int n = rectangle.width;
        int n2 = point.x + rectangle.x;
        if (this.getActualReadingDirection() == 2) {
            n2 = point.x;
        }
        return new Rectangle(n2, point.y + rectangle.y, n, rectangle.height);
    }

    private DTreeItem _getFirstVisibleItem() {
        int n;
        DTreeRootItem dTreeRootItem = this.getRoot();
        if (dTreeRootItem != null && (n = dTreeRootItem.getItemCount()) > 0) {
            return dTreeRootItem.getItem(0);
        }
        return null;
    }

    private DTreeItem _getLastVisibleItem() {
        return this._getLastVisibleItem(null);
    }

    private DTreeItem _getLastVisibleItem(DTreeItem dTreeItem) {
        DTreeItem dTreeItem2 = dTreeItem;
        if (dTreeItem2 == null) {
            dTreeItem2 = this.getRoot();
        }
        while (dTreeItem2 != null && dTreeItem2.isExpanded()) {
            int n = dTreeItem2.getItemCount();
            DTreeItem dTreeItem3 = null;
            if (n <= 0 || (dTreeItem3 = dTreeItem2.getItem(n - 1)) == null) break;
            dTreeItem2 = dTreeItem3;
        }
        if (dTreeItem2 == this.getRoot()) {
            return null;
        }
        return dTreeItem2;
    }

    private int _getRowsPerPage() {
        if (this._rowheight == 0) {
            return 0;
        }
        return this.getInnerSize().height / this._rowheight;
    }

    private DTreeItem _getSingleSelectedItem(DTreeRangeSet dTreeRangeSet) {
        if (dTreeRangeSet.getCount() != 1) {
            return null;
        }
        DTreeRange dTreeRange = dTreeRangeSet.getRange(0);
        if (dTreeRange.getCount() != 1) {
            return null;
        }
        DTreeItem dTreeItem = dTreeRange.getParent();
        return dTreeItem.getItem(dTreeRange.getStartIndex());
    }

    private int _getVisibleItemCount() {
        int n = 0;
        Enumeration enumeration = this.getExpandedEnumeration();
        while (enumeration.hasMoreElements()) {
            DTreeItem dTreeItem = (DTreeItem)enumeration.nextElement();
            n += dTreeItem.getItemCount();
        }
        return n;
    }

    private void _handleMouseEdit(MouseEvent mouseEvent, DTreeItem dTreeItem) {
        if (mouseEvent.getID() == 500 && mouseEvent.getClickCount() == 1) {
            Rectangle rectangle = this._getEditableBounds(dTreeItem);
            DTreeSelection dTreeSelection = this.getSelection();
            if (this._selectedAtPress && dTreeSelection.isSelected(dTreeItem) && rectangle.contains(mouseEvent.getX(), mouseEvent.getY())) {
                this.startEdit(dTreeItem);
            }
        }
    }

    private void _handleKeyboardAction(KeyEvent keyEvent, DTreeItem dTreeItem, boolean bl) {
        if (dTreeItem == null) {
            if (this.getRoot() == null) {
                return;
            }
            dTreeItem = this.getRoot();
        }
        boolean bl2 = this.getActualReadingDirection() == 2;
        int n = keyEvent.getKeyCode();
        DTreeItem dTreeItem2 = null;
        switch (n) {
            case 32: {
                dTreeItem2 = this._handleSpace(keyEvent, dTreeItem);
                break;
            }
            case 38: {
                dTreeItem2 = this.getPreviousVisibleItem(dTreeItem);
                break;
            }
            case 40: {
                dTreeItem2 = this.getNextVisibleItem(dTreeItem);
                break;
            }
            case 36: {
                dTreeItem2 = this._getFirstVisibleItem();
                break;
            }
            case 35: {
                dTreeItem2 = this._getLastVisibleItem();
                break;
            }
            case 33: {
                dTreeItem2 = this._handlePageUp(dTreeItem);
                break;
            }
            case 34: {
                dTreeItem2 = this._handlePageDown(dTreeItem);
                break;
            }
            case 37: {
                if (bl2) {
                    dTreeItem2 = this._handleRight(dTreeItem);
                    break;
                }
                dTreeItem2 = this._handleLeft(dTreeItem);
                break;
            }
            case 39: {
                if (bl2) {
                    dTreeItem2 = this._handleLeft(dTreeItem);
                    break;
                }
                dTreeItem2 = this._handleRight(dTreeItem);
                break;
            }
            case 113: {
                this._handleKeyboardEdit(dTreeItem);
                keyEvent.consume();
            }
        }
        if (dTreeItem2 != null) {
            if (!keyEvent.isControlDown() || keyEvent.isShiftDown() || n == 32) {
                this._updateSelection(keyEvent, dTreeItem2);
            }
            this.setFocusedItem(dTreeItem2);
            keyEvent.consume();
        }
    }

    private void _handleKeyboardEdit(DTreeItem dTreeItem) {
        if (dTreeItem != null && dTreeItem != this.getRoot()) {
            this.startEdit(dTreeItem);
        }
    }

    private DTreeItem _handleLeft(DTreeItem dTreeItem) {
        DTreeItem dTreeItem2 = null;
        if (!(dTreeItem == null || dTreeItem.isExpandable() && dTreeItem.isExpanded() || (dTreeItem2 = dTreeItem.getParent()) != this.getRoot())) {
            dTreeItem2 = null;
        }
        return dTreeItem2;
    }

    private void _handleMouseSelection(MouseEvent mouseEvent, DTreeItem dTreeItem, Point point) {
        if (dTreeItem != null) {
            if (dTreeItem.getTree() == null) {
                dTreeItem = null;
            } else {
                int n = dTreeItem.getX();
                int n2 = dTreeItem.getSize().width;
                if (point.x < n || point.x >= n + n2) {
                    dTreeItem = null;
                }
            }
        }
        if (dTreeItem != null) {
            this._updateSelection(mouseEvent, dTreeItem);
        }
    }

    private DTreeItem _handlePageDown(DTreeItem dTreeItem) {
        DTreeItem dTreeItem2 = dTreeItem;
        for (int i = this._getRowsPerPage() - 1; i > 0 && dTreeItem2 != null; --i) {
            dTreeItem2 = this.getNextVisibleItem(dTreeItem2);
        }
        if (dTreeItem2 == null) {
            dTreeItem2 = this._getLastVisibleItem();
        }
        return dTreeItem2;
    }

    private DTreeItem _handlePageUp(DTreeItem dTreeItem) {
        DTreeItem dTreeItem2 = dTreeItem;
        for (int i = this._getRowsPerPage() - 1; i > 0 && dTreeItem2 != null; --i) {
            dTreeItem2 = this.getPreviousVisibleItem(dTreeItem2);
        }
        if (dTreeItem2 == null) {
            dTreeItem2 = this._getFirstVisibleItem();
        }
        return dTreeItem2;
    }

    private DTreeItem _handleRight(DTreeItem dTreeItem) {
        int n;
        if (dTreeItem != null && dTreeItem.isExpandable() && dTreeItem.isExpanded() && (n = dTreeItem.getItemCount()) > 0) {
            return dTreeItem.getItem(0);
        }
        return null;
    }

    private DTreeItem _handleSpace(KeyEvent keyEvent, DTreeItem dTreeItem) {
        if (keyEvent.isShiftDown() || keyEvent.isControlDown()) {
            return dTreeItem;
        }
        DTreeSelection dTreeSelection = this.getSelection();
        if (!dTreeSelection.isSelected(dTreeItem)) {
            dTreeSelection.toggleItem(dTreeItem);
        }
        return null;
    }

    private void _makeChildrenVisible(DTreeItem dTreeItem) {
        DTreeItem dTreeItem2 = this._getLastVisibleItem(dTreeItem);
        if (dTreeItem2 == null) {
            this.makeVisible(dTreeItem);
            return;
        }
        this.validate();
        Point point = this.getCanvasOrigin();
        int n = point.y;
        Rectangle rectangle = this.getInnerBounds();
        int n2 = dTreeItem.getY();
        int n3 = dTreeItem2.getY();
        int n4 = dTreeItem2.getSize().height;
        Point point2 = this._convertCanvasToInner(0, n3);
        if (point2.y < 0) {
            n = -n3;
        } else if (point2.y + n4 > rectangle.height) {
            n = rectangle.height - (n3 + n4);
        }
        if (n2 < -n) {
            n = -n2;
        }
        if (n != point.y) {
            this.setCanvasOrigin(point.x, n);
        }
    }

    private void _makeHorizontalVisible(DTreeItem dTreeItem) {
        this.makeVisible(dTreeItem);
        Point point = this.getCanvasOrigin();
        Rectangle rectangle = this.getInnerBounds();
        int n = dTreeItem.getX();
        Point point2 = this._convertCanvasToInner(n, 0);
        int n2 = dTreeItem.getSize().width;
        int n3 = point.x;
        if (point2.x < 0) {
            n3 = -n;
        } else if (point2.x + n2 > rectangle.width && n + (n3 = rectangle.width - (n + n2)) < 0) {
            n3 = -n;
        }
        if (point.x != n3) {
            this.setCanvasOrigin(n3, point.y);
        }
    }

    private void _paintItemImmediate(DTreeItem dTreeItem) {
        if (dTreeItem.getTree() != this || !DTree.isItemVisible(dTreeItem)) {
            return;
        }
        this.validate();
        int n = dTreeItem.getX();
        int n2 = dTreeItem.getY();
        Point point = this.convertCanvasToOuter(n, n2);
        Dimension dimension = dTreeItem.getSize();
        this.paintImmediate(point.x, point.y, dimension.width, dimension.height);
    }

    private void _paintSelectionChanges(DTreeSelectionEvent dTreeSelectionEvent) {
        DTreeItem dTreeItem = this._getSingleSelectedItem(dTreeSelectionEvent.getOldSelectionRanges());
        DTreeItem dTreeItem2 = this._getSingleSelectedItem(dTreeSelectionEvent.getNewSelectionRanges());
        if (dTreeItem != null && dTreeItem2 != null) {
            this._paintItemImmediate(dTreeItem);
            this._paintItemImmediate(dTreeItem2);
        } else {
            this.repaint();
        }
    }

    private void _repairDecoration(PaintContext paintContext, Graphics graphics, DTreeItem dTreeItem, DTreeDecoration dTreeDecoration, int n) {
        DTreeRootItem dTreeRootItem = this.getRoot();
        while (dTreeItem != dTreeRootItem) {
            int n2 = dTreeItem.getX();
            int n3 = dTreeItem.getY();
            Dimension dimension = dTreeItem.getSize();
            graphics.translate(0, n3);
            dTreeDecoration.paintDecoration(paintContext, graphics, dTreeItem, this.getActualReadingDirection() == 2 ? n - (n2 + dimension.width) : n2, dimension.height);
            graphics.translate(0, -n3);
            dTreeItem = dTreeItem.getParent();
        }
    }

    private void _setRoot(DTreeRootItem dTreeRootItem) {
        if (this._root != dTreeRootItem) {
            AccessibleContext accessibleContext = this.accessAccessibleContext();
            if (this._root != null) {
                DTreeSelection dTreeSelection = this.getSelection();
                if (dTreeSelection != null) {
                    dTreeSelection.selectItem(null);
                }
                this._root.setTree(null);
                if (accessibleContext != null && this._root instanceof Accessible) {
                    accessibleContext.firePropertyChange("AccessibleChild", ((Accessible)((Object)this._root)).getAccessibleContext(), null);
                }
                this._root = null;
            }
            if (dTreeRootItem != null) {
                this._root = dTreeRootItem;
                this._root.setTree(this);
                this._root.setExpanded(true);
                if (accessibleContext != null && this._root instanceof Accessible) {
                    accessibleContext.firePropertyChange("AccessibleChild", null, ((Accessible)((Object)this._root)).getAccessibleContext());
                }
            }
            this.invalidateCanvas();
        }
    }

    private void _updateCanvasBounds(Rectangle rectangle, DTreeItem dTreeItem) {
        int n;
        int n2;
        Point point = this.getCanvasOrigin();
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.getCanvasSize();
        int n3 = dimension2.width;
        while (dTreeItem != null && dTreeItem.getY() <= rectangle.y + rectangle.height) {
            n2 = dTreeItem.getX();
            if (n2 < n3) {
                n3 = n2;
            }
            dTreeItem = this.getNextVisibleItem(dTreeItem);
        }
        n2 = Math.max(dimension2.width, dimension2.width - n3);
        if (dimension.width > n2) {
            n2 = dimension.width;
        }
        if ((n = dimension2.width >= dimension.width ? point.x + dimension2.width - n2 : dimension.width - n2) != point.x || n2 != dimension2.width) {
            this.storeCanvasOrigin(n, point.y);
            this.setCanvasSize(n2, dimension2.height);
            this.repaintInterior();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _updateSelection(InputEvent inputEvent, DTreeItem dTreeItem) {
        DTreeSelection dTreeSelection = this.getSelection();
        this.freezeRepaints();
        try {
            int n = inputEvent instanceof MouseEvent ? Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() : 2;
            if (inputEvent.isShiftDown()) {
                dTreeSelection.extendSelection(dTreeItem);
            } else if ((n & InputEventUtils.getMods(inputEvent)) != 0) {
                dTreeSelection.toggleItem(dTreeItem);
            } else {
                dTreeSelection.selectItem(dTreeItem);
            }
        }
        finally {
            this.unfreezeRepaints();
        }
    }

    private class Access
    extends AccessibleLWComponent
    implements DTreeSelectionListener,
    DTreeExpansionListener {
        public Access() {
            super(DTree.this);
            DTree.this.addSelectionListener(this);
            DTree.this.addExpansionListener(this);
        }

        @Override
        public int getAccessibleChildrenCount() {
            return DTree.this.getRoot() instanceof Accessible ? 1 : 0;
        }

        @Override
        public Accessible getAccessibleChild(int n) {
            DTreeRootItem dTreeRootItem;
            if (n == 0 && (dTreeRootItem = DTree.this.getRoot()) instanceof Accessible) {
                return (Accessible)((Object)dTreeRootItem);
            }
            return null;
        }

        @Override
        public Accessible getAccessibleAt(Point point) {
            Point point2 = DTree.this.convertOuterToCanvas(point.x, point.y);
            DTreeItem dTreeItem = DTree.this.getItemAt(point2.x, point2.y);
            if (dTreeItem instanceof Accessible) {
                return (Accessible)((Object)dTreeItem);
            }
            return null;
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TREE;
        }

        @Override
        public void dTreeSelectionChanged(DTreeSelectionEvent dTreeSelectionEvent) {
            DTreeRangeSet dTreeRangeSet = dTreeSelectionEvent.getOldSelectionRanges();
            DTreeRangeSet dTreeRangeSet2 = dTreeSelectionEvent.getNewSelectionRanges();
            this.firePropertyChange("AccessibleSelection", DTree.this.getFocusedItem(), null);
        }

        @Override
        public void dTreeItemExpanded(DTreeItemEvent dTreeItemEvent) {
            DTreeItem dTreeItem = dTreeItemEvent.getItem();
            if (dTreeItem instanceof Accessible) {
                this.firePropertyChange("AccessibleState", AccessibleState.COLLAPSED, AccessibleState.EXPANDED);
                Accessible accessible = (Accessible)((Object)dTreeItem);
                accessible.getAccessibleContext().firePropertyChange("AccessibleState", AccessibleState.COLLAPSED, AccessibleState.EXPANDED);
            }
        }

        @Override
        public void dTreeItemCollapsed(DTreeItemEvent dTreeItemEvent) {
            DTreeItem dTreeItem = dTreeItemEvent.getItem();
            if (dTreeItem instanceof Accessible) {
                this.firePropertyChange("AccessibleState", AccessibleState.EXPANDED, AccessibleState.COLLAPSED);
                Accessible accessible = (Accessible)((Object)dTreeItem);
                accessible.getAccessibleContext().firePropertyChange("AccessibleState", AccessibleState.EXPANDED, AccessibleState.COLLAPSED);
            }
        }

        @Override
        public void dTreeSelectionChanging(DTreeSelectionEvent dTreeSelectionEvent) {
        }

        @Override
        public void dTreeItemExpanding(DTreeItemEvent dTreeItemEvent) {
        }

        @Override
        public void dTreeItemCollapsing(DTreeItemEvent dTreeItemEvent) {
        }

        public void fireVisibleDataPropertyChange() {
            this.firePropertyChange("AccessibleVisibleData", null, null);
        }
    }

    private class EditDismisser
    extends KeyAdapter
    implements FocusListener {
        private boolean _enterPressed;

        private EditDismisser() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                this._enterPressed = true;
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            if (n == 10) {
                if (this._enterPressed) {
                    DTree.this.commitEdit();
                    keyEvent.consume();
                }
            } else if (n == 27) {
                DTree.this.cancelEdit();
                keyEvent.consume();
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            DTree.this.commitEdit();
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
        }
    }
}

