/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.comboBox;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import oracle.bali.share.sort.Sort;
import oracle.bali.share.sort.StringComparator;
import oracle.ewt.access.AccessibleContextProxy;
import oracle.ewt.lwAWT.LWChoice;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.plaf.ComboBoxUI;
import oracle.ewt.util.ImmInsets;

public class ComboBox
extends LWChoice {
    public static final int USER_TEXT = -1;
    private int _selectedIndex;
    private boolean _dirty;
    private boolean _isEditable;
    private boolean _isEditing;
    private LWTextField _editor;
    private String _userText;
    private String _lastSelection = "";

    public ComboBox() {
        this(true);
    }

    public ComboBox(boolean bl) {
        this._isEditable = bl;
        this._dirty = false;
        this.updateUI(ComboBox.class);
        this._selectedIndex = -1;
        super.setLayout(null);
    }

    @Override
    public String getItem(int n) {
        if (n == -1) {
            return this._getUserText();
        }
        return super.getItem(n);
    }

    @Override
    public void remove(int n) {
        String string;
        String string2 = this.getSelectedItem();
        super.remove(n);
        if (this._selectedIndex != -1) {
            this._selectedIndex = super.getSelectedIndex();
        }
        if (this.isEditing() && string2 != (string = this.getSelectedItem())) {
            this._setText(string);
        }
    }

    @Override
    public void insert(String string, int n) {
        String string2;
        String string3 = this.getSelectedItem();
        super.insert(string, n);
        if (this._selectedIndex != -1) {
            this._selectedIndex = super.getSelectedIndex();
        }
        if (this.isEditing() && string3 != (string2 = this.getSelectedItem())) {
            this._setText(string2);
        }
    }

    @Override
    public synchronized void removeAll() {
        super.removeAll();
        this._selectedIndex = -1;
        this._setText("");
    }

    @Override
    public synchronized String getSelectedItem() {
        int n = this.getSelectedIndex();
        if (n == -1) {
            return this._userText;
        }
        return this.getItem(n);
    }

    @Override
    public int getSelectedIndex() {
        if (this._dirty) {
            this._updateUserText();
        }
        return this._selectedIndex;
    }

    @Override
    public void select(String string) {
        int n = this._getItemIndex(string);
        if (n == -1) {
            this._setUserText(string);
            this._setDirty(false);
        } else {
            this.select(n);
        }
    }

    @Override
    public void select(int n) {
        super.select(n);
        this._selectedIndex = n;
        String string = this.getItem(n);
        this._setText(string);
        this._setDirty(false);
        this._lastSelection = string;
    }

    public void addTextListener(TextListener textListener) {
        LWTextField lWTextField = this.getLWTextField();
        lWTextField.addTextListener(textListener);
    }

    public void removeTextListener(TextListener textListener) {
        LWTextField lWTextField = this.getLWTextField();
        lWTextField.removeTextListener(textListener);
    }

    @Override
    public void addKeyListener(KeyListener keyListener) {
        super.addKeyListener(keyListener);
        this.getLWTextField().addKeyListener(keyListener);
    }

    @Override
    public void removeKeyListener(KeyListener keyListener) {
        super.removeKeyListener(keyListener);
        this.getLWTextField().removeKeyListener(keyListener);
    }

    public boolean isEditable() {
        return this._isEditable;
    }

    public void setEditable(boolean bl) {
        if (this._isEditable != bl) {
            this.setDropDownVisible(false);
            this._isEditable = bl;
            if (bl) {
                this.getLWTextField().setVisible(true);
            }
            if (!bl && this.isEditing()) {
                this._stopEdit();
                if (this.getSelectedIndex() == -1 && this.getItemCount() > 0) {
                    this.select(0);
                }
            } else if (bl && !this.isEditing()) {
                this._startEdit();
            }
            if (!bl) {
                this.getLWTextField().setVisible(false);
            }
            this.getComboBoxUI().installUI(this);
            this.updateListUI();
            this.setEnabled(this.isEnabled());
            this.validate();
            this.repaint();
        }
    }

    public boolean isEditing() {
        return this._isEditing;
    }

    public String[] getItems() {
        int n = this.getItemCount();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.getItem(i);
        }
        return stringArray;
    }

    public synchronized void setItems(String[] stringArray) {
        this.removeAll();
        if (stringArray != null) {
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                this.add(stringArray[i]);
            }
        }
        if (this.isEditing()) {
            this._setUserText("");
        }
    }

    public LWTextField getLWTextField() {
        if (this._editor == null) {
            this._editor = this.createLWTextField();
        }
        return this._editor;
    }

    public synchronized void sort(StringComparator stringComparator) {
        Object[] objectArray = this.getItems();
        String string = this.getSelectedItem();
        Sort.qSort(objectArray, objectArray.length, stringComparator);
        this.setItems((String[])objectArray);
        this.select(string);
    }

    @Override
    public void requestFocus() {
        if (this.isEditable()) {
            if (!this.isEditing()) {
                this._startEdit();
            }
            this.getLWTextField().requestFocus();
        } else {
            super.requestFocus();
        }
    }

    @Override
    public boolean isFocusTraversable() {
        return !this.isEditable();
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.getLWTextField().setEnabled(bl);
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        LWTextField lWTextField = this.getLWTextField();
        if (lWTextField != null) {
            lWTextField.setBackground(color);
        }
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        LWTextField lWTextField = this.getLWTextField();
        if (lWTextField != null) {
            lWTextField.setForeground(color);
        }
    }

    @Override
    public Object getUIClassID() {
        return "ComboBoxUI";
    }

    protected final ComboBoxUI getComboBoxUI() {
        return (ComboBoxUI)this.getUI();
    }

    @Override
    public void doLayout() {
        super.doLayout();
        if (this.isEditable()) {
            Dimension dimension = this.getComponent(0).getSize();
            Dimension dimension2 = this.getSize();
            LWTextField lWTextField = this.getLWTextField();
            if (lWTextField.getParent() != this) {
                this.add(lWTextField);
            }
            PaintContext paintContext = this.getPaintContext();
            BorderPainter borderPainter = this.getBorderPainter();
            ImmInsets immInsets = borderPainter.getInsets(paintContext);
            int n = dimension2.width - dimension.width;
            int n2 = this.getActualReadingDirection() == 1 ? immInsets.left : immInsets.left + dimension.width;
            lWTextField.setBounds(n2, immInsets.top, n - immInsets.left - immInsets.right, dimension2.height - immInsets.top - immInsets.bottom);
            if (!this.isEditing()) {
                this._startEdit();
            }
        }
    }

    @Override
    protected void updateUI(Class clazz) {
        if (clazz == ComboBox.class) {
            this.updateUI();
        }
    }

    @Override
    protected boolean allowDropDown() {
        if (!this.isEditable()) {
            return super.allowDropDown();
        }
        int n = this.getItemCount();
        return n > 1 || n == 1 && this.getSelectedIndex() == -1;
    }

    @Override
    protected void processItemEvent(ItemEvent itemEvent) {
        super.processItemEvent(itemEvent);
        if (itemEvent.getStateChange() == 2) {
            return;
        }
        if (this.isEditing()) {
            this._setText(this.getSelectedItem());
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (this.isEditable()) {
            mouseEvent.consume();
        }
        super.processMouseEvent(mouseEvent);
    }

    @Override
    protected Object getPaintData(Object object) {
        if (object.equals("Button")) {
            return this.getComponent(0);
        }
        return super.getPaintData(object);
    }

    protected final void fireItemEvent(int n, int n2) {
        this.fireItemEvent(this.getItem(n), n2);
    }

    @Override
    protected void fireItemEvent(String string, int n) {
        if (n == 2) {
            string = this._lastSelection;
        }
        ItemEvent itemEvent = new ItemEvent(this, 701, string, n);
        this.processEvent(itemEvent);
    }

    LWTextField createLWTextField() {
        ComboBoxUI comboBoxUI = this.getComboBoxUI();
        if (comboBoxUI != null) {
            Field field = new Field();
            BorderPainter borderPainter = comboBoxUI.getFieldBorderPainter(this);
            field.setBorderPainter(borderPainter);
            return field;
        }
        return null;
    }

    void _setDirty(boolean bl) {
        if (bl && !this._dirty) {
            this._lastSelection = this.getSelectedItem();
        }
        boolean bl2 = this._dirty;
        this._dirty = bl;
        if (bl2 != this._dirty) {
            this.setEnabled(this.isEnabled());
        }
    }

    void _postFocusEvent(FocusEvent focusEvent) {
        this.processFocusEvent(focusEvent);
    }

    private int _getItemIndex(String string) {
        int n = this.getItemCount();
        for (int i = 0; i < n; ++i) {
            String string2 = this.getItem(i);
            if (!string.equals(string2)) continue;
            return i;
        }
        return -1;
    }

    private void _updateUserText() {
        int n;
        this._userText = this.getLWTextField().getText();
        this._selectedIndex = n = this._getItemIndex(this._userText);
    }

    private String _getUserText() {
        if (this._dirty) {
            this._updateUserText();
        }
        return this._userText;
    }

    private void _setUserText(String string) {
        this._userText = string;
        if (this._userText == null) {
            this._userText = "";
        }
        if (this.isEditable()) {
            this._selectedIndex = -1;
            this._setText(string);
        }
    }

    private void _startEdit() {
        if (!this.isEditing()) {
            this._isEditing = true;
            LWTextField lWTextField = this.getLWTextField();
            String string = this.getSelectedItem();
            this._setText(string);
            lWTextField.setVisible(true);
        }
    }

    private void _stopEdit() {
        if (!this.isEditing()) {
            return;
        }
        if (this.getLWTextField().hasFocus()) {
            this.requestFocus();
        }
        this.getLWTextField().setVisible(false);
        this._isEditing = false;
    }

    private void _setText(String string) {
        LWTextField lWTextField = this.getLWTextField();
        lWTextField.setText(string);
        lWTextField.selectAll();
        AccessibleContext accessibleContext = this.accessAccessibleContext();
        if (accessibleContext != null) {
            accessibleContext.firePropertyChange("AccessibleVisibleData", null, string);
            accessibleContext.firePropertyChange("AccessibleText", null, string);
        }
    }

    private void _toggleDropDown() {
        super.toggleDropDown();
    }

    void _processEnter(KeyEvent keyEvent) {
        if (this.isDropDownVisible()) {
            this.setDropDownVisible(false);
            keyEvent.consume();
        }
        this._submitUserText();
    }

    void _processEscape(KeyEvent keyEvent) {
        if (this.isDropDownVisible()) {
            this.setDropDownVisible(false);
            keyEvent.consume();
        }
    }

    void _processArrow(KeyEvent keyEvent, boolean bl) {
        int n = this.getSelectedIndex();
        int n2 = -1;
        if (n == -1) {
            n2 = 0;
        } else if (bl) {
            if (n > 0) {
                n2 = n - 1;
            }
        } else if (n < this.getItemCount() - 1) {
            n2 = n + 1;
        }
        if (n2 != -1 && n2 != n) {
            if (n == -1) {
                this.fireItemEvent(this._lastSelection, 2);
            } else {
                this.fireItemEvent(n, 2);
            }
            this.select(n2);
            this.fireItemEvent(n2, 1);
            keyEvent.consume();
            this.updateButtonEnabled();
        }
    }

    void _submitUserText() {
        if (this._dirty) {
            this.fireItemEvent(this._lastSelection, 2);
            String string = this._getUserText();
            this.select(string);
            this.fireItemEvent(-1, 1);
            this._lastSelection = string;
        }
    }

    @Override
    protected Component getEditComponent() {
        if (this.isEditable()) {
            return this.getLWTextField();
        }
        return null;
    }

    private class Proxy
    extends AccessibleContextProxy {
        private AccessibleContext _ac;

        public Proxy(AccessibleContext accessibleContext) {
            this._ac = accessibleContext;
        }

        @Override
        public String getAccessibleName() {
            String string = super.getAccessibleName();
            return string == null ? this.getAccessibleParent().getAccessibleContext().getAccessibleName() : string;
        }

        @Override
        public String getAccessibleDescription() {
            String string = super.getAccessibleDescription();
            return string == null ? this.getAccessibleParent().getAccessibleContext().getAccessibleDescription() : string;
        }

        @Override
        public Accessible getAccessibleParent() {
            Accessible accessible = super.getAccessibleParent();
            if (accessible == null) {
                accessible = ComboBox.this;
            }
            return accessible;
        }

        @Override
        protected AccessibleContext getAccessibleContext() {
            return this._ac;
        }
    }

    private class Field
    extends LWTextField
    implements KeyListener {
        private boolean _filterTyped;

        Field() {
            this.addKeyListener(this);
        }

        @Override
        protected AccessibleContext createAccessibleContext() {
            AccessibleContext accessibleContext = super.createAccessibleContext();
            return new Proxy(accessibleContext);
        }

        @Override
        protected void processKeyEvent(KeyEvent keyEvent) {
            super.processKeyEvent(keyEvent);
            if (!keyEvent.isConsumed() && keyEvent.getID() == 401) {
                int n = keyEvent.getKeyCode();
                switch (n) {
                    case 40: {
                        if (this._filterAltArrow(keyEvent)) break;
                        ComboBox.this._processArrow(keyEvent, false);
                        break;
                    }
                    case 38: {
                        if (this._filterAltArrow(keyEvent)) break;
                        ComboBox.this._processArrow(keyEvent, true);
                        break;
                    }
                    case 10: {
                        ComboBox.this._processEnter(keyEvent);
                        break;
                    }
                    case 27: {
                        ComboBox.this._processEscape(keyEvent);
                    }
                }
            }
        }

        @Override
        protected void processTextEvent(TextEvent textEvent) {
            ComboBox.this._setDirty(true);
            textEvent = new TextEvent(ComboBox.this, textEvent.getID());
            super.processTextEvent(textEvent);
        }

        @Override
        protected void processFocusEvent(FocusEvent focusEvent) {
            if (focusEvent.getID() == 1004) {
                this.selectAll();
            } else {
                ComboBox.this._submitUserText();
            }
            ComboBox.this._postFocusEvent(new FocusEvent(ComboBox.this, focusEvent.getID(), focusEvent.isTemporary()));
            super.processFocusEvent(focusEvent);
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            if (this._filterTyped) {
                this._filterTyped = false;
                keyEvent.consume();
            }
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }

        private boolean _filterAltArrow(KeyEvent keyEvent) {
            if (keyEvent.isAltDown()) {
                ComboBox.this._toggleDropDown();
                keyEvent.consume();
                this._filterTyped = true;
                return true;
            }
            return false;
        }
    }
}

