/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.button;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import oracle.ewt.access.AccessibleLWComponent;
import oracle.ewt.button.ContinuousButton;
import oracle.ewt.button.PulsingButtonEvent;
import oracle.ewt.button.PulsingButtonListener;
import oracle.ewt.button.SpinAccelerator;
import oracle.ewt.button.SpinButtonEvent;
import oracle.ewt.button.SpinButtonListener;
import oracle.ewt.event.ListenerManager;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.plaf.ComponentUI;
import oracle.ewt.plaf.SpinButtonUI;
import oracle.ewt.util.LocaleUtils;

public class SpinButton
extends LWComponent
implements Runnable,
PulsingButtonListener {
    private static final String _RESOURCE_BUNDLE = "oracle.ewt.access.resource.AccessibilityBundle";
    private static final String _INCREMENT_KEY = "INCREMENT";
    private static final String _DECREMENT_KEY = "DECREMENT";
    private boolean _incrementDisabled;
    private boolean _decrementDisabled;
    private boolean _vertical;
    private boolean _standAlone;
    private ContinuousButton _increment = new ContinuousButton(this);
    private ContinuousButton _decrement = new ContinuousButton(this);
    private ContinuousButton _buttonSpinning;
    private SpinAccelerator _accelerator;
    ListenerManager _listeners;
    private static int _sInstanceCounter;

    public SpinButton() {
        this(true);
    }

    public SpinButton(boolean bl) {
        this(bl, true);
    }

    public SpinButton(boolean bl, boolean bl2) {
        this._increment.setFocusable(false);
        this._decrement.setFocusable(false);
        this._increment.addPulsingButtonListener(this);
        this._decrement.addPulsingButtonListener(this);
        this._standAlone = bl2;
        this._vertical = !bl;
        this.setVertical(bl);
        this.setLayout(null);
        this.add(this._increment);
        this.add(this._decrement);
        this.updateUI(SpinButton.class);
    }

    @Override
    public Object getUIClassID() {
        return "SpinButtonUI";
    }

    public void setVertical(boolean bl) {
        if (bl != this._vertical) {
            this._vertical = bl;
            this._updateButtonPainters();
            this.invalidate();
        }
    }

    public boolean isVertical() {
        return this._vertical;
    }

    public void setIncrementEnabled(boolean bl) {
        if (bl != this.isIncrementEnabled()) {
            if (this.isEnabled()) {
                this._increment.setEnabled(bl);
            }
            this._incrementDisabled = !bl;
        }
    }

    public boolean isIncrementEnabled() {
        return !this._incrementDisabled;
    }

    public void setDecrementEnabled(boolean bl) {
        if (bl != this.isDecrementEnabled()) {
            if (this.isEnabled()) {
                this._decrement.setEnabled(bl);
            }
            this._decrementDisabled = !bl;
        }
    }

    public boolean isDecrementEnabled() {
        return !this._decrementDisabled;
    }

    public void setIncrementArmed(boolean bl) {
        if (bl) {
            this._decrement.setArmed(false);
            this._increment.setArmedState();
        } else {
            this._increment.setArmed(bl);
        }
    }

    public void setDecrementArmed(boolean bl) {
        if (bl) {
            this._increment.setArmed(false);
            this._decrement.setArmedState();
        } else {
            this._decrement.setArmed(bl);
        }
    }

    public SpinAccelerator getAccelerator() {
        return this._accelerator;
    }

    public void setAccelerator(SpinAccelerator spinAccelerator) {
        this._accelerator = spinAccelerator;
    }

    public void addSpinButtonListener(SpinButtonListener spinButtonListener) {
        if (this._listeners == null) {
            this._listeners = new ListenerManager();
        }
        this._listeners.addListener(spinButtonListener);
    }

    public void removeSpinButtonListener(SpinButtonListener spinButtonListener) {
        this._listeners.removeListener(spinButtonListener);
    }

    public boolean isStandalone() {
        return this._standAlone;
    }

    @Override
    public synchronized void doLayout() {
        Dimension dimension = this.getSize();
        int n = dimension.width;
        boolean bl = this.isVertical();
        int n2 = dimension.height;
        if (bl) {
            this._increment.setBounds(0, 0, n, n2 /= 2);
            this._decrement.setBounds(0, n2, n, n2);
        } else {
            this._decrement.setBounds(0, 0, n /= 2, n2);
            this._increment.setBounds(n, 0, n, n2);
        }
    }

    @Override
    public void enable() {
        this._increment.setEnabled(this.isIncrementEnabled());
        this._decrement.setEnabled(this.isDecrementEnabled());
        super.enable();
    }

    @Override
    public void disable() {
        this._increment.disable();
        this._decrement.disable();
        super.disable();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = this._increment.getPreferredSize();
        Dimension dimension2 = this._decrement.getPreferredSize();
        if (this.isVertical()) {
            return new Dimension(Math.max(dimension.width, dimension2.width), dimension.height + dimension2.height);
        }
        return new Dimension(dimension.width + dimension2.width, Math.max(dimension.height, dimension2.height));
    }

    @Override
    public void pulseStartPulsing(PulsingButtonEvent pulsingButtonEvent) {
        this._buttonSpinning = (ContinuousButton)pulsingButtonEvent.getSource();
        if (this._accelerator != null) {
            this._accelerator.reset();
            this._buttonSpinning.setDelay(this._accelerator.getInterval());
        }
    }

    @Override
    public void pulseEndPulsing(PulsingButtonEvent pulsingButtonEvent) {
        this._buttonSpinning = null;
    }

    @Override
    public void run() {
        ContinuousButton continuousButton = this._buttonSpinning;
        if (continuousButton != null) {
            int n = continuousButton == this._increment ? 1 : 2;
            this.__fireSpinButtonEvent(n);
            if (this._accelerator != null && continuousButton != null) {
                this._accelerator.advance();
                continuousButton.setDelay(this._accelerator.getInterval());
            }
        }
    }

    @Override
    public boolean isChildClipped(Component component) {
        return this.isClippedBySibling();
    }

    @Override
    protected void setUI(ComponentUI componentUI) {
        super.setUI(componentUI);
        if (componentUI != null) {
            this._updateButtonPainters();
        }
    }

    protected final SpinButtonUI getSpinButtonUI() {
        return (SpinButtonUI)this.getUI();
    }

    @Override
    protected void processEventImpl(AWTEvent aWTEvent) {
        if (aWTEvent instanceof SpinButtonEvent) {
            this.processSpinButtonEvent((SpinButtonEvent)aWTEvent);
        } else {
            super.processEventImpl(aWTEvent);
        }
    }

    protected void processSpinButtonEvent(SpinButtonEvent spinButtonEvent) {
        Enumeration enumeration;
        ListenerManager listenerManager = this._listeners;
        if (listenerManager != null && (enumeration = listenerManager.getListeners()) != null) {
            while (enumeration.hasMoreElements()) {
                SpinButtonListener spinButtonListener = (SpinButtonListener)enumeration.nextElement();
                switch (spinButtonEvent.getID()) {
                    case 2000: {
                        spinButtonListener.spinButtonSpinning(spinButtonEvent);
                        break;
                    }
                }
            }
        }
    }

    @Override
    protected AccessibleContext createAccessibleContext() {
        return new Access();
    }

    @Override
    protected String getDefaultName() {
        return this.getBaseClassName() + _sInstanceCounter++;
    }

    private void _updateButtonPainters() {
        if (this._increment != null) {
            SpinButtonUI spinButtonUI = this.getSpinButtonUI();
            this._increment.setPainter(spinButtonUI.getIncrementPainter(this));
            this._decrement.setPainter(spinButtonUI.getDecrementPainter(this));
        }
    }

    void __fireSpinButtonEvent(int n) {
        if (this._listeners != null) {
            this.processEvent(new SpinButtonEvent(this, 2000, n));
        }
    }

    private class Access
    extends AccessibleLWComponent
    implements AccessibleAction {
        public Access() {
            super(SpinButton.this);
        }

        @Override
        public AccessibleAction getAccessibleAction() {
            return this;
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.AWT_COMPONENT;
        }

        @Override
        public int getAccessibleChildrenCount() {
            return 0;
        }

        @Override
        public Accessible getAccessibleChild(int n) {
            return null;
        }

        @Override
        public int getAccessibleActionCount() {
            return 2;
        }

        @Override
        public String getAccessibleActionDescription(int n) {
            Locale locale = LocaleUtils.getDefaultableLocale(SpinButton.this);
            ResourceBundle resourceBundle = ResourceBundle.getBundle(SpinButton._RESOURCE_BUNDLE, LocaleUtils.getTranslationLocale(locale));
            switch (n) {
                case 0: {
                    return resourceBundle.getString(SpinButton._INCREMENT_KEY);
                }
                case 1: {
                    return resourceBundle.getString(SpinButton._DECREMENT_KEY);
                }
            }
            return null;
        }

        @Override
        public boolean doAccessibleAction(int n) {
            int n2;
            switch (n) {
                case 0: {
                    if (!SpinButton.this.isIncrementEnabled()) {
                        return false;
                    }
                    n2 = 1;
                    break;
                }
                case 1: {
                    if (!SpinButton.this.isDecrementEnabled()) {
                        return false;
                    }
                    n2 = 2;
                    break;
                }
                default: {
                    return false;
                }
            }
            SpinButton.this.__fireSpinButtonEvent(n2);
            return true;
        }
    }
}

