/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.button;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.util.Enumeration;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import oracle.ewt.button.PulsingButtonEvent;
import oracle.ewt.button.PulsingButtonListener;
import oracle.ewt.event.ListenerManager;
import oracle.ewt.lwAWT.AbstractButton;
import oracle.ewt.painter.NullPainter;
import oracle.ewt.painter.Painter;
import oracle.ewt.thread.Task;
import oracle.ewt.thread.TaskEvent;
import oracle.ewt.thread.TaskScheduler;
import oracle.ewt.util.EventQueueUtils;

public class ContinuousButton
extends AbstractButton {
    private boolean _isArmed;
    private Runnable _runnable;
    private PulseTask _task;
    private boolean _running;
    private int _delay = 200;
    private ListenerManager _listeners;
    private Painter _painter;
    private boolean _startPulsing;
    private static TaskScheduler _scheduler = TaskScheduler.getDefaultTaskScheduler();
    private static final int _PULSE_DELAY = 200;
    private StartPulseTask _pTask;

    public ContinuousButton(Runnable runnable) {
        this._init(runnable, NullPainter.getPainter());
    }

    public ContinuousButton(Runnable runnable, Painter painter) {
        this._init(runnable, painter);
    }

    public void setPainter(Painter painter) {
        if (this._painter != painter) {
            this._painter = painter;
            this.invalidate();
            this.repaint();
        }
    }

    @Override
    public Painter getPainter() {
        return this._painter;
    }

    public int getDelay() {
        return this._delay;
    }

    public void setDelay(int n) {
        this._delay = n;
    }

    public void addPulsingButtonListener(PulsingButtonListener pulsingButtonListener) {
        if (this._listeners == null) {
            this._listeners = new ListenerManager();
        }
        this._listeners.addListener(pulsingButtonListener);
    }

    public void removePulsingButtonListener(PulsingButtonListener pulsingButtonListener) {
        this._listeners.removeListener(pulsingButtonListener);
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        this._schedulePulseTask();
    }

    @Override
    protected AccessibleContext createAccessibleContext() {
        return new AccessibleContinousButton();
    }

    @Override
    protected boolean isArmed() {
        return this._isArmed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setArmed(boolean bl) {
        if (bl != this.isArmed()) {
            this._isArmed = bl;
            this.paintImmediate();
            int n = bl ? 2000 : 2001;
            this.processEvent(new PulsingButtonEvent(this, n));
            if (bl) {
                ContinuousButton continuousButton = this;
                synchronized (continuousButton) {
                    this._running = true;
                    if (this._task == null) {
                        this._task = new PulseTask();
                    }
                }
                this._doRun();
                this._startPulsing = true;
                this.repaint(0, 0, 1, 1);
                this._scheduleTaskAfterRepaint();
            } else {
                this._startPulsing = false;
                this._running = false;
                _scheduler.cancel(this._task);
            }
        }
    }

    void setArmedState() {
        if (!this.isArmed()) {
            this._isArmed = true;
            this.paintImmediate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handlePulse(TaskEvent taskEvent) {
        this._doRun();
        ContinuousButton continuousButton = this;
        synchronized (continuousButton) {
            if (this._running) {
                _scheduler.schedule(this._task, this.getDelay());
            }
        }
    }

    @Override
    protected void processEventImpl(AWTEvent aWTEvent) {
        if (aWTEvent instanceof PulsingButtonEvent) {
            this.processPulsingButtonEvent((PulsingButtonEvent)aWTEvent);
        } else {
            super.processEventImpl(aWTEvent);
        }
    }

    protected void processPulsingButtonEvent(PulsingButtonEvent pulsingButtonEvent) {
        Enumeration enumeration;
        ListenerManager listenerManager = this._listeners;
        if (listenerManager != null && (enumeration = listenerManager.getListeners()) != null) {
            while (enumeration.hasMoreElements()) {
                PulsingButtonListener pulsingButtonListener = (PulsingButtonListener)enumeration.nextElement();
                switch (pulsingButtonEvent.getID()) {
                    case 2000: {
                        pulsingButtonListener.pulseStartPulsing(pulsingButtonEvent);
                        break;
                    }
                    case 2001: {
                        pulsingButtonListener.pulseEndPulsing(pulsingButtonEvent);
                        break;
                    }
                }
            }
        }
    }

    private void _doRun() {
        if (!this.isActive()) {
            this.terminateInteraction();
        }
        this._runnable.run();
    }

    private void _init(Runnable runnable, Painter painter) {
        this._runnable = runnable;
        this._painter = painter;
        this.setFill(NullPainter.getPainter());
    }

    private void _scheduleTaskAfterRepaint() {
        if (this._pTask == null) {
            this._pTask = new StartPulseTask();
        }
        _scheduler.schedule(this._pTask, 100);
    }

    private void _schedulePulseTask() {
        if (this._startPulsing) {
            this._startPulsing = false;
            if (this._running) {
                _scheduler.schedule(this._task, this.getDelay());
            }
        }
    }

    private class AccessibleContinousButton
    extends AbstractButton.AccessibleAbstractButton {
        private AccessibleContinousButton() {
            super(ContinuousButton.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PUSH_BUTTON;
        }
    }

    private class StartPulseTask
    implements Task {
        private StartPulseTask() {
        }

        @Override
        public void runTask(TaskEvent taskEvent) {
            EventQueueUtils.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!StartPulseTask.this._hasPaintEventsPending()) {
                        _scheduler.cancel(StartPulseTask.this);
                        ContinuousButton.this._schedulePulseTask();
                    } else {
                        _scheduler.schedule(StartPulseTask.this, 100);
                    }
                }
            });
        }

        private boolean _hasPaintEventsPending() {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            EventQueue eventQueue = toolkit.getSystemEventQueue();
            return eventQueue.peekEvent(800) != null || eventQueue.peekEvent(801) != null;
        }
    }

    private class PulseTask
    implements Task {
        private PulseTask() {
        }

        @Override
        public void runTask(TaskEvent taskEvent) {
            ContinuousButton.this.handlePulse(taskEvent);
        }
    }
}

