/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.alert;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import oracle.ewt.access.AccessibleLWComponent;
import oracle.ewt.graphics.FontUtils;
import oracle.ewt.imageCanvas.ImageCanvas;
import oracle.ewt.layout.DirectionalBorderLayout;
import oracle.ewt.lwAWT.AbstractButton;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.lwAWT.LWContainer;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.ewt.plaf.AlertUI;
import oracle.ewt.textWrapper.TextWrapper;
import oracle.ewt.textWrapper.WordWrapper;
import oracle.ewt.util.ImmInsets;

public class BaseAlertPane
extends LWComponent
implements KeyListener,
ContainerListener {
    public static final int TYPE_STOP = 0;
    public static final int TYPE_CAUTION = 1;
    public static final int TYPE_NOTE = 2;
    public static final int TYPE_MISC = 3;
    private Component _defaultComponent;
    private Component _cancelComponent;
    private Component _helpComponent;
    private Component _extraComponent;
    private Image _icon;
    private ImageCanvas _iconWidget;
    private LWContainer _messagePane;
    private LWComponent _buttonPane;
    private LWContainer _extraContainer;
    private MultiLineLabel _messageLabel;
    private String _message;
    private int _alertType;
    private static final int _MINIMUM_LABEL_WIDTH = 45;

    public BaseAlertPane(String string, int n) {
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException("Illegal alert type");
        }
        this._alertType = n;
        this.setLayout(new BorderLayout());
        this._icon = this._getStandardIcon();
        this._buttonPane = this._createButtonContainer();
        this.add("South", this._buttonPane);
        this.addKeyListener(this);
        this.addContainerListener(this);
        this._buttonPane.addContainerListener(this);
        this.setMessage(string);
        LWContainer lWContainer = new LWContainer();
        ImmInsets immInsets = this._getMessageInsets();
        lWContainer.setBorderPainter(new FixedBorderPainter(immInsets.top, immInsets.left, immInsets.bottom, immInsets.right));
        lWContainer.setLayout(new DirectionalBorderLayout(this._getMessageIconDelta(), 0));
        this._iconWidget = new ImageCanvas(this._icon);
        this._iconWidget.setInteriorAlignmentY(0.0f);
        this._iconWidget.setVisible(this._icon != null);
        lWContainer.add("West", this._iconWidget);
        this._messageLabel = new PreferredAspectLabel(WordWrapper.getTextWrapper(), this.getMessage());
        this._extraContainer = new LWContainer(new BorderLayout());
        this._extraContainer.add("North", this._messageLabel);
        lWContainer.add("Center", this._extraContainer);
        this._messagePane = lWContainer;
        this.add("Center", lWContainer);
    }

    public BaseAlertPane(int n) {
        this("", n);
    }

    @Override
    public Object getUIClassID() {
        return "AlertUI";
    }

    public void setMessage(String string) {
        if (string == null) {
            string = "";
        }
        this._message = string;
        if (this._messageLabel != null) {
            this._messageLabel.setText(string);
        }
    }

    public String getMessage() {
        return this._message;
    }

    public void setIcon(Image image) {
        this._icon = image;
        if (this._iconWidget != null) {
            this._iconWidget.setImage(image);
            this._iconWidget.setVisible(this._icon != null);
        }
    }

    public Image getIcon() {
        return this._icon;
    }

    public void setExtraComponent(Component component) {
        if (this.isShowing()) {
            throw new IllegalStateException();
        }
        if (this._extraComponent != component) {
            if (this._extraComponent != null) {
                this._extraContainer.remove(this._extraComponent);
            }
            if (component != null) {
                this._extraContainer.add(component, "Center");
            }
            this._extraComponent = component;
        }
    }

    public Component getExtraComponent() {
        return this._extraComponent;
    }

    public void addUserButton(String string, Component component) {
        this.getAlertUI().addUserButton(this, string, component);
    }

    public final void addUserButton(Component component) {
        this.addUserButton(null, component);
    }

    public synchronized void removeComponent(Component component) {
        if (this._defaultComponent == component) {
            this._defaultComponent = null;
        }
        if (this._cancelComponent == component) {
            this._cancelComponent = null;
        }
        if (this._helpComponent == component) {
            this._helpComponent = null;
        }
        this.getAlertUI().removeUserButton(this, component);
    }

    public synchronized void removeAllComponents() {
        this._defaultComponent = null;
        this._cancelComponent = null;
        this._helpComponent = null;
        this.getAlertUI().removeAllButtons(this);
    }

    public void setDefaultComponent(Component component) {
        this._defaultComponent = component;
        if (this._defaultComponent != null) {
            this._defaultComponent.requestFocus();
        }
    }

    public Component getDefaultComponent() {
        return this._defaultComponent;
    }

    public void setCancelComponent(Component component) {
        this._cancelComponent = component;
    }

    public Component getCancelComponent() {
        return this._cancelComponent;
    }

    public void setHelpComponent(Component component) {
        this._helpComponent = component;
    }

    public Component getHelpComponent() {
        return this._helpComponent;
    }

    public int getAlertType() {
        return this._alertType;
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.isConsumed()) {
            return;
        }
        Component component = null;
        switch (keyEvent.getKeyCode()) {
            case 27: {
                component = this.getCancelComponent();
            }
        }
        if (component != null) {
            keyEvent.consume();
            this.doComponentKey(component);
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.isConsumed()) {
            return;
        }
        Component component = null;
        switch (keyEvent.getKeyCode()) {
            case 112: 
            case 156: {
                component = this.getHelpComponent();
            }
        }
        if (component != null) {
            keyEvent.consume();
            this.doComponentKey(component);
        }
    }

    @Override
    public BorderPainter getBorderPainter() {
        return this.getAlertUI().getDefaultBorderPainter(this);
    }

    @Override
    public Dimension getPreferredSize() {
        int n;
        MultiLineLabel multiLineLabel = this._messageLabel;
        if (multiLineLabel == null) {
            return super.getPreferredSize();
        }
        int n2 = this._buttonPane.getPreferredSize().width;
        if (this._icon != null) {
            n2 -= this._iconWidget.getPreferredSize().width;
            n2 -= this._getMessageIconDelta();
        }
        if ((n = 45 * FontUtils.getAverageWidth(this.getFont())) < n2) {
            n = n2;
        }
        Dimension dimension = multiLineLabel.getPreferredSize();
        if (dimension.width < n) {
            multiLineLabel.setWrappingLocked(false);
            multiLineLabel.setWrapWidth(n);
        }
        Dimension dimension2 = super.getPreferredSize();
        if (dimension.width < n) {
            multiLineLabel.setWrappingLocked(true);
        }
        return dimension2;
    }

    protected void doComponentKey(Component component) {
    }

    @Override
    public void componentAdded(ContainerEvent containerEvent) {
        containerEvent.getChild().addKeyListener(this);
    }

    @Override
    public void componentRemoved(ContainerEvent containerEvent) {
        containerEvent.getChild().removeKeyListener(this);
    }

    @Override
    public void postProcessKey(KeyEvent keyEvent) {
        AbstractButton abstractButton;
        if (keyEvent.isConsumed() || !this.isEnabled()) {
            return;
        }
        if (keyEvent.getID() == 401 && (abstractButton = this._tryAllButtons(this._buttonPane, keyEvent)) != null) {
            if (abstractButton.hasFocus()) {
                return;
            }
            abstractButton.requestFocus();
            abstractButton.redispatchEvent(keyEvent);
            keyEvent.consume();
            return;
        }
        super.postProcessKey(keyEvent);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this._defaultComponent != null) {
            this._defaultComponent.requestFocus();
        } else if (this._cancelComponent != null) {
            this._cancelComponent.requestFocus();
        }
    }

    protected final AlertUI getAlertUI() {
        return (AlertUI)this.getUI();
    }

    @Override
    protected AccessibleContext createAccessibleContext() {
        return new Access();
    }

    private AbstractButton _tryAllButtons(Container container, KeyEvent keyEvent) {
        int n;
        Component[] componentArray;
        if (container instanceof AbstractButton && (componentArray = (Component[])container).isEnabled() && componentArray.isVisible() && BaseAlertPane.eventMatchesMnemonic(keyEvent, (char)(n = (int)componentArray.getMnemonicChar()))) {
            return componentArray;
        }
        componentArray = container.getComponents();
        for (n = 0; n < componentArray.length; ++n) {
            AbstractButton abstractButton;
            Component component = componentArray[n];
            if (!(component instanceof Container) || (abstractButton = this._tryAllButtons((Container)component, keyEvent)) == null) continue;
            return abstractButton;
        }
        return null;
    }

    private ImmInsets _getMessageInsets() {
        return this.getAlertUI().getMessageInsets(this);
    }

    private int _getMessageIconDelta() {
        return this.getAlertUI().getMessageIconDelta(this);
    }

    private LWComponent _createButtonContainer() {
        return this.getAlertUI().createButtonContainer(this);
    }

    private Image _getStandardIcon() {
        int n = this.getAlertType();
        switch (n) {
            case 0: {
                return this.getAlertUI().getStopIcon(this);
            }
            case 1: {
                return this.getAlertUI().getCautionIcon(this);
            }
            case 2: {
                return this.getAlertUI().getNoteIcon(this);
            }
        }
        return null;
    }

    private class PreferredAspectLabel
    extends MultiLineLabel {
        public PreferredAspectLabel(TextWrapper textWrapper, String string) {
            super(textWrapper, string);
        }

        @Override
        protected Dimension layoutCanvas() {
            int n;
            float f;
            Dimension dimension = super.layoutCanvas();
            if (BaseAlertPane.this.getExtraComponent() != null && (f = this.getPreferredAspectRatio()) != 0.0f && (n = (int)((float)dimension.width / f)) > dimension.height) {
                dimension.height = n;
            }
            return dimension;
        }
    }

    private class Access
    extends AccessibleLWComponent {
        public Access() {
            super(BaseAlertPane.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.OPTION_PANE;
        }

        @Override
        public String getAccessibleName() {
            if (this.accessibleName != null) {
                return this.accessibleName;
            }
            if (BaseAlertPane.this.getMessage() == null) {
                return super.getAccessibleName();
            }
            return BaseAlertPane.this.getMessage();
        }

        @Override
        public String getAccessibleDescription() {
            if (this.accessibleDescription != null) {
                return this.accessibleDescription;
            }
            if (BaseAlertPane.this.getMessage() == null) {
                return super.getAccessibleDescription();
            }
            return BaseAlertPane.this.getMessage();
        }
    }
}

