/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.alert;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import oracle.ewt.access.AccessibleComponentImpl;
import oracle.ewt.alert.BaseAlertPane;
import oracle.ewt.lwAWT.BufferedDialog;
import oracle.ewt.util.WindowUtils;

public class BaseAlert
extends BufferedDialog {
    public static final int TYPE_STOP = 0;
    public static final int TYPE_CAUTION = 1;
    public static final int TYPE_NOTE = 2;
    public static final int TYPE_MISC = 3;
    private BaseAlertPane _pane;
    private Component _pressed;
    private boolean _firstTime;
    private Component _centerOver;
    private transient AccessibleContext _accessibleContext;

    public BaseAlert(int n) {
        this(null, "", n);
    }

    public BaseAlert(int n, String string) {
        this(null, string, n);
    }

    public BaseAlert(Frame frame, int n) {
        this(frame, "", n);
    }

    public BaseAlert(Frame frame, String string, int n) {
        super(frame, true);
        this._pane = this.createPane(string, n);
        this.add("Center", this._pane);
        this.enableEvents(64L);
        this.setCenterOver(frame);
    }

    public BaseAlertPane getPane() {
        return this._pane;
    }

    protected BaseAlertPane createPane(String string, int n) {
        return new BaseAlertPane(string, n);
    }

    public void dismissAlert(Component component) {
        this._pressed = component;
        this.setVisible(false);
    }

    public Component getPressed() {
        return this._pressed;
    }

    public Component getCenterOver() {
        return this._centerOver;
    }

    public void setCenterOver(Component component) {
        this._centerOver = component;
    }

    public void setMessage(String string) {
        this._pane.setMessage(string);
        if (this._accessibleContext != null) {
            this._accessibleContext.setAccessibleDescription(string);
        }
    }

    public String getMessage() {
        return this._pane.getMessage();
    }

    public void setIcon(Image image) {
        this._pane.setIcon(image);
    }

    public Image getIcon() {
        return this._pane.getIcon();
    }

    public void setExtraComponent(Component component) {
        this._pane.setExtraComponent(component);
    }

    public Component getExtraComponent() {
        return this._pane.getExtraComponent();
    }

    public void addUserButton(String string, Component component) {
        this._pane.addUserButton(string, component);
    }

    public final void addUserButton(Component component) {
        this._pane.addUserButton(component);
    }

    public void removeComponent(Component component) {
        this._pane.removeComponent(component);
    }

    public void removeAllComponents() {
        this._pane.removeAllComponents();
    }

    public void setDefaultComponent(Component component) {
        this._pane.setDefaultComponent(component);
    }

    public Component getDefaultComponent() {
        return this._pane.getDefaultComponent();
    }

    public void setCancelComponent(Component component) {
        this._pane.setCancelComponent(component);
    }

    public Component getCancelComponent() {
        return this._pane.getCancelComponent();
    }

    public void setHelpComponent(Component component) {
        this._pane.setHelpComponent(component);
    }

    public Component getHelpComponent() {
        return this._pane.getHelpComponent();
    }

    public int getAlertType() {
        return this._pane.getAlertType();
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this._accessibleContext == null) {
            this._accessibleContext = new Access();
        }
        return this._accessibleContext;
    }

    @Override
    public void show() {
        this._pressed = null;
        this.pack();
        Dimension dimension = this.getSize();
        this.setSize(dimension.width + 2, dimension.height + 2);
        WindowUtils.centerWindow(this, this._centerOver);
        this._firstTime = true;
        super.show();
    }

    @Override
    protected void processWindowEvent(WindowEvent windowEvent) {
        super.processWindowEvent(windowEvent);
        if (windowEvent.getID() == 201) {
            Component component = this.getCancelComponent();
            if (component == null) {
                component = this.getDefaultComponent();
            }
            if (component != null) {
                this._pane.doComponentKey(component);
            }
        } else if (windowEvent.getID() == 205) {
            if (this.getAlertType() == 0 && this._firstTime) {
                Toolkit.getDefaultToolkit().beep();
            }
            this._firstTime = false;
        }
    }

    private class Access
    extends AccessibleComponentImpl {
        public Access() {
            super(BaseAlert.this);
        }

        @Override
        public String getAccessibleName() {
            if (this.accessibleName != null) {
                return this.accessibleName;
            }
            if (BaseAlert.this.getTitle() == null) {
                return super.getAccessibleName();
            }
            return BaseAlert.this.getTitle();
        }

        @Override
        public String getAccessibleDescription() {
            if (this.accessibleDescription != null) {
                return this.accessibleDescription;
            }
            if (BaseAlert.this.getMessage() == null) {
                return super.getAccessibleDescription();
            }
            return BaseAlert.this.getMessage();
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.ALERT;
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (BaseAlert.this.isResizable()) {
                accessibleStateSet.add(AccessibleState.RESIZABLE);
            }
            if (BaseAlert.this.isActive()) {
                accessibleStateSet.add(AccessibleState.ACTIVE);
            }
            if (BaseAlert.this.isModal()) {
                accessibleStateSet.add(AccessibleState.MODAL);
            }
            return accessibleStateSet;
        }
    }
}

