/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt;

import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.image.ImageFilter;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import oracle.ewt.LookAndFeel;
import oracle.ewt.UIDefaults;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.painter.Painter;

public class UIManager
implements Serializable {
    private static final String _LOOK_AND_FEEL_KEY = "DefaultLookAndFeel";
    private static final String _ORACLE_CLASS_NAME = "oracle.ewt.laf.oracle.OracleLookAndFeel";
    private static boolean _sIsInitialized = false;
    private static final Object _sINIT_LOCK = new Object();
    private static LookAndFeel _sLookAndFeel;
    private static PropertyChangeSupport _sChangeSupport;
    private static Hashtable _sInstalledLookAndFeels;
    private static Hashtable _sInstantiatedLookAndFeels;
    private static final Object _sLock;

    private UIManager() {
    }

    public static LookAndFeel getLookAndFeel() {
        UIManager._maybeInitialize(null);
        return _sLookAndFeel;
    }

    public static LookAndFeel getLookAndFeel(String string) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        LookAndFeel lookAndFeel = (LookAndFeel)_sInstantiatedLookAndFeels.get(string);
        if (lookAndFeel == null) {
            try {
                Class<?> clazz = Class.forName(string);
                lookAndFeel = (LookAndFeel)clazz.newInstance();
                _sInstantiatedLookAndFeels.put(string, lookAndFeel);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return lookAndFeel;
    }

    public static LookAndFeel getLookAndFeelByName(String string) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        UIManager._maybeInitialize(string);
        LookAndFeelInfo lookAndFeelInfo = (LookAndFeelInfo)_sInstalledLookAndFeels.get(string);
        String string2 = lookAndFeelInfo != null ? lookAndFeelInfo.getClassName() : null;
        return UIManager.getLookAndFeel(string2);
    }

    public static LookAndFeelInfo[] getInstalledLookAndFeels() {
        UIManager._maybeInitialize(null);
        int n = _sInstalledLookAndFeels.size();
        LookAndFeelInfo[] lookAndFeelInfoArray = new LookAndFeelInfo[n];
        Enumeration enumeration = _sInstalledLookAndFeels.elements();
        for (int i = 0; i < n; ++i) {
            lookAndFeelInfoArray[i] = (LookAndFeelInfo)enumeration.nextElement();
        }
        return lookAndFeelInfoArray;
    }

    public static void setLookAndFeel(LookAndFeel lookAndFeel) {
        if (_sLookAndFeel != lookAndFeel) {
            if (lookAndFeel == null) {
                throw new IllegalArgumentException();
            }
            String string = lookAndFeel.getClass().getName();
            _sInstantiatedLookAndFeels.put(string, lookAndFeel);
            LookAndFeel lookAndFeel2 = _sLookAndFeel;
            _sLookAndFeel = lookAndFeel;
            UIManager.firePropertyChange("lookAndFeel", lookAndFeel2, _sLookAndFeel);
        }
    }

    public static void setLookAndFeel(String string) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        UIManager.setLookAndFeel(UIManager.getLookAndFeel(string));
    }

    public static void setLookAndFeelByName(String string) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        UIManager.setLookAndFeel(UIManager.getLookAndFeelByName(string));
    }

    public static BorderPainter createGroupBoxPainter(String string) {
        return _sLookAndFeel.createGroupBoxPainter(string);
    }

    public static BorderPainter createGroupBoxPainter(Painter painter, String string) {
        return _sLookAndFeel.createGroupBoxPainter(painter, string);
    }

    public static BorderPainter createGroupBoxPainter(Painter painter) {
        return _sLookAndFeel.createGroupBoxPainter(painter);
    }

    public static BorderPainter createGroupBoxPainter(Painter painter, Painter painter2) {
        return _sLookAndFeel.createGroupBoxPainter(painter, painter2);
    }

    public static boolean isGroupBoxPainter(BorderPainter borderPainter) {
        return _sLookAndFeel.isGroupBoxPainter(borderPainter);
    }

    public static String getGroupBoxTitle(BorderPainter borderPainter) {
        return _sLookAndFeel.getGroupBoxTitle(borderPainter);
    }

    public static UIDefaults getDefaults() {
        UIManager._maybeInitialize(null);
        return _sLookAndFeel.getDefaults((PaintContext)null);
    }

    public static UIDefaults getDefaults(PaintContext paintContext) {
        UIManager._maybeInitialize(null);
        return _sLookAndFeel.getDefaults(paintContext);
    }

    public static Font getFont(Object object) {
        return UIManager.getDefaults().getFont(object);
    }

    public static Color getColor(Object object) {
        return UIManager.getDefaults().getColor(object);
    }

    public static Image getImage(Object object) {
        return UIManager.getDefaults().getImage(object);
    }

    public static String getString(Object object) {
        return UIManager.getDefaults().getString(object);
    }

    public static Painter getPainter(Object object) {
        return UIManager.getDefaults().getPainter(object);
    }

    public static BorderPainter getBorderPainter(Object object) {
        return UIManager.getDefaults().getBorderPainter(object);
    }

    public static ImageFilter getImageFilter(Object object) {
        return UIManager.getDefaults().getImageFilter(object);
    }

    public static Object get(Object object) {
        return UIManager.getDefaults().get(object);
    }

    public static Object put(Object object, Object object2) {
        return UIManager.getDefaults().put(object, object2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        Object object = _sLock;
        synchronized (object) {
            if (_sChangeSupport == null) {
                _sChangeSupport = new PropertyChangeSupport(UIManager.class);
            }
            _sChangeSupport.addPropertyChangeListener(propertyChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        Object object = _sLock;
        synchronized (object) {
            if (_sChangeSupport != null) {
                _sChangeSupport.removePropertyChangeListener(propertyChangeListener);
            }
        }
    }

    protected static void firePropertyChange(String string, Object object, Object object2) {
        if (_sChangeSupport != null) {
            _sChangeSupport.firePropertyChange(string, object, object2);
        }
    }

    private static Properties _loadUserProperties() {
        Properties properties = new Properties();
        if (UIManager.class.getClassLoader() == null) {
            String string = File.separator;
            try {
                String string2 = System.getProperty("java.home");
                String string3 = string2 + string + "lib" + string + "uimanager.properties";
                File file = new File(string3);
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                properties.load(bufferedInputStream);
                bufferedInputStream.close();
            }
            catch (Exception exception) {
                properties.clear();
            }
        }
        return properties;
    }

    private static void _initializeDefaultLookAndFeel(Properties properties, String string) {
        if (_sLookAndFeel != null) {
            return;
        }
        String string2 = _ORACLE_CLASS_NAME;
        String string3 = "<undefined>";
        try {
            string3 = string == null ? properties.getProperty(_LOOK_AND_FEEL_KEY, string2) : string;
            UIManager.setLookAndFeel(string3);
        }
        catch (Exception exception) {
            try {
                UIManager.setLookAndFeel(string2);
            }
            catch (Exception exception2) {
                throw new Error("can't load " + string2);
            }
        }
    }

    private static void _initialize(String string) {
        Properties properties = UIManager._loadUserProperties();
        String string2 = "oracle.ewt.laf.generic.GenericLookAndFeel";
        String string3 = System.getProperty("os.name");
        String string4 = string3 != null && string3.indexOf("Windows") != -1 ? string2 : _ORACLE_CLASS_NAME;
        LookAndFeelInfo[] lookAndFeelInfoArray = new LookAndFeelInfo[]{new LookAndFeelInfo("Oracle", _ORACLE_CLASS_NAME), new LookAndFeelInfo("Generic", string2), new LookAndFeelInfo("Windows", string2), new LookAndFeelInfo("Cross Platform", _ORACLE_CLASS_NAME), new LookAndFeelInfo("Native", string4), new LookAndFeelInfo("Default", properties.getProperty(_LOOK_AND_FEEL_KEY, _ORACLE_CLASS_NAME))};
        for (int i = 0; i < lookAndFeelInfoArray.length; ++i) {
            LookAndFeelInfo lookAndFeelInfo = lookAndFeelInfoArray[i];
            _sInstalledLookAndFeels.put(lookAndFeelInfo.getName(), lookAndFeelInfo);
        }
        String string5 = string != null ? ((LookAndFeelInfo)_sInstalledLookAndFeels.get(string)).getClassName() : null;
        UIManager._initializeDefaultLookAndFeel(properties, string5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _maybeInitialize(String string) {
        Object object = _sINIT_LOCK;
        synchronized (object) {
            if (!_sIsInitialized) {
                _sIsInitialized = true;
                UIManager._initialize(string);
            }
        }
    }

    static {
        _sInstalledLookAndFeels = new Hashtable(11);
        _sInstantiatedLookAndFeels = new Hashtable(7);
        _sLock = new Object();
    }

    public static final class LookAndFeelInfo {
        private String _logicalName;
        private String _className;

        LookAndFeelInfo(String string, String string2) {
            this._logicalName = string;
            this._className = string2;
        }

        public String getName() {
            return this._logicalName;
        }

        public String getDisplayName(Locale locale) {
            return this.getName();
        }

        public String getClassName() {
            return this._className;
        }
    }
}

