/*
 * Decompiled with CFR 0.152.
 */
package forms.sct.ui;

import forms.updater.UpdateInfo;
import forms.updater.Updater;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import oracle.forms.engine.Main;
import oracle.forms.handler.IHandler;
import oracle.forms.properties.ID;
import oracle.forms.ui.VBean;

public class SCanvasBg
extends VBean {
    public static final ID SET_CANVAS_BG_COLOR = ID.registerProperty("SET_CANVAS_BG_COLOR");
    public static final ID SET_CANVAS_BG_IMAGE = ID.registerProperty("SET_CANVAS_BG_IMAGE");
    public static final ID SET_WIN_ICON_IMAGE = ID.registerProperty("SET_WIN_ICON_IMAGE");
    private IHandler m_handler;
    private Color canvasBgColor;
    private ImageIcon canvasIcon = null;
    private ImageIcon windowIcon = null;
    private int rBg;
    private int gBg;
    private int bBg;
    protected boolean bFirst = true;
    protected JPanel jp = null;
    private static int intReadingCount = 0;
    private Main mFormsMain = null;
    private Frame mainFrame = null;

    public SCanvasBg() {
        System.out.println("SCanvasBg : Constructor worked...");
    }

    public void paint(Graphics g) {
        if (this.bFirst) {
            this.bFirst = false;
            this.jp = new JPanel(){

                public void paint(Graphics g) {
                    if (SCanvasBg.this.canvasBgColor != null) {
                        g.setColor(SCanvasBg.this.canvasBgColor);
                    }
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                    if (SCanvasBg.this.canvasIcon != null) {
                        g.drawImage(SCanvasBg.this.canvasIcon.getImage(), 0, 0, this);
                    }
                }
            };
            this.jp.setBounds(this.getParent().getBounds());
            this.jp.setVisible(true);
            this.getParent().add(this.jp);
        }
    }

    public void init(IHandler handler) {
        this.m_handler = handler;
        super.init(handler);
        ++intReadingCount;
        this.mFormsMain = this.m_handler.getApplet();
        try {
            this.mainFrame = this.mFormsMain.getFrame();
        }
        catch (Exception e) {
            System.out.println("Frame Getting : Exception - " + e);
        }
        if (intReadingCount == 1) {
            String applicationName = "SCT_Applications.jar";
            int currentVersion = 0;
            try {
                String line;
                System.out.println("Path of jar - 1 : " + SCanvasBg.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath().substring(1));
                JarFile jarFile = new JarFile(applicationName);
                JarEntry entry = jarFile.getJarEntry("version.txt");
                InputStream input = jarFile.getInputStream(entry);
                InputStreamReader isr = new InputStreamReader(input);
                BufferedReader reader = new BufferedReader(isr);
                while ((line = reader.readLine()) != null) {
                    System.out.println(line);
                    currentVersion = Integer.parseInt(line.substring(line.indexOf("[version]") + 9, line.indexOf("[/version]")));
                }
                reader.close();
                jarFile.close();
                try {
                    System.out.println(Updater.getLatestVersion());
                    if (Integer.parseInt(Updater.getLatestVersion()) > currentVersion) {
                        UpdateInfo obj = new UpdateInfo(Updater.getWhatsNew(), this.mainFrame);
                        obj.setApplicationName(applicationName);
                    }
                }
                catch (Exception ex) {
                    System.out.println(ex);
                }
            }
            catch (ArrayIndexOutOfBoundsException ai) {
                System.out.println(ai);
            }
            catch (FileNotFoundException fnfe) {
                System.out.println(fnfe);
            }
            catch (IOException ioe) {
                System.out.println(ioe);
            }
            catch (URISyntaxException uri) {
                System.out.println(uri);
            }
        }
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            SwingUtilities.updateComponentTreeUI(this);
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
        if (this.mainFrame != null) {
            Window[] win = Window.getWindows();
            System.out.println("Window Count : " + win.length);
            WindowListener[] wl = win[0].getWindowListeners();
            for (int i = 0; i < wl.length; ++i) {
                win[0].removeWindowListener(wl[i]);
            }
            win[0].addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                }
            });
        }
        System.out.println("SCanvasBg : init() worked...");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        System.out.println("Inside of 'destroy' method of 'SCanvasBg'...");
        try {
            this.mainFrame.dispose();
        }
        catch (Exception e) {
            System.out.println("Exception:999 - " + e);
        }
        finally {
            System.out.println("Executing 'Runtime.getRuntime().halt(1)'...");
            Runtime.getRuntime().halt(1);
        }
    }

    public boolean setProperty(ID id, Object value) {
        boolean success = true;
        if (id == SET_CANVAS_BG_COLOR) {
            String sColor = value.toString().trim();
            StringTokenizer st = new StringTokenizer(sColor, ",");
            this.rBg = Integer.parseInt(st.nextToken());
            this.gBg = Integer.parseInt(st.nextToken());
            this.bBg = Integer.parseInt(st.nextToken());
            this.canvasBgColor = new Color(this.rBg, this.gBg, this.bBg);
            if (this.jp != null) {
                this.jp.invalidate();
            }
            System.out.println("Set Canvas BG Color...");
            return success;
        }
        if (id == SET_CANVAS_BG_IMAGE) {
            try {
                URL url = new URL(value.toString().trim());
                this.canvasIcon = new ImageIcon(url);
            }
            catch (MalformedURLException ex) {
                this.canvasIcon = new ImageIcon(value.toString().trim());
            }
            if (this.jp != null) {
                this.jp.invalidate();
            }
            System.out.println("Set Canvas BG Image...");
            return success;
        }
        if (id == SET_WIN_ICON_IMAGE) {
            try {
                URL url = new URL(value.toString().trim());
                this.windowIcon = new ImageIcon(url);
            }
            catch (MalformedURLException ex) {
                this.windowIcon = new ImageIcon(value.toString().trim());
            }
            if (this.windowIcon != null) {
                this.mainFrame.setIconImage(this.windowIcon.getImage());
            }
            System.out.println("Set Window Icon Image...");
            return success;
        }
        success = super.setProperty(id, value);
        return success;
    }

    public Object getProperty(ID id) {
        return super.getProperty(id);
    }
}

